#include <stdio.h>


#define	min(a,b)	((a>b) ? b : a)

#define BITS 12

#if BITS == 16
# define HSIZE	69001		/* 95% occupancy */
#endif
#if BITS == 15
# define HSIZE	35023		/* 94% occupancy */
#endif
#if BITS == 14
# define HSIZE	18013		/* 91% occupancy */
#endif
#if BITS == 13
# define HSIZE	9001		/* 91% occupancy */
#endif
#if BITS <= 12
# define HSIZE	5003		/* 80% occupancy */
#endif

#if BITS > 15
typedef long int	code_int;
#else
typedef int		code_int;
#endif

typedef long int	count_int;
typedef	unsigned char	char_type;

#define BIT_MASK	0x1f
#define BLOCK_MASK	0x80
#define INIT_BITS       9	 /* initial number of bits/code        */

#undef vax                       /* F machine takes vax as default!    */



int n_bits;    	                 /* number of bits/code                */
int maxbits = BITS;              /* user settable max # bits/code      */
code_int maxcode;                /* maximum code, given n_bits         */
code_int maxmaxcode = 1 << BITS; /* should NEVER generate this code    */
# define MAXCODE(n_bits)	((1 << (n_bits)) - 1)

count_int htab [HSIZE];          /* hashing table                      */
unsigned short codetab [HSIZE];  /* code table                         */

code_int free_ent = 0;

#define htabof(i)	htab[i]
#define codetabof(i)	codetab[i]

int block_compress = BLOCK_MASK;
int clear_flg = 0;
#define FIRST	257	         /* first free entry                   */
#define	CLEAR	256	         /* table clear output code            */

char_type rmask[9] = {0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff};
int in_count = 0;	 /* length of input                    */

#define tab_prefixof(i)	codetabof(i)
#define tab_suffixof(i)	((char_type *)(htab))[i]
#define de_stack		((char_type *)&tab_suffixof(1<<BITS))
