/* image.h      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

#define NONE 0		/* no decompression */
#define CCC 1		/* CCC decompression */
#define QUANTIZE 2	/* color quantization */
#define LEMPEL_ZIV 4	/* Lempel-Ziv compressed */

#define RED 0
#define GREEN 1
#define BLUE 2

struct mapstore
{
    long num ;			/* number of entries in color map */
    unsigned char s_map[256][3] ;	/* 24 bit version of color map */
    unsigned short h_map[256] ;		/* 16 bit version of color map */
    unsigned char g_map[256] ;		/* 8 bit greyscale version */
} ;

extern struct mapstore map ;	/* color map */

    /* border color */
extern unsigned char back_red ;
extern unsigned char back_green ;
extern unsigned char back_blue ;


    /* centering information necessary if image smaller than frame
       buffer */
extern int center_x_left ;
extern int center_y_bottom, center_y_top ;

/* information to decompress and record frame buffer */

struct image_stuff
{
    int height ;
    int width ;
    long depth ;	/* color resolution  of server display in bytes */
    long client_im_bytes ;	/* image on client information */
    long client_ht ;
    long client_wd ;
    long compression ;		/* type of compression */
    long recordable ;		/* recording mode */
    long total ;	/* total bytes in (compressed) incoming image */
	/* number of bytes in compressed frame (Lempel-Ziv only) */
    long total_lz ;
    long in_at ;		/* start recording frame at */
    long out_at ;		/* finish recording frame at */
    long current_frame_to_save;	/* unused in PC server */
    long total_frames;		/* unused in PC server */
    unsigned char data[32767] ; /* maximum will read at one time */
} ;

extern struct image_stuff image_info ;
    /* used in Lempel-Ziv decompression */
extern unsigned char outbuf[32767] ;
