/* scry_image.h      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#define S_NONE 0		/* no compression */
#define S_CCC 1			/* CCC and run length encoding */
#define S_QUANTIZE 2		/* quantized to 8 bits */
#define S_LEMPEL_ZIV 4		/* Lempel-Ziv compressed */

#define S_MAX_COL_SIZE		256	/* maximum size of color table */

extern int S_maxcol ;		/* maximum number of entries in color map */
extern int S_mapnum ;		/* number of entries in color map */
extern unsigned char S_map[S_MAX_COL_SIZE][3] ;	/* RGB color map */

#define S_RED 0
#define S_GREEN 1
#define S_BLUE 2

    /* legal range in bytes of color resolution */
#define S_MIN_COLOR_DEPTH	1
#define S_MAX_COLOR_DEPTH	4

/* information to transmit and display image */

struct image_stuff
{
    long c_height ;	/* image height */
    long c_width ;	/* image width */
    long c_depth ;	/* color resolution in bytes */
    long s_height ;	/* server window height */
    long s_width ;	/* server window width */
    long s_depth ;	/* server color resolution in bytes */
    long s_max_height ;	/* maximum server height */
    long s_max_width ;	/* maximum server width */
    long s_recordable ;	/* server has video recorder or not */
    long compression ;	/* type of compression used on image */
    long current_frame_to_save ;	/* current Anima frame to save */
    long total_frames ;	/* total frames to save in Anima file */
    long total ;	/* total number of bytes in compressed image */
    long total_lz ;	/* number of bytes after Lempel-Ziv compression */
    long in_at ;	/* starting recording frame */
    long out_at ;	/* finishing recording frame */
    char *filename ;	/* Anima file name */
    unsigned char *data ;	/* buffer for compressed image */
} ;

extern struct image_stuff S_image_info ;

extern unsigned char *S_image_mem ;	/* uncompressed image */
