/* iff_format.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include <stdio.h>
#include <scry_image.h>
#include <scry_anima.h>

struct animavars S_avars ;	/* Anima playback information */
struct footer *S_a_index ;	/* Anima footer */
int S_anima_count ;		/* number of frames in Anima file */
int S_anima_bytes ;		/* number of bytes to footer */
FILE *S_anima_file ;		/* Anima file */
char S_anima_filename[80] ;	/* Anima file name */

/* iff_read_header:	read the IFF header associated with Anima frame(s),
			which contains image height and width,
			the colormap, etc.
   hbtoi:		converts IFF color map entry to Anima format
   iff_read_buf:	reads the compressed image buffer
   iff_write_header:	writes out the IFF header associated with Anima
			frame(s)
   iff_write_buf:	writes out compressed image buffer
   anima_write_footer:	writes Anima footer */

    
/* read the IFF header associated with Anima frame(s),
   which contains image height and width, the colormap, etc. */

int 
iff_read_header(file,buffer,height,width,format)
     
FILE *file;			/* Anima file */
struct image_stuff *buffer;	/* image information */
int *height ;			/* image height */
int *width ;			/* image width */
char *format ;			/* Anima file format */

{
    char recv_str[256*7+30] ;	/* input buffer */
    char *map_arg ;		/* IFF color map entry */
    unsigned char red[256], green[256], blue[256] ;
    int i ;

    fscanf (file,"%s\n",recv_str) ;
    fgets (recv_str,256*7+30,file) ;
    while (recv_str[0] != '\f')
    {
	if (((strncmp(recv_str,"frames",6)) == 0) ||
	    ((strncmp(recv_str,"rank",4)) == 0) ||
	    ((strncmp(recv_str,"bands",5)) == 0) ||
	    ((strncmp(recv_str,"bits",4)) == 0))
		;   /* do nothing */
	else if ((strncmp(recv_str,"format",6)) == 0)
	    sscanf(recv_str,"format=%s;",format) ;
	else if ((strncmp(recv_str,"size",4)) == 0)
	    sscanf(recv_str,"size=%d %d;",width,height) ;
	else if ((strncmp(recv_str,"compression",11)) == 0)
	{
	    sscanf(recv_str,"compression=%d;",&(buffer->compression)) ;
	}
	else if ((strncmp(recv_str,"colormapsize",12)) == 0)
	{
	    sscanf(recv_str,"colormapsize=%d;",&(S_mapnum)) ;
	}
	else if ((strncmp(recv_str,"colormap",8)) == 0)
	{
            map_arg = recv_str+9 ;
            for (i = 0 ; i < S_mapnum ; i++)
		{
		    hbtoi (&map_arg,&blue[i]) ;
		    hbtoi (&map_arg,&green[i]) ;
		    hbtoi (&map_arg,&red[i]) ;
		    map_arg++ ;
		    S_map[i][S_RED] = red[i] ;
		    S_map[i][S_GREEN] = green[i] ;
		    S_map[i][S_BLUE] = blue[i] ;
		}
	}
        fgets (recv_str,256*7+30,file) ;
    }
    return(1);
}



/* converts IFF format color map entry to Anima format */

hbtoi (ptchar,mapind)

unsigned char *ptchar[] ;
unsigned char *mapind ;

{
    unsigned int templeft ;
    unsigned int tempright ;

    templeft = (unsigned int) **ptchar ;
    if (templeft < 97)
	templeft = (unsigned int) (**ptchar - '0') ;
    else
	templeft = 10 + (unsigned int) (**ptchar - 'a') ;
    (*ptchar)++ ;
    tempright = (unsigned int) **ptchar ;
    if (tempright < 97)
	tempright = (unsigned int) (**ptchar - '0') ;
    else
	tempright = 10 + (unsigned int) (**ptchar - 'a') ;
    *mapind = (unsigned char) (16 * templeft + tempright) ;
    (*ptchar)++ ;
}



/* reads compressed image buffer */

int
iff_read_buf(file,buffer)

FILE *file;		/* stored images file handle */
struct image_stuff *buffer;	/* compressed image */

{
    if(fread((char *)buffer->data, buffer->total, 1, file) == 0)
	return(0);
    return(1);
}



/* writes IFF header associated with Anima frame(s) */

int
iff_write_header (anima_fp,buf,height,width,anima_format)

FILE *anima_fp ;		/* Anima output file */
struct image_stuff *buf ;	/* image information */
int height ;			/* image height */
int width ;			/* image width */
char *anima_format ;		/* Anima file format */

{
    unsigned char iff_ptr[40] ;
    unsigned char red[256],green[256],blue[256] ;
    int iff_length ;
    int i ;

        /* IFF ID */
    sprintf (iff_ptr,"%s\n","ncaa") ;
    iff_length = strlen(iff_ptr) ;
    fwrite (iff_ptr,iff_length,1,anima_fp) ;
    S_anima_bytes += iff_length ;
	/* Anima format */
    sprintf (iff_ptr,"%s%s;\n","format=",anima_format) ;
    iff_length = strlen(iff_ptr) ;
    fwrite (iff_ptr,iff_length,1,anima_fp) ;
    S_anima_bytes += iff_length ;
	/* for IFF compatibility only */
    sprintf (iff_ptr,"%s\n","rank=2;") ;
    iff_length = strlen(iff_ptr) ;
    fwrite (iff_ptr,iff_length,1,anima_fp) ;
    S_anima_bytes += iff_length ;
	/* for IFF compatibility only */
    sprintf (iff_ptr,"bands=3;\n") ;
    iff_length = strlen(iff_ptr) ;
    fwrite (iff_ptr,iff_length,1,anima_fp) ;
    S_anima_bytes += iff_length ;
	/* for IFF compatibility only */
    sprintf (iff_ptr,"bits=8 8 16;\n") ;
    iff_length = strlen(iff_ptr) ;
    fwrite (iff_ptr,iff_length,1,anima_fp) ;
    S_anima_bytes += iff_length ;
	/* image width and height */
    sprintf (iff_ptr,"%s%d %d;\n","size=",width,height) ;
    iff_length = strlen(iff_ptr) ;
    fwrite (iff_ptr,iff_length,1,anima_fp) ;
    S_anima_bytes += iff_length ;
	/* number of color map entries */
    sprintf (iff_ptr,"colormapsize=%d;\n",S_mapnum) ;
    iff_length = strlen(iff_ptr) ;
    fwrite (iff_ptr,iff_length,1,anima_fp) ;
    S_anima_bytes += iff_length ;
    red[0] = 0 ;
    green[0] = 0 ;
    blue[0] = 0 ;
    for(i = 0; i < S_mapnum; i++)
	{
	    red[i] = S_map[i][S_RED];
	    green[i] = S_map[i][S_GREEN];
	    blue[i] = S_map[i][S_BLUE];
	}

    for (i = S_mapnum ; i < 256 ; i++)
	{
	    red[i] = 0 ;
	    green[i] = 0 ;
	    blue[i] = 0 ;
	}
    sprintf (iff_ptr,"colormap=") ;
    iff_length = strlen(iff_ptr) ;
    fwrite (iff_ptr,iff_length,1,anima_fp) ;
    S_anima_bytes += iff_length ;
	/* write out color map in IFF format */
    for (i = 0 ; i < S_mapnum ; i++)
    {
	sprintf (iff_ptr,"%02x%02x%02x ",blue[i],green[i],red[i]) ;
        if ((fwrite (iff_ptr,7,sizeof(char),anima_fp)) != 1) 
	    printf ("foo!\n");
	S_anima_bytes += 7 ;
    }
    sprintf (iff_ptr,";\n") ;
    if ((fwrite (iff_ptr,2,sizeof(char),anima_fp)) != 1) 
	printf ("foo!\n");
    S_anima_bytes += 2 ;
    iff_ptr[0] = '\f' ;
    if ((fwrite (iff_ptr,1,sizeof(char),anima_fp)) != sizeof(char))
	printf ("foo!\n");
    ++S_anima_bytes ;
    iff_ptr[0] = '\n' ;
    if ((fwrite (iff_ptr,1,sizeof(char),anima_fp)) != sizeof(char))
	printf ("foo!\n");
    ++S_anima_bytes ;
}



/* write out compressed image */

int
iff_write_buf (anima_fp,buf)

FILE *anima_fp ;
struct image_stuff *buf ;	/* frame */

{
    fwrite (buf->data, buf->total, 1, anima_fp);
    S_anima_bytes += buf->total;

    return(1) ;
}




/* write Anima footer */

int
anima_write_footer (anima_fp)

FILE *anima_fp ;

{
    int i ;
    char anima_id[7] ;	/* identifies file as Anima file */

    if (anima_fp == NULL)
    {
	fprintf (stderr,"can't write footer to non-existent file\n") ;
	exit(0) ;
    }
    strcpy (anima_id,"anima") ;
    fprintf (anima_fp,"\n\f\n") ;
    for (i = S_anima_count - 1 ; i >= 0 ; i--)
    {
	fprintf (anima_fp,"%d %ld %ld\n",i,S_a_index[i].buf_total,
					   S_a_index[i].offset) ;
    }
    fprintf (anima_fp,"bytes to footer =%12ld\n",S_anima_bytes) ;
    fprintf (anima_fp,"number of frames=%12ld\n",S_anima_count) ;
    fprintf (anima_fp,"%s",anima_id) ;
}
