/* record.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


/* part of client RPC package having to do with recording */

#include <stdio.h>
#include <math.h>
#include <scry_image.h>
#include <scry_client.h>
#include <scry_limits.h>


/* scry_init_record:  set record option and optionally position recorder
   sc_set_frame:  update current frame number
   xdr_init_ret:  XDR decode server recorder information
   xdr_init_req:  XDR encode recorder initialization information */


struct recinfo
{
    long optflag ;	/* server has optical disk */
    int start_frame ;	/* starting frame to record on */
    int total ;		/* total number frames to record */
    char *username ;	/* user id */
    char *system_name ;	/* symbolic name for client in /etc/hosts */
    char *movie_title ;	/* title of movie */
} ;

static long s_optflag ;		/* whether server has optical disk */
static int s_curr_frame ;	/* current recording frame */




/* set record option, and if in record mode, position videotape or
   videodisk at starting frame */

scry_init_record (framenum,total,movie_title)

int framenum ;		/* record option */
int total ;		/* if not preview, total frames requested */
char *movie_title ;

{
    struct recinfo rec_send ;	/* recording information sent */
    struct recinfo rec_return ;	/* recording information returned */
    enum clnt_stat err ;	/* error status of RPC call */
    bool_t xdr_init_req() ;		/* XDR encode recording information */
    bool_t xdr_init_ret() ;		/* XDR encode recording information */

    if ((framenum < S_AUTOSEEK) || (framenum > S_MAX_REC_FRAMES))
    {
	fprintf (stderr,"scry_init_record:  %d is an illegal recording option\n",framenum) ;
	scry_close() ;
	exit(0) ;
    }
    if ((total < 1) || (total > S_MAX_REC_FRAMES))
    {
	fprintf (stderr,"scry_init_record:  %d is an illegal number of frames\n",framenum) ;
	scry_close() ;
	exit(0) ;
    }
    S_image_info.s_recordable = framenum ;
	/* if preview only */
    if (framenum == S_PREVIEW)
    {
       S_image_info.in_at = 0 ;
       S_image_info.out_at = 0 ;
       return ;
    }
    if (S_image_info.s_recordable != S_PREVIEW)
    {
	rec_send.start_frame = framenum ;
	rec_send.total = total ;

	    /* info to be put in log on PC (in \movie\movie.log) */
	rec_send.username = malloc(80) ;
	rec_send.system_name = malloc(80) ;
	rec_send.movie_title = malloc(120) ;
	cuserid(rec_send.username) ;
	gethostname(rec_send.system_name,80) ;
	if (movie_title != NULL)
	    strcpy(rec_send.movie_title,movie_title) ;
	else
	    strcpy(rec_send.movie_title,"untitled") ;

        S_during_rpc = 1 ;
	    /* position at starting frame */
	    /* find out whether video workstation uses videotape or
	       video disk (RPC returns optflag) */
        if ((int) (err = clnt_call(S_client,S_INITPROC,xdr_init_req,&rec_send,
			 xdr_init_ret,&rec_return,S_total_timeout)) != 0)
        {
	    clnt_perrno ((int) err) ;
	    fprintf (stderr,"can't make S_INITPROC call\n") ;
	    clnt_destroy (S_client) ;
	    return ;
        }
        S_during_rpc = 0 ;
        if (S_make_closing_call)
	    scry_abn_exit() ;
	free(rec_send.username) ;
	free(rec_send.system_name) ;
	free(rec_send.movie_title) ;
	s_curr_frame = rec_return.start_frame ;
	    /* if server is not in record mode */
	if (s_curr_frame == 0)
	{
	    S_image_info.s_recordable = 0 ;
	    return ;
	}
	s_optflag = rec_return.optflag ;
	    /* if server has optical disk */
	if (s_optflag)
	{
		/* check starting frame */
	    if (rec_return.start_frame == -1)
	    {
		fprintf (stderr,"not enough frames on optical disk\n") ;
		exit (0) ;
	    
	   }
	}
    }
}




/* update current frame number */

sc_set_frame (s_copy_num)

int s_copy_num ;	/* ununsed in this revision */

{
        /* if actually recording */
    if ((S_image_info.s_recordable != S_PREVIEW) && (s_curr_frame != 0))
    {
	S_image_info.in_at = s_curr_frame ;	/* start recording at */
	if (!s_optflag)	/* if recording on videotape */
		/* record copy_num frames */
	    S_image_info.out_at = s_curr_frame + s_copy_num ;
	else		/* recording on video disk */
		/* record 1 frame */
	    S_image_info.out_at = s_curr_frame + 1 ;
	s_curr_frame = S_image_info.out_at ;
    }
}




/* XDR decode server recorder information */

bool_t 
xdr_init_ret (xdrsp,rec_return)

XDR *xdrsp ;		/* XDR handle */
struct recinfo *rec_return ;

{
	    /* optical disk or not */
    if (!xdr_int(xdrsp,&(rec_return->optflag)))
	return (0) ;
	    /* starting frame */
    if (!xdr_int(xdrsp,&(rec_return->start_frame)))
	return (0) ;
	    /* frames requested */
    if (!xdr_int(xdrsp,&(rec_return->total)))
	return (0) ;
    return(1) ;
}



/* XDR encode movie log and requested frame number and number
   of frames to record */

bool_t 
xdr_init_req (xdrsp,rec_send)

XDR *xdrsp ;		/* XDR handle */
struct recinfo *rec_send ;

{
    int user_length = strlen(rec_send->username) ;
    int system_length = strlen(rec_send->system_name) ;
    int title_length = strlen(rec_send->movie_title) ;

    user_length += 4 - (user_length % 4) ;
    system_length += 4 - (system_length % 4) ;
    title_length += 4 - (system_length % 4) ;
	    /* optical disk or not */
    if (!xdr_int(xdrsp,&(rec_send->optflag)))
	return (0) ;
	    /* starting frame */
    if (!xdr_int(xdrsp,&(rec_send->start_frame)))
	return (0) ;
	    /* frames requested */
    if (!xdr_int(xdrsp,&(rec_send->total)))
	return (0) ;
	    /* user id */
    if (!xdr_bytes(xdrsp,&(rec_send->username),&user_length,80))
	return (0) ;
	    /* client host name */
    if (!xdr_bytes(xdrsp,&(rec_send->system_name),&system_length,80))
	return (0) ;
	    /* movie title */
    if (!xdr_bytes(xdrsp,&(rec_send->movie_title),&title_length,100))
	return (0) ;
    return(1) ;
}
