/* compress.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


/* sc_compress:		compresses an image
   sc_set_compress:	sets compression type
   scry_set_max_color:	sets maximum number of color map entries
			resulting from quantization
   scry_set_map:	explicitly set color map */


#include <stdio.h>
#include <math.h>
#include <scry_image.h>
#include <scry_anima.h>
#include <scry_client.h>



/* compresses an image */

unsigned char *
sc_compress (image,height,width,depth)

unsigned char *image ;
int height ;
int width ;
int depth ;

{
    unsigned char *compdata = NULL ;
    unsigned char *interdata ;
    int datasize ;
    int saveflag = 0 ;
    int i ;

       /* Anima files can only have compression type S_CCC.
	  However S_CCC and S_LEMPEL_ZIV compression can be used
	  to transmit an image; it will be expanded to
	  S_CCC only on the server */

        /* if saving an Anima file */
    if (S_anima_filename[0] != '\0')
    {
	if (S_client == NULL)	/* if to save locally */
	    S_image_info.compression = S_CCC ;
	else
	{	/* save on server */
	    if (S_image_info.compression & S_LEMPEL_ZIV)
	        saveflag = S_LEMPEL_ZIV ;
	    S_image_info.compression = S_CCC | saveflag ;
	}
    }

    switch (S_image_info.compression)
    {
	    /* quantization to 8 bits only */
        case S_QUANTIZE:
            compdata = (unsigned char *) malloc(height*width) ;
		/* if not already 8 bits, quantize */
            if (depth != 1)
                S_mapnum = quantize (image,compdata,S_map,S_maxcol,height,width,0) ;
            else
                memcpy (compdata,image,height*width) ;
            S_image_info.total = height * width ;
            break ;		
		/* quantization to 8 bits followed by
		   Lempel-Ziv compression */
        case S_QUANTIZE | S_LEMPEL_ZIV:
            interdata = (unsigned char *) malloc(height*width) ;
		/* if not already 8 bits, quantize */
            if (depth != 1)
                S_mapnum = quantize (image,interdata,S_map,S_maxcol,height,width,0) ;
            else
                memcpy (interdata,image,height*width) ;
            datasize = S_image_info.total = height * width ;
            compdata = (unsigned char *) malloc(S_image_info.total) ;
		/* perform Lempel-Ziv (Unix "compress") */
            lzw_compress (interdata,&datasize,compdata) ;
		/* if compression was worthwhile */
            if ((datasize+1000)<S_image_info.total)
                S_image_info.total_lz = datasize ;
            else	/* undo */
            {
                S_image_info.total_lz = 0 ;
                S_image_info.compression -= S_LEMPEL_ZIV ;
                memcpy(compdata,interdata,S_image_info.total) ;
            }
            free(interdata);
            break ;
		/* S_CCC and run length encoding (IFF format compression) */
        case S_CCC :
            compdata = (unsigned char *) malloc((height*width)/2) ;
            ccc_compress (image,compdata,&datasize,height,width) ;
            S_image_info.total = datasize ;
            break ;
		/* S_CCC and run length encoding, followed by
		   Lempel-Ziv compression on result */
        case S_CCC | S_LEMPEL_ZIV:
            interdata = (unsigned char *) malloc((height*width)/2) ;
            ccc_compress (image,interdata,&datasize,height,width) ;
            S_image_info.total = datasize ;
            compdata = (unsigned char *) malloc(datasize) ;
            lzw_compress (interdata,&datasize,compdata) ;
		/* if compression worthwhile */
            if ((datasize+1000)<S_image_info.total)
                S_image_info.total_lz = datasize ;
            else	/* undo */
            {
                S_image_info.total_lz = 0 ;
                S_image_info.compression -= S_LEMPEL_ZIV ;
                memcpy(compdata,interdata,S_image_info.total) ;
            }
            free(interdata) ;
            break ;
        case S_LEMPEL_ZIV:
            fprintf (stderr,"S_LEMPEL_ZIV by itself is only a legal option in Scry\n") ;
            fprintf (stderr,"for images that have been converted to 8 bits:\n") ;
            fprintf (stderr,"select the S_QUANTIZE option as well.\n") ;
            fprintf (stderr,"No further compression performed.\n") ;
            S_image_info.compression = S_NONE ;
		/* no compression */
        case S_NONE:
            compdata = (unsigned char *) malloc(height*width*depth) ;
            memcpy (compdata,image,height*width*depth) ;
            break ;
        default:
            fprintf (stderr,"compression type not supported; no further compression performed\n") ;
            compdata = (unsigned char *) malloc(height*width*depth) ;
            memcpy (compdata,image,height*width*depth) ;
            break ;
    }
    return (compdata) ;
}




/* sets compression type */

sc_set_compress (compress_type)

int compress_type ;

{
    S_image_info.compression = compress_type ;
}



/* sets maximum number of quantization entries */

scry_set_max_color (mapnum)

int mapnum ;

{
    if ((mapnum < 0) || (mapnum > S_MAX_COL_SIZE))
    {
	fprintf (stderr,"scry_set_max_color:  %d is an illegal number of color map entries\n",mapnum) ;
	fprintf (stderr,"Using the maximum.\n") ;
	S_maxcol = S_MAX_COL_SIZE ;
    }
    else
        S_maxcol = mapnum ;
}



/* sets color map */

scry_set_map (num,map)

int num ;
unsigned char *map  ;

{
    int i ;

    if (map == NULL)
    {
	fprintf (stderr,"scry_set_map:  space for color map has not been allocated\n") ;
	fprintf (stderr,"This call has had no effect\n") ;
	return ;
    }
    if ((num < 1) || (num > S_MAX_COL_SIZE))
    {
	fprintf (stderr,"scry_set_map:  %d is an illegal number of entries\n") ;
	fprintf (stderr,"This call has had no effect\n") ;
	return ;
    }
    S_mapnum = num ;
    for (i = 0 ; i < num ; i++)
    {
	S_map[i][S_RED] = map[i*3] ;
	S_map[i][S_GREEN] = map[i*3+1] ;
	S_map[i][S_BLUE] = map[i*3+2] ;
    }
}
