/* Xserv.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include <stdio.h>
#include <math.h>
#include <scry_serv.h>
#include "xvwin.h"
#include <scry_image.h>
#include <scry_anima.h>
#include <scry_limits.h>
#include <signal.h>
#include "Xserv_ui.h"

/* quit_button_handler:  quit server
   gamma_handler:  set gamma value for next frame
   anima_init:  initialize Anima footer variable values
   parse_args:  parse command-line arguments
   tcp_service:  TCP server
   svc_notifier:  uses Notifier to get incoming RPC's
   session_closed:  sets variable that indicates the connection has been closed
   graphics_dispatch:  RPC remote "program"
   xdr_map:  XDR decodes color map
   xdr_image_info:  XDR decodes incoming image information
   xdr_compressed:  gets compressed image
   xdr_visout:  XDR encodes server display information for client
   xdr_filesave:  XDR decodes name to save Anima file under
   xdr_init_ret:  noop -- provides compatibility with PC server
   xdr_init_req:  noop -- provides compatibility with PC server	  */

int S_dont_repaint = 1 ;	/* if on, don't repaint */
int prognum ;		/* RPC program number */

static int a_convenient_address ;		/* address of notifier client */
static Notify_client *notifier_client ;	
static Notify_value svc_notifier() ;	/* gets incoming RPC's using the notifier */
static int start_of_session = 1 ;	/* connection coming in */
static int prev_session_ended = 0 ;	/* previous session ended */
static int initial_socket ;		/* initial socket */
static int connection_socket ;	/* dup'ed socket that handles incoming RPC's */
static int no_RPC_made = 1 ;	/* no RPC has been made for this session */

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */

Attr_attribute	INSTANCE;

Xserv_control_objects *Xserv_control ;	/* Xserv control panel */

void
main(argc, argv)

int argc;
char *argv[];

{
        /* Initialize XView. */
    xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, 0);
    INSTANCE = xv_unique_key();
	
	/* Initialize user interface components. */
    Xserv_control = Xserv_control_objects_initialize(NULL, NULL);

	/* get command-line arguments */
    parse_args (argv,argc,&prognum) ;

    if (prognum == 0)
    {
	fprintf (stderr,"program number must be supplied: use -P # option\n") ;
	exit (0) ;
    }
    if (prognum < S_MIN_RPC_PROGNUM)
    {
	fprintf (stderr,"illegal program number\n") ;
	exit(0) ;
    }
	/* initialize display window */
    image_init(Xserv_control->control) ;
	/* initialize Anima footer variables */
    anima_init() ;
	/* start server */
    tcp_service(prognum);
}




/*
 * Notify callback function for `quit_button'.
 */

/* destroy server */

void
quit_button_handler(item, event)

Panel_item	item;
Event		*event;

{
    Xserv_control_objects	*ip = (Xserv_control_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
    session_closed() ;
    notify_set_input_func(notifier_client, NOTIFY_FUNC_NULL, initial_socket) ;

    xv_set(Xserv_control->control, FRAME_NO_CONFIRM, TRUE, 0);
    xv_destroy_safe(Xserv_control->control);
    xv_set(image_canvas, FRAME_NO_CONFIRM, TRUE, 0);
    xv_destroy_safe(image_canvas);
    free(S_image_info.data) ;
}




/*
 * Notify callback function for `gamma_text'.
 */

/* set gamma value for next image received */

Panel_setting
gamma_handler(item, event)
	Panel_item	item;
	Event		*event;
{
	Xserv_control_objects	*ip = (Xserv_control_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char *	value = (char *) xv_get(item, PANEL_VALUE);
	float temp_gamma ;
	
	temp_gamma = (float) atof(value) ;
	if ((temp_gamma > 0.1) && (temp_gamma <= 4.0))
	    scry_gamma = atof(value) ;
	else
	    xv_set(item, PANEL_VALUE,"",0) ;
	return panel_text_notify(item, event);
}




/* initialize Anima footer variable values */

anima_init()

{
    S_anima_file = NULL ;
    S_anima_filename[0] = '\0' ;
    S_anima_bytes = 0 ;
    S_anima_count = 0 ;
    S_a_index = NULL ;
}




/* parse command-line arguments */

parse_args (argv,argc,prognum)

char *argv[] ;
int argc ;
int *prognum ;		/* RPC program number */

{
    int i ;

    *prognum = 0 ;
    for(i = 1; i < argc; i++)
    {
        if (*argv[i] != '-')
        {
            fprintf (stderr,"bad command line:  use %s -h for help\n",argv[0]) ;
            exit (-1) ;
        }
    	switch(*(argv[i]+1))
        {
	    case 'p':
	    case 'P':
		*prognum = atoi(argv[++i]) ;
		break ;
		    /* set maximum number of entries in color table */
	    case 'c':
		S_maxcol = atoi(argv[++i]) ;
		if ((S_maxcol < 1) || (S_maxcol > S_MAX_COL_SIZE))
		{
		    fprintf (stderr,"incorrect color entry maximum setting\n") ;
		    fprintf (stderr,"using default number of colors\n") ;
		    S_maxcol = S_MAX_COL_DISPLAY ;
		}
		break ;
            case 'h':
            case 'H':
                fprintf (stderr,"usage is %s -p prognum [-w x y]\n",argv[0]) ;
		fprintf (stderr,"-p num chooses program number\n") ;
		fprintf (stderr,"-c chooses the maximum number of colors\n") ;
                fprintf (stderr,"-h displays this message\n") ;
                exit (1) ;
            default:
                fprintf(stderr, "use %s -h for help\n",argv[0]) ;
                exit(1);
        }
    }
}




/* TCP server */

tcp_service (prognum)

int prognum ;		/* RPC program number */

{
    register SVCXPRT *transp ;	/* RPC transport handle */

    if ((initial_socket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
        perror("tcp socket creation problem") ;

        /* create transport handle */
    if ((transp = svctcp_create(initial_socket,0,0)) == NULL)
    {
        fprintf (stderr,"svctcp_create: error\n") ;
        exit(1) ;
    }

    pmap_unset (prognum, S_TESTVERS);

    /* register service (routine contain remote "procedures") */
    if (!svc_register(transp,prognum,S_TESTVERS,graphics_dispatch,IPPROTO_TCP))
    {
        fprintf (stderr, "prognum %d svc_register: error\n",prognum) ;
        exit (1) ;
    }

    notifier_client = (Notify_client *) &a_convenient_address ;
	/* set notify routine to call when activity on socket */
    (void) notify_set_input_func(notifier_client, svc_notifier, initial_socket) ;
    xv_main_loop(Xserv_control->control) ;
}




/* uses Notifier to get incoming RPC's */

static Notify_value
svc_notifier(notifier_client,current_socket)

Notify_client notifier_client ;
int current_socket ;

{
    fd_set readfds ;
    int socket_duplicated = 0 ;

    if (start_of_session && prev_session_ended)
    {
	close(connection_socket) ;
        notify_set_input_func(notifier_client, NOTIFY_FUNC_NULL, connection_socket) ;
	prev_session_ended = 0 ;
    }
    FD_ZERO(&readfds) ;
    FD_SET(current_socket, &readfds ) ;
    no_RPC_made = 1 ;
    svc_getreqset(&readfds);
    FD_CLR(current_socket, &readfds) ;
	/* reset notifier to watch for activity on dup'ed socket */
    if (start_of_session)
    {
	connection_socket = current_socket + 1 ;
	while (FD_ISSET(connection_socket,&svc_fdset)==0)
	    connection_socket++ ;
        (void) notify_set_input_func(notifier_client, svc_notifier, connection_socket) ;
	start_of_session = 0 ;
	socket_duplicated = 1 ;
    }
	/* cannot leave routine with closed socket, so dup temporarily */
    if ((prev_session_ended == 1)
	|| (!socket_duplicated && !prev_session_ended &&
	    !start_of_session && no_RPC_made))
    {
	prev_session_ended = 1 ;
	start_of_session = 1 ;
	if ((current_socket = dup2(initial_socket,current_socket)) == -1)
	{
	    fprintf (stderr,"socket duplication didn't work\n") ;
	    exit(0) ;
	}
    }
    return (NOTIFY_DONE) ;
}




/* sets variable that indicates the connection has been closed */

session_closed()

{
    prev_session_ended = 1 ;
}




/* noop structure:  used for compatibility with PC server */

struct recinfo
{
    long optflag ;
    long start_frame ;
    long total ;
    char *username ;
    char *system_name ;
    char *movie_title ;
} ;

struct recinfo rec_recv, rec_sent ;


/* used if saving Anima file */

struct fileinfo
{
    long total_frames ;		/* total frames to save */
    char *filename[80] ;
} ;

struct fileinfo file_stuff ;




/* graphics dispatch:  contains remote procedures */


/* In RPC parlance, corresponds to remote program (graphics_dispatch was
   registered with svc_register).  Different cases are remote procedures. */

graphics_dispatch (rqstp,transp)

register struct svc_req *rqstp ;	/* RPC request data structure */
register SVCXPRT *transp ;	/* RPC transport handle */

{
    int i ;
    long normal ;
    XID canvas_xid ;

    switch ((int) rqstp->rq_proc)    /* which RPC */
    {
            /* NULL RPC call */
        case NULLPROC:
                /* send acknowledgement */
            if (svc_sendreply (transp,xdr_void,0) == 0)
            {
                fprintf (stderr,"err: rcp_service\n") ;
                return(0) ;
            }
	    no_RPC_made = 0 ;
            return (1) ;


            /* clear server display */
        case S_CLEARPROC:
                /* send acknowledgement */
            if (svc_sendreply (transp,xdr_void,0) == 0)
            {
                fprintf (stderr,"err: rcp_service\n") ;
                return(0) ;
            }
            canvas_xid = (XID) xv_get(canvas_paint_window(image_canvas), XV_XID);
	    XClearWindow(display,canvas_xid) ;
	    no_RPC_made = 0 ;
            return (1) ;


        case S_VISPROC:
                /* send server info */
            if (svc_sendreply (transp,xdr_visout,&S_image_info) == 0)
            {
                fprintf (stderr,"err: rcp_service\n") ;
                return(0) ;
            }
	    no_RPC_made = 0 ;
            return (1) ;


       case S_CLOSEPROC:
#ifdef MESSAGES
	    fprintf (stderr,"CLOSEPROC called\n") ;
#endif
            if (!svc_getargs(transp,xdr_long,&normal))
            {
                svcerr_decode(transp) ;
                return(0) ;
            }
	    no_RPC_made = 0 ;
	    session_closed() ;
	    if ((S_anima_file != NULL) && !normal)
	    {
		fprintf (stderr,"unlinking Anima file on client interrupt\n") ;
		unlink (S_anima_filename) ;
	    }
               /* send acknowledgement */
            if (!svc_sendreply(transp,xdr_void,(char *) 0))
            {
               	fprintf (stderr,"can't reply\n") ;
               	return (0) ;
            }
            return (1) ;


           /* noop recorder initialization called; provided
	      for compatibility with PC server */

       case S_INITPROC:
            if (!svc_getargs(transp,xdr_init_req,&rec_recv))
            {
                svcerr_decode(transp) ;
                return(0) ;
            }
	    rec_sent.total = 0 ;
	    rec_sent.optflag = 0 ;
	    rec_sent.start_frame = 0 ;
               /* send acknowledgement */
            if (!svc_sendreply(transp,xdr_init_ret,&rec_sent))
            {
               	fprintf (stderr,"can't reply\n") ;
               	return (0) ;
            }
	    no_RPC_made = 0 ;
            return (1) ;


          /* get name to save Anima file under and
	     total frames to be saved */
       case S_FILENAMEPROC:
            if (!svc_getargs(transp,xdr_filesave,&file_stuff))
            {
                svcerr_decode(transp) ;
                return(0) ;
            }
		/* initialize Anima footer variables */
            if ((S_anima_file == NULL) && (file_stuff.filename[0] != '\0'))
	    {
		strcpy(S_anima_filename,file_stuff.filename) ;
#ifdef MESSAGES
		fprintf (stderr,"opening anima file %s\n",S_anima_filename) ;
#endif
	        S_anima_file = fopen (S_anima_filename,"w") ;
                S_anima_bytes = 0 ;
                S_anima_count = 0 ;
                if (S_a_index == NULL)
                    S_a_index = (struct footer *)malloc(file_stuff.total_frames
					*sizeof(struct footer)) ;
                else
	            S_a_index = (struct footer *) realloc((char *)S_a_index,
				    file_stuff.total_frames*sizeof(struct footer)) ;
	    }
	    no_RPC_made = 0 ;
               /* send acknowledgement */
            if (!svc_sendreply(transp,xdr_void,(char *) 0))
            {
               	fprintf (stderr,"can't reply\n") ;
               	return (0) ;
            }
            return (1) ;



	   /* optionally decompress and display image */

	   /* acknowledgement to RPC sent within display_frame */
       case S_DISPLAYPROC:
	       no_RPC_made = 0 ;
               return (display_frame(transp)) ;


           /* couldn't find RPC - send error message */
       default:
           svcerr_noproc(transp) ;
           return(0) ;
    }
}




/* XDR routine for decoding color map */

bool_t 
xdr_map (xdrsp,map)

XDR *xdrsp ;		/* XDR handle */
unsigned char *map ;	/* color map */

{
    int i ;

	/* number of entries incolor map */
    if (!xdr_long(xdrsp,&(S_mapnum)))
        return (0) ;
    if (!xdr_opaque(xdrsp,map,S_mapnum*3))
        return (0) ;
    return(1) ;
}




/* XDR decodes incoming image information */

bool_t 
xdr_image_info (xdrsp,buf)

XDR *xdrsp ;     /* XDR handle */
struct image_stuff *buf ;	/* control information */

{
    short i ;

	    /* current frame in Anima file, if saving */
    if (!xdr_long(xdrsp,&buf->current_frame_to_save))
        return (0) ;
	    /* total frames in Anima file, if saving */
    if (!xdr_long(xdrsp,&buf->total_frames))
        return (0) ;
	    /* compression type */
    if (!xdr_long(xdrsp,&buf->compression))
        return (0) ;
	    /* number of bytes in compressed frame */
    if (!xdr_long(xdrsp,&buf->total))
        return (0) ;
    if (!xdr_long(xdrsp,&buf->c_height))
        return (0) ;
    if (!xdr_long(xdrsp,&buf->c_width))
        return (0) ;
    if (!xdr_long(xdrsp,&buf->c_depth))
        return (0) ;
        /* if Lempel-Ziv compression was used */
    if (buf->compression & S_LEMPEL_ZIV)
    {
        if (!xdr_long(xdrsp,&buf->total_lz))
            return (0) ;
    }
    /* not used with this server */
    if (!xdr_long(xdrsp,&(buf->in_at)))  /* start recording at */
        return (0) ;
    if (!xdr_long(xdrsp,&(buf->out_at))) /* finish recording at */
        return (0) ;
    return(1) ;
}




/* gets compressed image */

bool_t 
xdr_compressed (xdrsp,buf)

XDR *xdrsp ;			/* XDR handle */
struct image_stuff *buf ;	/* frame */

{
	/* read in as is */
    if (!xdr_opaque(xdrsp,buf->data,buf->total))
        return (0) ;

    return(1) ;
}




/* XDR encodes server display information for client */

bool_t 
xdr_visout (xdrsp,image_info)

XDR *xdrsp ;		/* XDR handle */
struct image_stuff *image_info ;

{
	    /* depth of server display in bytes */
    if (!xdr_long(xdrsp,&(image_info->s_depth)))
	return (0) ;
	    /* maximum server display height */
    if (!xdr_long(xdrsp,&(image_info->s_max_height)))
	return (0) ;
	     /* maximum server display width */
    if (!xdr_long(xdrsp,&(image_info->s_max_width)))
	return (0) ;
	     /* equipped with videodisk recorder or not */
    if (!xdr_long(xdrsp,&(image_info->s_recordable)))
	return (0) ;
    return(1) ;
}




/* XDR decodes name to save Anima file under */

bool_t 
xdr_filesave (xdrsp,file_stuff)

XDR *xdrsp ;		/* XDR handle */
struct fileinfo *file_stuff ;

{
        /* total frames to be saved */
    if (!xdr_long(xdrsp,&(file_stuff->total_frames)))
	return (0) ;
    if (!xdr_opaque(xdrsp,file_stuff->filename,80))
	return (0) ;
    return (1) ;
}




/* noop -- provides compatibility with PC server */

bool_t 
xdr_init_ret (xdrsp,rec_return)

XDR *xdrsp ;		/* XDR handle */
struct recinfo *rec_return ;

{
	    /* optical disk or not */
    if (!xdr_int(xdrsp,&(rec_return->optflag)))
	return (0) ;
	    /* starting frame */
    if (!xdr_int(xdrsp,&(rec_return->start_frame)))
	return (0) ;
	    /* frames requested */
    if (!xdr_int(xdrsp,&(rec_return->total)))
	return (0) ;
    return(1) ;
}




/* noop -- provides compatibility with PC server */

bool_t 
xdr_init_req (xdrsp,rec_send)

XDR *xdrsp ;		/* XDR handle */
struct recinfo *rec_send ;

{
    int dummy ;

	    /* optical disk or not */
    if (!xdr_int(xdrsp,&(rec_send->optflag)))
	return (0) ;
	    /* starting frame */
    if (!xdr_int(xdrsp,&(rec_send->start_frame)))
	return (0) ;
	    /* frames requested */
    if (!xdr_int(xdrsp,&(rec_send->total)))
	return (0) ;
	    /* movie title information */
    if (!xdr_bytes(xdrsp,&(rec_send->username),&dummy,80))
	return (0) ;
    if (!xdr_bytes(xdrsp,&(rec_send->system_name),&dummy,80))
	return (0) ;
    if (!xdr_bytes(xdrsp,&(rec_send->movie_title),&dummy,100))
	return (0) ;
    return(1) ;
}
