/* svanima.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


/* Animation playback program
 * Teck-Joo Chua 8/18/88
 * Max Rible 10/31/88
 * Antony Courtney 89
 * David Robertson 89, 90
 */

#include <stdio.h>
#include <scry_anima.h>
#include <scry_limits.h>
#include "svwin.h"


/* parse_args:  parse command-line arguments
   init_anima_vars:  initialize sequence and footer information */


static void parse_args();
static void init_anima_vars();

struct panelvars a_panel;	/* svanima control panel */
int S_do_zoom = 0 ;		/* zoom or not */
int winx, winy ;		/* upper left corner of window */
float scry_gamma = S_DEF_GAMMA_VALUE ;	/* gamma value */
int gamma_changed = 0 ;		/* gamma value changed or not */
int S_dont_repaint = 1 ;		/* if true, don't repaint */



main(argc, argv)

int argc;
char *argv[];

{
    init_anima_vars();
    winx = 512; winy = 256;	/* default placement of control panel */

        /* get command-line arguments */
    parse_args(argc, argv);
    
	/* set up control panel and display window */
    image_init(argc,argv,winx,winy);
	/* if Anima file name was entered on command line */
    if(S_anima_filename[0] != NULL)
    {
	    /* get it */
	if (getfile())
	{
	    S_avars.frame.last = S_anima_count - 1 ;
	    S_avars.start = TRUE ;
	}
    }

	/* service requests until quit */
    window_main_loop(anima_control);
}




/* parse command-line arguments */

static void
parse_args(argc, argv)

int argc;
char *argv[];

{
    int i;
    
    for(i = 1; i < argc; i++)
    {
        if(*argv[i] != '-')
        {
            fprintf(stderr,"bad command line:  use %s -h for help\n", argv[0]);
            exit(-1);
        }
        switch(*(argv[i]+1))
        {
            case 'i':		/* compressed data file */
                strcpy(S_anima_filename, argv[++i]);
                break;
            case 'w':		/* upper left corner of panel */
                winx = atoi(argv[++i]);
                winy = atoi(argv[++i]);
                break;
            case 'h':
                fprintf(stderr,"Sunview animation editor.\n");
                fprintf(stderr,"Usually invoke with %s [args]\n",argv[0]);
                fprintf(stderr,"-i file : compressed image input file\n");
                fprintf(stderr,"-w winx winy : upper left window origin\n");
                fprintf(stderr,"-h : this message\n");
                exit(-1);
            default:
                printf("bad command line:  use %s -h for help\n", argv[0]);
                exit(-1);
        }
    }
}




/* initialize sequence viewing and Anima footer */

static void
init_anima_vars()
{
    S_avars.stop = TRUE;		/* Stay put */
    S_avars.advance = FALSE;	/* Stay put */
    S_avars.speed = 5;		/* Half speed */
    S_avars.search = FALSE;	/* Stay put */
    S_avars.current = 0;		/* Start at 0 */
    S_avars.start = FALSE;		/* Nothing yet... */
    S_avars.direction = S_FORWARD;
    S_avars.quit = FALSE;		/* Don't die! */
    S_avars.pid = getpid();

    S_anima_file = NULL ;
    S_anima_filename[0] = '\0' ;
    S_anima_bytes = 0 ;
    S_anima_count = 0 ;
}
