/* combine.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include <stdio.h>
#include <scry_anima.h>
#include <scry_image.h>
#include <scry_limits.h>


/* parse_args:  parse command-line arguments
   combine_frame:  get frame and put it in combined file */


static void parse_args();

char anima_format[80] ;		/* whether many map or one map Anima file */

char out_name[80] ;		/* name of combined name */
char anima_filename1[80] ;	/* old Anima files */
char anima_filename2[80] ;
FILE *anima_file1 ;
FILE *anima_file2 ;
FILE *combined_file ;

unsigned char *S_image_mem ;
struct image_stuff S_image_info ;	/* image information (height, etc.) */
unsigned char S_map[S_MAX_COL_SIZE][3] ;	/* color map */
int S_mapnum ;			/* number of entries in color map */



main(argc, argv)

int argc;
char *argv[];

{
    int i ;
    int height, width ;
    int first_count = 0 ;	/* number of frames in first file */
    int first_bytes = 0 ;	/* number of bytes to footer in first file */
    int second_count = 0 ;	/* number of frames in second file */
    int second_bytes = 0 ;	/* number of bytes to footer in second file */
    
    S_anima_bytes = 0 ;
    S_anima_count = 0 ;

        /* get command-line arguments */
    parse_args(argc, argv);
    combined_file = fopen (out_name, "w") ;
    if (anima_filename1[0] != NULL)
    {
	    /* read first file's Anima footer */
	if (!get_one_file(&anima_file1,anima_filename1,&first_count,&first_bytes))
	{
	    perror ("reading anima file") ;
	    exit (0) ;
	}
    }
    if (anima_filename2[0] != NULL)
    {
	    /* read second file's Anima footer */
	if (!get_one_file(&anima_file2,anima_filename2,&second_count,&second_bytes))
	{
	    perror ("reading anima file") ;
	    exit (0) ;
	}
    }
	/* form combined Anima footer */
    get_footer(anima_file1,anima_file2,first_count,second_count,first_bytes,second_bytes) ;

    S_image_info.c_width = 0 ;
    S_image_info.c_height = 0 ;
    
    S_anima_count = 0 ;
    S_anima_bytes = 0 ;

    S_anima_file = anima_file1 ;
    fseek(S_anima_file,0,0) ;

        /* add in frames from first file */
    for (i = 0 ; i < first_count ; i++)
    {
        if ((i % 25) == 0)
            fprintf (stderr,"frame %d\n",i) ;
        combine_frame(i,combined_file) ;
    }
    fclose(S_anima_file) ;

    S_anima_file = anima_file2 ;
    fseek(S_anima_file,0,0) ;
	/* add in frames from second file */
    for (i = 0 ; i < second_count ; i++)
    {
        if ((i % 25) == 0)
            fprintf (stderr,"frame %d\n",i) ;
        combine_frame(i,combined_file) ;
    }
	/* write combined Anima footer */
    anima_write_footer(combined_file) ;
    fclose(S_anima_file) ;
    fclose(combined_file) ;
}




/* get command-line arguments */

static void
parse_args(argc, argv)

int argc;
char *argv[];

{
    int i;
    
    for(i = 1; i < argc; i++)
    {
	    if(*argv[i] != '-')
            {
		    printf("bad command line:  use %s -h for help\n", argv[0]);
		    exit(-1);
            }
	    switch(*(argv[i]+1))
            {
		case 'i':		/* two Anima files */
		    strcpy(anima_filename1, argv[++i]);
		    strcpy(anima_filename2, argv[++i]);
		    break;
		case 'o':		/* combined file */
		    strcpy(out_name,argv[++i]) ;
		    break ;
		case 'h':
		    fprintf(stderr,"combines two Anima files\n") ;
		    fprintf(stderr,"usage:  combine -i file1 file2 -o output\n") ;
		    fprintf(stderr,"-h : this message\n");
		    exit(-1);
		default:
		    fprintf(stderr,"bad command line:  use %s -h for help\n", argv[0]);
		    exit(-1);
        }
    }
}




/* adds one frame to combined file */

combine_frame(current,out)

int current ;	/* current frame */
FILE *out ;	/* output file */

{
    int height, width ;
    
	/* seek to first frame */
    fseek(S_anima_file, 0, 0) ;
	/* read IFF header */
    if(!iff_read_header(S_anima_file, &S_image_info, &height, &width,anima_format))
        fprintf(stderr,"iff_read_header failed\n");
	    /* if different size than previous */
    if ((S_image_info.c_height != height) || (S_image_info.c_width != width))
    {
        S_image_info.c_height = height ;
        S_image_info.c_width = width ;
        if (S_image_info.data != NULL)
            free(S_image_info.data) ;
        S_image_info.data = (unsigned char *) malloc(S_image_info.c_height * S_image_info.c_width / 2) ;
    }
	/* seek to current frame */
    fseek(S_anima_file, S_a_index[S_anima_count].offset, 0);

	/* read IFF header if necessary */
    if ((anima_format[0] == 'm') || (current == 0))
    {
        if(!iff_read_header(S_anima_file, &S_image_info, &height, &width,anima_format))
	    fprintf(stderr,"iff_read_header failed\n");
    
	     /* if different size than previous */
        if ((S_image_info.c_height != height) || (S_image_info.c_width != width))
        {
            S_image_info.c_height = height ;
            S_image_info.c_width = width ;
	    if (S_image_info.data != NULL)
	        free(S_image_info.data) ;
	    S_image_info.data = (unsigned char *) malloc(S_image_info.c_height * S_image_info.c_width / 2) ;
        }
    }
    S_image_info.total = S_a_index[S_anima_count].buf_total ;
	/* read compressed image */
    iff_read_buf(S_anima_file, &S_image_info);
	/* update combined Anima footer */
    S_a_index[S_anima_count].offset = S_anima_bytes ;
    S_a_index[S_anima_count].buf_total = S_image_info.total ;
	/* write IFF header to combined file */
    iff_write_header(out,&S_image_info,S_image_info.c_height,
			 S_image_info.c_width,"many map Anima file") ;
    S_anima_count++ ;
	/* write compressed image to combined file */
    iff_write_buf(out,&S_image_info) ;
}
