
/*
 * cloned from orseq.c             -Brian Tierney   5/89
 */
/*
 * maxseq.c -- use the maximum value of two sequences.
 * 
 * usage: maxseq file  < insequence > outsequence
 * 
 * to load: cc -o maxseq maxseq.c -lhipl
 * 
 * Michael Landy - 9/18/88
 */

#include <hipl_format.h>
#include <stdio.h>
char            Progname[] = "maxseq";

main(argc, argv)
	int             argc;
	char           *argv[];

{
        unsigned char   *in1, *in2, *pin1, *pin2;
	int             fd, i, nels, nf, nrc, factor, c;
	struct header   hd1, hd2;

	if (argv[argc - 1][0] == '-' && argv[argc - 1][1] == 'D')
		argc--;
	if (argc < 2)
		perr("usage: maxseq file");
	if ((fd = open(argv[1], 0)) == -1)
		perr("can't open %s\n", argv[1]);

	read_header(&hd1);
	fread_header(fd, &hd2);
	if ((hd1.pixel_format != PFBYTE) || (hd2.pixel_format != PFBYTE))
		perr("image pixel format must be bytes");
	nf = hd1.num_frame;
	if (nf < 0)
		perr("#frames must be zero or positive");
	if ((hd1.bits_per_pixel != hd2.bits_per_pixel) ||
	    (hd1.num_frame != hd2.num_frame) ||
	    (hd1.bit_packing != hd2.bit_packing) ||
	    (hd1.rows != hd2.rows) || (hd1.cols != hd2.cols))
		perr("headers must agree");
	c = hd1.bit_packing ? (hd1.cols + 7) / 8 : hd1.cols;
	nrc = hd1.rows * c;
	in1 = (unsigned char *) halloc(nrc, sizeof(char));
	in2 = (unsigned char *) halloc(nrc, sizeof(char));
	update_header(&hd1, argc, argv);
	write_header(&hd1);

	for (nf = 0; nf < hd1.num_frame; nf++) {
		if (pread(0, in1, nrc * sizeof(char)) != nrc * sizeof(char)
		  || read(fd, in2, nrc * sizeof(char)) !=nrc * sizeof(char))
			perr("error in reading");
		pin1 = in1;
		pin2 = in2;
		for (nels = 0; nels < nrc; nels++) {
			/* *pin2++ |= *pin1++;  *//* orseq */
			if ( *pin1 > *pin2 )
				*pin2 = *pin1;
			*pin2++;
			*pin1++;
		}

		write(1, in2, nrc * sizeof(char));
	}
}
