.TH HIPS L "1 May 1990" "LBL"
.PD 1.4
.SH NAME
This is a synopsis of all HIPS moldules written at Lawrence Berkeley 
Laboratory.
.SH PROGRAMS
.B 3dmask
- generalized convolution
.br
.I 3dmask
[-m filter-number]
.br
.B 3dmask
-f filter-descriptor-file

.B 3dog
 - filter an image by applying difference of Gaussians mask
.br
.I 3dog
[-A esigma [masksize [ratio ]]] [-p #] [-b #] [-n #]
.br
[-g #] [-i [-c]] [-m] [-lvf] [-w] [ < ] input > output

addmask - combines a HIPS image with a binary mask to create a new image.
.br
.B addmask
[-n] mask_image <  image > new_image

.B append
- merge files, or merge file and string input from console.
.br
.B append
output_seq <
.I input_file
.br
.B append
outfile -r repeat -s string
.br
.B append
outfile -f source_file [-t title]
.br
.B append
-h

applylut - apply a text gray-level look-up table to a byte or short 
formatted HIPS image.
.br
.B applylut 
lut_file < inseq > outseq
.sp
.br
autocollage - collages a sequence of hips images into a single 
frame with 50 pixels between each image.
.br
.B autocollage 
[-b NN] [-o NN NN] < inseq > outimage
.sp
autoextract - generate a csh script file to automatically extract
smaller images from a larger HIPS image.
.br
.B autoextract 
< -f infile > < -s x y OR -p r c > [ -q ]
.sp
bclean2 - removes small isolated objects from binary HIPS images
.br
.B bclean2
[-s NN] < infile > outfile
.sp
bin_mask - apply a bitmask to each pixel of an image
.br
.B bin_mask
[-m] < inseq > outseq
.sp
bthin - thins binary objects down to a single pixel line
.br
.B bthin
[-v nn] < infile > outfile
.sp
clip - limit the upper and lower grey values of an images to a specified value
.br
.B clip
[low high [new_low_value new_high_value]]

.B dog2
-- new dog version.

.B f3dmaskm
-- multiple processes version for 3dmask. It is 10 times faster than 3dmask.

.sp
fill_holes - fill small holes in binary HIPS images.
.br
.B fill_holes
[-s N][-e] < infile > outfile
.sp
flip_quad - flips the 4 quadrants of a HIPS image.
.br
.B flip_quad
<infile > outfile
.sp
getobj - Selects objects out of an image, and sets the
rest of the image to a given background value. 
.br
.B getobj
[-s NN][-b NN][-c NN NN][-d][-a][-v][-f fname] < infile > outfile
.sp
getobj3d - is a 3D version of getobj, 
which selects objects out of an image, and sets the
rest of the image to a given background value.
.br
.B getobj3d
[-s NN][-b NN][-c NN NN][-g NN][-d][-o][-v][-f fname] < infile > outfile
.sp
gray_wedge - generate a gray value ramp image
.br
.B gray_wedge
-r rows -w cols -m upper_value [-b, -s, -i, -f] -n num_frames
.sp
hfant - perform simple spatial transforms on a hips sequence of images
.br
.B hfant
[-s XX YY] [-v] [-a RR] [-o X Y ] < infile > outfile
.sp
hgrad - computes the gradient of a hips image
.br
.B hgrad
[-t nn] < infile > outfile 

.B hexdump
- dump file in hex mode for debugging and data comparing

hstat - computes statistics on objects in a HIPS image defined 
by a binary mask.
.br
.B hstat
-m mask_file [-l][-s][-p] <  image > output
.sp
hstr - performs a histogram stretch
.br
.B hstr
<infile > outfile
.sp
linesegs - creates straight line segments of minimum  length N
from thinned (single pixel line) binary HIPS images.
.B linesegs
[-l N][-s R][-f[F] fname] < inseq > outseq
.sp
make_mask - make edge detection masks for use with the mask program.
.br
.B make_mask
[-s] [-1 .. -8] [-a] > outfile

.B multi_mask
 multiple function bit mask

.B powertool
- image development tool
.sp
printxyz - makes list of x,y,z locations of objects in a binary image mask.
.br
.B printxyz
[outfiles] < binary_image

.B pshalftone2
- print halftone image with FOOTNOTE.
.sp
segal - An X-windows based image/mask viewer, editor, and analyser.
.br
.B segal
[-i image][-m mask] [-v] [-c NN][-h][-help]
.sp
var_thresh - performs a variable threshold on a HIPS image.
.br
.B var_thresh
[-x nn][-y nn][-t n][-v nn][-k ff][-b nn] < infile > outfile
.sp
.SH LBL MAINTENCE
Brian Tierney, LBL        email: bltierney@lbl.gov
.SH "SEE ALSO"
.PP
All programs (should) have a -h argument for help.
.br
hips_intro(1)
.SH BUGS
Report to Brian Tierney.
