/*
 * memory.c
 *
 * $Log:	memory.c,v $
 * Revision 4.0  91/07/17  14:30:57  kolb
 * Initial version.
 *
 */
/*#ifdef SYSV
#include <memory.h>
#else 
extern char* malloc();
extern char* calloc();
#endif*/
#include "common.h"

char* r_Malloc();
char* r_Calloc();

unsigned long TotalAllocated;
unsigned long TotalFreed;

void
PrintMemoryStats(fp)
FILE *fp;
{
	fprintf(fp,"Total memory allocated:\t\t%lu bytes\n",
			TotalAllocated);
}
 
/*
 * Allocate space for a string, copy string into space.
 */
char *
strsave(s)
char *s;
{
	char *tmp;
 
	if (s == (char *)NULL)
		return (char *)NULL;
 
         tmp = (char *)Malloc((unsigned long)strlen(s) + 1);
	(void)strcpy(tmp, s);
	return tmp;
}
 
#ifdef MULTIMAX
 
char *
share_calloc(num, siz)
int num;
unsigned int siz;
{
	char *res;
 
	res = share_malloc(num*siz);
	bzero(res, num*siz);
	return res;
}
#endif

char* r_Malloc(bytes)
unsigned long bytes;
{
	char *res;
 
	TotalAllocated += bytes;
 
	res = (char*)malloc(bytes);
        if (res == NULL)
		RLerror(RL_PANIC,
			"Out of memory trying to allocate %d bytes.\n",bytes);
	return res;
}


char* r_Calloc(nelem,elen)
unsigned long nelem, elen;
{
	voidstar res;
 
	res = (char*)calloc(nelem,elen);

	bzero(res, nelem*elen);
	return res;
}
 
