#
# This is the make file for the triv_lib library.
#
#                               Gershon Elber, Aug 1990
#

include ../makeflag.sas

OBJS =  geomat4d.o mrchcube.o trinterp.o \
	triv_aux.o triv_dbg.o triv_der.o triv_err.o triv_ftl.o triv_gen.o \
	triv_ref.o triv_sub.o trivcmpt.o trivcoer.o \
	triveval.o trivmesh.o trivrais.o trivstrv.o

all:	triv.lib

triv.lib: $(OBJS)
	rm -f triv.lib
	oml triv.lib a $(OBJS)

install: triv.lib
	mv -f triv.lib $(LIB_DIR)

testeval:       testeval.o libtriv.a
	$(CC) $(CFLAGS) -o testeval testeval.o libtriv.a $(LIBS) -lm $(MORELIBS)


test_ref:       test_ref.o libtriv.a
	$(CC) $(CFLAGS) -o test_ref test_ref.o libtriv.a $(LIBS) -lm $(MORELIBS)

test_sub:       test_sub.o libtriv.a
	$(CC) $(CFLAGS) -o test_sub test_sub.o libtriv.a $(LIBS) -lm $(MORELIBS)

testrais:       testrais.o libtriv.a
	$(CC) $(CFLAGS) -o testrais testrais.o libtriv.a $(LIBS) -lm $(MORELIBS)

testrdwt:       testrdwt.o libtriv.a
	$(CC) $(CFLAGS) -o testrdwt testrdwt.o libtriv.a $(LIBS) -lm $(MORELIBS)


test_der:       test_der.o libtriv.a
	$(CC) $(CFLAGS) -o test_der test_der.o libtriv.a $(LIBS) -lm $(MORELIBS)

data4:	  data4.o
	$(CC) $(CFLAGS) -o data4 data4.o $(LIBS) -lm $(MORELIBS)

geomat4d:	geomat4d.o libtriv.a
	$(CC) $(CFLAGS) -o geomat4d geomat4d.o libtriv.a  $(LIBS) -lm $(MORELIBS)

# DO NOT DELETE THIS LINE -- make depend depends on it.

data4.o: ../include/irit_sm.h
geomat4d.o: ../include/irit_sm.h triv_loc.h ../include/iritprsr.h
geomat4d.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
geomat4d.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
geomat4d.o: ../include/triv_lib.h
mrchcube.o: ../include/irit_sm.h mrchcube.h triv_loc.h ../include/iritprsr.h
mrchcube.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
mrchcube.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
mrchcube.o: ../include/triv_lib.h
test_der.o: triv_loc.h ../include/irit_sm.h ../include/iritprsr.h
test_der.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
test_der.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
test_der.o: ../include/triv_lib.h
test_ref.o: ../include/triv_lib.h ../include/irit_sm.h ../include/imalloc.h
test_ref.o: ../include/miscattr.h ../include/genmat.h ../include/cagd_lib.h
test_ref.o: ../include/symb_lib.h
test_sub.o: ../include/triv_lib.h ../include/irit_sm.h ../include/imalloc.h
test_sub.o: ../include/miscattr.h ../include/genmat.h ../include/cagd_lib.h
test_sub.o: ../include/symb_lib.h
testeval.o: ../include/triv_lib.h ../include/irit_sm.h ../include/imalloc.h
testeval.o: ../include/miscattr.h ../include/genmat.h ../include/cagd_lib.h
testeval.o: ../include/symb_lib.h
testrais.o: ../include/triv_lib.h ../include/irit_sm.h ../include/imalloc.h
testrais.o: ../include/miscattr.h ../include/genmat.h ../include/cagd_lib.h
testrais.o: ../include/symb_lib.h
testrdwt.o: ../include/triv_lib.h ../include/irit_sm.h ../include/imalloc.h
testrdwt.o: ../include/miscattr.h ../include/genmat.h ../include/cagd_lib.h
testrdwt.o: ../include/symb_lib.h
triv_aux.o: triv_loc.h ../include/irit_sm.h ../include/iritprsr.h
triv_aux.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
triv_aux.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
triv_aux.o: ../include/triv_lib.h
triv_dbg.o: triv_loc.h ../include/irit_sm.h ../include/iritprsr.h
triv_dbg.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
triv_dbg.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
triv_dbg.o: ../include/triv_lib.h
triv_der.o: triv_loc.h ../include/irit_sm.h ../include/iritprsr.h
triv_der.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
triv_der.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
triv_der.o: ../include/triv_lib.h
triv_err.o: triv_loc.h ../include/irit_sm.h ../include/iritprsr.h
triv_err.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
triv_err.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
triv_err.o: ../include/triv_lib.h
triv_ftl.o: triv_loc.h ../include/irit_sm.h ../include/iritprsr.h
triv_ftl.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
triv_ftl.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
triv_ftl.o: ../include/triv_lib.h
triv_gen.o: triv_loc.h ../include/irit_sm.h ../include/iritprsr.h
triv_gen.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
triv_gen.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
triv_gen.o: ../include/triv_lib.h ../include/geomat3d.h
triv_ref.o: triv_loc.h ../include/irit_sm.h ../include/iritprsr.h
triv_ref.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
triv_ref.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
triv_ref.o: ../include/triv_lib.h
triv_sub.o: triv_loc.h ../include/irit_sm.h ../include/iritprsr.h
triv_sub.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
triv_sub.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
triv_sub.o: ../include/triv_lib.h
trivcmpt.o: triv_loc.h ../include/irit_sm.h ../include/iritprsr.h
trivcmpt.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
trivcmpt.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
trivcmpt.o: ../include/triv_lib.h
trivcoer.o: triv_loc.h ../include/irit_sm.h ../include/iritprsr.h
trivcoer.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
trivcoer.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
trivcoer.o: ../include/triv_lib.h
triveval.o: triv_loc.h ../include/irit_sm.h ../include/iritprsr.h
triveval.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
triveval.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
triveval.o: ../include/triv_lib.h
trivmesh.o: triv_loc.h ../include/irit_sm.h ../include/iritprsr.h
trivmesh.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
trivmesh.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
trivmesh.o: ../include/triv_lib.h
trivrais.o: triv_loc.h ../include/irit_sm.h ../include/iritprsr.h
trivrais.o: ../include/cagd_lib.h ../include/imalloc.h ../include/miscattr.h
trivrais.o: ../include/genmat.h ../include/symb_lib.h ../include/trim_lib.h
trivrais.o: ../include/triv_lib.h
