/******************************************************************************
* Trim_dbg.c - Provide a routine to print Trimmed surface objects to stderr.  *
*******************************************************************************
* Written by Gershon Elber, Dec. 94.					      *
******************************************************************************/

#include "trim_loc.h"
#include "iritprsr.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Prints trimmed surfaces to stderr. Should be linked to programs for        M
*  debugging purposes, so trimmed surfaces may be inspected from a debugger. M
*                                                                            *
* PARAMETERS:                                                                M
*   Obj:       A trimmed surface - to be printed to stderr.  		     M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   TrimDbg, debugging                                                       M
*****************************************************************************/
void TrimDbg(void *Obj)
{
    char *ErrorMsg;
    TrimSrfStruct
	*TrimSrf = (TrimSrfStruct *) Obj;

    TrimWriteTrimmedSrfToFile3(TrimSrf, stderr, 0, "TrivDbg", &ErrorMsg);

    if (ErrorMsg)
	fprintf(stderr, "TrimDbg Error: %s\n", ErrorMsg);
}
