
#
# Makefile for the POLY3D-R rendering program.
#

#-----
#
# The XXX_DIR variables below MUST have ABSOLUTE path. Since this file
# is sourced from several directories relative path specification will
# be simple wrong.
#

SRC_DIR = Work:T/Irit
#
# All libraries created will be installed into the LIB_DIR directory.
#
LIB_DIR = $(SRC_DIR)/lib

#
# All includes files associated with the installed libraries will be
# installed into the INC_DIR directory.
#
INC_DIR = $(SRC_DIR)/inc

#
# All binaries created will be installed into the BIN_DIR directory.
#
BIN_DIR = $(SRC_DIR)/bin

#
# Uncomment the correct set of variables to be used or modify it for
# your system.
#
# -D flags:
#
# -D__GL__ - if your system supports gl graphics library (SGI 4d & IBM R6000).
#
# -D__X11__ - if your system supports X11. Only one of __GL__ or __X11__ should
#	be used.
#
#  Emulation to the following function are available by defining the
#  following. Look at misc_lib/xgeneral.c/h for implementation.
# -DGETCWD - if getcwd is not defined in this system.
# -DSTRSTR - if strstr is not defined in this system.
# -DSTRDUP - if strdup is not defined in this system.
# -DSTRICMP - if stricmp and strincmp are not defined in this system.
#
# -DTIMES - if times is defined in your system, otherwise uses time.
#
# -DRAND - if the (s)rand random number generator exists.
# -DRAND48 - ?rand48 random number generators exists.
#	If non of RAND or RAND48 are defined, (s)random is used.
#
# -DNO_VOID_PTR - if your C compiler does not support (void *).
#
# -DUSE_VARARGS - if your system does not have stdarg.h and have the old
#	varargs.h.
#
# -DNO_CONCAT_STR - if 'char *p = "This is" "one string";' is illegal.
#
# -DGRAPDRVS - any combination of of 'amidrvs', 'nuldrvs'.
#
# Other, possibly useful defines (for c code development):
#
# -DDEBUG - for some debugging functions in the code (that can be invoked
#		from a debugger).
#

#
# Flags for Amiga using SAS/C
#
# Use DEFINE=M68881 if you have a 68881/68882/68040
# Use DEFINE=MIEEE if you want to use the IEEE math library
# Use DEFINE=MFFP if you want to use the FFP math library
#
CC = sc
DFLAGS = DEFINE=M68881 DEFINE=RAND48
CFLAGS = $(DFLAGS) CPU=68040 MATH=68882 NOSTACKCHECK STRMERGE IGNORE=79
MORELIBS = 
GRAPDRVS =nuldrvs amidrvs

#
# Default rule for compilation.
#
.c.o:
	$(CC) $(CFLAGS) IDIR= IDIR=$(INC_DIR) IDIR=$(SRC_DIR)/amigalib $<

#
# All libraries.
LIBS = $(LIB_DIR)/geom.lib $(LIB_DIR)/prsr.lib $(LIB_DIR)/cagd.lib\
       $(LIB_DIR)/misc.lib $(LIB_DIR)/gif.lib
#-----

OBJS	= poly3d-r.o prepdata.o colortbl.o evalcolr.o scandata.o

poly3d-r:	$(OBJS)
	slink TO poly3d-r FROM LIB:c.o $(OBJS)\
	LIB $(LIBS) $(MORELIBS) LIB:scm881.lib LIB:sc.lib SC ND NOICONS

install: poly3d-r
	Copy poly3d-r $(BIN_DIR)
	Delete poly3d-r
	Copy poly3d-r.cfg $(BIN_DIR)

# Dependencies starts here - do not touch, generated automatically.
colortbl.o:	program.h
evalcolr.o:	program.h
poly3d-r.o:	program.h
prepdata.o:	program.h
scandata.o:	program.h
