.if n .ll 7.5i
.if n .nr LL 7.5i
.LP
.ce 1000
\s+2\fBSan Diego Supercomputer Center\fR\s-2
.sp 1
\s+4\fBImage Tools\fR\s-4
.sp 1
\s+2\fBRelease Notes\fR\s-2
.sp 1
\s+1\fBBinary Release 2.0\fR\s-1
\s+1\fBOctober 1991\fR\s-1
.ce 0
.sp 3
\fB1.  Introduction\fR
.LP
These notes describe binary release 2.0 of the San Diego
Supercomputer Center (SDSC) Image Tools.
.LP
Release 2.0 includes the following command-line tools:
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
\fBimconv\fR	Convert between various image file formats
\fBimcopy\fR	Copy a piece of an image into a new file
\fBimfile\fR	Determine the image file format used by one or more files
\fBimflip\fR	Flip an image vertically or horizontally
\fBimformats\fR	List the attributes of supported image file formats
\fBimgray\fR	Convert an image to grayscale
\fBimmono\fR	Convert an image to monochrome
\fBimpaste\fR	Paste an image on top of another image
\fBimscale\fR	Scale an image up or down in size
.TE
.if t .in -0.5i
.if n .in -5
.LP
Source code for each of the above tools is included.
.LP
Release 2.0 includes the C subroutine library \fBlibim.a\fR, its
include file \fBim.h\fR and its manual pages.  Source is not included.
.LP
Use of the
SDSC Image Tools library requires the companion SDSC Utility Library
\fBlibsdsc.a\fR.
\fBlibsdsc.a\fR includes C packages to handle portable binary I/O,
command-line argument parsing, and the tag table data structure used
by the SDSC Image Tools.
The SDSC Utility Library and its documentation may be separately
uploaded via anonymous ftp from \fBsdsc.edu\fR (132.249.20.22).
.sp 2
.LP
\fB2.  Binary Release\fR
.LP
This is a binary release.
Host architectures supported in this release include the following:
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l l.
alliantfx2800	Alliant Computer Systems	FX/2800 minisupercomputers
cray2	Cray Research Inc.	Cray-2 supercomputers
crayy	Cray Research Inc.	Y-MP supercomputers
decstation	Digital Equipment Corp.	DECStation workstations
decvax	Digital Equipment Corp.	DEC VAX and VAXStation workstations
ibmrs6000	International Business Machines	RS/6000 workstations
next	NeXT Computers	NeXTStation workstations
sgi4d	Silicon Graphics Inc.	4D workstations
stardent	Stardent Computer Systems	Stardent GS1000/2000 workstations
sun3	Sun Microsystems Inc.	Sun3 workstations
sun4	Sun Microsystems Inc.	Sun4 and SPARC workstations
.TE
.if t .in -0.5i
.if n .in -5
.LP
Additional architectures are expected in the near future.
.LP
A separate release \fBtar\fR or \fBcpio\fR file is generated for each
architecture.
.sp 2
.if n .bp
.LP
\fB3.  Image File Formats\fR
.LP
This release supports the following image file formats:
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
eps	Encapsulated PostScript file
gif	Compuserve Graphics image file
hdf	Hierarchical Data File
icon	Sun Icon and Cursor file
iff	Sun TAAC Image File Format
mpnt	Apple Macintosh MacPaint file
pbm	Portable Bit Map file
pcx	ZSoft IBM PC Paintbrush file
pgm	Portable Gray Map file
pic	PIXAR picture file
pict	Apple Macintosh QuickDraw/PICT file
pix	Alias image file
pnm	Portable aNy Map file
ppm	Portable Pixel Map file
ps	PostScript file
ras	Sun Rasterfile
rgb	SGI RGB image file
rla	Wavefront raster image file
rle	Utah Run length encoded image file
rpbm	Raw Portable Bit Map file
rpgm	Raw Portable Gray Map file
rpnm	Raw Portable aNy Map file
rppm	Raw Portable Pixel Map file
synu	Synu image file
tiff	Tagged image file
x	Stardent AVS X image file
xbm	X11 bitmap file
xwd	X Window System window dump image file
.TE
.if t .in -0.5i
.if n .in -5
.LP
Formats with multiple variants for handling different image depths and
compression schemes are fully supported (see exceptions later in this document).
You can obtain information on the supported variants by executing
the \fBimformats\fR tool with the \fB-long\fR option.  For instance:
.sp 0.5
.LP
.if t .in +0.5i
.if n .in +5
%  \fBimformats -long -hdf\fR
.br
.if t .ts 0.5i,1.0i,1.5i,2.0i,2.5i,3.0i
.if n .ts 8,16,24,32,40,48,56
hdf	Hierarchical Data File
.br
.if t .in +0.5i
.if n .in +8
.if t .ts 0.5i,1.0i,1.5i,2.0i,2.5i,3.0i
.if n .ts 8,16,24,32,40,48,56
a.k.a.:		df, ncsa
.br
.if t .ts 0.5i,1.0i,1.5i,2.0i,2.5i,3.0i
.if n .ts 8,16,24,32,40,48,56
Creator:	NCSA
.br
Read support:
.br
.if t .in +0.25i
.if n .in +2
8-bit color index images, un- and RLE-compressed.  16-, 24-, and
32-bit color index images, un-compressed.  24-bit RGB, un- and
RLE-compressed, un-, scanline- and plane-interleaved.  Raster image groups
as well as older Raster-8 files.
.br
.if t .in -0.25i
.if n .in -2
Write support:
.br
.if t .in +0.25i
.if n .in +2
8-bit color index images, un- and RLE-compressed.  16-bit color
index images, un-compressed.  24-bit RGB, uncompressed, un-,
scanline-, and plane-interleaved.  Raster image group and older Raster-8
tags included.
.if t .in -0.25i
.if n .in -2
.if t .in -0.5i
.if n .in -8
.if t .in -0.5i
.if n .in -5
.LP
Man pages on each of the supported file formats are also included.
.sp 2
.LP
.ne 5
\fB4.  Documentation\fR
.LP
\fBMan\fR pages are included that describe the tools, library routines,
and all supported image file formats.  \fBnroff\fR source is provided in files
with \fB.n\fR filename
suffixes and should be processed through \fBtbl\fR and \fBnroff\fR.
For example:
.if t .in +0.5i
.if n .in +5
.LP
\fBtbl imconv.n | nroff -man > imconv.1l\fR
.br
	or
.br
\fBtbl imtiff.n | nroff -man > imtiff.3l\fR
.br
	or
.br
\fBtbl imintro.n | nroff -man > imintro.3l\fR
.if t .in -0.5i
.if n .in -5
.LP
A \fBMakefile\fR is provided to build man pages using \fBnroff\fR and \fBtbl\fR.
.LP
For sites without access to \fBnroff\fR and \fBtbl\fR, post-processed text
versions of all man pages are included in files
with \fB.1l\fR and \fB.3l\fR filename suffixes.
.LP
For sites with PostScript laserprinters, PostScript versions of the manual
pages are provided in files with \fB.ps\fR filename suffixes.
.sp 2
.LP
\fB5.  Changes since the last release\fR
.LP
This is a major release for the SDSC Image Tools.  There have been significant
enhancements since release 1.1 (internal release) and release 1.0 (last
public release).  Release 2.0 also marks the first public release of the SDSC
Image Library \fBlibim.a\fR.
.sp 1
.LP
\fBNew Features:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
New tool:  \fBimcopy\fR.  Copy a portion of an image from one file into
a new file.
.IP \(bu 0.1i
New tool:  \fBimflip\fR.  Flip an image vertically, horizontally, or both and
store it into a new file.
.IP \(bu 0.1i
New tool:  \fBimgray\fR.  Convert an image to grayscale and store it into a
new file.
.IP \(bu 0.1i
New tool:  \fBimmono\fR.  Convert an image to monochrome and store it into a
new file.
.IP \(bu 0.1i
New tool:  \fBimpaste\fR.  Paste an image from one file on top of an image
in another file and store the result into a new file.
.IP \(bu 0.1i
New tool:  \fBimscale\fR.  Scale an image up or down and store it into a new
file.
.IP \(bu 0.1i
New library:  \fBlibim.a\fR.  Read and write image files in all supported
formats.  Copy, paste, scale, and convert images.  Object library only.
No source.
.IP \(bu 0.1i
New Macintosh application:  \fBSDSC ImageTyper\fR.  Set "Type" and "Creator"
fields on image files downloaded to the Macintosh.
.IP \(bu 0.1i
Source code for all tools is included.
.IP \(bu 0.1i
Manual pages for tools, file formats, and library routines is included as
\fBnroff\fR source, post-\fRnroff\fR text, and PostScript.
.if t .in -0.5i
.if n .in -5
.LP
\fBGeneral Enhancements:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
Tool help is no longer printed upon command-line syntax errors.
.IP \(bu 0.1i
Tool help has been split into \fB-help\fR for a brief listing of options,
and \fB-fullhelp\fR for a complete listing of options.
.IP \(bu 0.1i
All references to RGB image \fIinterlace\fR have been changed to RGB
\fIinterleave\fR to better reflect common usage.  The \fB-ouinterlace\fR
option has been changed to \fB-outinterleave\fR.
.if t .in -0.5i
.if n .in -5
.LP
\fBNew image file formats:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
Encapsulated PostScript.  Write support for device-independent monochrome,
grayscale, and color EPSI files.
A grayscale preview image is included.  Conforms to Adobe Document
Structuring Conventions 3.0.
.IP \(bu 0.1i
Sun icon format.  Read and write support for Sun icon and cursor monochrome
bitmap files.
.IP \(bu 0.1i
PCX format.  Read and write support for IBM PC / ZSoft PC Paintbrush monochrome
and color image files.
.if t .in -0.5i
.if n .in -5
.LP
\fBFile format enhancements:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
PBM restructured.
PBM file type recognition has been enhanced to treat \fBpbm, pgm, ppm, rpbm,
rpgm,\fR and \fBrppm\fR files as separate file formats.
This was done to clarify the actions of statements like:
.sp 0.5
.ce 1
\fBimconv myfile.ras myfile.pbm\fR

Prior to release 2.0, this command
generated a \fBpbm\fR file if \fBmyfile.ras\fR was monochrome,
a \fBpgm\fR file if it was grayscale, and a \fBppm\fR file if it was RGB.  This
conflicted with the PBM+ suite's convention that files ending in '.pbm'
are always monochrome \fBpbm\fR files.

In release 2.0, the above command guarantees to produce a \fBpbm\fR file.
If \fBmyfile.ras\fR contains grayscale or color image data, the image is
first converted to monochrome before being written to the \fBpbm\fR file.
Similar actions occur if the other PBM+ file formats are selected.

To mimic the previous release's automatic format choice actions, use the
PBM+ suite psuedo-format name \fBpnm\fR instead:
.sp 0.5
.ce 1
\fBimconv myfile.ras myfile.pnm\fR
.IP \(bu 0.1i
PICT enhanced.  Additional drawing operations involving pen modes and
color transfer modes have been added to PICT read support.
Warning messages output by the PICT reader when unsupported opcodes are
encountered now include english descriptions of the opcodes being skipped.
.IP \(bu 0.1i
PostScript enhanced.
PostScript support has been enhanced to generate grayscale and color
PostScript image files.
When printed, SDSC Image Tools
PostScript files automatically choose the best page orientation and the
largest possible image size.
Color PostScript files automatically convert to grayscale if printed to
non-color PostScript printers.
.IP \(bu 0.1i
Sun Rasterfiles enhanced.
32-bit RGB+alpha RAS file read and write support has been added.
.IP \(bu 0.1i
TIFF updated.
TIFF support has been upgraded to match the version 5.0 spec.
.IP \(bu 0.1i
XWD enhanced.
24-bit RGB XWD file read and write support has been added.
TrueColor and DirectColor visual classes may be read.
TrueColor images may be written.
.if t .in -0.5i
.if n .in -5
.LP
\fBFile format bug fixes:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
The HDF "NT" (Number Type) tag written to HDF files to describe image data
has been changed to indicate the data is 'bitwise numeric' data instead
of 'ASCII' data.
.IP \(bu 0.1i
IFF code that incorrectly wrote alpha channel data has been fixed.
.IP \(bu 0.1i
PBM monochrome write code that incorrectly
inverted black and white pixel values has been fixed.
.IP \(bu 0.1i
PIC code that became confused when image data did not start in the file where
it expected it is now more robust.
.IP \(bu 0.1i
PICT code that occasionally wrote incorrect PackBits compressed
images has been fixed.
.IP \(bu 0.1i
PICT code that occasionally core dumped as a result of memory allocation
errors in the read code has been fixed.
.IP \(bu 0.1i
RAS code that read and wrote 24-bit RGB data in the order R-G-B-R-G-B... has
been reversed to read and write data in the order B-G-R-B-G-R... in order to
conform to Sun tools.  Users with existing 24-bit images in the R-G-B... order
may convert them using Sun's \fBrasfilter_rgbtobgr\fR (in \fB/usr/bin\fR).
Alternatively, they may use the previous release of \fBimconv\fR to read in
the R-G-B RAS file, and write it out as an AVS X, HDF, or SGI RGB file.  Then,
using the latest release of \fBimconv\fR, read the AVS, HDF, or SGI file back
in and save it as a new B-G-R RAS file.
.IP \(bu 0.1i
TIFF code that caused bad monochrome images to be written if the image width
was not a multiple of 8 has been fixed.  A similar bug that caused TIFF code
to fail when reading monochrome images with widths not a multiple of 8 has
been fixed.
.IP \(bu 0.1i
TIFF code that incorrectly wrote alpha channel data has been fixed.
.IP \(bu 0.1i
X code that incorrectly wrote alpha channel data has been fixed.
.IP \(bu 0.1i
Monochrome-to-RGB-type image conversion that
improperly mapped monochrome white to RGB (1,1,1) instead of (255,255,255)
has been fixed.
.if t .in -0.5i
.if n .in -5
.LP
\fBRemoved features:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
CGM files are no longer supported.  The Pittsburgh Supercomputer Center's
\fBgplot\fR utility may be used to convert CGM files to image files for
use in SDSC's Image Tools.
.IP \(bu 0.1i
HDF write support for 24-bit images has been temporarily disabled pending
full support from NCSA's image tools.
Compressed 24-bit image read is still fully supported
within the SDSC Image Tools.
.IP \(bu 0.1i
The Alliant FX/80 is no longer supported.
.if t .in -0.5i
.if n .in -5
.sp 2
.ne 5
.LP
\fB6.  Items that may cause confusion\fR
.LP
The following features of the SDSC Image Tools may confuse some users.
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
While the GIF read code can handle multi-image GIF files, the write code
can only write out GIF files with one image to a file.
.IP \(bu 0.1i
IFF format files are Sun's TAAC images, not Amiga images.  Both Sun and
Commodore used the same mnemonic for their image files.
.IP \(bu 0.1i
PCX files generated on the IBM PC by CorelDRAW! are always monochrome, even
if the image being drawn uses color.  This is a problem with CorelDRAW!.
CorelDRAW! can, however, read in color PCX files generated by the SDSC Image
Tools, or other PC tools.
.IP \(bu 0.1i
PCX files generated on the IBM PC by PC PaintBrush from images using more
than 16 colors are incorrectly written using the 4-bit PCX format.  Colors
are lost.  This is a problem with PC PaintBrush.  PC PaintBrush can, however,
read in 8-bit PCX files generated by the SDSC Image Tools.
.IP \(bu 0.1i
PCX files generated on the IBM PC by PC PaintBrush from images with 2, 3, or
4 colors are sometimes written without their color tables.  Colors are lost.
This is a problem with PC PaintBrush.
.IP \(bu 0.1i
PICT handles PICT2 as well.
.IP \(bu 0.1i
PICT files are always mapped to RGB images during conversion.  This is an
artifact made necessary by support of multi-image, multi-color map features
of the PICT and PICT2 formats.  A command line
like the following will result in an RGB HDF file instead of the
expected color index HDF file:
.sp 0.5
.ce 1
\fBimconv image.pict image.hdf\fR
.IP \(bu 0.1i
PICT support does not handle many drawing operations.  To do so would require
reimplementing Apple's QuickDraw and is beyond the scope of an image handling
package.  PICT files containing drawing operations should be converted to
bitmaps on the Macintosh, then uploaded to the UNIX host.  Bitmap conversion
may be accomplished with a variety of tools, including SuperPaint, PhotoShop,
and others.
.IP \(bu 0.1i
PICT support does not handle fonts.  Text stored in a PICT file references a
font, but does not include the font's bitmap.  When uploaded to a UNIX host,
the font bitmaps are no longer available.  This makes it impossible to support
PICT text operations.  PICT files containing text should be converted to
bitmaps on the Macintosh, then uploaded to the UNIX host.  Bitmap conversion
may be accomplished with a variety of tools, including SuperPaint, PhotoShop,
and others.
.IP \(bu 0.1i
Wavefront RLA handles RLB as well.
.IP \(bu 0.1i
Wavefront's Silicon Graphics versions of
\fBimf_dspl\fR and \fBtex_bld_2D\fR (release 2.11) occasionally have trouble
reading RLA/RLB files generated by SDSC's Image Tools.  The cause for this
is still under investigation, but is believed to be an unfortunate
interaction between Wavefront's tools and IRIX 3.3.  Wavefront's tools
for the Alliant FX/2800 do not exhibit this problem.
.IP \(bu 0.1i
Stardent's \fBxwd\fR on Stardent GS1000s generates one
of two types of 24-bit RGB XWD files,
depending upon the type of image originally displayed.
.if t .in +0.5i
.if n .in +5
.IP "1." 0.25i
If a 24-bit image is displayed on a Stardent GS1000, then dumped to an XWD
file using \fBxwd\fR, a TrueColor RGB XWD image is created.  This is correct.
.IP "2." 0.25i
If an 8-bit image is displayed on a Stardent GS1000, then dumped to an XWD
file using \fBxwd\fR, a DirectColor RGB XWD image is created without a color
map.  This is incorrect and is a bug in Stardent's \fBxwd\fR.  DirectColor
RGB XWD images must have a color map.  SDSC's Image Tools, as well as
\fBxwud\fR and any
other image tools handling XWD files, will be unable to fix this problem.
.if t .in -0.5i
.if n .in -5
.if t .in -0.5i
.if n .in -5
.sp 2
.LP
\fB7.  Known Problems\fR
.LP
The following are known problems present in the 2.0 release of the SDSC
Image Tools:
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
GIF support is as of the 87a spec, not the newer 89a spec.
.IP \(bu 0.1i
Color PostScript support has been tested on black-and-white printers and
Sun's PageView, but not on a color printer (we don't have one).
.IP \(bu 0.1i
EPS file support needs more testing.
.IP \(bu 0.1i
PICT support does not read or write 24-bit RGB images.
.IP \(bu 0.1i
PCX file support needs more testing.
.IP \(bu 0.1i
TIFF core dumps on images only 1 scanline high,
or with fewer than 8 pixels per scanline.
.IP \(bu 0.1i
TIFF's "Photometric Interpretation" tag is not recognized to invert black
and white values in a monochrome image.  This is inconvenient when uploading
monochrome TIFF images from an IBM PC.
.IP \(bu 0.1i
TIFF handling supports uncompressed, PackBits compressed, and Limpel-Ziv &
Welch compressed images.  CCITT Huffman, CCIT RLE, CCIT Group 3 fax,
CCIT Group 4 fax, NeXT, Thunderscan, PIXAR PICIO, and SGI RLE compression
schemes are not supported.
.IP \(bu 0.1i
XWD files stored in the XY format (instead of Z format) are not supported yet.
.if t .in -0.5i
.if n .in -5
.sp 2
.LP
\fB8.  Future Directions\fR
.LP
This is an ongoing project at SDSC.  Plans for expansion include
extending the depth of support for the current set of image file formats,
adding additional file formats, and creating more tools and library
functions.  Input from SDSC Image Tools users would be quite helpful in
optimally directing our future efforts.
.br
.ne 5
.LP
Current plans call for enhancing format support in the following areas:
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
gif	Multi-image file write.  Update to spec version 89a.
hdf	IMCOMP compression support
pict	RGB image support
tiff	Additional tags and compression schemes
xwd	Monochrome (XY bitmap/pixmap) handling
.TE
.if t .in -0.5i
.if n .in -5
.ne 5
.LP
Additional image file formats slated for inclusion include:
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
bdf	Adobe Bitmap Description File (Fonts)
fits	NSDSSO Flexible Image Transport System
flux	apE image file
ilbm	Amiga Interleaved Bitmap file
nrif	NCAR Raster Interchange File
tga	Targa image file
uil	Motif icon file
viff	Khoros image file
xpm	X Pixelmap (Icon) file
.TE
.if t .in -0.5i
.if n .in -5
.LP
Additional image manipulation tools in progress include:
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
\fBimcat\fR	Concatenate multiple files into a multi-image file
\fBimcomp\fR	Composite images using alpha channels
\fBimfill\fR	Fill a region of an image with a color
\fBimhue\fR	Alter the hue of an image
\fBiminten\fR	Alter the intensity of an image
\fBimkey\fR	Chromakey paste an image
\fBimsat\fR	Alter the saturation of an image
\fBimsplit\fR	Split mult-image files into multiple files
\fBimstoryboard\fR	Paste images together to create a storyboard
\fBimtext\fR	Write text into an image using a font
.TE
.if t .in -0.5i
.if n .in -5
.LP
SDSC is in the process of developing a print queueing system for sending
images to a variety of image output devices, include film recorders, color
paper printers, and video decks.  This system is in the final stages of
development and is expected to be included in the next release of the
SDSC Image Tools.
.sp 2
.LP
\fB9.  Bug Reports and User Registration\fR
.LP
This software is developed and
supported by the San Diego Supercomputer Center, and we want
to hear from you.  If you find bugs (heaven forbid), or want to be put on
our mailing list for future software releases, please fill out
and send us a bug report and/or user registration form.  These forms may be
obtained by executing any one of our tools with the \fB-feedback\fR
or \fB-register\fR options.
.LP
For instance, to generate a bug report feedback form for \fBimconv\fR, type:
.if t .in +0.5i
.if n .in +5
.LP
% \fBimconv -feedback\fR
.if t .in -0.5i
.if n .in -5
.LP
The feedback (bug report) form is written to a file named \fBimconv.fbk.0\fR
in the current directory.
When generating a feedback form, the tool writes the form and exits without
executing further.
.LP
To generate a user registration form for \fBimconv\fR, type:
.if t .in +0.5i
.if n .in +5
.LP
% \fBimconv -register\fR
.if t .in -0.5i
.if n .in -5
.LP
Like the feedback form, the registration form is written to a file
named \fBimconv.reg.0\fR
in the current directory.  When
generating a registration form, the tool writes the form and exits without
executing further.
.LP
User registration is not required, but we'd like to hear from you anyway.
We'll put you on a mailing list for notification of future releases of
SDSC software tools, and read with interest who you are and what you
are doing with our software.
.LP
After you have filled out the form, please send the form, and any
accompanying data, source fragments, sample output, or whatever, to SDSC:
.if t .in +0.5i
.if n .in +5
.if n .bp
.ne 8
.LP
.TS
l l.
E-mail:	info@sdsc.edu

Surface mail:	Software Products Information
	San Diego Supercomputer Center
	P.O. Box 85608
	San Diego, CA  92186-9784

FAX:	(619) 534-5113
.TE
.if t .in -0.5i
.if n .in -5
.LP
If you have questions about this form or any of our software products, please
contact us via any of the above methods or call us at:
.if t .in +0.5i
.if n .in +5
.LP
(619) 534-5100  M-F, 8am-5pm, Pacific time
.if t .in -0.5i
.if n .in -5
.sp 2
.LP
\fB10.  Copyright\fR
.LP
Users and possessors of the files of this release are hereby granted a
nonexclusive, royalty-free copyright and design patent license to use
this code in individual software.  License is not granted for commercial
resale, in whole or in part, without prior written permission from SDSC.
This release is provided "AS IS" without express or implied warranty of any
kind.
.LP
We ask that the following message be included in all
derived works:  \fIPortions developed at the San Diego Supercomputer Center\fR.
.LP
Please do not redistribute this software.  We would prefer that interested
parties upload the software directly from our anonymous ftp account.  This
guarantees that they get the latest release, and helps us to keep track of
roughly how many sites out there are using our software.
.sp 2
.LP
\fB11.  Conclusion\fR
.LP
Please use these tools and send us feedback:  let us know what you like and what
you don't like about this software.  Tell us how you are using the SDSC
Image Tools and what you would like to see in the future, both as enhancements
to this product, and as additional products from SDSC.
.LP
We encourage you to cite in your publications
the use of the SDSC Image Tools, and any other
SDSC software you have used.  Your publication references and
your feedback support are what makes this project work, and what gives
us the opportunity to continue to develop portable free tools like
the SDSC Image Tools, and our other products.
We look forward to hearing from you!
.LP
