/************************************************************************/
/*									*/
/*	Copyright Pittsburgh Supercomputing Center 1987			*/
/*	All Rights Reserved						*/
/*	Author Joel Welling						*/
/*			    						*/
/*      CGMGEN_TEST2.C version 2.0                                      */
/*                                                                      */
/************************************************************************/

/*                       
	This module tests the facility for drawing general cell arrays
	from packed data.  It is written in c to facilitate byte
	manipulation.
*/

/*  This module recognizes what type of machine it's on by the presence
of the symbol VMS, unix, CRAY, or ardent.  The following makes the machine
assignment less ambiguous.
*/
#if (unix && (!CRAY && !ardent))
#define USE_UNIX
#endif

#ifdef VMS
#include stdio                            
#include descrip
#else
#include <stdio.h>
#include <string.h>
#endif
#ifdef ardent
#include <stdio.h>
#include <string.h>
#endif

/* Include defs files that allow linkage to Fortran on various systems */
#ifdef USE_UNIX
#include "unix_defs.h"
#endif
#ifdef CRAY
#include "unicos_defs.h"
#endif
#ifdef ardent
#include "unicos_defs.h"  /* these are also appropriate on Ardent Titan */
#endif

/* data array size */
#define maxbytes 360
/* x and y dimensions of test array */            
#define nxdim 9
#define nydim 10

/* Define some constants needed for masking */
#define mask_1_bit 1
#define mask_2_bits 3
#define mask_4_bits 15
#define mask_5_bits 31
#define mask_7_bits 127
#define mask_8_bits 255

/* Add an arbitrary precision color value, byte aligned or not */
/* in should be an unsigned integer at least precision bits long */
/* ptr points to unsigned chars, initially zero filled */
#define mcr_ptcv(ptr, precision, in, bit) switch (precision){		\
case 32: *ptr++ = ( in & (mask_8_bits << 24) ) >> 24;			\
case 24: *ptr++ = ( in & (mask_8_bits << 16) ) >> 16;			\
case 16: *ptr++ = ( in & (mask_8_bits << 8) ) >> 8;			\
case 8: *ptr++ = ( in & mask_8_bits ); break;				\
case 4: *ptr = *ptr | ((in & mask_4_bits) << (4-bit)); bit= bit+4;	\
if (bit == 8) { bit = 0; ++ptr; }; break;				\
case 2: *ptr = *ptr | ((in & mask_2_bits) << (6-bit)); bit= bit+2;	\
if (bit == 8) { bit = 0; ++ptr; }; break;				\
case 1: *ptr = *ptr | ((in & mask_1_bit) << (7-bit)); bit= bit+1;	\
if (bit == 8) { bit = 0; ++ptr; }; };

makedata(image,prec)
unsigned char *image;
int prec;
{
	int i,j,val,bit=0;
	unsigned char *imageptr;

	imageptr= image;
	for (i=0; i<maxbytes; i++) *imageptr++= 0;
	imageptr= image;
	for (j=0; j<nydim; j++)
		{
		for (i=0; i<nxdim; i++)
			{
			val= ((5*(i+1)) / (j+1)) % 2;
			mcr_ptcv(imageptr,prec,val,bit);
			};
		if (bit>0) { bit= 0; imageptr++;};
		};
}

tpcla(mode)
int *mode;
{
	unsigned char image[maxbytes];
	int ierr, prec, one= 1, zero= 0, nx= nxdim, ny= nydim;
	float temp;
	float xlbl1=0.1, ylbl1=0.26;
	float xlbl2=0.1, ylbl2=0.46;
	float xlbl3=0.1, ylbl3=0.66;
	float xlbl4=0.1, ylbl4=0.86;
	float xlbl5=0.6, ylbl5=0.46;
	float xlbl6=0.6, ylbl6=0.66;
	float xlbl7=0.6, ylbl7=0.86;
        float xclap1=0.1, xclaq1=0.3, xclar1=0.3;
        float yclap1=0.25, yclaq1=0.1, yclar1=0.25;
        float xclap2=0.1, xclaq2=0.3, xclar2=0.3;
        float yclap2=0.45, yclaq2=0.3, yclar2=0.45;
        float xclap3=0.1, xclaq3=0.3, xclar3=0.3;
        float yclap3=0.65, yclaq3=0.5, yclar3=0.65;
        float xclap4=0.1, xclaq4=0.3, xclar4=0.3;
        float yclap4=0.85, yclaq4=0.7, yclar4=0.85;
        float xclap5=0.6, xclaq5=0.8, xclar5=0.8;
        float yclap5=0.45, yclaq5=0.3, yclar5=0.45;
        float xclap6=0.6, xclaq6=0.8, xclar6=0.8;
        float yclap6=0.65, yclaq6=0.5, yclar6=0.65;
        float xclap7=0.6, xclaq7=0.8, xclar7=0.8;
        float yclap7=0.85, yclaq7=0.7, yclar7=0.85;
	float xtitle=0.1, ytitle= 0.9;

	/* Start the CGM frame */
        ierr= 0;              
	stcpnm("RLE Cell Arrays",&ierr);
	fprintf(stdout," stcpnm: ierr= %d\n",ierr);
        wrbegp(&ierr);
	fprintf(stdout," wrbegp: ierr= %d\n",ierr);
        wrbgpb(&ierr);
	fprintf(stdout," wrbgpb: ierr= %d\n",ierr);

	/* Top label */
	temp= 0.03;
	wrtxts(&temp,&ierr);
	fprintf(stdout," wrtxts: ierr= %d\n",ierr);
	if (*mode) wrttxt("Packed list mode",&xtitle,&ytitle,&ierr);
	else wrttxt("Run length mode",&xtitle,&ytitle,&ierr);
	fprintf(stdout," wrttxt: ierr= %d\n",ierr);

	temp= 0.01;
	wrtxts(&temp,&ierr);
	fprintf(stdout," wrtxts: ierr= %d\n",ierr);

	/* 8 bit case */
	wrttxt("8 bits",&xlbl1,&ylbl1,&ierr);
	prec= 8;
	fprintf(stdout," wrttxt: ierr= %d\n",ierr);
	makedata(image,prec);
	wrpcla(image,&nx,&ny,&xclap1,&yclap1,&xclaq1,&yclaq1,
		&xclar1,&yclar1,&prec,mode,&ierr);
	fprintf(stdout," wrpcla: ierr= %d\n",ierr);

	/* 4 bit case */
	wrttxt("4 bits",&xlbl2,&ylbl2,&ierr);
	prec= 4;
	fprintf(stdout," wrttxt: ierr= %d\n",ierr);
	makedata(image,prec);
	wrpcla(image,&nx,&ny,&xclap2,&yclap2,&xclaq2,&yclaq2,
		&xclar2,&yclar2,&prec,mode,&ierr);
	fprintf(stdout," wrpcla: ierr= %d\n",ierr);

	/* 2 bit case */
	wrttxt("2 bits",&xlbl3,&ylbl3,&ierr);
	prec= 2;
	fprintf(stdout," wrttxt: ierr= %d\n",ierr);
	makedata(image,prec);
	wrpcla(image,&nx,&ny,&xclap3,&yclap3,&xclaq3,&yclaq3,
		&xclar3,&yclar3,&prec,mode,&ierr);
	fprintf(stdout," wrpcla: ierr= %d\n",ierr);

	/* 1 bit case */
	wrttxt("1 bit",&xlbl4,&ylbl4,&ierr);
	prec= 1;
	fprintf(stdout," wrttxt: ierr= %d\n",ierr);
	makedata(image,prec);
	wrpcla(image,&nx,&ny,&xclap4,&yclap4,&xclaq4,&yclaq4,
		&xclar4,&yclar4,&prec,mode,&ierr);
	fprintf(stdout," wrpcla: ierr= %d\n",ierr);

	/* 32 bit case */
	wrttxt("32 bits",&xlbl5,&ylbl5,&ierr);
	prec= 32;
	fprintf(stdout," wrttxt: ierr= %d\n",ierr);
	makedata(image,prec);
	wrpcla(image,&nx,&ny,&xclap5,&yclap5,&xclaq5,&yclaq5,
		&xclar5,&yclar5,&prec,mode,&ierr);
	fprintf(stdout," wrpcla: ierr= %d\n",ierr);

	/* 24 bit case */
	wrttxt("24 bits",&xlbl6,&ylbl6,&ierr);
	prec= 24;
	fprintf(stdout," wrttxt: ierr= %d\n",ierr);
	makedata(image,prec);
	wrpcla(image,&nx,&ny,&xclap6,&yclap6,&xclaq6,&yclaq6,
		&xclar6,&yclar6,&prec,mode,&ierr);
	fprintf(stdout," wrpcla: ierr= %d\n",ierr);

	/* 16 bit case */
	wrttxt("16 bits",&xlbl7,&ylbl7,&ierr);
	prec= 16;
	fprintf(stdout," wrttxt: ierr= %d\n",ierr);
	makedata(image,prec);
	wrpcla(image,&nx,&ny,&xclap7,&yclap7,&xclaq7,&yclaq7,
		&xclar7,&yclar7,&prec,mode,&ierr);
	fprintf(stdout," wrpcla: ierr= %d\n",ierr);

        wrendp(&ierr);
	fprintf(stdout," wrendp: ierr= %d\n",ierr);
}
