/* module: 4dd_help.c help window functions */

static char SccsId[] = "@(#)4dd_help.c	1.2";

#include "gl.h"
#include "stdio.h"
#include "string.h"
#include "device.h"

#include "4dd_echo.h"
#include "4dd_cyfile.h"
#include "4dd_gt.h"

extern int errno;


struct helpinfo {
	long gid;
	char name[40];
	long position_x, position_y;
	long size_x, size_y;
	unsigned long color_background;
	unsigned long color_text;
	int menu;
	char current_string[40];
};

static struct helpinfo help = {
	0,
	"Help",
	840, 40, 395, 25,
	0xff000000, 0xffffffff,
	0, ""
};

/* help menu selections */
#define EXIT		1


long help_event(str, event, value)

char *str;
Device event;
short value;
{
	Boolean first_time = TRUE;

	/* if no string given, use previous string or default string */
	if (str != 0) {
		strcpy(help.current_string, str);	/* new string, save for redraw */
	} else {
		str = help.current_string;			/* redraw previous string */
	}

	switch (event) {			/* handle event */
	default:
		break;
	case CREATE:
		if (first_time) {
			first_time = FALSE;
			help_getdefaults(&help);
		}
		prefposition(
			help.position_x, help.size_x + help.position_x,
			help.position_y, help.size_y + help.position_y
		);
		help.gid = winopen(help.name);
		wintitle(help.name);
		prefsize(help.size_x, help.size_y);
		keepaspect(help.size_x, help.size_y);
		winconstraints();
		frontbuffer(TRUE);
		backbuffer(FALSE);
		RGBmode();
		gconfig();
		help.current_string[0] = NULL;
		help.menu = help_defpup();
		/* no break, draw window */
	case REDRAW:
		winset(help.gid);
		pushattributes();
		getorigin(&help.position_x, &help.position_y);
		reshapeviewport();
		ortho2(0., 29., .5, -1.5);
		cpack(help.color_background);
		clear();
		cpack(help.color_text);
		cmov2(0., 0.);
		charstr(" ");
		charstr(str);
		popattributes();
		break;
	case DESTROY:
		winclose(help.gid);
		break;
	case MENUBUTTON:
		if (getbutton(MENUBUTTON)) {
			switch(dopup(help.menu)) {
			default:
				break;
			case EXIT:
				edit_exit = TRUE;
				break;
			}
		}
		break;
	}
	return(help.gid);
}


help_defpup()
{
	long pup;
	char string[256], *s;

	s = string;
	s += sprintf(s, "Help Options %%t");
	s += sprintf(s, "| Exit Edit %%x%d", EXIT);
	pup = defpup(string);
	return(pup);
}



help_getdefaults(hi)

struct helpinfo *hi;
{
	char *cp;

	hi->position_x = 820;
	hi->position_y = 40;
	hi->size_x = 400;
	hi->size_y = 25;
	hi->color_background = 0xff000000;
	hi->color_text = 0xffffffff;
	strcpy(hi->name, "Echo Demo Help");
}
