/* SCCS @(#)widgetstructure.h	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       widgetstructure.h                              */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   widgetstructure.h                                   */
/*                                                                      */
/* DESCRIPTION  :   Structure of parameters                             */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include "../LaboImage.util.h"
#include "../define.h"
#include "../structure.h"
#include "../global.h"
#include "../type.h"

extern void libere_memoire();

typedef struct _struc_widgetparamIO {
    Widget      parent;
    Widget      header_length;
    Widget      No_rows_image;
    Widget      No_columns_image;
    Widget      No_bytes_to_skip_pixel;
    Widget      No_bytes_row;
} xs_struc_widgetparamIO;


typedef struct _struc_widgetIO {
    Widget      filewidget;
    xs_struc_widgetparamIO *param;
} xs_struc_widgetIO;


typedef struct _struc_widget_planeout {
    Widget 	IO_load_image_file_widget;
    int    	type;
    int  	(* fct_ok_lecture)();
    char 	* filename;
    struct fname   *fn; 
    struct 	lecture_lts *lect_lts; 
} xs_struc_widget_planeout;


typedef struct _image_select {
    Widget 	plan_image[MAX_IMAGE];
    int 	num_index;
} plan_image_select;


typedef struct _struct_paramsconversion {
    Widget      Generparent;
    Widget      GenerParamparent;
    Widget      parent;
    Widget      Imu;
    Widget      Imu2;
    Widget      Imin;
    Widget      Imax;
    Widget      Omin;
    Widget      Omax;
    short       type_arr;
} xs_struc_paramsconversion;


typedef struct _struct_paramprepro {
    int         type_operation;
    Widget      Generparent;
    Widget      GenerParamparent;
    Widget      parent;
    Widget      line;
    Widget      colon;
    Widget      line1;
    Widget      colon1;
    Widget	alpha;  /*hig_pass filter param, hamming, hanning, gaussian*/
    Widget	diameter; /*gaussian*/
    Widget      *Text;
} xs_struc_paramprepro;


typedef struct _struct_morpho {
    int         num_option;   /*morphologie binaire*/
    void        (* callback)();
} xs_struc_morpho;


typedef struct _struct_histo {
    struct description_vecteur *dv;
    Widget	canvas;   /*histogramme*/
    Widget	level;
    Widget      percent;
    Widget      percent_tot;
} xs_struc_histo;


typedef struct _IMAGE {
    Pixmap	pixmap;
    XImage  	*ximage;
    unsigned char 	*image;
    unsigned char 	*imagedisplay;    
    unsigned int  	type;
    unsigned int	width;
    unsigned int	height;
} IMAGE;


	
typedef struct _struct_display_menu {
    struct 	image_ecran *im_desc;
    IMAGE 	*ret;
    int 	colormap;
    Widget 	Thresh_text;
    Widget 	Drawing_Area;
    char 	repfloat[20];
    int    	calliperON;		/* Calliper */
    char   	*masque;		/* ROI      */
    Pixmap 	MaskPix;
    int 	masque_width;
    int 	masque_height;
    Widget 	Drawing_Area_profile;  	/* Profiler */
    Pixmap	pixmap_profile;
    Widget  	label_profile[6];
    Widget  	label_pixeledit[3];     /* Pixel Edit */
    Widget  	Couleur_correct;
} xs_struc_display_menu;



/****** Desctool TOOL ******/

typedef struct _struct_desctool {
    Widget 	tabtype[8];
    Widget      File;
    Widget      Type;
    Widget      Row_Count;
    Widget      Column_Count;
    Widget      Min[3];
    Widget      Max[3];
    Widget      Avg_Value[3];
    Widget      Std_Deviation[3];
    Widget      Comments;
} xs_struc_desctool;



/****** MapEdit TOOL ******/

typedef struct _struct_mapedit {
    Widget      File;
    Widget	map_type[4];
    Widget	FROM_TO_label[2];
    Widget	FROM_TO_text[2];
    Widget 	RGB1_label[3];
    Widget      RGB2_label[3];
    Widget      label0_1[3];
    Widget      label0_2[3];
    Widget      label255_1[3];
    Widget      label255_2[3];
    Widget      Scale1[3];
    int	        ValueScale1[3];
    Widget      Scale2[3];
    int	        ValueScale2[3];
} xs_struc_mapedit;



/****** Region Growing Segmentation TOOL ******/

typedef struct _struct_reg_growing {
    Widget 	tabsegmentation[4];
    Widget 	tabconnexity[2];
    Widget      tolerance;
    Widget      tabtrace[2];
    Widget      tabdisplay[3];
    Widget      drawing_widget[2];
} xs_struc_reg_growing;



/****** Image generation (monochrome&graytone) TOOL ******/

typedef struct _struct_ima_gener {
    Widget 	Width_text;
    Widget 	Height_text;
    Widget 	XY_label;
    Widget 	Draw_dialog;
    Widget 	Drawing_area;
    Pixmap      pixmap_drawing;
    Widget 	Back_color;
    Widget 	Seg_color;  
} xs_struc_ima_gener;
