/* SCCS @(#)mapeditTOOL.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                   mapeditTOOL.layout.c                               */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   mapeditTOOL.layout.c                                */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Map Editing Tool)                        */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "mapeditTOOL.layout.h"
#include "libwidgets/widgetstructure.h"
#include <Xm/Text.h>

#define MAX_ARGS 100

extern void hproc_MapEditbis();

extern XmFontList gFontlist, gSmall_fontlist;
extern Display *gDisplay;
extern Visual *gVisual;

extern GC default_gc;  
extern Pixel gOldLace;

void install_newcolormap();

Colormap Mapedit_colormap = NULL;
XColor Colors[MAXCOLORS];
int mode;

Pixmap mapeditpixmap;
Pixmap flechepixmap;
Widget XmDrawingAreamapedit;
Widget XmDrawingAreafleche;
XImage *ximage_mapedit;

extern void init_red_green_blue();
extern Widget gLabowidget;



static Widget Help_Mapedit_area;


/*****************************************************************************/
/*                							     */
/* nom      : write_help_mapedit					     */
/*									     */
/* fonction : ecrit le message help pointe par buf dans la fenetre           */
/*            de help						  	     */
/*									     */
/* entrees  : char *buf                 : message a ecrire                   */
/*									     */
/*								             */
/*****************************************************************************/
int write_help_mapedit(filename)
char filename[60];
{
  char * buf;
  int i;
  XmTextPosition position;

  format_to_windowsize(filename,&buf);

  if (buf == NULL) 
      return (0);
  else {
   position = XmTextGetCursorPosition (Help_Mapedit_area);
   XmTextInsert(Help_Mapedit_area, position, buf);

   free(buf);
   return(0);
   }
}


/********************************************************
/   Creation Function for Freeze_Frame 
/*******************************************************/

Widget
build_Freeze_Frame(mapedit_widget, Freeze_label, tab_widgets)
	Widget mapedit_widget;
        Widget Freeze_label;
	xs_struc_mapedit *tab_widgets;
{
	Widget Freeze_Frame;
	Widget RadioBox_1;
	Widget RadioButton_2;
	Widget RadioButton_3;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Freeze_Frame Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,Freeze_label); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,23); n++;

	Freeze_Frame = XmCreateFrame(mapedit_widget,"Freeze_Frame",args,n);
	XtManageChild(Freeze_Frame);

	/* Creating RadioBox_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	RadioBox_1 = XmCreateRadioBox(Freeze_Frame,"RadioBox_1",args,n);
	XtManageChild(RadioBox_1);

	/* Creating RadioButton_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("ON",
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_2 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_2",args,n);

	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback,
			Choose_freeze, 1);
	XtAddCallback(RadioButton_2,XmNvalueChangedCallback,
			freeze_proc, tab_widgets);

	XtManageChild(RadioButton_2);

	/* Creating RadioButton_3 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("OFF",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,true); n++;

	RadioButton_3 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_3",args,n);
		
	/* Adding Callbacks for RadioButton_3 */ 

	XtAddCallback(RadioButton_3,XmNvalueChangedCallback,
			Choose_freeze, 0);

	XtManageChild(RadioButton_3);

	return(Freeze_Frame);
}


/********************************************************
/   Creation Function for Interpolation_Frame 
/*******************************************************/

Widget
build_Interpolation_Frame(mapedit_widget, Interpolation_label)
	Widget mapedit_widget;
        Widget Interpolation_label;
{
	Widget Interpolation_Frame;
	Widget RadioBox_1;
	Widget RadioButton_2;
	Widget RadioButton_3;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Interpolation_Frame Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,Interpolation_label); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,23); n++;

	Interpolation_Frame = XmCreateFrame(mapedit_widget,
					    "Interpolation_Frame",args,n);
	XtManageChild(Interpolation_Frame);

	/* Creating RadioBox_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	RadioBox_1 = XmCreateRadioBox(Interpolation_Frame,
				      "RadioBox_1",args,n);
	XtManageChild(RadioBox_1);

	/* Creating RadioButton_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("LIN",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,true); n++;

	RadioButton_2 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_2",args,n);

	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback, Choose_interpolation, 1);

	XtManageChild(RadioButton_2);

	/* Creating RadioButton_3 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("LOG",
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_3 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_3",args,n);

	/* Adding Callbacks for RadioButton_3 */ 

	XtAddCallback(RadioButton_3,XmNvalueChangedCallback, Choose_interpolation, 0);

	XtManageChild(RadioButton_3);

	return(Interpolation_Frame);
}


/********************************************************
/   Creation Function for mapedit_widget 
/*******************************************************/

xs_struc_mapedit *
build_mapedit_widget(mapedit, mapeditseparator)
	Widget mapedit;
        Widget mapeditseparator;
    
{
	Widget mapedit_widget;
	Widget File_label;
	Widget File_text;
	Widget map_label;
	Widget Interpolation_label;
	Widget Map_frame;
	Widget RadioBox_1;
	Widget RadioButton_2;
	Widget RadioButton_3;
	Widget RadioButton_4;
	Widget RadioButton_5;
	Widget Freeze_label;
	Widget Freeze_Frame;
	Widget Interpolation_Frame;
	Widget FROM_label;
	Widget FROM_text;
	Widget TO_label;
	Widget TO_text;
	Widget R1_Label;
	Widget R1_0_Label;
	Widget R1_Scale;
	Widget R1_255_Label;
	Widget G1_Label;
	Widget G1_0_Label;
	Widget G1_Scale;
	Widget G1_255_Label;
	Widget B1_Label;
	Widget B1_0_Label;
	Widget B1_Scale;
	Widget B1_255_Label;
	Widget R2_Label;
	Widget G2_Label;
	Widget B2_Label;
	Widget R2_0_Label;
	Widget G2_0_Label;
	Widget B2_0_Label;
	Widget R2_Scale;
	Widget G2_Scale;
	Widget B2_Scale;
	Widget R2_255_Label;
	Widget G2_255_Label;
	Widget B2_255_Label;
	xs_struc_mapedit *tab_widgets;
	char *repstring;
	Arg args[MAX_ARGS];
	int n;

	tab_widgets = (xs_struc_mapedit *) malloc (sizeof (xs_struc_mapedit));

	repstring = (char *) malloc (20);

	/* Creating mapedit_widget Widget */ 

	n = 0;

	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget,mapeditseparator); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	mapedit_widget = XmCreateForm(mapedit,"mapedit_widget",args,n);

	/* Creating File_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[302],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,3); n++;

	File_label = XmCreateLabel(mapedit_widget,"File_label",args,n);
	XtManageChild(File_label);

	/* Creating File_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,File_label); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,3); n++;

	File_text = XmCreateText(mapedit_widget,"File_text",args,n);
	XmTextSetString (File_text, repertoire_image);

	XtManageChild(File_text);
	
	tab_widgets->File = File_text;
	
	/* Creating map_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[307],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,14); n++;

	map_label = XmCreateLabel(mapedit_widget,"map_label",args,n);
	XtManageChild(map_label);

	/* Creating Interpolation_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[305],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,23); n++;

	Interpolation_label = XmCreateLabel(mapedit_widget,
					    "Interpolation_label",args,n);
	XtManageChild(Interpolation_label);

	/* Creating Map_frame Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,Interpolation_label); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,14); n++;

	Map_frame = XmCreateFrame(mapedit_widget,"Map_frame",args,n);
	XtManageChild(Map_frame);

	/* Creating RadioBox_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	RadioBox_1 = XmCreateRadioBox(Map_frame,"RadioBox_1",args,n);
	XtManageChild(RadioBox_1);

	/* Creating RadioButton_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("RGB_multi",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,true); n++;
	mode = 1;
	RadioButton_2 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_2",args,n);

	tab_widgets->map_type[0] = RadioButton_2;

	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback,
			Set_map_edit, tab_widgets);

	XtManageChild(RadioButton_2);

	/* Creating RadioButton_3 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("RGB_one",
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_3 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_3",args,n);

	tab_widgets->map_type[1] = RadioButton_3;

	/* Adding Callbacks for RadioButton_3 */ 

	XtAddCallback(RadioButton_3,XmNvalueChangedCallback,
			Set_map_edit, tab_widgets);

	XtManageChild(RadioButton_3);

	/* Creating RadioButton_4 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("HLS_multi",
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_4 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_4",args,n);

	tab_widgets->map_type[2] = RadioButton_4;

	/* Adding Callbacks for RadioButton_4 */ 

	XtAddCallback(RadioButton_4,XmNvalueChangedCallback,
			Set_map_edit, tab_widgets);

	XtManageChild(RadioButton_4);

	/* Creating RadioButton_5 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("HLS_one",
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_5 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_5",args,n);

	tab_widgets->map_type[3] = RadioButton_5;

	/* Adding Callbacks for RadioButton_5 */ 

	XtAddCallback(RadioButton_5,XmNvalueChangedCallback,
			Set_map_edit, tab_widgets);

	XtManageChild(RadioButton_5);

	/* Creating Freeze_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[306],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,50); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,23); n++;

	Freeze_label = XmCreateLabel(mapedit_widget,"Freeze_label",args,n);
	XtManageChild(Freeze_label);

	/* Creating Freeze_Frame Widget */ 

	Freeze_Frame = build_Freeze_Frame(mapedit_widget,
					  Freeze_label, tab_widgets);

	/* Creating Interpolation_Frame Widget */ 

	Interpolation_Frame = build_Interpolation_Frame(mapedit_widget, 
							Interpolation_label);
	/* Creating FROM_label Widget */

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[314],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 5); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,35); n++;

	FROM_label = XmCreateLabel(mapedit_widget,"FROM_label",args,n);
	XtManageChild(FROM_label);

	tab_widgets->FROM_TO_label[0] = FROM_label;

	/* Creating FROM_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,FROM_label); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,35); n++;

	FROM_text = XmCreateText(mapedit_widget,"FROM_text",args,n);
	sprintf (repstring, "%d", 0); 
	XmTextSetString (FROM_text, repstring);
	XtManageChild(FROM_text);

	tab_widgets->FROM_TO_text[0] = FROM_text;

        XtAddCallback (FROM_text, XmNvalueChangedCallback,
					change_text_value, tab_widgets);

	/* Creating R1_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("R :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 10); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,44); n++;

	R1_Label = XmCreateLabel(mapedit_widget,"R1_Label",args,n);
	XtManageChild(R1_Label);

	tab_widgets->RGB1_label[0] = R1_Label;

	/* Creating R1_0_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,R1_Label); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,44); n++;

	R1_0_Label = XmCreateLabel(mapedit_widget,"R1_0_Label",args,n);
	XtManageChild(R1_0_Label);

	tab_widgets->label0_1[0] = R1_0_Label;

	/* Creating R1_Scale Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,R1_0_Label); n++;
	XtSetArg(args[n],XmNmaximum,255); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNprocessingDirection,XmMAX_ON_RIGHT); n++;
	XtSetArg(args[n],XmNscaleHeight,20); n++;
	XtSetArg(args[n],XmNscaleWidth,300); n++; /*256*/
	XtSetArg(args[n],XmNshowValue,true); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,41); n++;

	R1_Scale = XmCreateScale(mapedit_widget,"R1_Scale",args,n);
	XtManageChild(R1_Scale);

	tab_widgets->Scale1[0] = R1_Scale;

	tab_widgets->ValueScale1[0] = 0;
	
        XtAddCallback (R1_Scale, XmNdragCallback, 
					change_field, tab_widgets);
	XtAddCallback (R1_Scale, XmNvalueChangedCallback,
					change_field, tab_widgets);
        XtAddCallback (R1_Scale, XmNvalueChangedCallback,
					install_mapcolormap, NULL);

	/* Creating R1_255_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("255",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,R1_Scale); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,44); n++;

	R1_255_Label = XmCreateLabel(mapedit_widget,"R1_255_Label",args,n);
	XtManageChild(R1_255_Label);

	tab_widgets->label255_1[0] = R1_255_Label;

	/* Creating G1_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("G :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 10); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,52); n++;

	G1_Label = XmCreateLabel(mapedit_widget,"G1_Label",args,n);
	XtManageChild(G1_Label);

	tab_widgets->RGB1_label[1] = G1_Label;

	/* Creating G1_0_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,G1_Label); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,52); n++;

	G1_0_Label = XmCreateLabel(mapedit_widget,"G1_0_Label",args,n);
	XtManageChild(G1_0_Label);

	tab_widgets->label0_1[1] = G1_0_Label;

	/* Creating G1_Scale Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,G1_0_Label); n++;
	XtSetArg(args[n],XmNmaximum,255); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNprocessingDirection,XmMAX_ON_RIGHT); n++;
	XtSetArg(args[n],XmNscaleHeight,20); n++;
	XtSetArg(args[n],XmNscaleWidth,300); n++; /*256*/
	XtSetArg(args[n],XmNshowValue,true); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,49); n++;

	G1_Scale = XmCreateScale(mapedit_widget,"G1_Scale",args,n);
	XtManageChild(G1_Scale);

	tab_widgets->Scale1[1] = G1_Scale;

	tab_widgets->ValueScale1[1] = 0;

        XtAddCallback (G1_Scale, XmNdragCallback, 
					change_field, tab_widgets);
        XtAddCallback (G1_Scale, XmNvalueChangedCallback,
					change_field, tab_widgets);
        XtAddCallback (G1_Scale, XmNvalueChangedCallback,
					install_mapcolormap, NULL);

	/* Creating G1_255_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("255",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,G1_Scale); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,52); n++;

	G1_255_Label = XmCreateLabel(mapedit_widget,"G1_255_Label",args,n);
	XtManageChild(G1_255_Label);

	tab_widgets->label255_1[1] = G1_255_Label;

	/* Creating B1_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("B :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 10); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,60); n++;

	B1_Label = XmCreateLabel(mapedit_widget,"B1_Label",args,n);
	XtManageChild(B1_Label);

	tab_widgets->RGB1_label[2] = B1_Label;

	/* Creating B1_0_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,B1_Label); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,60); n++;

	B1_0_Label = XmCreateLabel(mapedit_widget,"B1_0_Label",args,n);
	XtManageChild(B1_0_Label);

	tab_widgets->label0_1[2] = B1_0_Label;

	/* Creating B1_Scale Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,B1_0_Label); n++;
	XtSetArg(args[n],XmNmaximum,255); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNprocessingDirection,XmMAX_ON_RIGHT); n++;
	XtSetArg(args[n],XmNscaleHeight,20); n++;
	XtSetArg(args[n],XmNscaleWidth,300); n++; /*256*/
	XtSetArg(args[n],XmNshowValue,true); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,57); n++;

	B1_Scale = XmCreateScale(mapedit_widget,"B1_Scale",args,n);
	XtManageChild(B1_Scale);

	tab_widgets->Scale1[2] = B1_Scale;

	tab_widgets->ValueScale1[2] = 0;

        XtAddCallback (B1_Scale, XmNdragCallback, 
					change_field, tab_widgets);
        XtAddCallback (B1_Scale, XmNvalueChangedCallback,
					change_field, tab_widgets);
        XtAddCallback (B1_Scale, XmNvalueChangedCallback,
					install_mapcolormap, NULL);

	/* Creating B1_255_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("255",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,B1_Scale); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,60); n++;

	B1_255_Label = XmCreateLabel(mapedit_widget,"B1_255_Label",args,n);
	XtManageChild(B1_255_Label);

	tab_widgets->label255_1[2] = B1_255_Label;


	/* Creating TO_label Widget */

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[315],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 5); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,69); n++;
	TO_label = XmCreateLabel(mapedit_widget,"TO_label",args,n);
	XtManageChild(TO_label);

	tab_widgets->FROM_TO_label[1] = TO_label;
	
	/* Creating TO_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,FROM_label); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,69); n++;

	TO_text = XmCreateText(mapedit_widget,"TO_text",args,n);
	sprintf (repstring, "%d", 255); 
	XmTextSetString (TO_text, repstring);
	XtManageChild(TO_text);

	tab_widgets->FROM_TO_text[1] = TO_text;

        XtAddCallback (TO_text, XmNvalueChangedCallback,
					change_text_value, tab_widgets);

	/* Creating R2_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("R :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 10); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,78); n++;

	R2_Label = XmCreateLabel(mapedit_widget,"R2_Label",args,n);
	XtManageChild(R2_Label);

	tab_widgets->RGB2_label[0] = R2_Label;

	/* Creating G2_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("G :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 10); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,86); n++;

	G2_Label = XmCreateLabel(mapedit_widget,"G2_Label",args,n);
	XtManageChild(G2_Label);

	tab_widgets->RGB2_label[1] = G2_Label;

	/* Creating B2_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("B :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 10); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,94); n++;

	B2_Label = XmCreateLabel(mapedit_widget,"B2_Label",args,n);
	XtManageChild(B2_Label);

	tab_widgets->RGB2_label[2] = B2_Label;

	/* Creating R2_0_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,R2_Label); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,78); n++;

	R2_0_Label = XmCreateLabel(mapedit_widget,"R2_0_Label",args,n);
	XtManageChild(R2_0_Label);

	tab_widgets->label0_2[0] = R2_0_Label;

	/* Creating G2_0_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,G2_Label); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,86); n++;

	G2_0_Label = XmCreateLabel(mapedit_widget,"G2_0_Label",args,n);
	XtManageChild(G2_0_Label);

	tab_widgets->label0_2[1] = G2_0_Label;

	/* Creating B2_0_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,B2_Label); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,94); n++;

	B2_0_Label = XmCreateLabel(mapedit_widget,"B2_0_Label",args,n);
	XtManageChild(B2_0_Label);

	tab_widgets->label0_2[2] = B2_0_Label;

	/* Creating R2_Scale Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,R2_0_Label); n++;
	XtSetArg(args[n],XmNmaximum,255); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNprocessingDirection,XmMAX_ON_RIGHT); n++;
	XtSetArg(args[n],XmNscaleHeight,20); n++;
	XtSetArg(args[n],XmNscaleWidth,300); n++; /*256*/
	XtSetArg(args[n],XmNshowValue,true); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,75); n++;

	R2_Scale = XmCreateScale(mapedit_widget,"R2_Scale",args,n);
	XtManageChild(R2_Scale);

	tab_widgets->Scale2[0] = R2_Scale;

	tab_widgets->ValueScale2[0] = 0;

        XtAddCallback (R2_Scale, XmNdragCallback, 
					change_field, tab_widgets);
        XtAddCallback (R2_Scale, XmNvalueChangedCallback,
					change_field, tab_widgets);
        XtAddCallback (R2_Scale, XmNvalueChangedCallback,
					install_mapcolormap, NULL);


	/* Creating G2_Scale Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,G2_0_Label); n++;
	XtSetArg(args[n],XmNmaximum,255); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNprocessingDirection,XmMAX_ON_RIGHT); n++;
	XtSetArg(args[n],XmNscaleHeight,20); n++;
	XtSetArg(args[n],XmNscaleWidth,300); n++; /*256*/
	XtSetArg(args[n],XmNshowValue,true); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,83); n++;

	G2_Scale = XmCreateScale(mapedit_widget,"G2_Scale",args,n);
	XtManageChild(G2_Scale);

	tab_widgets->Scale2[1] = G2_Scale;

	tab_widgets->ValueScale2[1] = 0;

        XtAddCallback (G2_Scale, XmNdragCallback, 
					change_field, tab_widgets);
        XtAddCallback (G2_Scale, XmNvalueChangedCallback,
					change_field, tab_widgets);
        XtAddCallback (G2_Scale, XmNvalueChangedCallback,
					install_mapcolormap, NULL);


	/* Creating B2_Scale Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,B2_0_Label); n++;
	XtSetArg(args[n],XmNmaximum,255); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNprocessingDirection,XmMAX_ON_RIGHT); n++;
	XtSetArg(args[n],XmNscaleHeight,20); n++;
	XtSetArg(args[n],XmNscaleWidth,300); n++; /*256*/
	XtSetArg(args[n],XmNshowValue,true); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,91); n++;

	B2_Scale = XmCreateScale(mapedit_widget,"B2_Scale",args,n);
	XtManageChild(B2_Scale);

	tab_widgets->Scale2[2] = B2_Scale;

	tab_widgets->ValueScale2[2] = 0;

        XtAddCallback (B2_Scale, XmNdragCallback, 
					change_field, tab_widgets);
        XtAddCallback (B2_Scale, XmNvalueChangedCallback,
					change_field, tab_widgets);
        XtAddCallback (B2_Scale, XmNvalueChangedCallback,
					install_mapcolormap, NULL);


	/* Creating R2_255_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("255",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,R2_Scale); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,78); n++;

	R2_255_Label = XmCreateLabel(mapedit_widget,"R2_255_Label",args,n);
	XtManageChild(R2_255_Label);

	tab_widgets->label255_2[0] = R2_255_Label;

	/* Creating G2_255_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("255",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,G2_Scale); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,86); n++;

	G2_255_Label = XmCreateLabel(mapedit_widget,"G2_255_Label",args,n);
	XtManageChild(G2_255_Label);

	tab_widgets->label255_2[1] = G2_255_Label;

	/* Creating B2_255_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("255",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,B2_Scale); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,94); n++;

	B2_255_Label = XmCreateLabel(mapedit_widget,"B2_255_Label",args,n);
	XtManageChild(B2_255_Label);

	tab_widgets->label255_2[2] = B2_255_Label;

	XtManageChild(mapedit_widget);

	return(tab_widgets);
}




/********************************************************
/   Creation Function for Help_Mapedit
/*******************************************************/

Widget 
build_Help_Mapedit(Help)
	Widget Help;
{
        Widget Help_Mapedit; 
        Widget MainWindow_7;
        Widget WorkRegion;
        Widget QUIT;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Help_Mapedit Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNdialogTitle, 
		XmStringLtoRCreate(paneltabs[312],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNshadowThickness,2); n++;
	XtSetArg(args[n],XmNx, 10); n++;
	XtSetArg(args[n],XmNy, 10); n++;
	XtSetArg(args[n],XmNheight,297); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,350); n++;

	Help_Mapedit = XmCreateFormDialog(Help,"Help_Mapedit",args,n);


        n = 0;
        XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
        XtSetArg(args[n],XmNbottomPosition, 98); n++;
        XtSetArg(args[n],XmNfontList,gFontlist); n++;
        XtSetArg(args[n],XmNlabelString,
                XmStringLtoRCreate(paneltabs[313],
                        XmSTRING_DEFAULT_CHARSET)); n++;
        XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
        XtSetArg(args[n],XmNleftPosition,40); n++;
        XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
        XtSetArg(args[n],XmNrightPosition, 60); n++;
        XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;

        QUIT = XmCreatePushButton(Help_Mapedit,"QUIT", args,n);
	XtManageChild(QUIT);

        /* Adding Callbacks for QUIT */

        XtAddCallback(QUIT,XmNactivateCallback,QUIT_help_actcall, Help_Mapedit);

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget, QUIT); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	MainWindow_7 = XmCreateMainWindow(Help_Mapedit,"MainWindow_7",args,n);
	XtManageChild(MainWindow_7);

        /* Creating WorkRegion Widget */

        n = 0;
        XtSetArg(args[n],XmNbackground, gOldLace); n++;
        XtSetArg(args[n],XmNheight,297); n++;
        XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;

        WorkRegion = CreateWorkRegion(MainWindow_7,"WorkRegion",args,n);
        XtManageChild(WorkRegion);

        /* Creating Help_Mapedit_area Widget */

        n = 0;
        XtSetArg(args[n],XmNeditMode,XmMULTI_LINE_EDIT); n++;
        XtSetArg(args[n],XmNheight,700); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

        Help_Mapedit_area = 
	    XmCreateScrolledText(WorkRegion,"Help_Mapedit_area", args,n);
        XtManageChild(Help_Mapedit_area);

        /* Set parent's geometry resources */

        n = 0;
        XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
        XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
        XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
        XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
        XtSetValues(XtParent(Help_Mapedit_area), args, n);

	return(Help_Mapedit);
}


void 
Build_mapedit()
{
	Widget mapedit_mainwidget;
	Widget mapedit_separator;
	Widget mapedit_command;
	Widget mapedit_LOAD;
	Widget mapedit_SAVE;
	Widget mapedit_HELP;
	Widget mapedit_QUIT;
	Widget Help_Mapedit;
	Widget mapeditview;
	Window Windowview;
	int i, j, size;
        XImage *ximage_fleche;
	unsigned char *mapedit_data;
 	Widget mapeditview_separator;
        xs_struc_mapedit *tab_widgets;
	Arg args[MAX_ARGS];
	int n;
	Position  x, y;

	/* Creating mapedit_mainwidget Widget */ 

	n = 0;
        XtSetArg(args[n],XmNwidth,530); n++;
        XtSetArg(args[n],XmNheight,600); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNdialogTitle, 
	   XmStringLtoRCreate("Mapedit", XmSTRING_DEFAULT_CHARSET)); n++;

	mapedit_mainwidget =
		XmCreateFormDialog(gLabowidget,"mapedit_mainwidget",args,n);

	XtAddEventHandler((Widget)mapedit_mainwidget, 
			EnterWindowMask | LeaveWindowMask,False,
 			(XtEventHandler)install_mapeditcolormap, NULL);


	/* Creating mapedit_command Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;

	mapedit_command = 
	  XmCreateForm(mapedit_mainwidget,"mapedit_command",args,n);
	XtManageChild(mapedit_command);

	/* Creating mapedit_LOAD Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[303],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,4); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,24); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	mapedit_LOAD = 
		XmCreatePushButton(mapedit_command,"mapedit_LOAD",args,n);
	XtManageChild(mapedit_LOAD);


	/* Creating mapedit_SAVE Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[304],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,28); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,48); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	mapedit_SAVE = 
		XmCreatePushButton(mapedit_command,"mapedit_SAVE",args,n);
	XtManageChild(mapedit_SAVE);

	/* Creating mapedit_HELP Widget */

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[312],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,52); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,72); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	mapedit_HELP = 
		XmCreatePushButton(mapedit_command,"mapedit_HELP",args,n);
	XtManageChild(mapedit_HELP);

	/* Creating Help_Labo Widget */ 

	Help_Mapedit = build_Help_Mapedit(mapedit_HELP);
	
	hproc_MapEditbis();

	/* Adding Callbacks for mapedit_HELP */ 

	XtAddCallback(mapedit_HELP,
		XmNactivateCallback,mapedit_HELP_callb, Help_Mapedit);

	/* Creating mapedit_QUIT Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[313],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,76); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,96); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	mapedit_QUIT = 
		XmCreatePushButton(mapedit_command,"mapedit_QUIT",args,n);
	XtManageChild(mapedit_QUIT);

	/* Adding Callbacks for mapedit_QUIT */ 

	XtAddCallback(mapedit_QUIT,
		XmNactivateCallback,mapedit_QUIT_callb, mapedit_mainwidget);

	/* Creating mapedit_separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget, mapedit_command); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;

	mapedit_separator = 
		XmCreateSeparator(mapedit_mainwidget,
				  "mapedit_separator",args,n);

	XtManageChild(mapedit_separator);


	/* Creating mapeditview Widget */ 

	n = 0;
        XtSetArg(args[n],XmNwidth,530); n++;
        XtSetArg(args[n],XmNheight,90); n++;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget,mapedit_separator); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;

	mapeditview = 
	  XmCreateForm(mapedit_mainwidget,"mapeditview",args,n);

	XtManageChild(mapeditview);

	mapeditpixmap = XCreatePixmap(gDisplay,
				  XDefaultRootWindow(gDisplay),
				  512, 50, 8);
	size = 512 * 50;
	
	mapedit_data = (unsigned char *)malloc(size); 

	ximage_mapedit = XCreateImage(gDisplay, gVisual,
			8, ZPixmap, 0, (char *)mapedit_data,
			512, 50, 8, 0);
	for (j = 0; j<50; j++) 
	  for (i = 0; i<256; i++) 
	  {
	  *mapedit_data = i;
	  mapedit_data++;
	  *mapedit_data = i;
	  mapedit_data++;
	  }
	XPutImage(gDisplay, mapeditpixmap, default_gc,
	    ximage_mapedit, 0, 0, 0, 0, 512, 50);
/*	XDestroyImage(ximage_mapedit);*/
	free(mapedit_data);

	n = 0;
	XtSetArg(args[n],XmNbackgroundPixmap, mapeditpixmap); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 30); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 2); n++;
	XtSetArg(args[n],XmNwidth, 512); n++;
	XtSetArg(args[n],XmNheight, 50); n++;
	XmDrawingAreamapedit = XtCreateWidget("XmDrawingAreamapedit",
					      xmDrawingAreaWidgetClass,
					      mapeditview, args, n);
 
	XtManageChild(XmDrawingAreamapedit);

	flechepixmap = XCreatePixmap(gDisplay,
				  XDefaultRootWindow(gDisplay),
				  512, 20, 8);
	size = 512 * 20;
	
	mapedit_data = (unsigned char *)malloc(size); 

	ximage_fleche = XCreateImage(gDisplay, gVisual,
			8, ZPixmap, 0, (char *)mapedit_data,
			512, 20, 8, 0);
        for (i = 0; i<size; i++) 
	  {
	  *mapedit_data = 0;
	  mapedit_data++;
	  }
	XPutImage(gDisplay, flechepixmap, default_gc,
	    ximage_fleche, 0, 0, 0, 0, 512, 20);
	XDestroyImage(ximage_fleche);
	free(mapedit_data);

	n = 0;
	XtSetArg(args[n],XmNbackgroundPixmap, flechepixmap); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,10); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 2); n++;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNbottomPosition, 30); n++;
	XtSetArg(args[n],XmNwidth, 512); n++;
	XmDrawingAreafleche = XtCreateWidget("XmDrawingAreafleche",
					     xmDrawingAreaWidgetClass,
					     mapeditview, args, n);
 
	XtManageChild(XmDrawingAreafleche);

	/* Creating mapeditview_separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget, mapeditview); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;

	mapeditview_separator = 
	XmCreateSeparator(mapedit_mainwidget,"mapeditview_separator",args,n);

	XtManageChild(mapeditview_separator);


	tab_widgets = 
	build_mapedit_widget(mapedit_mainwidget, mapeditview_separator);
	        
	XtAddEventHandler((Widget)XmDrawingAreamapedit, 
			EnterWindowMask | LeaveWindowMask,False,
 			(XtEventHandler)install_newcolormap, tab_widgets);


	/* Adding Callbacks for mapedit_LOAD */ 

	XtAddCallback(mapedit_LOAD,
		XmNactivateCallback,mapedit_LOAD_callb, tab_widgets);

	/* Adding Callbacks for mapedit_SAVE */ 

	XtAddCallback(mapedit_SAVE,
		XmNactivateCallback,mapedit_SAVE_callb, tab_widgets);

	XtManageChild(mapedit_mainwidget);

	/* Adding Callbacks for XmDrawingAreafleche */ 

	XtAddEventHandler((Widget)XmDrawingAreafleche, 
			ButtonPressMask,False,
 			(XtEventHandler)get_field, tab_widgets);

        Mapedit_colormap = 
	  XCreateColormap (gDisplay, DefaultRootWindow (gDisplay), 
			   DefaultVisual(gDisplay, DefaultScreen(gDisplay)),
			   AllocAll);

        Colors[0].red = Colors[0].green = Colors[0].blue = 65535;
        Colors[0].pixel = 0;
        Colors[0].flags = DoRed|DoGreen|DoBlue;

        for (i = 1 ; i < MAXCOLORS ; i++) {
	  Colors[i].red = Colors[i].green = Colors[i].blue = i * 257;
  	  Colors[i].pixel = i;
	  Colors[i].flags = DoRed|DoGreen|DoBlue;
         }
        Colors[255].red = Colors[255].green = Colors[255].blue = 0;
        Colors[255].pixel = 255;
        Colors[255].flags = DoRed|DoGreen|DoBlue;
        XStoreColors (gDisplay, Mapedit_colormap, Colors, MAXCOLORS);
	
	init_red_green_blue(tab_widgets);
}



