/* Partie declarative */

# include <stdio.h>
# include <math.h>
# include <suntool/sunview.h>
# include <suntool/panel.h>
# include <suntool/frame.h>
# include <suntool/canvas.h>
# include <suntool/scrollbar.h>
# include <pixrect/pixrect_hs.h>

# include "define.h"
# include "structure.h"
# include "global.h"
# include "type.h"


extern void hproc_construct_graphe();
extern void hproc_grapheToimage();
extern void hproc_extract_regions();
extern void hproc_eliminate_regions();
extern void hproc_Ohlander_Price_Reddy_gray();
extern void hproc_Ohlander_Price_Reddy_rgb();



	  /* Structures de donnees permettant la construction du graphe */

struct run	   /* liste permettant de representer une ligne d'image */  
    {
     int no_region;                              /* numero de la region */
     short int start, end, line;  /* debut & fin du "run" & no de ligne */
     struct graph *node;             /* pointeur sur le noeud du graphe */
     struct run *next_run;
    };

struct feat_list		   /* liste des proprietes d'une region */
    {
     float feature;
     struct feat_list *next_f;
    };

struct graph_list		      /* liste des voisins d'une region */
    {
     struct graph *g_vois;
     struct graph_list *next_gl;
    };

struct graph					   /* noeud d'un graphe */
    {
     int region;		  		 /* numero de la region */
     int nbpix;		     /* nombre de pixels dans la region */
     float sx, sx2;		     /* esp, esp de x2 */
     struct feat_list *first_feat; /* pointeur sur liste des proprietes */
     struct graph_list *first_gl;  /* pointeur sur la liste des voisins */
     struct run *first_run;         /* pointeur sur la liste des "runs" */
    };

struct reg_grow		/* liste des criteres de segmentation/extraction */
    {
     int choix;						/* no du critere */
     float toler;		     /* tolerance par rapport au critere */
     struct reg_grow *next_rg;		 /* prochain element de la liste */
    };

Frame frame_choix;		/* pour l'interaction avec l'utilisateur */
Panel panel_choix;
Panel_item grow_choice;

		/* variables globales pour segment.c & ohl.c */
  
int taille, n_line, n_col, mmin, mmax, /* comme pour images LaboImage */
    cline,					    /* ligne courante */
    tot_region,			       /* nombre de regions du graphe */
    meth = 0;
unsigned char *first;			      /* pointeur sur l'image */
struct reg_grow *f_rg;		/* pointeur sur la liste des criteres */
struct graph *f_g;	/* pointeur sur le premier elelment du graphe */

#include "ohl.c"

/************************************************************************/
/*									*/
/* Nom : lire_choice							*/
/* Fonction : lecture de la reponse de l'utilisateur concernant l'emploi*/
/* ou le non_emploi d'un critere					*/
/* Entree : Panel_item item, Event *event				*/
/* Global : -								*/
/* Routine : -								*/
/* Sortie : -								*/
/*									*/
/* Made by Rene LUTZ 13.10.1989						*/
/************************************************************************/

static Panel_setting lire_choice (item, event)
Panel_item item;
Event *event;
{

    if (event_id(event) == CTRLC) {
        /* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
        window_return (NULL);
        window_destroy (frame_choix);
        return;
    }
    else if (event_id(event) == '\t')
	return(PANEL_NEXT) ;
    else
	window_return((caddr_t)1);

} /* lire_choice */


/************************************************************************/
/*									*/
/* Nom : grow_panel							*/
/* Fonction : Afficher les fenetres d'interaction pour lire le choix	*/
/* des criteres a prendre en consideration pour la methode de region-	*/
/* growing, ainsi que la tolerance pour chaque critere choisi		*/
/* Entree : int methode							*/
/* Global : Frame frame_choix, Panel panel_choix, Panel_item grow_choice*/
/*	    int flag_exec, struct reg_grow *f_rg			*/
/* Routine : lire_choice						*/
/* Sortie : struct reg_grow *f_growy					*/
/*									*/
/* Made by Rene LUTZ 13.10.1989						*/
/************************************************************************/

struct reg_grow *grow_panel (methode)

int methode;		/* 1 = lect. crit. seg, 2 = lect. extract. reg. */

{	/* les variables */
    int i, ligne;
    Panel_item tol_item[8];
    char *stitre[8], rep[20], *chaine_item;
    struct reg_grow *f_growy, *growy, *o_growy, *rg;
    float valeur;

    frame_choix = window_create (frame, FRAME, FRAME_LABEL,
					    labeltabs[6],
				 WIN_X, 500, WIN_Y, 500, 
				 FRAME_NO_CONFIRM, TRUE, 
				 0);

    panel_choix = window_create (frame_choix, PANEL, 
				 PANEL_LABEL_BOLD, TRUE,	    
				 PANEL_NOTIFY_STRING,"\r\t\n\03",
				 0);


    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	f_growy = (struct reg_grow *) (macro_cour->param);
    else f_growy = NULL;
    growy = f_growy;

    for (i = 0 ; i <= 7 ; i++)
	tol_item[i] = NULL ;

    stitre[0] = paneltabs[461];
    stitre[1] =paneltabs[462]; 
    stitre[2] = paneltabs[463];
    stitre[3] =paneltabs[464]; 

    if (methode == 1) /* croissance de region avec criteres */
    {
	panel_create_item (panel_choix,PANEL_MESSAGE,
			       PANEL_SHOW_ITEM,TRUE,
			       PANEL_LABEL_X,ATTR_COL(0),
			       PANEL_LABEL_Y,ATTR_ROW(0),
			       PANEL_LABEL_STRING,paneltabs[465],
				0);

	stitre[4] = paneltabs[466];
	stitre[5] = paneltabs[467];
	stitre[6] = paneltabs[468];
	stitre[7] =paneltabs[469]; 

	for (i = 0 ; i <= 3 ; i++)
	{	
	    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
		if ((growy != NULL) && (growy->choix == i)) 
		{
		    sprintf (rep, "%4.4f", growy->toler);
		    growy = growy->next_rg;
		}
		else strcpy (rep,"xxx");
	    else strcpy (rep,"xxx");

	    tol_item[i] = panel_create_item (panel_choix,PANEL_TEXT,
					 PANEL_SHOW_ITEM,TRUE,
					 PANEL_LABEL_X,ATTR_COL(0),
					 PANEL_LABEL_Y,ATTR_ROW(i+2),
					 PANEL_LABEL_STRING,stitre[i+4],
					 PANEL_NOTIFY_STRING,"\r\t\n\03",
			                 PANEL_VALUE_DISPLAY_LENGTH, 10, 
					 PANEL_VALUE, rep,
					 PANEL_NOTIFY_PROC,lire_choice,0);
	    /*if (growy != NULL) growy = growy->next_rg;*/
	}

    }
    else /* methode = 2 extraction de regions du graphe */
    {
	rg = f_rg;

	panel_create_item (panel_choix,PANEL_MESSAGE,
			       PANEL_SHOW_ITEM,TRUE,
			       PANEL_LABEL_X,ATTR_COL(0),
			       PANEL_LABEL_Y,ATTR_ROW(0),
			       PANEL_LABEL_STRING,paneltabs[470],
			    0);

	for(i = 0 ; i <= 3 ; i++)
	{
	    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
		if ((growy != NULL) && (growy->choix == i))
		{
		    sprintf (rep, "%4.4f", growy->toler);
		    growy = growy->next_rg;
		}
		else strcpy (rep,"xxx");
	    else strcpy (rep,"xxx");

	    tol_item[i] = panel_create_item (panel_choix,PANEL_TEXT,
					 PANEL_SHOW_ITEM,TRUE,
					 PANEL_LABEL_X,ATTR_COL(0),
					 PANEL_LABEL_Y,ATTR_ROW(i+2),
					 PANEL_LABEL_STRING,stitre[i],
					 PANEL_NOTIFY_STRING,"\r\t\n\03",
			                 PANEL_VALUE_DISPLAY_LENGTH, 10,
					 PANEL_VALUE, rep,
					 PANEL_NOTIFY_PROC,lire_choice,0);
	    /*if (growy != NULL) growy = growy->next_rg;*/    
	}
	ligne = 6 ;
	stitre[4] = paneltabs[471];
	stitre[5] = paneltabs[472];
	stitre[6] =paneltabs[473]; 
	stitre[7] =paneltabs[474];

	if (!flag_creer)
	{
	    i = 0;
	    while (rg != NULL)
	    {
	    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
		if (growy != NULL && growy->choix == i) 
		{
		    sprintf (rep, "%4.4f", growy->toler);
		    growy = growy->next_rg;
		}
		else strcpy (rep,"xxx");
	    else strcpy (rep,"xxx");

	    tol_item[rg->choix+4] = panel_create_item (panel_choix,PANEL_TEXT,
					 PANEL_SHOW_ITEM,TRUE,
					 PANEL_LABEL_X,ATTR_COL(0),
					 PANEL_LABEL_Y,ATTR_ROW(ligne),
					 PANEL_LABEL_STRING,
					 stitre[rg->choix + 4],
					 PANEL_NOTIFY_STRING,"\r\t\n\03",
			                 PANEL_VALUE_DISPLAY_LENGTH, 10,
					 PANEL_VALUE, rep,
					 PANEL_NOTIFY_PROC,lire_choice,0);
	    if (rg != NULL) rg = rg->next_rg ;	   
	    ligne++;
	    i ++;
	    /*if (growy != NULL) growy = growy->next_rg;*/
	    } /* while */ 
	} /* if not flag_creer */
	else
	{
	    for (i = 4; i <= 7; i ++)
	    {
		strcpy (rep, "xxx");

		tol_item[i] = panel_create_item (panel_choix,PANEL_TEXT,
					 PANEL_SHOW_ITEM,TRUE,
					 PANEL_LABEL_X,ATTR_COL(0),
					 PANEL_LABEL_Y,ATTR_ROW(ligne),
					 PANEL_LABEL_STRING,stitre[i],
					 PANEL_NOTIFY_STRING,"\r\t\n\03",
			                 PANEL_VALUE_DISPLAY_LENGTH, 10,
					 PANEL_VALUE, rep,
					 PANEL_NOTIFY_PROC,lire_choice,0);
		ligne++ ;
	    } /* for */
	} /* else */
		
    }

    window_fit (panel_choix);
    window_fit (frame_choix);
    window_set(panel_choix, WIN_CLIENT_DATA, 0, 0) ;
    window_set(panel_choix, PANEL_CARET_ITEM, tol_item[0],0) ;
    if ((flag_break) || window_loop (frame_choix) == NULL) return;

    f_growy = NULL;
    growy = f_growy;
    for (i = 0 ; i <= 7 ; i++)
    {
	if (tol_item[i] != NULL)
	{
	    chaine_item = (char *) panel_get_value(tol_item[i]) ;
	    if (*chaine_item != 'x')
	    {
		valeur = (float) atof (chaine_item) ;
	    	
		growy = (struct reg_grow *) calloc (1, sizeof (*growy));
		growy->choix = i;
		growy->toler = valeur;
		growy->next_rg = NULL;

		if (f_growy == NULL) 
		{
		    f_growy = growy;
		    o_growy = growy;
		}
		else 
		{
		    o_growy->next_rg = growy;
		    o_growy = growy;
		}
	    } /* if chaine_item <> x */
	}
    }	

    window_destroy (frame_choix);
    return (f_growy);

} /* grow_panel */

/************************************************************************/
/*									*/
/* Nom : creer_noeud							*/
/* Fonction : creation d'un nouveau noeud du graphe.			*/
/* Entree : int no, struct run *r, struct feat_list *p_f, float sx, sx2	*/
/* Global : -								*/
/* Routine : -								*/
/* Sortie : struct graph * gr						*/
/*								        */
/* Made by Christian GIRARD 21.2.1989					*/
/************************************************************************/

struct graph * creer_noeud (no, r, p_f, sx, sx2)		

int no;
struct run *r;
struct feat_list *p_f;
float sx, sx2;

{
    struct graph * p_g;
    
    p_g = (struct graph *) calloc (1,sizeof (* p_g));
    p_g->region = no;
    p_g->nbpix = r->end - r->start + 1;
    p_g->sx = sx;
    p_g->sx2 = sx2;
    p_g->first_gl = NULL;
    p_g->first_feat = p_f;
			/* on copie le "run" courant dans le nouveau noeud */
    p_g->first_run = (struct run *) calloc (1,sizeof( *r));
    p_g->first_run->no_region = r->no_region;
    p_g->first_run->start = r->start;
    p_g->first_run->end = r->end;
    p_g->first_run->line = r->line;
    p_g->first_run->next_run = NULL;
    return (p_g);
}

/********************************************************************/
/*								    */
/* Nom : bat_run						    */
/* Fonction : construction d'un run a partir d'une ligne de l'image */
/* on accepte un nouveau pixel dans le run sur la base de criteres  */
/* Entree : int no_reg, lin, max, type; int *col;		    */
/*	    float *sx, *sx2, *err				    */
/*          unsigned char *pict;				    */
/*	    struct reg_grow *f_rg;				    */
/*	    struct feat_list *p_f;				    */
/*	    float sx, sx2					    */
/* Global : -							    */
/* Routine : -							    */
/* Sortie : struct run *c_r; int *col;				    */
/*								    */
/* made by Christian Girard 4.9.1989				    */
/********************************************************************/

struct run *bat_run (no_reg, lin, col, max_col, pict, type, f_rg, p_f, sx, sx2)

int no_reg;					    /* nb de regions */
int lin;				       /* numero de la ligne */
int *col;				     /* numero de la colonne */
int max_col;				 /* nombre total de colonnes */
unsigned char *pict;		     /* ptr sur le point a segmenter */
int type;					  /* type de l'image */
struct reg_grow *f_rg;		    /* ptr sur la liste des criteres */
struct feat_list *p_f;		    /* ptr sur la premiere propriete */
float *sx;					 /* somme des pixels */
float *sx2;				/* somme des pixels au carre */

{		/* declaration des variables */
    short int *pict1;
    int *pict2, i, ok, n, passage, p_pass;
    float *pict3, ex2, ex, grey, var, val,err, s;
    struct run *r;
    struct reg_grow *rg, *o_rg;
    struct feat_list *fl, *o_fl;

		    /* code de bat_run */
    r = (struct run *) calloc (1, sizeof (*r));	 /* creation du run */
    r->no_region = no_reg;
    r->line = lin;
    r->start = *col;
    
    ok = 1;
    n = 1;				 /* nombre de points du run */
    passage = 0;
    p_pass = 0;				  /* pour la 1ere propriete */
    rg = f_rg;	   /* pointeur de travail sur la liste des criteres */
    o_rg = rg;

    switch (type)
    {
        case 1 : pict1 = (short int *) pict; break;
        case 2 : pict2 = (int *) pict; break;
        case 3 : pict3 = (float *) pict; break;
    } /* switch */
    
    while ((*col < max_col) && (ok == 1))     /* boucle sur la ligne */
    {
				/* parcours de la liste des criteres */
	while ((rg != NULL) && (ok == 1))
	{
	    if (passage == 0)
	    {
		if (p_pass != 0)
		{
		    fl = (struct feat_list *) calloc (1, sizeof(*fl));
		    o_fl->next_f = fl;
		}
		else
		{
		    fl = p_f;
		    p_pass = 1;
		}
		fl->next_f = NULL;
		o_fl = fl;
	    } /* if */

	    switch (rg->choix)
	    {
		case 0 : if (passage == 0)		    /* esperance */
			 {
			    switch (type)
			    {
				case 0 : grey = (float) *pict;
					 break;
				case 1 : grey = (float) *pict1;
					 break;
				case 2 : grey = (float) *pict2;
					 break;
				case 3 : grey = *pict3;
					 break;
			    } /* switch type */
			 } /* passage = 0 */

			 else 
			 {
			    switch (type)
			    {
				case 0 : if (fabs (fl->feature - (float) *pict)
								  <= rg->toler)
					    grey = (float) *pict;
					 else ok = 0;
					 break;
				case 1 : if (fabs (fl->feature - (float)*pict1)
								  <= rg->toler)
					    grey = (float) *pict1;
					 else ok = 0;
					 break;
				case 2 : if (fabs (fl->feature - (float)*pict2)
								  <= rg->toler)
					    grey = (float) *pict2;
					 else ok = 0;
					 break;
				case 3 : if (fabs (fl->feature - *pict3) <= 
								    rg->toler)
					    grey = *pict3;
					 else ok = 0;
					 break;
			    } /* switch type */

 			 } /* passage <> 0 */
			 break; /* case 0 esperance */

		case 1 : switch (type)			/* esperance-2 */
			 {
			    case 0 : grey = (float) *pict; break;
			    case 1 : grey = (float) *pict1; break;
			    case 2 : grey = (float) *pict2; break;
			    case 3 : grey = *pict3; break;
			 } /* switch */
			
			 if (passage == 0) ex = grey;
			 else
			 {
			     ex = (((float) (n - 1) * fl->feature) + grey) /
								    (float) n;
			     if (fabs (fl->feature - grey) > rg->toler) ok = 0;

			 } /* passage <> 0 */
			 break; /* esperance-2 */

		case 2 : if (passage == 0)			/* variance */
			 {
			     switch (type)
			     {
				 case 0 : *sx = (float) *pict;
					  break;
				 case 1 : *sx = (float) *pict1;
					  break;
				 case 2 : *sx = (float) *pict2;
					  break;
				 case 3 : *sx = *pict3;
					  break;
			     } /* switch type */

			     *sx2 = *sx * (*sx);
			     ex = *sx;
			     ex2 = *sx2;
			     var = ex2 - (ex * ex);

			 } /* passage = 0 */

			 else 
			 {
			     switch (type)
			     {
				 case 0: *sx + = (float) *pict;
					 *sx2 + = (float) (*pict * (*pict));
					 break;
				 case 1: *sx + = (float) *pict1;
					 *sx2 + = (float) (*pict1 * (*pict1));
					 break;
				 case 2: *sx + = (float) *pict2;
					 *sx2 + = (float) (*pict2 * (*pict2));
					 break;
				 case 3: *sx + = *pict3;
					 *sx2 + = *pict3 * (*pict3);
					 break;
			     } /* switch type */

			     ex = (float) (*sx / (float) n);
			     ex2 = (float) (*sx2 / (float) n);
			     var = (float) (ex2 - (ex * ex));
			     if (fabs (var - fl->feature) > rg->toler) ok = 0;

			 } /* passage <> 0 */
			 break; /* variance */

		case 3 : if (passage == 0)		/* erreur moyenne */
			 {
			     err = 0.0;
			     s = 0.0;
			 } /* passage = 0 */

			 else
			 {
			     switch (type)
			     {
				 case 0 : val = (float) *pict;
					  for (i = 1; i < n; i ++)
					  {
					      pict --;
					      s+ = fabs((float)*pict - val);
					  }
					  pict + = n - 1;
					  break;
				 case 1 : val = (float) *pict1;
					  for (i = 1; i < n; i ++)
					  {
					      pict1 --;
					      s+ = fabs((float)*pict1 -val);
					  }
					  pict1 + = n - 1;
					  break;
				 case 2 : val = (float) *pict2;
					  for (i = 1; i < n; i ++)
					  {
					      pict2 --;
					      s+ = fabs((float)*pict2 -val);
					  }
					  pict2 + = n - 1;
					  break;
				 case 3 : val = *pict3;
					  for (i = 1; i < n; i ++)
					  {
					      pict3 --;
					      s+ = fabs(*pict3 - val);
					  }
					  pict3 + = n - 1;
					  break;
			     } /* switch type */

			     err = s / (float) ((2 * n) - 1);
			     if (err > rg->toler) ok = 0;

			 } /* passage <> 0 */
			 break; /* erreur moyenne */

	    } /* switch rg->choix */

	    o_rg = rg;
	    rg = rg->next_rg;
	    if (rg != NULL) fl = fl->next_f;

	} /* parcours de la liste des criteres */

	if (ok == 1)
	{
	    passage = 1;

	    rg = f_rg;
	    fl = p_f;
	    
	    while (rg != NULL)
	    {
		switch (rg->choix)	    /* stockage des new features */
		{
		    case 0 : fl->feature = (((float)(n - 1) * fl->feature) + 
							    grey) / (float) n;
			     break;
		    case 1 : fl->feature = ex;
			     break;
		    case 2 : fl->feature = var;
			     break;
		    case 3 : fl->feature = err;
			     break;
		} /* switch */
		
		rg = rg->next_rg;
		fl = fl->next_f;
	    } /* while */

	    rg = f_rg;
	    fl = p_f;

	    n ++;
	    (*col) ++;
	    switch (type)
	    {
		case 0 : pict ++; break;
		case 1 : pict1 ++; break;
		case 2 : pict2 ++; break;
		case 3 : pict3 ++; break;
	    }

	} /* if ok = 1 */
	else /* ok = 0 */
	{
	    rg = f_rg;
	    fl = p_f;

	    while (rg != NULL)
	    {
		if (rg->choix == 2)
		{
		    switch (type)
		    {
			case 0 : *sx - = (float) *pict;
				 *sx2 - = (float) *pict * (float)*pict;
				 break;
			case 1 : *sx - = (float) *pict1; 
				 *sx2 - = (float) *pict1 * (float)*pict1;
				 break;
			case 2 : *sx - = (float) *pict2; 
				 *sx2 - = (float) *pict2 * (float)*pict2;
				 break;
			case 3 : *sx - = *pict3;
				 *sx2 - = *pict3 * (*pict3);
				 break;
		    } /* switch */
		} /* if */

		rg = rg->next_rg;
		fl = fl->next_f;

	    } /* while rg <> NULL */
	} /* else ok = 0 */

    } /* while boucle sur la ligne */

    r->end = *col - 1;
    return (r);
    
} /* bat_run */

/********************************************************************/
/*								    */
/* Nom : node_vois						    */
/* Fonction : cree le lien entre un noeud et son voisin sur la meme */
/* ligne de l'image						    */
/* Entree : struct graph *vois : ptr sur le noeud voisin	    */
/*	    struct graph_list *w_g_l : element suivant de la liste  */
/*				       des voisins		    */
/* Global : -							    */
/* Sortie : g_l : ptr sur la liste des voisins modifiee		    */
/*								    */
/* Made by Christian GIRARD 28.11.1989				    */
/********************************************************************/

struct graph_list * node_vois (vois, w_g_l)

struct graph *vois;
struct graph_list *w_g_l;

{		    /* declaration des variables */
    struct graph_list *g_l;

		    /* code de la routine node_vois */
    g_l = (struct graph_list *) calloc (1,sizeof (*g_l));
    g_l->g_vois = vois;
    g_l->next_gl = w_g_l;

    return (g_l);
} /* node_vois */

/********************************************************************/
/*								    */
/* Nom : cmp_prop						    */
/* Fonction : comparer les listes de proprietes de deux noeuds afin */
/* de determiner si leurs proprietes sont suffisammnent similaires  */
/* selon la liste des criteres definis pour pouvoir fusionner les   */
/* deux noeuds							    */
/* Entree : struct feat_list *c_fl : prop. du new noeud		    */
/*	    struct feat_list *l_fl : prop. du noeud de la ligne prec*/
/*	    struct reg_grow *rg : ptr sur liste des criteres	    */
/*	    int c_pix : nb de pixel du new noeud		    */
/*	    int l_pix : nb de pixel du noeud de la ligne precedente */
/*	    int cas : cas de fusion courant			    */
/* Global : -							    */
/* Routine : -							    */
/* Sortie : int flag : booleen indiquant si prop assez proches	    */
/*								    */
/* Made by Christian GIRARD 28.11.1989				    */
/********************************************************************/

int cmp_prop (c_fl, l_fl, rg, c_pix, l_pix, cas)

struct feat_list *c_fl, *l_fl;
struct reg_grow *rg;
int c_pix, l_pix, cas;

{		    /* declaration des variables */
    int flag;

		    /* code de la routine cmp_prop */
    flag = 1;
						 /* parcours des criteres */
    while ((flag == 1) && (rg != NULL))
    {
	switch (rg->choix)
	{	
						    /* critere = esperance */
	    case 0 : if (fabs (c_fl->feature - l_fl->feature) > rg->toler)
		     flag = 0;					 /* FALSE */
				     break;

						 /* critere = esperance_2 */
	    case 1 : if (cas < 2)
		     {
			 if (fabs (((((float) c_pix * c_fl->feature) +
				     ((float) l_pix * l_fl->feature)) /
				      (float) (c_pix + l_pix)) -
				      l_fl->feature) > rg->toler) 
					    flag = 0;
		    }
		    else
		    {
			if (fabs (((((float) c_pix * c_fl->feature) +
				     ((float) l_pix * l_fl->feature)) /
				    (float) (c_pix + l_pix)) -c_fl->feature) >
								    rg->toler)
					 flag = 0;	 
		    }
		    break;

						     /* critere = variance */
	    case 2: if (fabs (c_fl->feature - l_fl->feature) > rg->toler)
			flag = 0;				  /* FALSE */
		    break;

						/* critere = erreur moyenne */
	    case 3 : if ((((float) c_pix * c_fl->feature) +
			  ((float) l_pix * l_fl->feature)) /
			 (float)(c_pix + l_pix) > rg->toler)
				flag = 0;			   /* FALSE */
				     break;

	} /* switch rg->choix */

	rg = rg->next_rg;		       /* passage au critere suivant */
	c_fl = c_fl->next_f;			       /* propriete suivante */
	l_fl = l_fl->next_f;			       /* propriete suivante */

    } /* while parcours des criteres */
		    
    return (flag);			    /* 1 si assez semblable 0 sinon */

} /* cmp_prop */

/********************************************************************/
/*								    */
/* Nom : fus_run						    */
/* Fonction : fusionne deux "runs" lors de l'affectation de la liste*/
/* de "run" d'un noeud a un autre lors de la fusion de deux noeuds  */
/* si les deux "runs" sont adjacents sur une meme ligne		    */
/* Entree : struct run *fnr : ptr sur debut de liste du noeud	    */
/*	    fusionneur						    */
/*	    struct run *or : ptr sur le "run" susceptible de fusion */
/* Global : -							    */
/* Routine : -							    */
/* Sortie : int fusion : y a-t-il eu fusion ou pas ?		    */
/*								    */
/* Made by Christian GIRARD 1.12.1989				    */
/********************************************************************/

int fus_run (fnr, or)

struct run *fnr, *or;

{
    struct run *nr;
    int fusion;

    fusion = 0;
    nr = fnr;
    
    while (nr != NULL)
    {
	if (nr->line == or->line)
	{
	    if (nr->start <= or->end + 1 && nr->start >= or->start)
	    {
		nr->start = or->start;
		fusion = 1;
	    }
	    if (nr->end >= or->start - 1 && nr->end <= or->end)
	    {
		nr->end = or->end;
		fusion = 1;
	    }
	}
	nr = nr->next_run;
    } /* while */

    return (fusion);

} /* fus_run */

/********************************************************************/
/*								    */
/* Nom : affecte_list_run					    */
/* Fonction : affecte la liste de "run" du noeud fusionne au noeud  */
/* fusionneur							    */
/* Entree : struct run *f_nr : liste de "run" du noeud fusionneur   */
/*	    struct run *f_or : liste de "run" a reaffecter	    */
/*	    struct run *temp : pour elim petites regions	    */
/*	    int meth : point d'appel de la routine (bat_graph /     */
/* graph_image) afin de savoir si fusion des "runs" ou pas	    */
/* Global : -							    */
/* Routine : fus_run						    */
/* Sortie : struct graph *g					    */
/*								    */
/* made by Christian Girard 22.2.1989				    */
/********************************************************************/

struct run * affecte_list_run (f_nr, f_or, temp, meth)

struct run *f_nr;    /* pointeur sur la liste du  noeud qui restera */
struct run *f_or;    /* pointeur sur la liste de "run" a reaffecter */
struct run *temp;
int *meth;		 /* 0 = bat_graph, 1 = elim petites regions */

{
    struct run *wfnr, *wr1, *wr2, *wr3;
    int fusion = 0, flag = 0;

    wfnr = f_nr;

    wr1 = f_or;
    wr2 = wr1;
    while (wr1 != NULL)
    {
	if (*meth == 1) fusion = fus_run (f_nr, wr1);/* elimination regions */
	if (fusion == 1)		   /* "run" a eliminer car fusionne */
	{
	    if (wr1 == wr2)			    /* tete de liste */
	    {
		wr3 = f_or;
		f_or = wr1->next_run;
		wr1 = f_or;
		wr2 = wr1;
		flag = 1;
		if (f_or == NULL) flag = 2;
		else *temp = *f_or;
	    }
	    else
	    {
		wr3 = wr1;
		wr2->next_run = wr1->next_run;
		wr1 = wr1->next_run;
		cfree (wr3);
	    }
	}
	else	/* noeud ne fusionne pas => mettre a jour et suivant */
	{
	    wr1->node = f_nr->node;
	    wr1->no_region = f_nr->no_region;
	    wr2 = wr1;
	    wr1 = wr1->next_run;
	}
    } /* while */

    if (f_or != NULL)
    {
        f_nr = f_or;
	wr2->next_run = wfnr;
    }

    *meth = flag;

    return (f_nr);
} /* affecte_list_run */

/********************************************************************/
/*								    */
/* Nom : affecte_graph_list					    */
/* Fonction : affecte un voisin du noeud a merger au noeud mergeur  */
/* Entree : struct graph_list *w_g_l, *m_w_g_l			    */
/* Global : -							    */
/* Routine : -							    */
/* Sortie : struct graph_list *w_g_l, *w_g_l1			    */
/*								    */
/* made by Christian Girard 22.2.1989				    */
/********************************************************************/

struct graph_list * affecte_graph_list (w_g_l, m_w_g_l)

struct graph_list *w_g_l;		    /* liste du noeud merged */
struct graph_list *m_w_g_l;		     /* liste a augmenter */

{
    struct graph_list *w_g_l1,		/* ptr sur liste a completer */
		      *w_g_l2, /* ptr sur l'element precedent w_g_l1 */
		      *w_g_l3;		 /* nouvel element (rajoute) */

    w_g_l1 = m_w_g_l;
    w_g_l2 = w_g_l1;
/* regarde si le voisin fait deja partie de la liste du new noeud */
    while ((w_g_l1 != NULL) && (w_g_l->g_vois != w_g_l1->g_vois))
    {
	w_g_l2 = w_g_l1;
	w_g_l1 = w_g_l1->next_gl;
    }
    if (w_g_l1 == NULL)		 /* noeud a ajouter dans la liste */
    {
	w_g_l3 = (struct graph_list *) calloc (1, sizeof (*w_g_l3));
	w_g_l3->g_vois = w_g_l->g_vois;
	w_g_l3->next_gl = NULL;
	w_g_l1 = w_g_l3;
	if (w_g_l2 != NULL)
	    w_g_l2->next_gl = w_g_l1;
	else m_w_g_l = w_g_l1;
    }
    return (m_w_g_l);
} /* affecte_graph_list */

/************************************************************************/
/*									*/
/* Nom : verif_old_lien							*/
/* Fonction : Detruire le lien vers le noeud fusionne chez les voisins	*/
/* dudit noeud.								*/
/* Entree : struct graph_list *g_l, struct graph *g			*/
/* Global : -								*/
/* Routine : -								*/
/* Sortie : struct graph_list *g_l					*/
/*									*/
/* Made by Christian GIRARD 22.3.1989					*/
/************************************************************************/

struct graph_list * verif_old_lien (gl, g)

struct graph_list *gl;	   /* ptr sur liste des voisins du noeud a fusionner */
struct graph *g;				/* ptr sur noeud a fusionner */

{	    /* ptr sur la liste des voisins d'un voisin du noeud a fusionner */
    struct graph_list *gl1,
		      *gl2;			    /* element precedent gl1 */

	 /* destruction du lien vers le noeud "merge" chez les voisins */ 
    gl1 = gl->g_vois->first_gl;
    gl2 = gl1;
    while ((gl1 != NULL) && (gl1->g_vois != g))
    {
	gl2 = gl1;
	gl1 = gl1->next_gl;
    } /* while */
    if (gl1 != NULL)
    {
	if (gl2 != gl1) /* si ne pointe pas sur 1er element de la liste */
	{
	    gl2->next_gl = gl1->next_gl;
	}
	else gl->g_vois->first_gl = gl1->next_gl;
	cfree (gl1);
    } /* if */
    return (gl);
} /* verif_old_lien */

/************************************************************************/
/*									*/
/* Nom : verif_new_lien							*/
/* Fonction : Verifie si le lien vers le nouveau noeud n'existe pas deja*/
/* si il n'existe pas, le cree.						*/
/* Entree : struct graph_list *g_l, struct graph *g			*/
/* Global : -								*/
/* Routine : -								*/
/* Sortie : struct graph_list *w_g_l					*/
/*									*/
/* Made by Christian GIRARD 22.3.1989					*/
/************************************************************************/

struct graph_list * verif_new_lien (gl, g)

struct graph_list *gl;	     /* liste des voisins du noeud a fusionner */
struct graph *g;			/* ptr sur le noeud fusionneur */

{	 /* ptr sur liste des voisins d'un voisin du noeud a fusionner */
    struct graph_list *gl1;

    gl1 = gl->g_vois->first_gl;
    while ((gl1 != NULL) && (gl1->g_vois != g))
    {
	gl1 = gl1->next_gl;
    }
    if (gl1 == NULL)	/* noeud "mergeur" pas rencontre => a ajouter */
    {
	gl1 = (struct graph_list *) calloc (1,sizeof (*gl1));
	gl1->g_vois = g;
	gl1->next_gl = gl->g_vois->first_gl;
	gl->g_vois->first_gl = gl1;
    }
    return (gl);
} /* verif_new_lien */

/************************************************************************/
/*									*/
/* Nom : maj_prop							*/
/* Fonction : mise a jour de la liste de propriete d'un noeud du graphe */
/* lors du merging de deux noeuds					*/
/* Entree : struct reg_grow *f_rg; struct graph *n_g, *m_g		*/
/* Global : -								*/
/* Routine : -								*/
/* Sortie : struct graph *n_g						*/
/*									*/
/* Made by Christian GIRARD 6.9.1989					*/
/************************************************************************/

struct graph *maj_prop (f_rg, n_g, m_g)

struct reg_grow *f_rg;		       /* ptr sur la liste des criteres */
struct graph *n_g, *m_g;		    /* new graph - merged graph */

{
    float n, m, ex;
    struct reg_grow *rg;       /* ptr de travail sur liste des criteres */
    struct feat_list *n_fl, *m_fl;     /* ptrs sur liste des proprietes */

    rg = f_rg;
    n = (float) n_g->nbpix;
    m = (float) m_g->nbpix;
    n_fl = n_g->first_feat;
    m_fl = m_g->first_feat;

    while (rg != NULL)		    /* parcours de la liste des criteres */
    {
	switch(rg->choix)
	{
	    case 0 :
	    case 1 : n_fl->feature = ((n * n_fl->feature)+(m * m_fl->feature))
				     / (n + m);
		     break;
	    case 2 : ex = (m_g->sx + n_g->sx) / (n + m);
		     ex = ex * ex;
		     n_g->sx + = m_g->sx;
		     n_fl->feature = ((m_g->sx2 + n_g->sx2) / (n + m)) - ex;
		     n_g->sx2 + = m_g->sx2;
		     break;
	    case 3 : n_fl->feature = ((n * n_fl->feature)+(m * m_fl->feature))
				     / (n + m);
		     break;
	} /* switch */
	
	rg = rg->next_rg;			    /* critere suivant */
	n_fl = n_fl->next_f;
	m_fl = m_fl->next_f;

    } /* while parcours de la liste des criteres */

    return (n_g);
} /* maj_prop */

/************************************************************************/
/*									*/
/* Nom : maj_run							*/
/* Fonction : mise a jour des numeros et pointeurs sur le noeud des runs*/
/* de la ligne courante ou precedente dans le cas de fusion numero 3	*/
/* Entree : struct run *r : ptr sur le noeud a verifier			*/
/*	    struct run *borne : ptr a atteindre				*/
/*	    struct graph *g : nouveau ptr = a mettre a jour chez le run */
/*	    int reg : ancien no de run = a changer			*/
/* Global : -								*/
/* Routine : -								*/
/* Sortie : -								*/
/*									*/
/* Made by Christian GIRARD 28.11.1989					*/
/************************************************************************/

maj_run (r, borne, g, reg)

struct run *r, *borne;
struct graph *g;
int reg;

{			
    while (r != borne)
    {
        if (r->no_region == reg)
        {
	    r->node = g;
	    r->no_region = g->region;
	}
        r = r->next_run;
    } /* while */

} /* maj_run */

/************************************************************************/
/*									*/
/* Nom : bat_graph							*/
/* Fonction : Construction du graphe associe a une image segmentee par  */
/* une des methode de seuillage. Agit selon une methode de recherche de */
/* region ligne par ligne, chaque region etant stockee sous forme de    */
/* "run".								*/
/* Entree : unsigned char *plan : ptr sur l'image			*/
/*	    struct reg_grow *f_rg : ptr sur liste des criteres		*/
/* Global : int taille, n_line, n_col, mmin, mmax (stat de l'image)	*/
/*		tot_region, meth;					*/
/*	    struct graph *f_g; (ptr sur le graphe)			*/
/* Routines : creer_noeud, bat_run, affecte_graph_list, affecte_list_run*/
/*	      verif_old_lien, verif_new_lien, maj_prop, node_vois	*/
/*	      cmp_prop, maj_run						*/
/* Sortie : struct graph *first_gr : ptr sur le 1er ele du graphe	*/
/*								        */
/* Made by Christian GIRARD 21.2.1989					*/
/************************************************************************/

struct graph * bat_graph (plan, f_rg)

unsigned char * plan;		    /* pointeur sur le debut de l'image */
struct reg_grow * f_rg;		  /* pointeur sur la liste des criteres */ 

{
/* declaration des variables */

    struct run *curr_run, *old_run, *c_r, *first_curr_run;/* ligne courante */
    struct run *ll_run, *l_r, *first_ll_run, *tmp;	/* ligne precedente */
    struct graph *w_gr, *old_gr, *first_gr;
    struct graph_list *g_l, *w_g_l, *f_g_l, *w_g_l1, *w_g_l2, *w_g_l3, *w_g_l4;
    struct reg_grow *rg;
    struct feat_list *c_fl, *l_fl, *fl;
    unsigned char *im0;
    short int *im1;
    float *im3, 
	  sx, sx2;			/* somme des "x" et des "x" carres */
    int *im2,
	type, col, curr_region, i, cas, meth,
	flag_f, pass, flag_crit;			   /* des booleens */
    
/* corps de bat_graph */
							/* initialisations */
    type = dir_desc[index_image[0]].type;
    first_gr = NULL;
    tot_region = 0;
    curr_region = 0;
    cline = 0;
    tmp = (struct run *) calloc (1, sizeof (*tmp));/* for affecte_list_run */

    switch (type)			/* ptr sur l'image selon son type */
	{
	    case -1 : 
	    case 0 : im0 = plan;
		     break;
	    case 1 : im1 = (short int *) plan;
		     break;
	    case 2 : im2 = (int *) plan;
		     break;
	    case 3 : im3 = (float *) plan;
		     break;
	}


    while (cline < n_line)		/* boucle sur les lignes de l'image */
    {
	old_run = NULL;
	col = 0;


	while (col < n_col)	      /* boucle sur les colonnes de l'image */
	{
	    sx = 0.0;			      /* somme des "x" d'une region */
	    sx2 = 0.0;			/* somme des "x" carre d'une region */

	 /* on alloue de la place pour la liste des proprietes du new "run" */
	    fl = (struct feat_list *) calloc (1, sizeof (*fl));

	    switch (type)
	    {
		case 1: im0 = (unsigned char *) im1; break;
		case 2: im0 = (unsigned char *) im2; break;
		case 3: im0 = (unsigned char *) im3; break;
	    } /* switch */
					    /* creation d'un nouveau "run" */
	    curr_run = bat_run (++curr_region, cline, &col, n_col, im0, type, 
							f_rg, fl, &sx, &sx2);

	    i = curr_run->start;	/* deplacement du ptr sur l'image */
	    while (i < col)
	    {
		switch (type)
		{
		    case 0 : im0++; break;
		    case 1 : im1++; break;
		    case 2 : im2++; break;
		    case 3 : im3++; break;
		}
		i ++;
	    }

	    tot_region ++;  /* on incremente le nombre total de regions */

			      /* on attache le nouveau "run" a sa place */
	    if (curr_run->start == 0)		    /* si premier "run" */
		first_curr_run = curr_run;
	       else
		old_run->next_run = curr_run;

					  /* creation du nouveau noeud */
	    w_gr = creer_noeud (curr_region, curr_run, fl, sx, sx2);

			    /* on attache le nouveau noeud a sa place */
	    if (first_gr == NULL)         
		first_gr = w_gr;
	    else
	    {
		if (curr_run->start != 0)
                {    
    /* on attache le nouveau noeud a l'ancien (voisinage sur la meme ligne) */
		    w_g_l = NULL;
		    w_gr->first_gl = node_vois (old_gr, w_g_l);
				    /* on attache l'ancien noeud au nouveau */
		    w_g_l = old_gr->first_gl;
		    old_gr->first_gl = node_vois (w_gr, w_g_l);
		}
	    } /* first_gr <> NULL */

	    curr_run->node = w_gr;	    /* on attache le "run" au noeud */
	    w_gr->first_run->node = w_gr;

		/* si pas premiere ligne => possibilite de fusion verticale */
	    if (cline != 0)			   
	    {
		cas = 1;		/* initialisation du cas rencontre */

		f_g_l = NULL; /* tete de liste (non_rattachee) des voisins */
		pass = 1;

	     /* comparaison du new "run" avec celui de la ligne precedente */
		while ((ll_run != NULL) && (ll_run->start <= curr_run->end) &&
		       (pass == 1))
		{

		    c_fl = w_gr->first_feat;   /* proprietes du noeud new */
		    l_fl = ll_run->node->first_feat;
		    rg = f_rg;		    /* ptr sur liste des criteres */
		    flag_crit = 1;				  /* TRUE */

/* comparaison des proprietess du nouveau noeud et de celles du noeud de la */
/* ligne precedente afin de savoir si l'on doit fusionner les deux noeuds */ 
/* ou pas. La comparaison s'effectue sur la base de la liste des criteres */
/* choisis par l'utilisateur */
		    flag_crit = cmp_prop (c_fl, l_fl, f_rg, w_gr->nbpix, 
						ll_run->node->nbpix, cas);

		    if (flag_crit == 0)		    /* cas 1 pas de fusion */
		    {		  /* on garde le futur voisin ds une liste */
			f_g_l = node_vois (ll_run->node, f_g_l);
		    } /* if cas 1 */

		    else			    /* noeuds fusionnent */
		    {
			if (cas < 3) cas ++;

			if (curr_run->no_region != ll_run->no_region)
			{				      /* cas 2 & 3 */

			    tot_region --;/* ajuste le nb total de regions */


    /* cas 2 => nouvelle region fusionne avec celle de la ligne precedente */
			    if (cas == 2)
			    {
				/* mise a jour de la liste des proprietes */
				ll_run->node = maj_prop (f_rg, ll_run->node,
									 w_gr);

				ll_run->node->nbpix + = w_gr->nbpix;

				w_g_l = w_gr->first_gl; /*vois reg fusionnee */
		    /* parcours de la liste des voisins du noeud a fusionner */
				while (w_g_l != NULL)
				{      /* liste des vois du noeud fusionneur */
				    w_g_l1 = ll_run->node->first_gl; 
				    ll_run->node->first_gl = affecte_graph_list
							       (w_g_l, w_g_l1);
				    w_g_l = verif_old_lien (w_g_l, w_gr);
				    w_g_l = verif_new_lien (w_g_l, ll_run->node);
				    w_g_l = w_g_l->next_gl;
				} /* while */

				curr_run->no_region = ll_run->no_region;
				w_gr = ll_run->node;

				meth = 0;	    /* pour affecte_list_run */
				w_gr->first_run = affecte_list_run 
							    (w_gr->first_run,
						    curr_run->node->first_run, 
								tmp, &meth);
				curr_run->node = w_gr;
			    } /* if cas = 2 */


    /* cas 3 => region de la ligne precedente fusionne avec la nouvelle */
			    else /* cas = 3 */
			    {
				  /* mise a jour de la liste des proprietes */
				w_gr = maj_prop (f_rg, w_gr, ll_run->node);

				w_gr->nbpix + = ll_run->node->nbpix;

				  /* liste des voisins de l'ancienne region */
				w_g_l = ll_run->node->first_gl; 
 
	/* parcours de la liste des voisins du noeud de la ligne precedente */
				while (w_g_l != NULL)
				{
				    flag_f = 0;

				      /* liste des voisins du nouveau noeud */
				    w_g_l1 = w_gr->first_gl; 

				    w_gr->first_gl = affecte_graph_list (w_g_l,
								       w_g_l1);

				    w_g_l = verif_old_lien (w_g_l, ll_run->node);
				    w_g_l = verif_new_lien (w_g_l, w_gr);

				    w_g_l = w_g_l->next_gl;
				} /* while */

		     /* mise a jour du no de "run" de la curr_line de "run" */
				maj_run (first_curr_run, curr_run, w_gr,
							ll_run->no_region);
				
		    /* mise a jour du no de "run" de la "last line" de "run" */
				maj_run (ll_run->next_run, NULL, w_gr,
							ll_run->no_region);

				ll_run->no_region = curr_run->no_region;
				meth = 0;/* pour affecte_list_run */
				w_gr->first_run = affecte_list_run (
					    w_gr->first_run, 
					    ll_run->node->first_run, tmp, 
					    &meth);

				ll_run->node = w_gr;
			    } /* else cas 3 */

			} /* if  no_region non-identiques (cas 2 & 3)*/

		    } /* else  features identiques => fusion */


/* va-t-on envisager le run suivant de la ligne precedente pour une fusion ? */
		    if (ll_run->end >= curr_run->end) pass = 0;
		    if (ll_run->end <= curr_run->end)
			ll_run = ll_run->next_run; /* passe au "run" suivant */

		} /* while ll_run.start <= curr_run.end */


   /* apres l'examen du "run" : mise en place des voisins trouves par cas 1 */
	        if (f_g_l != NULL)
		{     /* ptr de travail pour parcours de la liste a ajouter */
		    w_g_l = f_g_l;

		    while (w_g_l != NULL)
		    {
			    /* ptr sur la liste de voisin du nouveau noeud */
		        w_g_l1 = w_gr->first_gl;
/*if (w_gr->region == 1709)
    printf ("alerte !");*/

		        w_gr->first_gl = affecte_graph_list (w_g_l, w_g_l1);

	    /* on complete egalement la liste des voisins de l'autre noeud */
			w_g_l3 = w_g_l->g_vois->first_gl;

		        w_g_l4 =(struct graph_list *)calloc(1,sizeof(*w_g_l4));
		        w_g_l4->g_vois = w_gr;
		        w_g_l4->next_gl = NULL;

		        w_g_l->g_vois->first_gl = affecte_graph_list (w_g_l4, 
								      w_g_l3);
			w_g_l = w_g_l->next_gl;

		    } /* while */

		} /* if  f_g_l != NULL fin de mise en place des voisins*/

	    } /* if cline <> 0 (fusion a envisager) */

	    old_run = curr_run;		    /* pour passer au "run" suivant */
	    old_gr = w_gr;

	} /* while col < n_col (boucle sur les colonnes) */

	first_ll_run = first_curr_run;	   /* on passe a la ligne suivante */
	ll_run = first_ll_run;
	cline ++;

    } /* while line < nb line (boucle sur les lignes) */

    sprintf (buf, mastertabs[250],
    tot_region);
    write_master (buf);

    return (first_gr);			/* ptr sur le 1er element du graphe */
} /* bat_graph */

/********************************************************************/
/*								    */
/* Nom : ecrire_noeud						    */
/* Fonction : Ecrire un noeud du graph dans l'image resultat	    */
/* Entree : struct run *r, int color, n_col, type		    */
/*	    unsigned char *im					    */
/* Global : -							    */
/* Routine : -							    */
/* Sortie : -							    */
/*								    */
/* made by Christian Girard 22.2.1989 modified 11.10.1989	    */
/********************************************************************/

ecrire_noeud (r, color, n_col, type, im)

struct run *r;					   /* run de depart */
int color;				    /* couleur de la region */
int n_col;			   /* nombre de colonnes de l'image */
int type;					 /* type de l'image */
unsigned char *im;		   /* pointeur sur l'image pos cour */

{   /* declaration des variables */
    int *wim2;
    int pos, depl;
    float *wim3;
    struct run *w_r;
    
    /* code de ecrire_noeud */
    w_r = r;

    while (w_r != NULL)	    /* parcours de la liste des "run" */
    {			      /* position reelle dans l'image */
	pos = (n_col * w_r->line) + w_r->start;
    
        switch (type)	      /* deplacement au debut du "run" dans l'image */
        {
	    case 2 : wim2 = (int *) im;
		     wim2 + = pos;
		     break;
	    case 3 : wim3 = (float *) im;
		     wim3 + = pos;
		     break;
	}

        depl = w_r->end - w_r->start + 1;     
        while (depl > 0)			   /* on ecrit dans l'image */
        {
	    switch (type)
	    {
	        case 2 : * wim2 = color;
			 wim2 ++;
			 break; 
		case 3 : * wim3 = (float) color;
		         wim3 ++;
		         break;  
	    }
	    depl --;
        } /* while */
        w_r = w_r->next_run;	    
    } /* while w_r <> NULL */

} /* ecrire_noeud */

/********************************************************************/
/*								    */
/* Nom : graph_image						    */
/* Fonction : Passer de la representation par graphe d'une image    */
/* a l'image elle_meme						    */
/* Entree : int type, mode, struct reg_grow *f_c		    */
/* Global : int taille, n_line, n_col, meth			    */
/* Routine : ecrire_noeud, maj_prop, affecte_graph_list, 	    */
/*	     verif_old_lien, verif_new_lien, affecte_list_run	    */
/* Sortie : -							    */
/*								    */
/* made by Christian Girard 22.2.1989				    */
/********************************************************************/

graph_image (type, mode, f_c)

int type;				      /* type de l'image a recreer */
int mode;   /* mode de passage 1=tous les noeuds, 2=extraction de criteres */
				      /* 3=elimination des petites regions */
struct reg_grow *f_c;			     /* criteres pour l'extraction */

{
    struct list_BFS
    {
	struct graph *g;		/* pointeur sur un noeud du graphe */
	struct list_BFS *next_BFS;
    };

/* Declaration des variables */

    struct list_BFS *f_l1, *w_l, *w_l1, *w_l11;	    /* ptr sur 1ere liste */
    struct list_BFS *f_l2,*w_l2, *w_l21, *l_l2;	    /* ptr sur 2eme liste */
    int	pts[4], i, color,    /* pour l'ecriture des niv gris dans l'image */
        nb_feat,      /* nombre de proprietes pour eciture des grey level */
	flag_c, counter, meth,
	used;		       /* savoir si il y a region extraite ou pas */
    struct feat_list *fl;
    struct graph_list *g_l, *gl, *wgl, *wgl1, *grand;
    struct run * w_r, *tmp;
    struct reg_grow *grow;
    struct graph *n_node, *c_node;    /* pour elimination petites regions */
    int * pict2, *wim2;				      /* ptrs sur l'image */
    float * pict3, *wim3, 
	  percent;   /* pourcentage d'err. sur propriete pour extraction */

/* corps de la routine graph_image */

    nb_feat = 0;		/* comptage du nombre de proprietes du graph */
    fl = f_g->first_feat;
    while (fl != NULL)
    {
	nb_feat ++;
	fl = fl->next_f;
    } /* while */

    if (nb_feat > 1)			    /* initialisation de la couleur */
    {
	i = 0;
	pts[0] = 1;
	pts[1] = (int) rint(.75 * (float) tot_region);
	pts[2] = tot_region;
	pts[3] = (int) rint(.25 * (float) tot_region);
    } /* if */

    used = 0;		 /* nombre de passage dans ecrire_noeud en mode 2 */

    if (mode != 3)
	switch (type)/* on reserve la memoire pour l'image et on lui donne */
				/* sa couleur de fond */
	{
	    case 2 : pict2 = (int *) calloc (taille, sizeof(* pict2));
		     wim2 = pict2;
		     if (mode == 2) 
		     {
			 for (i = 0; i < taille; i ++)
			 {
			    *wim2 = 100 + tot_region;
			    wim2 ++;
			 }
			 i = 0;
			 wim2 = pict2;
		     }
		    first = (unsigned char *) pict2;
		    break;
	    case 3 : pict3 = (float *) calloc (taille, sizeof(* pict3));
		     wim3 = pict3;
		     if (mode == 2) 
		     {
			 for (i = 0; i < taille; i ++)
			 {
			    *wim3 = (float) (100 + tot_region);
			    wim3 ++;
			 }
			 i = 0;
			 wim3 = pict3;
		     }
		     first = (unsigned char *) pict3;
		     break;
	} /* switch type  initialisation de l'image + couleur de fond */

	/* on va parcourir le graphe selon une methode BFS */

    f_l1 = NULL;				      /* initialisations */
    w_l1 = f_l1;
    f_l2 = (struct list_BFS *) calloc (1,sizeof (*f_l2));
    f_l2->g = f_g;	      /* on met le premier noeud dans la liste 2 */
    f_l2->next_BFS = NULL;
    l_l2 = f_l2;	    /* on garde un ptr sur la fin de la liste 2 */


			  /* parcours du graphe */
    while (f_l2 != NULL)  /* on execute jusqu'a ce la liste 2 soit vide */
    {
	w_l2 = f_l2->next_BFS;

	if (f_l1 == NULL)	      /* on passe le 1er ele de liste 2 */
	{				/* a la fin de la liste 1 */
	    f_l1 = (struct list_BFS *) calloc (1,sizeof (* f_l1));
	    f_l1->g = f_l2->g;
	    f_l1->next_BFS = NULL;	 	 
	    w_l1 = f_l1;
	}
	else
	{
	    w_l = (struct list_BFS *) calloc (1,sizeof (*w_l));
	    w_l->g = f_l2->g;
	    w_l->next_BFS = NULL;
	    w_l1->next_BFS = w_l;
	    w_l1 = w_l1->next_BFS;
	} /* else */

	f_l2 = w_l2;

	/* on met les voisins du noeud de la liste 1 dans la liste 2 */
	/* en verifiant qu'il n'appartiennent pas deja a la liste 1 */

	g_l = w_l1->g->first_gl;
	while (g_l != NULL) /* parcours des voisins a mettre ds liste 2 */
	{
	    w_l11 = f_l1;
				 /* verif de non_redondance ds liste 1 */
	    while ((w_l11 != NULL) && (w_l11->g != g_l->g_vois))
	    {
		w_l11 = w_l11->next_BFS;
	    } /* while */

	    w_l21 = f_l2;
				 /* verif de non_redondance ds liste 2 */
	    while ((w_l21 != NULL) && (w_l21->g != g_l->g_vois))
	    {
		w_l21 = w_l21->next_BFS;
	    } /* while */


/* si n'appartient pas deja a liste1 ou liste2 ajoute le noeud a la liste 2 */
	    if ((w_l11 == NULL) && (w_l21 == NULL))
	    {
	        w_l2 = (struct list_BFS *) calloc (1,sizeof (*w_l2));
		w_l2->g = g_l->g_vois;
		w_l2->next_BFS = NULL;
		l_l2->next_BFS = w_l2;
		l_l2 = l_l2->next_BFS;
		if (f_l2 == NULL) f_l2 = l_l2;
	    } /* if */

	    g_l = g_l->next_gl;
	} /* while (parcours des voisins a mettre dans la liste 2) */


				/* attribution de la couleur de la region */
	if (nb_feat > 1)
	{
	    color = pts[i];
	    if ((i == 0) || (i== 3)) pts[i]++;
	    else pts[i] --;
	    i ++;
	    if (i == 4) i = 0;
	} /* then */
	else color = (int) rint (w_l1->g->first_feat->feature);

	w_r = w_l1->g->first_run;


	switch (mode)		       /* ecriture selon la methode choisie */

	{				     /* ecriture non_conditionnelle */
	    case 1 : ecrire_noeud (w_r, color, n_col, type, first); 
		     used ++;
		     break;

	    case 2 : grow = f_c;		  /* extraction de regions */
		     flag_c = 1;
		     fl = w_l1->g->first_feat;
		     while ((grow != NULL) && (flag_c == 1))
		     {
			 switch (grow->choix)		/* selon le critere */
			 {
							/* numero de region */
			     case 0 : if (w_l1->g->region != (int) rint
								(grow->toler))
					 flag_c = 0;
				      break;

							/* nombre de pixel */
			     case 1 : if (w_l1->g->nbpix < (int) rint
								(grow->toler))
					 flag_c = 0;
				      break;

						       /* nombre de voisins */
			     case 2 : counter = 0;  /* comptage des voisins */
				      gl = w_l1->g->first_gl;

				      while (gl != NULL)
				      {
					  counter ++;
					  gl = gl->next_gl;
				      }
				      if (counter < (int) rint (grow->toler))
					 flag_c = 0;
				      break;

	/* initialisation du pourcentage d'erreur sur les criteres du graphe */
			     case 3 : percent = grow->toler / 100.0;
				      break;

			     case 4 :				/* esperance */
			     case 5 :			      /* esperance-2 */
			     case 6 :		       /* variance & err_moy */
			     case 7 : if ((grow->toler < fl->feature - (percent
							    * fl->feature)) ||
					  (grow->toler > fl->feature + (percent
							    * fl->feature)))
					 flag_c = 0;
				      break;

			 } /* switch grow->choix */

			 if (grow->choix > 3) fl = fl->next_f;
			 grow = grow->next_rg;

		     } /* while grow != NULL && flag_c = 1 */

		     if (flag_c == 1)
		     {
			ecrire_noeud(w_r, color, n_col,type, first);
			used ++;
		     }	
		     break; /* case 2 */

					 /* elimination des petites regions */
	    case 3 : if (w_l1->g->nbpix <= f_c->choix)
		     {
			 wgl = w_l1->g->first_gl;
			 grand = wgl;

			 while (wgl != NULL)
			 {
			     if (wgl->g_vois->nbpix > grand->g_vois->nbpix)
				 grand = wgl;
			     wgl = wgl->next_gl;
			 }
							 /* voisin "mergeur" */
			 n_node = grand->g_vois;

			 c_node = w_l1->g;		 /* noeud a eliminer */

				   /* mise a jour de la liste des proprietes */
			 if (meth != 1)	    /* si pas Ohlander-Price & Reddy */
			    n_node = maj_prop (f_rg, n_node, c_node);
			 n_node->nbpix + = c_node->nbpix;

		   /* on affecte les voisins de la region a eliminer a l'old */
			 wgl = c_node->first_gl;	       /* reg a elim */

			 while (wgl != NULL)	   /* parcours liste voisins */
			 { 
			     wgl1 = n_node->first_gl;	   /* reg "mergeuse" */

			     if (wgl->g_vois != n_node)
				n_node->first_gl =affecte_graph_list(wgl,wgl1);
			     wgl = verif_old_lien (wgl, c_node);
			     if (wgl->g_vois != n_node)
				wgl = verif_new_lien (wgl, n_node);

			     wgl = wgl->next_gl;
			 } /* while wgl <> NULL */

			 meth = 1;
			 tmp = (struct run *) calloc (1, sizeof (*tmp));
			 n_node->first_run = affecte_list_run (
							n_node->first_run, 
							c_node->first_run, 
							tmp, 
							&meth);
			 if (meth == 0) 
			 {
			    tmp->node = c_node;
			    tmp->no_region = c_node->region;	
			    c_node->first_run = tmp;
			 }
			 else if (meth == 2) c_node->first_run = NULL;

			 if (c_node = f_g) f_g = n_node;

			 used ++;

		     } /* if region a eliminer */
		     break; /* case 3*/

	} /* switch mode */

    } /* while f_l2 <> NULL (parcours du graphe) */

    if ((mode == 2) || (mode == 3))
    {
	if (used == 0) sprintf (buf,mastertabs[261]);
	else sprintf (buf,mastertabs[262],
		    used);
	write_master (buf);
    }

    if (mode != 3)  		    /* calcul des statistiques de l'image */
    {
	dir_desc[index_image[1]].nligne = n_line;
	dir_desc[index_image[1]].ncolonne = n_col;
	dir_desc[index_image[1]].type = type;

	dir_image[index_image[1]].image = first;

	statis (dir_image[index_image[1]].image,
		dir_desc[index_image[1]].type,
		dir_desc[index_image[1]].nligne,
		dir_desc[index_image[1]].ncolonne,
		&dir_desc[index_image[1]].mmin,
		&dir_desc[index_image[1]].mmax,
		&dir_desc[index_image[1]].mu,
		&dir_desc[index_image[1]].ecart);
    }

} /* graph_image */

/************************************************************************/
/*									*/
/* Nom : proc_graph							*/
/* Fonction : Lecture du choix de la methode de segmentation par 	*/
/* l'utilisateur, puis appel de la procedure correspondante		*/
/* Entree : Menu m; Menu_item mi (numero de la methode)			*/
/* Global : int taille, n_line, n_col, mmin, mmax, (stat image)		*/
/*		meth (pour ecriture ds image)				*/
/* Routines : grow_panel, bat_graph, graph_image, panel_int, O_P_R	*/
/* Sortie : -								*/
/*									*/
/* made by A.Jacot-Descombes 21.8.90 (proc_seg C.Girard 15.11.1989)	*/
/************************************************************************/

caddr_t proc_graph (m, mi)

Menu m;
Menu_item mi;       

{
    struct reg_grow *f_crit, *rg, *copygrowy, *fcg, *wcg, *ocg;
    int masque, no, ty, *p, pass;
    no = (int) menu_get (mi, MENU_VALUE);
    if (flag_bother){
	switch (no)
	{
	    case 1 : hproc_construct_graphe();
		     return;;
	    case 2 : hproc_grapheToimage();
		     return;
	    case 3 : hproc_extract_regions();
		     return;
	    case 4 : hproc_eliminate_regions();
		     return;
	} /* switch */	
    }

    if (!flag_creer)
    {
	switch (no)
	{
	    case 1 : if (flag_help) hproc_construct_graphe();
		     sprintf (buf,mastertabs[263] ); break;
	    case 2 : if (flag_help) hproc_grapheToimage();
		     sprintf (buf, mastertabs[265] 
		     ); break;
	    case 3 : if (flag_help) hproc_extract_regions();
		     sprintf (buf,mastertabs[266]  
		     ); break;
	    case 4 : if (flag_help) hproc_eliminate_regions();
		     sprintf (buf, mastertabs[265] 
		     ); break;
	} /* switch */
	write_master (buf);
    } /* if not flag_creer */

    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO)
    {
	switch (no)
	{
	    case 1 : index_image [0] = macro_cour->from [0]; break;
	    case 2 :
	    case 3 : index_image [1] = macro_cour->to [0]; break;
	} /* switch */
    }
    else 
	switch (no)
	{
	    case 1 : fromto (FROM, DEFAUT); break;
	    case 2 :
	    case 3 : fromto (TO, DEFAUT); break;
	} /* switch */

    if (flag_break) interruption();
    else
    {
	if (!flag_creer)
	{
	    switch (no)
	    {
		case 1 : sprintf (buf, "-->%d ", index_image [0]);
			 break; 
		case 2 : sprintf (buf, "--> %d\n", index_image [1]);
			 break;
		case 3 : sprintf (buf, "--> %d\n ", index_image [1]);
			 break;
		case 4 : sprintf (buf, " ");
			 break;
	    } /* switch */
	    write_master (buf);
	} /* if not flag_creer */

	if (flag_exec == AUTO || flag_exec == PARAM_AUTO)
	{
	    switch (no)
	    {
		case 3 : f_crit = (struct reg_grow *) calloc (1, sizeof 
								    (*f_crit));
		         *f_crit = *((struct reg_grow *) macro_cour->param);

			 rg = f_rg;    /* on verifie les criteres introduits */
			 wcg = f_crit;
			 ocg = wcg;
					        /* rech debut des crit dynam */
			 while (wcg != NULL && wcg->choix < 4)
			 {
			     ocg = wcg;
			     wcg = wcg->next_rg;
			 }

			 while (wcg != NULL)
			 {
			     if (rg != NULL && wcg->choix == rg->choix)
			     {
				 rg = rg->next_rg;
				 ocg = wcg;
				 wcg = wcg->next_rg;
			     }
			     if (rg == NULL || wcg->choix < rg->choix)
			     {
				 ocg->next_rg = wcg->next_rg;
				 wcg = wcg->next_rg;
			     }
			     if (rg != NULL && wcg->choix > rg->choix)
			     {
				 rg = rg->next_rg;
			     }
			 } /* while */
			 break;
		case 4 : masque = *((int *) macro_cour->param);
			 f_crit = (struct reg_grow *) calloc (1, sizeof
								(*f_crit));
			 f_crit->choix = masque;
			 f_crit->toler = 0.0;
			 f_crit->next_rg = NULL;
			 break;
	    }
	}
	else
	{
	    switch (no)
	    {			
		case 3 : /*f_crit = (struct reg_grow *) calloc (1, sizeof
								(*f_crit));*/
			 f_crit = grow_panel (2);
			 break;
		case 4 : f_crit = (struct reg_grow *) calloc (1, sizeof 
								    (*f_crit));
			 masque = panel_int (2);
			 f_crit->choix = masque;
			 f_crit-> toler = 0.0;
			 f_crit->next_rg = NULL;
			 break;
	    } /* switch no */
	} /* else */

	if (flag_break) interruption ();
	else
	{
	    if (flag_creer)				/* creation de macro */
	    {
		struct commande *com;
		com = (struct commande *) new_commande (&macro_cour);
		switch (no)
		{
		    case 1 : sprintf (buf, "PROREGGRAGCO FROM %d \n", index_image
									[0]);
			     sprintf (com->nom, "PROREGGRAGCO");
			     write_macro (buf);
			     com->from [0] = index_image [0];
			     com->code = 140;
			     break;
		    case 2 : sprintf (buf, "PROREGGRAGIM TO %d \n", index_image
									[1]);
			     write_macro (buf);
			     sprintf (com->nom, "PROREGGRAGIM");
			     com->to [0] = index_image [1];
			     com->code = 143;
			     break;

		    case 3 : sprintf (buf, "PROREGGRAREX TO %d WITH ", index_image
									[1]);
			     write_macro (buf);
			     rg = f_crit;
			     pass = 0;
			     while (rg != NULL)
			     {
				sprintf (buf, "%d %f ", rg->choix, rg->toler);
				write_macro (buf);
				copygrowy = (struct reg_grow *) calloc (1, 
					    sizeof (*copygrowy));
				*copygrowy = *rg;
				if (f_crit == rg) 
				{
				    fcg = copygrowy;
				    wcg = fcg;
				}
				if (pass > 0)
				{
				    wcg->next_rg = copygrowy;
				    wcg = copygrowy;
				}
				pass ++;
				rg = rg->next_rg;
			     } /* while */

			     sprintf (buf, "\n");
			     write_macro (buf);
			     com->param = (char *) fcg;
			     com->to [0] = index_image [1];
			     sprintf (com->nom, "PROREGGRAREX");
			     com->code = 144;
			     break;

		    case 4 : sprintf (buf, "PROREGGRAESR WITH %d\n", masque);
			     write_macro (buf);
			     sprintf (com->nom, "PROREGGRAESR");
			     com->code = 145;
			     p = (int *) calloc (1, sizeof (*p));
			     *p = masque;
			     com->param = (char *) p;
			     break;

		} /* switch no */

	    } /* then flag_creer */
	    else
	    {				    /* les statistiques de l'image */
		if (no == 1 || no == 2 || no == 3)
		{
		    n_line = dir_desc [index_image [0]].nligne;
		    n_col = dir_desc [index_image [0]].ncolonne;
		    mmin = dir_desc [index_image [0]].mmin;
		    mmax = dir_desc [index_image [0]].mmax;
		    taille = n_line * n_col;
		    first = dir_image [index_image [0]].image;
		}

		switch (no)
		{
		    case 1 : f_rg = (struct reg_grow *) calloc (1, sizeof 
								    (*f_rg));
			     f_rg->choix = 0;
			     f_rg->toler = 0.0;
			     f_rg->next_rg = NULL;
			     f_g = NULL;
			     f_g = bat_graph (first, f_rg);
			     break;

		    case 2 : if (dir_desc [index_image [0]].type <= 2) ty= 2;
			     else ty = 3;
			     graph_image (ty, 1, NULL);
			     break;
	    
		    case 3 : rg = f_crit;
			     while (rg != NULL)
			     {
				 switch (rg->choix)
				 {
				     case 0 : sprintf(buf,mastertabs[272]
				     ); break;
				     case 1 : sprintf(buf,mastertabs[273]
				     ); break;
				     case 2 : sprintf(buf,mastertabs[274]
				     ); break;
				     case 3 : sprintf(buf,mastertabs[275]
				     ); break;
				     case 4 : sprintf(buf,mastertabs[268]
				     ); break;
				     case 5 : sprintf(buf,mastertabs[268]
				     ); break;
				     case 6 : sprintf(buf,mastertabs[269]
				     ); break;
				     case 7 : sprintf(buf,"var :"); break;
				     case 8 :
				     sprintf(buf,mastertabs[270]
				     ); break;
				 }
				 write_master (buf);
				 sprintf (buf, " %4.4f ", rg->toler);
				 write_master (buf);
				 rg = rg->next_rg;
			     }
			     if (f_g != NULL)
			     {
				if (dir_desc [index_image [0]].type <= 2) ty=2;
				else ty = 3;
				graph_image (ty, 2, f_crit);
			     }
			     break;
	
		    case 4 : sprintf (buf,mastertabs[267], 
					masque);
			     write_master (buf);
			     if (f_g != NULL)
			     {
				if (dir_desc [index_image [0]].type <= 2) ty=2;
				else ty = 3;
				graph_image (ty, 3, f_crit);
			     }
			     break;
	
		} /* switch no */

	    } /* else !flag_creer */
	} /* 2e flag_break */
    } /* if 1er flag_break */

} /* end of proc_graph */

/************************************************************************/
/*									*/
/* Nom : proc_opr							*/
/* Fonction : Lecture du choix de la methode de segmentation par 	*/
/* l'utilisateur, puis appel de la procedure correspondante		*/
/* Entree : Menu m; Menu_item mi (numero de la methode)			*/
/* Global : int taille, n_line, n_col, mmin, mmax, (stat image)		*/
/*		meth (pour ecriture ds image)				*/
/* Routines : grow_panel, bat_graph, graph_image, panel_int, O_P_R	*/
/* Sortie : -								*/
/*									*/
/* made A.Jacot-Descombes 21.8.90 (proc_seg by C.Girard 15.11.1989)	*/
/************************************************************************/

caddr_t proc_opr (m, mi)

Menu m;
Menu_item mi;       

{
    int masque, no, *p;

    no = (int) menu_get (mi, MENU_VALUE);
    if (flag_bother){
	switch (no)
	{
	    case 1 : hproc_Ohlander_Price_Reddy_gray();
		     return;
	    case 2 : hproc_Ohlander_Price_Reddy_rgb();
		     return;
	} /* switch */	
    }

    if (!flag_creer)
    {
	switch (no)
	{
	    case 1 : if (flag_help) hproc_Ohlander_Price_Reddy_gray();
		     sprintf (buf, "Ohlander Price & Reddy gray tone"); break;
	    case 2 : if (flag_help) hproc_Ohlander_Price_Reddy_rgb();
		     sprintf (buf, "Ohlander Price & Reddy rgb"); break;
	} /* switch */
	write_master (buf);
    } /* if not flag_creer */

    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO)
    {
	switch (no)
	{
	    case 1 : index_image [0] = macro_cour->from [0];
		     index_image [1] = macro_cour->to [0];
		     index_vect [1] = macro_cour->to [1];
		     break;
	    case 2 : break;
	} /* switch */
    }
    else 
	switch (no)
	{
	    case 1 : fromto (FROMTO, DEFAUT);
		     fromto_vect (TO, DEFAUT);
		     break;
	    case 2 : break;
	} /* switch */

    if (flag_break) interruption();
    else
    {
	if (!flag_creer)
	{
	    switch (no)
	    {
		case 1 : sprintf (buf, "%d -->(%d,Vec %d)", 
			 index_image [0], index_image [1], index_vect [1]);
			 break;
		case 2 : break;
	    } /* switch */
	    write_master (buf);
	} /* if not flag_creer */

	if (flag_exec == AUTO || flag_exec == PARAM_AUTO)
	{
	    switch (no)
	    {
		case 1 : masque = *((int *) macro_cour->param);
			 break;
		case 2 : break;
	    }
	}
	else
	{
	    switch (no)
	    {			
					/* lecture de la taille du masque */
		case 1 : masque = panel_int (1);
			 f_g = NULL;
			 break;

		case 2 : break;
	    } /* switch no */
	} /* else */

	if (flag_break) interruption ();
	else
	{
	    if (flag_creer)				/* creation de macro */
	    {
		struct commande *com;
		com = (struct commande *) new_commande (&macro_cour);
		switch (no)
		{
		    case 1 : sprintf(buf,"PROREGOPRGRA FROM %d TO %d %d WITH %d\n",
					    index_image [0], index_image [1],
					    index_vect [1], masque);
			     write_macro (buf);
			     com->from [0] = index_image [0];
			     com->to [0] = index_image [1];
			     com->to [1] = index_vect [1];
			     sprintf (com->nom, "PROREGOPRGRA");
			     com->code = 142;
			     p = (int *) calloc (1, sizeof (*p));
			     *p = masque;
			     com->param = (char *) p;
			     break;

		    case 2 : break;

		} /* switch no */

	    } /* then flag_creer */
	    else
	    {				    /* les statistiques de l'image */
		if (no == 1)
		{
		    n_line = dir_desc [index_image [0]].nligne;
		    n_col = dir_desc [index_image [0]].ncolonne;
		    mmin = dir_desc [index_image [0]].mmin;
		    mmax = dir_desc [index_image [0]].mmax;
		    taille = n_line * n_col;
		    first = dir_image [index_image [0]].image;
		}

		switch (no)
		{
		    case 1 : sprintf (buf, mastertabs[271],
				     masque);
			     write_master (buf);
			     first = O_P_R (first, masque);
				 /* utile lors de l'elimination de pttes reg */
			     meth = 1; 
			     break;

		    case 2 : break;
	
		} /* switch no */

	    } /* else !flag_creer */
	} /* 2e flag_break */
    } /* if 1er flag_break */

} /* end of proc_opr */

