

#include <stdio.h>
#include <strings.h>
#include <sys/time.h>
#include <setjmp.h>
#include <signal.h>
#include "defs.h"
#include "tif.h"

extern CHAR *optarg;
extern INT  optind;

CHAR    *progname, *version();

main (ac, av)
     INT   ac;
     CHAR  **av;
{
  INT     getopt(), c, nfiles, i, cleanup();
  VOID    usage(), logerr(), dodump(), genps();
  DOUBLE  xoffset = 0., yoffset= 0., scalefactor = 1., height = 0.;
  DOUBLE  xresfactor, yresfactor, atof();
  PICTURE picts[8]; /* maximal 8 pictures */
  TIFF    tiff;
  jmp_buf env;

  if (!rindex (av[0], '/')) progname = av[0];
    else progname = rindex (av[0], '/') + 1;

  if (ac < 2)
    {
      usage ();
      exit (-1);
    }

  while ((c = getopt (ac, av, "v:")) != EOF) {
      switch (c) {
      case 'v': /* print current version of this program */
	printf ("This is %s version %s.\n", av[0], version());
	exit (0);
      default:
	usage ();
	exit (-1);
      }
   }  /* end of command line parsing */

  (VOID) signal (SIGINT, cleanup);

  nfiles = ac - optind;
  for (i = 0; i < nfiles; i++)
    {
      if (scantif (av[i+optind], picts, &tiff) == ERROR)
	{ logerr (progname, "cannot read file"); exit (-1); }
      if (!strcmp (progname, "tifdump"))
	{
	  printf ("This is %s version %s.\n\n", progname, version());
	  dodump (av[i+optind], &tiff);
	  continue;
	}
      /* else do initializations */
      /* a loop through all pictures should be inserted here */

      /* adjust bytecount ???? perhaps not correct */
      /* manages only single strip pictures */
      if (picts[0].image.strips[0].byteCount == 0)
	picts[0].image.strips[0].byteCount = 
	  (picts[0].image.imWidth * picts[0].image.imLength) / 
	    (8 / picts[i].image.bitsPerSample);

      switch (picts[0].physWorld.resUnit)
	{
	case 1: /* special */
	  xresfactor = 1. / picts[0].physWorld.xRes;
	  yresfactor = 1. / picts[0].physWorld.yRes;
	  break;
	case 2: /* inches */
	  xresfactor = 72. / picts[0].physWorld.xRes;
	  yresfactor = 72. / picts[0].physWorld.yRes;
	  break;
	case 3: /* centimetres */
	  xresfactor = 28.3465 / picts[0].physWorld.xRes;
	  yresfactor = 28.3465 / picts[0].physWorld.yRes;
	  break;
	}
      
      if (height != 0.)
	scalefactor = (height / (picts[0].image.imLength * yresfactor));
      
      if (xoffset != 0.)
	picts[0].context.xPos = xoffset;
      if (yoffset != 0.)
	picts[0].context.yPos = yoffset;
      
      picts[0].context.xMax = 
	(picts[0].image.imWidth * xresfactor * scalefactor) +
	  picts[0].context.xPos;
      picts[0].context.yMax = 
	(picts[0].image.imLength * yresfactor * scalefactor) + 
	  picts[0].context.yPos;
      
      genrast (av[i+optind], picts);
    }
} /* end of main */

LOCAL INT cleanup ()
{
#ifdef MSDOS
  cprintf ("cleanup...\n");
#else
  fprintf (stderr, "cleanup...\n");
#endif
  exit (-1);
}

LOCAL VOID usage ()
{
  printf ("usage: %s[-v] file1 ...\n", progname);
}

EXPORT VOID logerr (routine, msg)
     CHAR *routine, *msg;
{
#ifdef MSDOS
  cprintf ("%s(%s): %s\n", progname, routine, msg);
#else
  fprintf (stderr, "%s(%s): %s\n", progname, routine, msg);
#endif
}

EXPORT CHAR *date()
{
  LONG seconds, time();
#ifndef MSDOS
  CHAR *asctime();  
#endif

#ifdef MSDOS
  time (&seconds);
  return (ctime (&seconds));
#else 
  seconds = time ((LONG *) 0);
  return (asctime (localtime (&seconds)));
#endif
}

EXPORT CHAR *caller()
{
  STATIC CHAR name[128];
#ifdef MSDOS
  strcpy (name, ""); /* cannot get hostname and login name */
#else
  CHAR *getlogin (), host[128];

  (VOID) gethostname (host, 128);
  (VOID) sprintf (name, "%s@%s\0", getlogin(), host);
#endif
  return (name);
}
