/* dbmtry.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* If you have problems with the dbm interface, try this program.
 * If it fails with ALERT messages when given an argument of 300 or so,
 * you almost certainly have a faulty dbm.
 *
 * On SysV, by the way, check for delitem() calling bcopy() with
 * overlapping arguments...
 *
 * $Header: /usr/src/cmd/lq-text/src/test/RCS/dbmtry.c,v 1.5 91/03/03 00:47:56 lee Exp $
 *
 * $Log:	dbmtry.c,v $
 * Revision 1.5  91/03/03  00:47:56  lee
 * added sys/types.h for ozmahash
 * 
 * Revision 1.4  90/08/09  19:17:47  lee
 * *** empty log message ***
 * 
 * Revision 1.3  90/07/27  17:41:54  lee
 * *** empty log message ***
 * 
 * Revision 1.2  89/09/16  21:16:15  lee
 * First demonstratable version.
 * 
 * Revision 1.1  89/09/07  21:05:54  lee
 * Initial revision
 * 
 */

#include "globals.h" /* defines and declarations for database filenames */

#include <stdio.h>
#include <fcntl.h>
#ifdef ozmahash
# include <sys/types.h>
#endif
#include "smalldb.h"

char *progname = "dbmtry";

/** Unix system calls: **/
extern void exit();

/** Unix Library Functions: **/
extern int atoi();
extern int strlen();
extern void perror();

/** Routines in this file which need declaring: **/
void printvalues();

/** **/


int
main(ac, av)
    int ac;
    char *av[];
{
    DBM *db;
    int max = atoi(av[1]);
    int i;
    datum key, data;
    char dbuf[30];


    if (ac <= 1) {
	fprintf(stderr, "Usage: %s maxkey\n", av[0]);
	exit(1);
    }

    if ((db = startdb("/tmp/trydbm")) == (DBM *) 0) {
	fprintf(stderr, "dbmopen 1 failed\n");
	exit(1);
    }

    for (i = 1; i <= max; i++) {
	char buf[20];
	register int s_val;

	if ((i % 500) == 0) {
	    (void) fprintf(stderr, "\r%d ", i);
	    (void) fflush(stderr);
	}
	sprintf(buf, "%d", i);
	sprintf(dbuf, "%d data item here", i);
	    /* Note: the number is at the start to help speed the
	     * strcmp, as it is most likely to differ
	     */
	key.dsize = strlen(buf) + 1; /* include th nul so we can strcmp() */
	key.dptr = buf;
	data.dptr = dbuf;
	data.dsize = strlen(dbuf) + 1;
	s_val = dbm_store(db, key, data, DBM_INSERT);
	if (s_val != 0) {
	    printf("store %d returned %d\n", i, s_val);
	}
    }

    enddb(db);

    printvalues(max);
    return 0;
}

void
printvalues(max)
    int max;
{
    DBM *db;
    int i;
    datum key, data;

    db = startdb("/tmp/trydbm");

    if (!db) {
	fprintf(stderr, "Unable to open database ");
	perror("/tmp/trydbm");
	exit(1);
    }

    for (i = 1; i <= max; i++) {
	char buf[20];

	sprintf(buf, "%d", i);
	key.dsize = strlen(buf) + 1;
	key.dptr = buf;
	data = dbm_fetch(db, key);

	if (data.dsize == 0) {
	    printf("ALERT! Item %d has been lost! ALERT!\n", i);
	} else {
	    char *Buf[100];
	    (void) sprintf(Buf, "%d data item here", i);
	    if (strcmp(Buf, data.dptr) != 0) {
		printf("%d: Corrupt: \"%s\" != \"%s\"\n",
				i, data.dptr, Buf);
		/* NOTE: no use using STREQ, as the strings are usually
		 * the same.
		 */
	    }
	}
    }

    enddb(db);
}
