/*
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	%W% (Berkeley) %G%
 */
/*
    RCS INFO
    $header$

    Definitions for hashing page file format.
*/
extern	HTAB	*hashp;
/*
 * routines dealing with a data page
 *
 * page format:
 *	+------------------------------+
 * p	| n | keyoff | datoff | keyoff |
 * 	+------------+--------+--------+
 *	| datoff | free  |  ptr  | --> |
 *	+--------+---------------------+
 *	|	 F R E E A R E A       |
 *	+--------------+---------------+
 *	|  <---- - - - | data          |
 *	+--------+-----+----+----------+
 *	|  key   | data     | key      |
 *	+--------+----------+----------+
 *
 * Pointer to the free space is always:  p[p[0] + 2]
 * Amount of free space on the page is:  p[p[0] + 1]
 */

/*
    How many bytes required for this pair?
    2 shorts in the table at the top of the page +
    room for the key and room for the data

    We prohibit entering a pair on a page unless there is also
    room to append an overflow page. The reason for this it that
    you can get in a situation where a single key/data pair fits
    on a page, but you can't append an overflow page and later
    you'd have to split the key/data and handle like a big pair.
    You might as well do this up front.

*/
#define	PAIRSIZE(K,D)	(2*sizeof(u_short) + K->size + D->size)
#define BIGOVERHEAD	(4*sizeof(u_short))
#define KEYSIZE(K)	(4*sizeof(u_short) + K->size);
#define OVFLSIZE	(2*sizeof(u_short))
#define FREESPACE(P)	(P[P[0]+1])
#define	OFFSET(P)	(P[P[0]+2])
#define PAIRFITS(P,K,D)	((P[1] >= REAL_KEY) && \
			 (PAIRSIZE(K,D) + OVFLSIZE) <= FREESPACE(P))
#define PAGE_META(N)	((N+3) * sizeof(u_short))

#define	MIN(A,B)	(A<=B?A:B)

typedef struct {
    BUFHEAD	*newp;
    BUFHEAD	*oldp;
    BUFHEAD	*nextp;
    u_short	next_addr;
} SPLIT_RETURN;

