#ifdef BCOPYTEST
# include <stdio.h>
#endif

/* this is a simple replacement for bcopy() where the native bcopy()
 * does not handle overlapping blocks.
 * do
 *	cc -DBCOPYTEST -o bcopy bcopy.c
 * and run "./bcopy" for a simple test.  You should get three
 * identical lines of output.
 */

bcopy(src, dest, nbytes)
    char *dest;
    char *src;
    int nbytes;
{
    /* We have to be clever about this...
     * If src < dest then we copy from the top down
     * otherwise, copy from the bottom up...
     */
    
    register char *p, *q;

    if (src < dest) {
	for (p = &src[nbytes - 1], q = &dest[nbytes - 1]; nbytes--; q--, p--) {
	    *q = *p;
	}
    } else {
	for (p = src, q = dest; nbytes--; p++, q++) {
	    *q = *p;
	}
    }
}

#ifdef BCOPYTEST
main()
{
    char buffer[4096];
    char *s = "The naked children hugged each other";

    puts(s); /* first line */
    (void) sprintf(&buffer[12], "%s", s);
    bcopy(&buffer[12], buffer, strlen(s) + 1);
    printf("[%s]\n", buffer); /* 2nd line */
    bcopy(buffer, &buffer[12], strlen(s) + 1);
    printf("[%s]\n", &buffer[12]); /* 3rd line */
}
#endif
