#! /bin/sh
: use /bin/sh
# put the : line first on System V

# lq -- Copyright 1990 Liam R. Quin.  All Rights Reserved.
# This code is NOT in the public domain.
# See the file ../COPYRIGHT for full details.
#
# $Id: lq.sh,v 1.3 90/10/06 00:50:53 lee Rel1-10 $
#

if [ x"`echo -n hello`" = x'hello' ]
then
    N=-n
    C=
else
    N=
    C='\c'
fi

quit=no
t=/tmp/lq$$
ListFile=/tmp/lqshow$$
export ListFile

trap '/bin/rm -f $t; exit' 0 1 2 3 15


while  [ x"$quit" != x"yes" ]
do
    cat << boy
| Type a words or phrases to find, one per line,
| and then press return.
boy
    x='fhdjfd'
    Phrases=
    while [ x"$x" != x"" ]
    do
	echo $N "| $C"
	read x
	if [ x"$x" != x"" ]
	then
	    New=`echo "$x" | sed 's/"/:/g'`
	    Phrases="${Phrases} \"$x\""
	fi
    done
    echo $Phrases
    eval lqphrase -p $Phrases \> $t
    if [ ! -s $t ]
    then
	echo "No match"
    else
	# determine the order in which matches will be presented to the user:
	sort +2 -o "$t" "$t" # (this is our ranking function)
	# (it only makes a difference if there was more than one phrase)

	# Now some arcanery, I'm afraid...  The trick is that lqshow can be
	# given the name of a file descriptor in which to save the names of
	# any files the user selects (with "s").
	old_t="$t"
	t="$t ${ListFile}"
	lqshow -o 3 -f $t 3>> ${ListFile}
	t="$old_t"
	if [ -s ${ListFile} ]
	then ## the user typed s/k/whatever to save some files...
	    # make the list by interpreting the list file:
	    LIST=`awk '
	    /^#.*$/ { next }
	    ($1 == "s") { SAVE[$2]++ }
	    ($1 == "d") { SAVE[$2] = 0 }
	    END {
		for (i in SAVE) {
		    if (SAVE[i] > 0) print i
		}
	    }' $ListFile | sort -u`
	    # make a new list file...
	    echo "$LIST" | sed '/^[ 	]*$/d' > $ListFile
	    LIST="" # save memory
	fi
	# now see if it's still non-empty...
	if [ -s ${ListFile} ]
	then
	    List="Type S filename to save the list of files (s also quits) "
	else
	    /bin/rm -f ${ListFile}
	fi
    fi
    echo $List
    echo $N "Type q to quit, or return to continue: $C"
    read quit rest
    case "$quit" in
    [qQ]*) quit="yes" ;;
    [sS]) # save the list of matches
	cat $ListFile

	if [ ! -s "$ListFile" ]
	then
	    echo "No files in the list to save."
	    quit=no
	else
	    if [ -z "$rest" ]
	    then rest="lq.list"
	    fi

	    if [ -f "$rest" ]
	    then echo "Appending to existing file $rest"
	    fi

	    cat $ListFile >> $rest
	    rm $ListFile
	    if [ x"$quit" = x"s" ]
	    then quit=yes
	    else quit=no
	    fi
	fi
    ;;
    *)	   quit=no ;;
    esac
done

#
# $Log:	lq.sh,v $
# Revision 1.3  90/10/06  00:50:53  lee
# Prepared for first beta release.
# 
#
#
