/* malloc.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/*
 * malloc.c -- wrapper routines for free/malloc, that do checking and
 * print errors.
 *
 * $Id: malloc.c,v 1.6 91/03/03 00:14:27 lee Rel1-10 $
 *
 * $Log:	malloc.c,v $
 * Revision 1.6  91/03/03  00:14:27  lee
 * Simpler interface if MALLOCTRACE undefined.
 * 
 * Revision 1.5  90/10/06  00:12:11  lee
 * Prepared for first beta release.
 * 
 * Revision 1.4  90/09/29  23:51:31  lee
 * Added MALLTRACE to detect memory leaks.
 * 
 * Revision 1.3  90/08/29  21:46:55  lee
 * Alpha release.
 * 
 * Revision 1.2  90/08/09  19:16:44  lee
 * BSD lint and fixes...
 * 
 * Revision 2.2  89/10/08  20:46:10  lee
 * Working version of nx-text engine.  Addfile and wordinfo work OK.
 * 
 *
 */

#include "globals.h"

#include <malloc.h>
#include <stdio.h>
#include <ctype.h>

extern char *progname;

extern void exit();

int _LiamIsInCurses = 0;
    /* This should be in error.c */

INLINE char *
_emalloc(nbytes
#ifdef MALLOCTRACE
, FileName, Line
#endif
)
    unsigned nbytes;
#ifdef MALLOCTRACE
    char *FileName;
    int Line;
#endif
{
    char *Result;

    if ((Result = malloc(nbytes)) == (char *) 0) {
#ifdef MALLOCTRACE
	fprintf(stderr, "%s: %s: %d: emalloc(%u) failed.\n",
					progname, FileName, Line, nbytes);
#else
	fprintf(stderr, "%s: emalloc(%u) failed.\n", progname, nbytes);
#endif
	exit(1);
    }

#ifdef MALLOCTRACE
    (void) fprintf(stderr, "malloc %u > 0x%x %s %d\n", nbytes, Result, FileName, Line);
#endif
    return Result;
}

INLINE char *
_ecalloc(Number, Size
#ifdef MALLOCTRACE
			, FileName, Line
#endif
)
    unsigned Number;
    unsigned Size;
#ifdef MALLOCTRACE
    char *FileName;
    int Line;
#endif
{
    char *Result;
    extern char *calloc();

    if ((Result = calloc(Number, Size)) == (char *) 0) {
#ifdef MALLOCTRACE
	fprintf(stderr, "%s: %s: %d: ecalloc(%u x %u) failed.\n",
			progname, FileName, Line, Number, Size);
#else
	fprintf(stderr, "%s: ecalloc(%u x %u) failed.\n",
			progname, Number, Size);
#endif
	exit(1);
    }

    return Result;
}

INLINE char *
_erealloc(OldString, NewSize
#ifdef MALLOCTRACE
				, FileName, Line
#endif
)
    char *OldString;
    unsigned NewSize;
#ifdef MALLOCTRACE
    char *FileName;
    int Line;
#endif
{
    char *Result;

    if ((Result = realloc(OldString, NewSize)) == (char *) 0) {
#ifdef MALLOCTRACE
	fprintf(stderr, "%s: %s: %d: erealloc(0x%x, %u) failed.\n",
			    progname, FileName, Line, OldString, NewSize);
#else
	fprintf(stderr, "%s: erealloc(0x%x, %u) failed.\n",
			    progname, OldString, NewSize);
#endif
	exit(1);
    }

#ifdef MALLOCTRACE
    (void) fprintf(stderr, "realloc 0x%x %u > 0x%x %s %d\n", OldString, NewSize, Result, FileName, Line);
#endif
    return Result;
}

INLINE void
_efree(String
#ifdef MALLOCTRACE
		, FileName, Line
#endif
)
    char *String;
#ifdef MALLOCTRACE
    char *FileName;
    int Line;
#endif
{
    if (!String) {
#ifdef MALLOCTRACE
	(void) fprintf(stderr, "%s: %s: %d: Warning: free(0) ignored\n",
			progname, FileName, Line);
#else
	(void) fprintf(stderr, "%s: Warning: free(0) ignored\n", progname);
#endif
	return;
    }
#ifdef MALLOCTRACE
    (void) fprintf(stderr, "free 0x%x\n", String);
#endif

    (void) free(String);
}
