/* DocPath.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 *
 * $Id: DocPath.c,v 1.5 90/10/06 00:11:53 lee Rel1-10 $
 *
 *
 * $Log:	DocPath.c,v $
 * Revision 1.5  90/10/06  00:11:53  lee
 * Prepared for first beta release.
 * 
 * Revision 1.4  90/10/05  23:43:19  lee
 * Put the debugging in isfile() within ASCIITRACE ifdefs.
 * 
 * Revision 1.3  90/08/29  21:46:32  lee
 * Alpha release.
 * 
 * Revision 1.2  90/08/09  19:16:12  lee
 * *** empty log message ***
 * 
 *
 */

#include "globals.h" /* defines and declarations for database filenames */

#include <sys/types.h>
#include <sys/stat.h>
#ifdef BSD
# include <sys/param.h>
# define PATH_MAX MAXPATHLEN
#else /*not BSD*/
# include <limits.h> /* for PATH_MAX */
#endif
#include <stdio.h>
#include "emalloc.h"
#include "fileinfo.h"

/** Unix system calls: **/
extern int stat();
/** C Library functions: **/
extern int strlen();
extern char *strcpy();
/** Within this file: **/
extern int IsDir();
/** **/

#ifdef ASCIITRACE
extern int AsciiTrace;
#endif

typedef struct s_DocPath {
    char *DirName;
    struct s_DocPath *Next;
} t_DocPath;

static t_DocPath *XDocPath = 0;

#ifndef PATH_MAX
# define PATH_MAX 2048
#endif

char *
_FindFile(Name)
    char *Name;
{
    int IsFile();

    t_DocPath *p;
    static char Buffer[PATH_MAX + 3]; /* +1 for "\0" */

    if (!XDocPath) {
#ifdef ASCIITRACE
	if (AsciiTrace > 4) {
	    fprintf(stderr, "FindFile(%s) --> %s\n", Name,
					IsFile(Name) ? Name : (char *) 0);
	}
#endif
	return IsFile(Name) ? Name : (char *) 0;
    }

    for (p = XDocPath; p; p = p->Next) {
	(void) sprintf(Buffer, "%s/%s", p->DirName, Name);
	if (IsFile(Buffer)) {
#ifdef ASCIITRACE
	    if (AsciiTrace > 4) {
		fprintf(stderr, "FindFile(%s) --> %s\n", Name, Buffer);
	    }
#endif
	    return Buffer;
	}
    }

    return (char*) 0;
}

int
MakeDocPath(Path)
    char *Path;
{
    extern char *getenv();

    char *Start, *End;
    t_DocPath **dpp;

    if (XDocPath == (t_DocPath *) 0) {
	dpp = &XDocPath;
	*dpp = (t_DocPath *) 0;

	/* For each element in DocPath, */
	for (Start = Path; Start && *Start; Start = End) {
	    char SaveEnd;

	    /* find the end of this bit of the path */
	    for (End = Start; *End && *End != ':'; End++)
		;
	    
	    if (End == Start) break;

	    SaveEnd = (*End);
	    *End = '\0';

	    /* if not a directory, delete from path */
	    if (!IsDir(Start)) {
		*End = SaveEnd;
		continue;
	    }

	    /* add to the linked list */
	    *dpp = (t_DocPath *) emalloc(sizeof(t_DocPath));
	    (*dpp)->DirName = emalloc(strlen(Start) + 1);
	    (void) strcpy((*dpp)->DirName, Start);
	    dpp = &(*dpp)->Next;
	    (*dpp) = (t_DocPath *) 0;
	    if ((*End = SaveEnd) != '\0') {
		End++;
	    }
	}
    }
    return 0;
}

int
IsDir(Dir)
    char *Dir;
{
    struct stat statbuf;

    if (!Dir || !*Dir) return 0;
    if (stat(Dir, &statbuf) < 0) return 0;
    if ((statbuf.st_mode & S_IFMT) != S_IFDIR) {
	return 0;
    }
    return 1;
}

int
IsFile(Path)
    char *Path;
{
    struct stat statbuf;

#ifdef ASCIITRACE
    if (AsciiTrace > 20) {
	fprintf(stderr, "IsFile(%s)\n", Path);
    }
#endif
    if (stat(Path, &statbuf) < 0) return 0;
    if ((statbuf.st_mode & S_IFMT) != S_IFREG) {
	return 0;
    }
#ifdef ASCIITRACE
    if (AsciiTrace > 20) {
	fprintf(stderr, "\t\tIsFile(%s) returns true.\n", Path);
    }
#endif
    return 1;
}
