/* phrase.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* LQ-Text -- Liam's Text Retrieval Package
 * Liam R. Quin, September 1989, and later...
 *
 * phrase.h -- data structures for handling entire phrases
 *
 */

/* $Id: phrase.h,v 1.2 90/10/06 02:18:33 lee Rel1-10 $
 *
 */

/* Represent a Phrase as a linked list of WordInfo pointers, plus a list
 * of matches.
 */

typedef struct s_PhraseItem {
    t_WordInfo *Word;
    struct s_PhraseItem *Next;
    unsigned long SearchIndex; /* For phrase-matching */
    char *WordStart; /* pointer into original phrase */
} t_PhraseItem;

typedef enum {
    PCM_AnyCase, /* Ignore case entirely */
    PCM_HalfCase, /* Upper only matches upper; lower matches either */
    PCM_SameCase, /* Exact matching */
} t_PhraseCaseMatch;

typedef struct s_Match {
    t_WID WID;
    t_WordPlace *Where;
    struct s_Match *Next;
} t_Match;

typedef struct s_MatchList {
    t_Match *Match;
    struct s_MatchList *Next;
} t_MatchList;


typedef struct s_Phrase {
    t_PhraseItem *Words; /* list of words and pblocks */
    char *OriginalString; /* as supplied by the user */
    char *ModifiedString; /* after deleting short/unindexed words */
    unsigned long NumberOfMatches;
    t_MatchList *Matches;
    struct s_Phrase *Next; /* for use when we're in a list of phrases... */
    unsigned short HasUnknownWords;
} t_Phrase;

/* This is for FilleList() */
typedef struct s_Answer {
    char *Answer;
    struct s_Answer *Next;
} t_Answer;

/*
 * $Log:	phrase.h,v $
 * Revision 1.2  90/10/06  02:18:33  lee
 * Prepared for first beta release.
 * 
 * Revision 1.1  90/08/09  19:15:49  lee
 * Initial revision
 * 
 * Revision 1.1  89/09/17  23:03:37  lee
 * Initial revision
 * 
 */
