/* globals.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 *
 * $Id: globals.h,v 1.6 91/02/20 19:26:53 lee Rel1-10 $
 *
 * (see Log at end of this file for change history.  Keep this up to date
 * using rcs if you have it...)
 */

/* globals.h -- declarations of globally accessible variables, and also
 * of configurable parameters.
 *
 * Some of the configuation options might be given in ../Makefile, so
 * you must check in there too.
 *
 * Everything that includes this file must be linked with Defaults.c
 */

/* 
 * DOCPATH gives the list of directories in which to search in order
 * to find files to retrieve and to index.  The default can be wired
 * in here, or can be simply "." (in which case relative pathnames will
 * be from wherever one invokes the commands, and absolute pathnames
 * will be absolute.  For example,
 * #define DFLTDOCPATH "/usr/man:."
 * In any case, it can be overridden by a DOCPATH line in the configuration
 * file for a given database (README in the database directory), and also
 * by an environment variable DOCPATH (the latter taking precedence over
 * the former).
 *
 * Use ((char *) 0) to disable the default -- in this case, you always have
 * to give one, either with the $DOCPATH variable or in the database file.
 *
 */
#ifndef DFLTDOCPATH
# define DFLTDOCPATH ((char *) 0)
#endif

/* LQTEXTDIR: if the programs can't find the directory to use -- i.e.,
 * there was no -d option and $(LQTEXTDIR) is unset, we either
 * look in UNDERHOME (if that was defined here) or in wherever LQTEXTDIR
 * is defined to point.
 */
#ifndef LQTEXTDIR
# define LQTEXTDIR "/usr/spool/lqtextdir"
#endif

/* If UNDERHOME is set, look there for a directory -- e.g. 
 * #define UNDERHOME "sockdrawer"
 * would make lqtext programs look for a directory something like
 * /users/liam/sockdrawer
 * (where /users/liam is my login directory)
 */
#ifndef UNDERHOME
# define UNDERHOME "LQTEXTDIR"
#endif

/* The name of a configuration file found in the database directory:
 */
#define CONFIGFILE "README"

/* If the config file doesn't give a filename for a list of common
 * words, we look for one called DFLTCOMMONFILE (and don't mind if we
 * don't find it).  Use "/dev/null" or ((char *) 0) if you want to
 * disable the default.
 * It's case sensitive, of course.
 */
#define DFLTCOMMONFILE "CommonWords"

#ifndef PAGER
/* The default pager to use if the user doesn't set $PAGER.  This is only
 * used in lqshow, the browser.  Good things to try are
 * more, "less -Ce", and (generally only on System V) "pg -ns".
 * Specify an absolute path if possible.  It's often a lot faster, and
 * it's somewhat safer...
 */
# ifdef BSD
#  define PAGER "/usr/ucb/more"
# else
#  define PAGER "/usr/bin/pg -ns"
# endif
#endif

#ifndef DBMCREAT
/* If you are using dbm or gdbm (?), you will need to create the dbm files
 * by hand yourself.  Defining DBMCREAT as 0 makes the software do this
 * automatically, with a very slight performance penalty.
 *
 * ndbm and sdbm can use O_CREAT, so set it to 1 here for them.
 * You will also have to look at ../Makefile, ../PORTING, smalldb.h and
 * ../lqlib/smalldb.h, making whatever changes are needed.
 */
# define DBMCREAT 1 /* 1 for ndbm, 0 for dbm */
#endif

#ifdef sparc
# define NEEDALIGN
#endif

#ifdef mips /* e.g. SGI machines */
# define NEEDALIGN
#endif

/* NEEDALIGN is for C compilers that require C structures to start at
 * word boundaries.  You need this on sparc and sgi machines...
 */

/***
 *** If you want to change anything beyond here...
 ***
 *** well, you can.
 *** After all, it's your copy.
 ***
 *** But don't come running back to me if it doesn't work!
 *** At least not until you have tried
 ***	+  understanding what the problem is;
 ***	+  looking at the source to see why;
 ***	+  fixing the problem;
 ***	+  taking off your shoes and socks and grinning for a while.
 ***
 *** Liam.
 ***
 ***/

/* The following let you reconfigure the names of the files that form
 * part of the database, but there is no point in doing so unless you
 * are porting to some strange system that has absurd filename restrictions!
 */
#ifndef WORDINDEX
# define WORDINDEX "wordlist"
    /* This is a dbm file, so you'll get two files, one with ".pag"
     * stuck on the end and one with ".dir" on the end.
     * It contains an entry for every word in the database, enabling
     * the software to go from a word to an integer (well, a t_WID)
     * very quickly.
     * It tends to be a little over one tenth of the size of the DATABASE.
     */
#endif
#ifndef WIDINDEXFILE
# define WIDINDEXFILE "WIDIndex"
    /* WIDINDEXFILE contains each word in the datbase, together with some
     * information and the first few bytes of data.
     * It contains WIDBLOCKSIZE bytes for every word, but this has to
     * be at least MAXWORDLEN + 10 bytes long (see WordInfo.c).
     */
#endif
#ifndef DATABASE
# define DATABASE "data"
    /* For those words whose data doesn't fit into the first WIDBLOCKSIZE
     * bytes, space is allocated in this file in BLOCKSIZE chunks.  Make
     * BLOCKSIZE small, or you will waste a lot of space -- on the other
     * hand, there's a 4-byte-per-block overhead at the moment.
     * This file gets very  b  i  g  indeed.
     */
#endif
#ifndef FILEINDEX
# define FILEINDEX "FileList"
    /* This is a list of every file in the database, again in dbm format,
     * so there are actually two files (a .pag and a .dir) involved.
     * If your files are short, it will quickly grow to a tenth of the size
     * of the database.
     * It stores the filename, and some other information.
     */
#endif
#ifndef FIDFILE
# define FIDFILE "FIDFile"
    /* This contains the largest currently used file number... you can
     * look at it to see how many files have been indexed.
     * It is only a few bytes long.
     */
#endif
#ifndef WIDFILE
# define WIDFILE "WIDFile"
    /* This contains the largest currently used word number... you can
     * look at it to see how many unique words have been seen.
     * It is only a few bytes long.
     */
#endif

#ifndef WIDBLOCKSIZE
# define WIDBLOCKSIZE	32
/* WIDBLOCKSIZE absolutely must be large enough to fit at least one byte
 * of actual data, or all hell will break loose.
 * (actually that could be fixed...).
 * In any case, it has to contain (apart from the >= 1 byte of data):
 * + the length count (1 byte) and the word itself (no null on the end)
 * + the block number in the database (1..5 bytes)
 * + the number of matches (1..5 bytes)
 *
 * It helps efficiency very, very slightly if these are a power of two
 * bytes, as then they never cross Unix block boundaries.
 *
 */
#endif

#ifndef BLOCKSIZE
#define BLOCKSIZE	64
/* BLOCKSIZE is the size of blocks in the data file.  There are several
 * tradeoffs:
 * + there is a 4-bytes-per-block overhead for list pointers, so it's
 *   a good idea to make them large
 * + there's a bit of work involved in fetching the blocks, so things go
 *   faster if they're larger...
 * + many blocks are not full, so it's a good idea to make them small.
 *   On average, a little over (BLOCKSIZE - 4) / 2 bytes are wasted for
 *   every word chain.
 * + since many of the blocks are not full, it's a good idea to make them
 *   small, minimising the amount of extra data that gets copied around by
 *   the Unix kernel.  If the blocks are smaller it'll go faster...
 *
 * It helps efficiency very, very slightly if these are a power of two
 * bytes, as then they never cross Unix block boundaries.
 *
 */
#endif

/**** Some useful macros */

/* STREQ(a,b) is much faster than strcmp() in the (common) case that the
 * first character of the strings differ.
 * It is due (as far as I know) to Henry Spencer, at the University of
 * Toronto Zoology Dept.,
 * utzoo!henry
 */
#ifndef STREQ
# define STREQ(henry,utzoo) (*(henry) == *(utzoo) && !strcmp(henry, utzoo))
#endif

/* Inline functions are functions that get expanded inline during
 * compilation -- sort of like macros with real local arguments.
 * Not all compilers support them.
 */
#ifdef __GNUC__
#  define INLINE inline
#else
#  define INLINE /* not supported */
#endif

#ifdef DefineThem
# define DECL(name, type, value)   type name = value
# define EXTERN /* just define them please */
#else
# define EXTERN extern /* declare but do not define */
# define DECL(name, type, value)   EXTERN type name
#endif

/****/

/* Now declare (or define) things: */

extern char *progname; /* from progname.c, for error messages */
DECL(CommonWordFile, char *, DFLTCOMMONFILE); 
DECL(DatabaseDir, char *, LQTEXTDIR); 
DECL(FileIndex, char *, FILEINDEX);
DECL(WordIndex, char *, WORDINDEX);
DECL(DataBase, char *, DATABASE);
DECL(FidFile, char *, FIDFILE);
DECL(WidFile, char *, WIDFILE);
DECL(WidIndexFile, char *, WIDINDEXFILE);
DECL(DocPath, char *, DFLTDOCPATH); 

/*
 * $Log:	globals.h,v $
 * Revision 1.6  91/02/20  19:26:53  lee
 * Added NEEDALIGN on mips systems
 * (thanks to Mark Moraes, moraes@cs.toronto.edu)
 * 
 * Revision 1.5  90/10/07  20:41:20  lee
 * Added NEEDALIGN for fussy architectures.
 * 
 * Revision 1.4  90/10/06  02:21:21  lee
 * Prepared for first beta release.
 * 
 * Revision 1.3  90/10/03  21:31:54  lee
 * Added definition of PAGER, which has moved here from lqshow.c
 * 
 * Revision 1.2  90/08/09  19:15:03  lee
 * after BSD lint and saber-C
 * 
 * Revision 1.1  90/03/23  17:32:11  lee
 * Initial revision
 * 
 *
 */
