/* filter.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* filter.h -- define filter table for NX-Text, Liam Quin's text retrieval
 * program.
 * This table is built from a file like a simplified /etc/magic, normally
 * stored in /usr/local/lib/nx-text/lib/filtertable
 * but you can set this either here or in the Makefile.
 *
 * NEEDS: stdio.h
 *
 * $Id: filter.h,v 1.6 91/03/02 18:45:04 lee Rel1-10 $
 *
 * $Log:	filter.h,v $
 * Revision 1.6  91/03/02  18:45:04  lee
 * Spell MAILFILTER correctly in the ifdef...
 * 
 * Revision 1.5  90/10/13  03:11:31  lee
 * Now defines filters for easier stand-alone testing of stuff...
 * 
 * Revision 1.4  90/10/06  02:18:28  lee
 * Prepared for first beta release.
 * 
 * Revision 1.3  90/09/28  23:03:16  lee
 * Now use MAILFILTER and NEWSFILTER...
 * 
 * Revision 1.2  90/08/29  21:57:57  lee
 * removed most of the testing code
 * 
 * Revision 1.1  90/08/09  19:15:01  lee
 * Initial revision
 * 
 * Revision 2.2  89/10/08  20:46:04  lee
 * Working version of nx-text engine.  Addfile and wordinfo work OK.
 * 
 * Revision 2.1  89/10/02  01:14:33  lee
 * New index format, with Block/WordInBlock/Flags/BytesSkipped info.
 * 
 *
 */

#define FTYPE_NEWS  1
#define FTYPE_MAIL  2
#define FTYPE_CDMS  3
#define FTYPE_MOSTLYASCII 4
#define FTYPE_C_SOURCE 5

/* The Type field in each array entry is so that I can do some very simple
 * checking...
 */
extern int fclose(), pclose();
struct s_FilterTable {
    int Type;
    int (* close)(); /* how to close the darned stream */
    char *String;
};
#ifndef FILTERDEF
extern struct s_FilterTable FilterTable[];
#else
struct s_FilterTable FilterTable[] = {
    { 0, fclose, 0 }, /* use fopen() */
#ifndef NEWSFILTER
# define NEWSFILTER "NewsFilter"
#endif
    { FTYPE_NEWS, pclose, NEWSFILTER },
#ifndef MAILFILTER
# define MAILFILTER "MailFilter"
#endif
    { FTYPE_MAIL, pclose, MAILFILTER },
#ifdef FTYPE_CDMS /* CrystalWriter from Syntactics... */
    { FTYPE_CDMS, pclose, "CDMSFilter" },
#endif
#ifdef FTYPE_NTROFF
    { FTYPE_NTROFF, pclose, "lqderoff" }, /* not yet released, sorry */
#endif
    { FTYPE_MOSTLYASCII, pclose, "AsciiFilter" },
#ifdef FTYPE_C_SOURCE
    { FTYPE_C_SOURCE, pclose, "CFilter" }, /* leave me last! */
#endif
    /* If you add more, you MUST update MaxFilterType */
    { 0, 0, 0 }
};
#endif
#define MaxFilterType FTYPE_C_SOURCE
