/* fileinfo.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* Internal structure used by NX-Text to represent a word */

/* Needs: sys/types.h */

/* $Id: fileinfo.h,v 1.2 90/10/06 02:18:27 lee Rel1-10 $
 *
 * $Log:	fileinfo.h,v $
 * Revision 1.2  90/10/06  02:18:27  lee
 * Prepared for first beta release.
 * 
 * Revision 1.1  90/08/09  19:14:57  lee
 * Initial revision
 * 
 * Revision 2.2  89/10/08  20:45:57  lee
 * Working version of nx-text engine.  Addfile and wordinfo work OK.
 * 
 * Revision 2.1  89/10/02  01:14:29  lee
 * New index format, with Block/WordInBlock/Flags/BytesSkipped info.
 * 
 * Revision 1.2  89/09/16  21:15:19  lee
 * First demonstratable version.
 * 
 * Revision 1.1  89/09/07  21:00:34  lee
 * Initial revision
 * 
 *
 */

typedef unsigned long t_FID;

typedef struct {
    char *Name;
    t_FID FID; /* File Identifier */
    int FilterType; /* command to ASCIIify, 0 unknown, 1 none */
    time_t Date; /* when the file was last indexed */
    FILE *Stream;
} t_FileInfo;

#define FindFile(name) ((*(name) == '/') ? (name) : _FindFile(name))
extern char *_FindFile();
