/* FilterMain.c -- Copyright 1989, 1990 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* $Id: FilterMain.c,v 1.3 90/10/06 00:57:16 lee Rel1-10 $
 */

/* FilterMain is intended to make writing filters easier; one
 * simply writes the Filter() routine and links with FilterMain.o to
 * produce a new filter.
 *
 * The filter should use "wordrules.h", and should transform its input
 * into words, spaces and newlines, with all other characters turnded into
 * spaces.
 *
 * A simple filter might be something like (on System V):
 *
 *	system("tr -c '[a-z][A-Z][0-9]_' '[ *]'");
 *
 * except that a word shouldn't start with a digit or _.
 *
 * Addfile itself maps upper case to lower, and may also check on the length
 * of words (min is currently 3, max 20, for example).
 *
 * A News or Mail filter might delete things from the header (turning them
 * into spaces to preserve file offsets), so that the index doesn't fill
 * up with ihnp4!decwrl!seismo!utzoo!henry everwhere.  Of course, it
 * would retain the utzoo!henry at the end of the From line.
 *
 * A filter for the Crystal Word Processor might turn accented characters
 * into their ASCII non-accented equivalents, (although NX-Text is 8-bit
 * transparent, so one could also decide to use an 8-bit character set),
 * and remove style information, non-local object banners, etc.
 *
 * This file must fork "compress -d" if appropriate, to read compressed files.
 * Note -- compress -d is the same as uncompress, but more likely to work.
 * Some sites also have zcat, but this is even rarer.
 *
 */

/** Unix system calls used in this file: **/
extern void exit();
/** C Library functions used in this file: **/
extern void perror();

#include <stdio.h>

char *progname;
void Filter();

extern int AsciiTrace;

int
main(ac, av)
    int ac;
    char *av[];
{
    progname = av[0];

    if (ac ==1) {
	Filter(stdin, "(standard input)");
    } else {
	while (--ac) {
	    FILE *f = fopen(*++av, "r");

	    if (f == (FILE *) 0) {
		fprintf(stderr, "%s: can't open ", progname);
		perror(*av);
		exit(1);
	    }

	    Filter(f, *av);

	    (void) fclose(f);
	}
    }
    return 0;
}

/*
 * $Log:	FilterMain.c,v $
 * Revision 1.3  90/10/06  00:57:16  lee
 * Prepared for first beta release.
 * 
 * Revision 1.2  90/09/20  18:32:39  lee
 * Removed extra variable declarations...
 * 
 * Revision 1.1  90/08/09  19:17:54  lee
 * Initial revision
 * 
 * Revision 1.2  89/09/16  21:15:58  lee
 * First demonstratable version.
 * 
 * Revision 1.1  89/09/07  21:01:54  lee
 * Initial revision
 * 
 */
