#!PERL

#       netdbm - generate a DBM file from an ASCII dbase file
#
#	$RCSfile: netdbm.pl,v $
#	$Revision: 0.15 $
#	$Author: marten $
#	$Date: 1994/12/16 11:07:24 $
#

@INC = ("LIBDIR", @INC);

if (!$ARGV[0]) {
	print STDERR "Usage: $0 [-c [-p]] [-V] dbfile\n";
	print STDERR "Where:\n";
	print STDERR "-c\tindex database classless style only\n";
	print STDERR "-p\tprime classless indexed database\n";
	print STDERR "-V\tbe verbose\n";
	exit 0;
}

require "rconf.pl";
require "dbopen.pl";
require "dbclose.pl";
require "donetdbm.pl";
require "cldb.pl";
require "getopts.pl";
require "syslog.pl";

&Getopts('cpV');

local($conffile) = $ENV{"RIPEDBCNF"};
$conffile = "DEFCONFIG" unless $conffile;

&rconf($conffile);

# Remove the old indexes, otherwise it will append

if ($opt_c) {
    unlink("$ARGV[0].cl.pag");
    unlink("$ARGV[0].cl.dir");
} else {
    unlink("$ARGV[0].pag");
    unlink("$ARGV[0].dir");
}

%nothing = ();

# Fiddle with the lock file, this should go out as soon as we run
# production

$ARGV[0] =~ /([^\/]+)$/;
local($fileext) = $1;

# $lockfile = "$CLEANLOCK.$fileext";
# unlink($lockfile);

if (&dbopen("database",*nothing,1, $ARGV[0])) {

# More fiddling with the lockfile

#    open(AAP, ">$lockfile");
#    print AAP $$;
#    close(AAP);


    local(*db) = 'database';
    
    if ($opt_c) {
	&dbclopen(*nothing,1,$ARGV[0]);
	&docldbm(*db);
	&dbclclose();
    } else {
	&donetdbm(*db);
    }
    
    &dbclose(*db);
}
else {
    print STDERR "$0: error opening \"$ARGV[0]\"\n";
    exit 0;
}
