/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.pgp.FormatException;
import cryptix.pgp.Packet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;

abstract class Certificate
extends Packet {
    private static final byte VERSION = 2;
    private static final int LENGTH = 7;
    private static final int ONE_DAY = 86400000;
    protected transient Date timeStamp;
    protected int unixTime;
    protected int daysValid;
    protected byte version;

    Certificate() {
        this(new Date(), 0);
    }

    Certificate(Date date, int n) {
        this.version = (byte)2;
        this.timeStamp = date;
        this.daysValid = n;
        this.unixTime = (int)(this.timeStamp.getTime() / 1000L);
    }

    Certificate(DataInput dataInput, int n) throws IOException {
        super(dataInput, n);
    }

    public void read(DataInput dataInput, int n) throws IOException {
        if (n < 7) {
            throw new FormatException("Length too short.");
        }
        this.version = dataInput.readByte();
        this.unixTime = dataInput.readInt();
        this.timeStamp = new Date(((long)this.unixTime & 0xFFFFFFFFL) * 1000L);
        this.daysValid = dataInput.readShort();
    }

    public int write(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.version);
        dataOutput.writeInt(this.unixTime);
        dataOutput.writeShort(this.daysValid);
        return 7;
    }

    public String toString() {
        return "version: " + this.version + " created:" + this.timeStamp + " valid for" + (this.daysValid == 0 ? "ever" : " " + this.daysValid + " days");
    }

    public Date validUntil() {
        if (this.daysValid == 0) {
            return null;
        }
        return new Date(this.timeStamp.getTime() + (long)this.daysValid * 86400000L);
    }

    public boolean expired() {
        Date date = this.validUntil();
        if (date == null) {
            return false;
        }
        return new Date().after(date);
    }

    public int getType() {
        return 6;
    }
}

