/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import java.security.Cipher;
import java.security.FeedbackCipher;
import java.security.Key;
import java.security.SecretKey;

class TestSAFER
extends BaseTest {
    private static byte[] input = new byte[288];
    private static final byte[] anIV = new byte[]{116, 83, 110, -67, -62, 17, 72, 74};
    private SecretKey aKey;

    public static void main(String[] stringArray) {
        new TestSAFER().commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        int n;
        this.setExpectedPasses(17);
        byte[] byArray = new byte[]{66, 67, 27, -92, 13, 41, 31, -127, -42, 96, -125, -58, 5, -45, -92, -42};
        this.aKey = new RawSecretKey("SAFER", byArray);
        int n2 = 0;
        while (n2 < 2) {
            n = 1;
            while (n < 9) {
                TestSAFER.input[16 * n2 + n + 7] = (byte)n;
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < 256) {
            TestSAFER.input[32 + n] = (byte)n;
            ++n;
        }
        this.out.println("input data\n" + Hex.dumpString((byte[])input));
        this.test1();
        this.test2();
        this.test3();
        this.test4();
        this.test5();
        this.test6();
        this.test7();
        this.test8();
        this.test8B();
        this.test8C();
        this.test8E();
        this.test9();
        this.test10();
        this.test11();
    }

    private void test1() throws Exception {
        int[] nArray = new int[288];
        nArray[0] = 3;
        nArray[1] = 40;
        nArray[2] = 8;
        nArray[3] = 201;
        nArray[4] = 14;
        nArray[5] = 231;
        nArray[6] = 171;
        nArray[7] = 127;
        nArray[8] = 125;
        nArray[9] = 40;
        nArray[10] = 3;
        nArray[11] = 134;
        nArray[12] = 51;
        nArray[13] = 185;
        nArray[14] = 46;
        nArray[15] = 180;
        nArray[16] = 3;
        nArray[17] = 40;
        nArray[18] = 8;
        nArray[19] = 201;
        nArray[20] = 14;
        nArray[21] = 231;
        nArray[22] = 171;
        nArray[23] = 127;
        nArray[24] = 125;
        nArray[25] = 40;
        nArray[26] = 3;
        nArray[27] = 134;
        nArray[28] = 51;
        nArray[29] = 185;
        nArray[30] = 46;
        nArray[31] = 180;
        nArray[32] = 145;
        nArray[33] = 193;
        nArray[34] = 218;
        nArray[35] = 242;
        nArray[36] = 149;
        nArray[37] = 199;
        nArray[38] = 15;
        nArray[39] = 163;
        nArray[40] = 25;
        nArray[41] = 207;
        nArray[42] = 49;
        nArray[43] = 154;
        nArray[44] = 65;
        nArray[45] = 22;
        nArray[46] = 246;
        nArray[47] = 7;
        nArray[48] = 222;
        nArray[49] = 135;
        nArray[50] = 141;
        nArray[51] = 58;
        nArray[52] = 225;
        nArray[53] = 131;
        nArray[54] = 75;
        nArray[55] = 71;
        nArray[56] = 89;
        nArray[57] = 235;
        nArray[58] = 249;
        nArray[59] = 44;
        nArray[60] = 127;
        nArray[61] = 227;
        nArray[62] = 181;
        nArray[63] = 69;
        nArray[64] = 159;
        nArray[65] = 12;
        nArray[66] = 78;
        nArray[67] = 64;
        nArray[68] = 221;
        nArray[69] = 251;
        nArray[70] = 20;
        nArray[71] = 32;
        nArray[72] = 119;
        nArray[73] = 184;
        nArray[74] = 78;
        nArray[75] = 136;
        nArray[76] = 10;
        nArray[77] = 2;
        nArray[78] = 106;
        nArray[79] = 193;
        nArray[80] = 143;
        nArray[81] = 74;
        nArray[82] = 196;
        nArray[83] = 156;
        nArray[84] = 26;
        nArray[85] = 228;
        nArray[86] = 156;
        nArray[87] = 155;
        nArray[88] = 251;
        nArray[89] = 162;
        nArray[90] = 156;
        nArray[91] = 195;
        nArray[92] = 133;
        nArray[93] = 136;
        nArray[94] = 151;
        nArray[95] = 164;
        nArray[96] = 7;
        nArray[97] = 189;
        nArray[98] = 49;
        nArray[99] = 125;
        nArray[100] = 68;
        nArray[101] = 77;
        nArray[102] = 106;
        nArray[103] = 185;
        nArray[104] = 12;
        nArray[105] = 206;
        nArray[106] = 130;
        nArray[107] = 131;
        nArray[108] = 69;
        nArray[109] = 124;
        nArray[110] = 179;
        nArray[111] = 4;
        nArray[112] = 5;
        nArray[113] = 19;
        nArray[114] = 191;
        nArray[115] = 12;
        nArray[116] = 223;
        nArray[117] = 108;
        nArray[118] = 112;
        nArray[119] = 79;
        nArray[120] = 171;
        nArray[121] = 62;
        nArray[122] = 108;
        nArray[123] = 206;
        nArray[124] = 116;
        nArray[125] = 117;
        nArray[126] = 67;
        nArray[127] = 115;
        nArray[128] = 96;
        nArray[129] = 119;
        nArray[130] = 81;
        nArray[131] = 7;
        nArray[132] = 167;
        nArray[133] = 42;
        nArray[134] = 84;
        nArray[135] = 64;
        nArray[136] = 251;
        nArray[137] = 182;
        nArray[138] = 224;
        nArray[139] = 42;
        nArray[140] = 5;
        nArray[141] = 204;
        nArray[142] = 31;
        nArray[143] = 169;
        nArray[144] = 157;
        nArray[145] = 122;
        nArray[146] = 237;
        nArray[147] = 33;
        nArray[148] = 196;
        nArray[149] = 183;
        nArray[150] = 241;
        nArray[151] = 50;
        nArray[152] = 125;
        nArray[153] = 221;
        nArray[154] = 74;
        nArray[155] = 87;
        nArray[156] = 198;
        nArray[157] = 143;
        nArray[158] = 128;
        nArray[159] = 131;
        nArray[160] = 240;
        nArray[161] = 168;
        nArray[162] = 59;
        nArray[163] = 136;
        nArray[164] = 63;
        nArray[165] = 211;
        nArray[166] = 116;
        nArray[167] = 117;
        nArray[168] = 93;
        nArray[169] = 13;
        nArray[170] = 180;
        nArray[171] = 15;
        nArray[172] = 216;
        nArray[173] = 25;
        nArray[174] = 39;
        nArray[175] = 243;
        nArray[176] = 204;
        nArray[177] = 51;
        nArray[178] = 23;
        nArray[179] = 62;
        nArray[180] = 218;
        nArray[181] = 100;
        nArray[182] = 194;
        nArray[183] = 254;
        nArray[184] = 138;
        nArray[185] = 60;
        nArray[186] = 153;
        nArray[187] = 12;
        nArray[188] = 141;
        nArray[189] = 112;
        nArray[190] = 67;
        nArray[191] = 189;
        nArray[192] = 52;
        nArray[193] = 19;
        nArray[194] = 188;
        nArray[195] = 96;
        nArray[196] = 221;
        nArray[197] = 105;
        nArray[198] = 239;
        nArray[199] = 51;
        nArray[200] = 136;
        nArray[201] = 244;
        nArray[202] = 210;
        nArray[203] = 250;
        nArray[204] = 24;
        nArray[205] = 224;
        nArray[206] = 181;
        nArray[207] = 103;
        nArray[208] = 74;
        nArray[209] = 22;
        nArray[210] = 174;
        nArray[211] = 213;
        nArray[212] = 84;
        nArray[213] = 134;
        nArray[214] = 59;
        nArray[215] = 146;
        nArray[216] = 195;
        nArray[217] = 129;
        nArray[218] = 144;
        nArray[219] = 255;
        nArray[220] = 209;
        nArray[221] = 179;
        nArray[222] = 88;
        nArray[223] = 219;
        nArray[224] = 130;
        nArray[225] = 133;
        nArray[226] = 36;
        nArray[227] = 133;
        nArray[228] = 12;
        nArray[229] = 70;
        nArray[230] = 104;
        nArray[231] = 64;
        nArray[232] = 18;
        nArray[233] = 157;
        nArray[234] = 66;
        nArray[235] = 244;
        nArray[236] = 86;
        nArray[237] = 129;
        nArray[238] = 171;
        nArray[239] = 231;
        nArray[240] = 70;
        nArray[241] = 15;
        nArray[242] = 199;
        nArray[243] = 114;
        nArray[244] = 63;
        nArray[245] = 5;
        nArray[246] = 106;
        nArray[247] = 141;
        nArray[248] = 217;
        nArray[249] = 241;
        nArray[250] = 87;
        nArray[251] = 204;
        nArray[252] = 106;
        nArray[253] = 178;
        nArray[254] = 64;
        nArray[255] = 190;
        nArray[256] = 91;
        nArray[257] = 58;
        nArray[258] = 131;
        nArray[259] = 40;
        nArray[260] = 121;
        nArray[261] = 246;
        nArray[262] = 9;
        nArray[263] = 129;
        nArray[264] = 172;
        nArray[265] = 3;
        nArray[266] = 144;
        nArray[267] = 148;
        nArray[268] = 86;
        nArray[269] = 233;
        nArray[270] = 70;
        nArray[271] = 137;
        nArray[272] = 234;
        nArray[273] = 154;
        nArray[274] = 150;
        nArray[275] = 87;
        nArray[276] = 27;
        nArray[277] = 126;
        nArray[278] = 194;
        nArray[279] = 213;
        nArray[280] = 97;
        nArray[282] = 42;
        nArray[283] = 166;
        nArray[284] = 24;
        nArray[285] = 28;
        nArray[286] = 36;
        nArray[287] = 46;
        int[] nArray2 = nArray;
        this.out.println("\nSAFER in ECB mode: safer -e -ecb -kx 0000000000000000 -r 6\n");
        byte[] byArray = new byte[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            byArray[n] = (byte)nArray2[n];
            ++n;
        }
        Cipher cipher = Cipher.getInstance((String)"SAFER", (String)"Cryptix");
        cipher.setParameter("variant", (Object)"K-64");
        cipher.setParameter("rounds", (Object)new Integer(6));
        byte[] byArray2 = new byte[8];
        RawSecretKey rawSecretKey = new RawSecretKey("SAFER", byArray2);
        cipher.initEncrypt((Key)rawSecretKey);
        this.compareIt(cipher.crypt(input), byArray);
    }

    private void test2() throws Exception {
        int[] nArray = new int[288];
        nArray[0] = 90;
        nArray[1] = 178;
        nArray[2] = 127;
        nArray[3] = 114;
        nArray[4] = 20;
        nArray[5] = 163;
        nArray[6] = 58;
        nArray[7] = 225;
        nArray[8] = 53;
        nArray[9] = 216;
        nArray[10] = 27;
        nArray[11] = 187;
        nArray[12] = 244;
        nArray[13] = 86;
        nArray[14] = 143;
        nArray[15] = 221;
        nArray[16] = 90;
        nArray[17] = 178;
        nArray[18] = 127;
        nArray[19] = 114;
        nArray[20] = 20;
        nArray[21] = 163;
        nArray[22] = 58;
        nArray[23] = 225;
        nArray[24] = 53;
        nArray[25] = 216;
        nArray[26] = 27;
        nArray[27] = 187;
        nArray[28] = 244;
        nArray[29] = 86;
        nArray[30] = 143;
        nArray[31] = 221;
        nArray[32] = 176;
        nArray[33] = 77;
        nArray[34] = 205;
        nArray[35] = 34;
        nArray[36] = 113;
        nArray[37] = 253;
        nArray[38] = 45;
        nArray[39] = 100;
        nArray[40] = 117;
        nArray[41] = 35;
        nArray[42] = 111;
        nArray[43] = 82;
        nArray[44] = 245;
        nArray[45] = 22;
        nArray[46] = 192;
        nArray[47] = 247;
        nArray[48] = 113;
        nArray[49] = 229;
        nArray[50] = 207;
        nArray[51] = 127;
        nArray[52] = 8;
        nArray[53] = 58;
        nArray[54] = 89;
        nArray[55] = 197;
        nArray[56] = 53;
        nArray[57] = 111;
        nArray[58] = 112;
        nArray[59] = 44;
        nArray[60] = 199;
        nArray[61] = 250;
        nArray[62] = 129;
        nArray[63] = 97;
        nArray[64] = 22;
        nArray[65] = 45;
        nArray[66] = 118;
        nArray[67] = 143;
        nArray[68] = 36;
        nArray[69] = 19;
        nArray[70] = 175;
        nArray[71] = 42;
        nArray[72] = 17;
        nArray[73] = 98;
        nArray[74] = 225;
        nArray[75] = 143;
        nArray[76] = 245;
        nArray[77] = 22;
        nArray[78] = 92;
        nArray[79] = 104;
        nArray[80] = 30;
        nArray[81] = 78;
        nArray[82] = 11;
        nArray[83] = 197;
        nArray[84] = 233;
        nArray[85] = 245;
        nArray[86] = 156;
        nArray[87] = 211;
        nArray[88] = 252;
        nArray[89] = 128;
        nArray[90] = 59;
        nArray[91] = 102;
        nArray[92] = 39;
        nArray[93] = 106;
        nArray[94] = 52;
        nArray[95] = 201;
        nArray[96] = 36;
        nArray[97] = 150;
        nArray[98] = 88;
        nArray[99] = 51;
        nArray[100] = 99;
        nArray[101] = 193;
        nArray[102] = 250;
        nArray[103] = 199;
        nArray[104] = 101;
        nArray[105] = 188;
        nArray[106] = 204;
        nArray[107] = 108;
        nArray[108] = 195;
        nArray[109] = 158;
        nArray[110] = 4;
        nArray[111] = 16;
        nArray[112] = 64;
        nArray[113] = 14;
        nArray[114] = 12;
        nArray[115] = 4;
        nArray[116] = 69;
        nArray[117] = 77;
        nArray[118] = 87;
        nArray[119] = 174;
        nArray[120] = 179;
        nArray[121] = 168;
        nArray[122] = 218;
        nArray[123] = 211;
        nArray[124] = 98;
        nArray[125] = 49;
        nArray[126] = 250;
        nArray[127] = 255;
        nArray[128] = 108;
        nArray[129] = 197;
        nArray[130] = 119;
        nArray[131] = 252;
        nArray[132] = 139;
        nArray[133] = 188;
        nArray[134] = 188;
        nArray[135] = 69;
        nArray[136] = 111;
        nArray[137] = 126;
        nArray[138] = 135;
        nArray[139] = 26;
        nArray[140] = 214;
        nArray[141] = 89;
        nArray[142] = 66;
        nArray[143] = 223;
        nArray[144] = 89;
        nArray[145] = 23;
        nArray[146] = 144;
        nArray[147] = 219;
        nArray[148] = 71;
        nArray[149] = 139;
        nArray[150] = 62;
        nArray[151] = 28;
        nArray[152] = 168;
        nArray[153] = 72;
        nArray[154] = 23;
        nArray[155] = 84;
        nArray[156] = 206;
        nArray[157] = 185;
        nArray[158] = 152;
        nArray[159] = 189;
        nArray[160] = 224;
        nArray[162] = 3;
        nArray[163] = 206;
        nArray[164] = 49;
        nArray[165] = 73;
        nArray[166] = 65;
        nArray[167] = 167;
        nArray[168] = 192;
        nArray[169] = 241;
        nArray[170] = 81;
        nArray[171] = 40;
        nArray[172] = 12;
        nArray[173] = 142;
        nArray[174] = 229;
        nArray[175] = 74;
        nArray[176] = 4;
        nArray[177] = 186;
        nArray[178] = 59;
        nArray[179] = 173;
        nArray[180] = 112;
        nArray[181] = 219;
        nArray[182] = 152;
        nArray[183] = 96;
        nArray[184] = 6;
        nArray[185] = 40;
        nArray[186] = 84;
        nArray[187] = 232;
        nArray[188] = 152;
        nArray[189] = 173;
        nArray[190] = 91;
        nArray[191] = 48;
        nArray[192] = 65;
        nArray[193] = 34;
        nArray[194] = 12;
        nArray[195] = 56;
        nArray[196] = 92;
        nArray[197] = 127;
        nArray[198] = 196;
        nArray[199] = 80;
        nArray[200] = 104;
        nArray[201] = 37;
        nArray[202] = 133;
        nArray[203] = 26;
        nArray[204] = 77;
        nArray[205] = 151;
        nArray[206] = 103;
        nArray[207] = 250;
        nArray[208] = 83;
        nArray[209] = 94;
        nArray[210] = 214;
        nArray[211] = 100;
        nArray[212] = 211;
        nArray[213] = 196;
        nArray[214] = 211;
        nArray[215] = 86;
        nArray[216] = 176;
        nArray[217] = 148;
        nArray[218] = 84;
        nArray[219] = 52;
        nArray[220] = 16;
        nArray[221] = 98;
        nArray[222] = 181;
        nArray[223] = 167;
        nArray[224] = 171;
        nArray[225] = 165;
        nArray[226] = 176;
        nArray[227] = 131;
        nArray[228] = 34;
        nArray[229] = 234;
        nArray[230] = 253;
        nArray[231] = 245;
        nArray[232] = 243;
        nArray[233] = 229;
        nArray[234] = 190;
        nArray[235] = 104;
        nArray[236] = 135;
        nArray[237] = 12;
        nArray[238] = 178;
        nArray[239] = 255;
        nArray[240] = 88;
        nArray[241] = 83;
        nArray[242] = 26;
        nArray[243] = 197;
        nArray[244] = 13;
        nArray[245] = 87;
        nArray[246] = 161;
        nArray[247] = 25;
        nArray[248] = 152;
        nArray[249] = 13;
        nArray[250] = 132;
        nArray[251] = 120;
        nArray[252] = 232;
        nArray[253] = 132;
        nArray[254] = 144;
        nArray[255] = 232;
        nArray[256] = 238;
        nArray[257] = 120;
        nArray[258] = 80;
        nArray[259] = 141;
        nArray[260] = 244;
        nArray[261] = 81;
        nArray[262] = 238;
        nArray[263] = 133;
        nArray[264] = 178;
        nArray[265] = 195;
        nArray[266] = 161;
        nArray[267] = 51;
        nArray[268] = 196;
        nArray[269] = 174;
        nArray[270] = 204;
        nArray[271] = 11;
        nArray[272] = 79;
        nArray[273] = 48;
        nArray[274] = 86;
        nArray[275] = 90;
        nArray[276] = 145;
        nArray[277] = 237;
        nArray[278] = 144;
        nArray[279] = 173;
        nArray[280] = 117;
        nArray[281] = 144;
        nArray[282] = 116;
        nArray[283] = 74;
        nArray[284] = 226;
        nArray[285] = 113;
        nArray[286] = 221;
        nArray[287] = 90;
        int[] nArray2 = nArray;
        this.out.println("\nSAFER in ECB mode: safer -e -ecb -kx 0102030405060708 -r 6\n");
        byte[] byArray = new byte[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            byArray[n] = (byte)nArray2[n];
            ++n;
        }
        Cipher cipher = Cipher.getInstance((String)"SAFER", (String)"Cryptix");
        cipher.setParameter("variant", (Object)"K-64");
        cipher.setParameter("rounds", (Object)new Integer(6));
        byte[] byArray2 = new byte[8];
        int n2 = 1;
        while (n2 < 9) {
            byArray2[n2 - 1] = (byte)n2;
            ++n2;
        }
        RawSecretKey rawSecretKey = new RawSecretKey("SAFER", byArray2);
        cipher.initEncrypt((Key)rawSecretKey);
        this.compareIt(cipher.crypt(input), byArray);
    }

    private void test3() throws Exception {
        int[] nArray = new int[]{3, 92, 58, 98, 214, 251, 36, 18, 200, 242, 156, 221, 135, 120, 62, 217, 3, 92, 58, 98, 214, 251, 36, 18, 200, 242, 156, 221, 135, 120, 62, 217, 2, 200, 228, 89, 250, 111, 128, 147, 203, 125, 189, 26, 90, 50, 9, 146, 149, 78, 101, 142, 114, 229, 131, 2, 62, 174, 98, 110, 169, 197, 54, 63, 89, 85, 87, 223, 143, 246, 139, 69, 175, 47, 36, 136, 12, 214, 13, 29, 27, 37, 48, 227, 234, 251, 65, 118, 189, 249, 125, 187, 61, 95, 43, 165, 192, 19, 53, 236, 129, 201, 111, 186, 128, 238, 168, 161, 255, 185, 159, 60, 39, 215, 88, 181, 24, 210, 205, 138, 73, 233, 133, 129, 204, 192, 157, 89, 11, 204, 197, 13, 254, 57, 201, 86, 1, 104, 36, 93, 89, 167, 209, 28, 93, 108, 251, 66, 28, 190, 50, 250, 173, 10, 172, 104, 44, 220, 12, 66, 227, 252, 245, 29, 253, 71, 160, 74, 246, 140, 143, 29, 178, 92, 125, 196, 43, 64, 156, 229, 193, 21, 103, 211, 217, 196, 211, 32, 127, 150, 31, 19, 116, 226, 149, 154, 103, 37, 206, 37, 94, 65, 62, 89, 112, 69, 212, 173, 227, 86, 217, 69, 24, 157, 171, 91, 84, 105, 146, 134, 221, 99, 119, 167, 3, 38, 221, 132, 166, 194, 145, 244, 136, 58, 22, 218, 103, 85, 190, 178, 60, 157, 226, 234, 174, 78, 151, 117, 238, 127, 201, 155, 244, 3, 63, 66, 47, 145, 200, 239, 161, 113, 76, 233, 78, 142, 46, 172, 80, 1, 4, 9, 183, 25, 176, 250, 175, 216, 123, 45, 90, 108, 67, 187, 147, 57, 235, 25};
        this.out.println("\nSAFER in ECB mode: safer -e -ecb -kx 0807060504030201 -r 6\n");
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            byArray[n] = (byte)nArray[n];
            ++n;
        }
        Cipher cipher = Cipher.getInstance((String)"SAFER", (String)"Cryptix");
        cipher.setParameter("variant", (Object)"K-64");
        cipher.setParameter("rounds", (Object)new Integer(6));
        byte[] byArray2 = new byte[8];
        int n2 = 0;
        while (n2 < 8) {
            byArray2[n2] = (byte)(8 - n2);
            ++n2;
        }
        RawSecretKey rawSecretKey = new RawSecretKey("SAFER", byArray2);
        cipher.initEncrypt((Key)rawSecretKey);
        this.compareIt(cipher.crypt(input), byArray);
    }

    private void test4() throws Exception {
        int[] nArray = new int[288];
        nArray[0] = 193;
        nArray[1] = 162;
        nArray[2] = 137;
        nArray[3] = 119;
        nArray[4] = 71;
        nArray[5] = 111;
        nArray[6] = 4;
        nArray[7] = 122;
        nArray[8] = 221;
        nArray[9] = 53;
        nArray[10] = 132;
        nArray[11] = 163;
        nArray[12] = 31;
        nArray[13] = 251;
        nArray[14] = 91;
        nArray[15] = 187;
        nArray[16] = 193;
        nArray[17] = 162;
        nArray[18] = 137;
        nArray[19] = 119;
        nArray[20] = 71;
        nArray[21] = 111;
        nArray[22] = 4;
        nArray[23] = 122;
        nArray[24] = 221;
        nArray[25] = 53;
        nArray[26] = 132;
        nArray[27] = 163;
        nArray[28] = 31;
        nArray[29] = 251;
        nArray[30] = 91;
        nArray[31] = 187;
        nArray[32] = 200;
        nArray[33] = 7;
        nArray[34] = 221;
        nArray[35] = 209;
        nArray[36] = 159;
        nArray[37] = 188;
        nArray[38] = 204;
        nArray[39] = 148;
        nArray[40] = 108;
        nArray[41] = 182;
        nArray[42] = 178;
        nArray[43] = 60;
        nArray[44] = 21;
        nArray[45] = 6;
        nArray[46] = 172;
        nArray[47] = 3;
        nArray[48] = 135;
        nArray[49] = 38;
        nArray[50] = 14;
        nArray[51] = 54;
        nArray[52] = 116;
        nArray[53] = 19;
        nArray[54] = 125;
        nArray[55] = 236;
        nArray[56] = 12;
        nArray[57] = 65;
        nArray[58] = 190;
        nArray[59] = 138;
        nArray[60] = 183;
        nArray[61] = 64;
        nArray[62] = 84;
        nArray[63] = 94;
        nArray[64] = 211;
        nArray[65] = 57;
        nArray[66] = 211;
        nArray[67] = 91;
        nArray[68] = 134;
        nArray[69] = 90;
        nArray[70] = 189;
        nArray[71] = 173;
        nArray[72] = 198;
        nArray[73] = 52;
        nArray[74] = 54;
        nArray[75] = 78;
        nArray[76] = 218;
        nArray[77] = 211;
        nArray[78] = 10;
        nArray[79] = 64;
        nArray[80] = 160;
        nArray[81] = 250;
        nArray[82] = 24;
        nArray[83] = 252;
        nArray[84] = 43;
        nArray[85] = 62;
        nArray[86] = 176;
        nArray[87] = 51;
        nArray[88] = 229;
        nArray[89] = 82;
        nArray[90] = 255;
        nArray[91] = 241;
        nArray[92] = 155;
        nArray[93] = 211;
        nArray[94] = 23;
        nArray[95] = 185;
        nArray[96] = 144;
        nArray[97] = 30;
        nArray[98] = 255;
        nArray[99] = 20;
        nArray[100] = 82;
        nArray[101] = 191;
        nArray[102] = 37;
        nArray[103] = 197;
        nArray[104] = 241;
        nArray[105] = 45;
        nArray[106] = 53;
        nArray[107] = 149;
        nArray[108] = 201;
        nArray[109] = 159;
        nArray[110] = 67;
        nArray[111] = 72;
        nArray[112] = 56;
        nArray[113] = 230;
        nArray[114] = 77;
        nArray[115] = 191;
        nArray[116] = 110;
        nArray[117] = 15;
        nArray[118] = 137;
        nArray[119] = 110;
        nArray[120] = 125;
        nArray[121] = 143;
        nArray[122] = 1;
        nArray[123] = 74;
        nArray[124] = 144;
        nArray[125] = 36;
        nArray[126] = 128;
        nArray[127] = 254;
        nArray[128] = 42;
        nArray[129] = 66;
        nArray[130] = 86;
        nArray[131] = 239;
        nArray[132] = 123;
        nArray[133] = 207;
        nArray[134] = 118;
        nArray[135] = 129;
        nArray[136] = 79;
        nArray[137] = 15;
        nArray[138] = 246;
        nArray[139] = 165;
        nArray[140] = 44;
        nArray[141] = 92;
        nArray[142] = 253;
        nArray[143] = 96;
        nArray[144] = 229;
        nArray[145] = 105;
        nArray[146] = 211;
        nArray[147] = 191;
        nArray[148] = 109;
        nArray[149] = 129;
        nArray[150] = 236;
        nArray[151] = 199;
        nArray[152] = 134;
        nArray[153] = 174;
        nArray[154] = 205;
        nArray[155] = 197;
        nArray[156] = 236;
        nArray[157] = 183;
        nArray[158] = 160;
        nArray[159] = 119;
        nArray[160] = 39;
        nArray[161] = 48;
        nArray[162] = 34;
        nArray[163] = 113;
        nArray[164] = 23;
        nArray[165] = 99;
        nArray[166] = 138;
        nArray[167] = 156;
        nArray[168] = 241;
        nArray[169] = 88;
        nArray[170] = 87;
        nArray[171] = 154;
        nArray[172] = 155;
        nArray[173] = 138;
        nArray[174] = 208;
        nArray[175] = 73;
        nArray[176] = 76;
        nArray[177] = 235;
        nArray[178] = 164;
        nArray[179] = 163;
        nArray[180] = 78;
        nArray[181] = 161;
        nArray[182] = 71;
        nArray[183] = 16;
        nArray[184] = 35;
        nArray[185] = 35;
        nArray[186] = 55;
        nArray[187] = 87;
        nArray[189] = 148;
        nArray[190] = 112;
        nArray[191] = 232;
        nArray[192] = 98;
        nArray[193] = 175;
        nArray[194] = 26;
        nArray[195] = 239;
        nArray[196] = 137;
        nArray[197] = 77;
        nArray[198] = 16;
        nArray[199] = 106;
        nArray[200] = 26;
        nArray[201] = 246;
        nArray[202] = 43;
        nArray[203] = 38;
        nArray[204] = 237;
        nArray[205] = 84;
        nArray[206] = 201;
        nArray[207] = 35;
        nArray[208] = 213;
        nArray[209] = 220;
        nArray[210] = 132;
        nArray[211] = 203;
        nArray[212] = 53;
        nArray[213] = 48;
        nArray[214] = 202;
        nArray[215] = 119;
        nArray[216] = 192;
        nArray[217] = 74;
        nArray[218] = 167;
        nArray[219] = 216;
        nArray[220] = 1;
        nArray[221] = 111;
        nArray[222] = 138;
        nArray[223] = 10;
        nArray[224] = 25;
        nArray[225] = 68;
        nArray[226] = 167;
        nArray[227] = 158;
        nArray[228] = 226;
        nArray[229] = 226;
        nArray[230] = 255;
        nArray[231] = 64;
        nArray[232] = 179;
        nArray[233] = 148;
        nArray[234] = 31;
        nArray[235] = 8;
        nArray[236] = 78;
        nArray[237] = 243;
        nArray[238] = 131;
        nArray[239] = 146;
        nArray[240] = 144;
        nArray[241] = 89;
        nArray[242] = 114;
        nArray[243] = 186;
        nArray[244] = 228;
        nArray[245] = 43;
        nArray[246] = 99;
        nArray[247] = 173;
        nArray[248] = 198;
        nArray[249] = 192;
        nArray[250] = 243;
        nArray[251] = 9;
        nArray[252] = 44;
        nArray[253] = 153;
        nArray[254] = 27;
        nArray[255] = 235;
        nArray[256] = 6;
        nArray[257] = 33;
        nArray[258] = 118;
        nArray[259] = 4;
        nArray[260] = 173;
        nArray[261] = 100;
        nArray[262] = 48;
        nArray[263] = 242;
        nArray[264] = 92;
        nArray[265] = 98;
        nArray[266] = 216;
        nArray[267] = 213;
        nArray[268] = 149;
        nArray[269] = 225;
        nArray[270] = 238;
        nArray[271] = 128;
        nArray[272] = 198;
        nArray[273] = 93;
        nArray[274] = 197;
        nArray[275] = 243;
        nArray[276] = 203;
        nArray[277] = 210;
        nArray[278] = 227;
        nArray[279] = 203;
        nArray[280] = 191;
        nArray[281] = 225;
        nArray[282] = 181;
        nArray[283] = 137;
        nArray[284] = 184;
        nArray[285] = 73;
        nArray[286] = 136;
        nArray[287] = 66;
        int[] nArray2 = nArray;
        this.out.println("\nSAFER in ECB mode: safer -e -ecb -kx 08070605040302010807060504030201 -r 12\n");
        byte[] byArray = new byte[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            byArray[n] = (byte)nArray2[n];
            ++n;
        }
        Cipher cipher = Cipher.getInstance((String)"SAFER", (String)"Cryptix");
        cipher.setParameter("variant", (Object)"K-128");
        cipher.setParameter("rounds", (Object)new Integer(12));
        byte[] byArray2 = new byte[16];
        int n2 = 0;
        while (n2 < 8) {
            byte by = (byte)(8 - n2);
            byArray2[8 + n2] = by;
            byArray2[n2] = by;
            ++n2;
        }
        RawSecretKey rawSecretKey = new RawSecretKey("SAFER", byArray2);
        cipher.initEncrypt((Key)rawSecretKey);
        this.compareIt(cipher.crypt(input), byArray);
    }

    private void test5() throws Exception {
        int[] nArray = new int[288];
        nArray[0] = 18;
        nArray[1] = 137;
        nArray[2] = 3;
        nArray[3] = 44;
        nArray[4] = 179;
        nArray[5] = 185;
        nArray[6] = 93;
        nArray[7] = 230;
        nArray[8] = 127;
        nArray[9] = 241;
        nArray[10] = 49;
        nArray[11] = 31;
        nArray[12] = 136;
        nArray[13] = 105;
        nArray[14] = 240;
        nArray[15] = 21;
        nArray[16] = 18;
        nArray[17] = 137;
        nArray[18] = 3;
        nArray[19] = 44;
        nArray[20] = 179;
        nArray[21] = 185;
        nArray[22] = 93;
        nArray[23] = 230;
        nArray[24] = 127;
        nArray[25] = 241;
        nArray[26] = 49;
        nArray[27] = 31;
        nArray[28] = 136;
        nArray[29] = 105;
        nArray[30] = 240;
        nArray[31] = 21;
        nArray[32] = 90;
        nArray[33] = 66;
        nArray[34] = 146;
        nArray[35] = 57;
        nArray[36] = 213;
        nArray[37] = 20;
        nArray[38] = 160;
        nArray[39] = 29;
        nArray[40] = 97;
        nArray[41] = 17;
        nArray[42] = 200;
        nArray[43] = 117;
        nArray[44] = 225;
        nArray[45] = 187;
        nArray[46] = 79;
        nArray[47] = 170;
        nArray[48] = 248;
        nArray[49] = 157;
        nArray[50] = 7;
        nArray[51] = 200;
        nArray[52] = 220;
        nArray[53] = 237;
        nArray[54] = 22;
        nArray[55] = 209;
        nArray[56] = 88;
        nArray[57] = 114;
        nArray[58] = 63;
        nArray[59] = 233;
        nArray[60] = 77;
        nArray[61] = 121;
        nArray[62] = 72;
        nArray[63] = 88;
        nArray[64] = 210;
        nArray[65] = 88;
        nArray[66] = 247;
        nArray[67] = 213;
        nArray[68] = 135;
        nArray[69] = 182;
        nArray[70] = 73;
        nArray[71] = 127;
        nArray[72] = 253;
        nArray[73] = 46;
        nArray[74] = 224;
        nArray[75] = 20;
        nArray[76] = 23;
        nArray[77] = 240;
        nArray[78] = 166;
        nArray[79] = 236;
        nArray[80] = 105;
        nArray[81] = 19;
        nArray[82] = 251;
        nArray[83] = 246;
        nArray[84] = 255;
        nArray[85] = 225;
        nArray[86] = 70;
        nArray[87] = 32;
        nArray[88] = 198;
        nArray[89] = 78;
        nArray[90] = 25;
        nArray[91] = 12;
        nArray[92] = 13;
        nArray[93] = 10;
        nArray[94] = 181;
        nArray[95] = 136;
        nArray[96] = 111;
        nArray[97] = 165;
        nArray[98] = 163;
        nArray[99] = 110;
        nArray[100] = 119;
        nArray[101] = 225;
        nArray[102] = 189;
        nArray[103] = 19;
        nArray[104] = 141;
        nArray[105] = 195;
        nArray[106] = 52;
        nArray[107] = 246;
        nArray[108] = 182;
        nArray[109] = 99;
        nArray[110] = 86;
        nArray[111] = 150;
        nArray[112] = 115;
        nArray[113] = 139;
        nArray[114] = 227;
        nArray[115] = 14;
        nArray[116] = 40;
        nArray[117] = 161;
        nArray[118] = 6;
        nArray[119] = 252;
        nArray[120] = 156;
        nArray[121] = 253;
        nArray[122] = 33;
        nArray[123] = 133;
        nArray[124] = 167;
        nArray[125] = 121;
        nArray[126] = 148;
        nArray[127] = 124;
        nArray[128] = 17;
        nArray[129] = 53;
        nArray[130] = 17;
        nArray[131] = 194;
        nArray[132] = 46;
        nArray[133] = 121;
        nArray[134] = 54;
        nArray[135] = 223;
        nArray[136] = 158;
        nArray[137] = 235;
        nArray[138] = 45;
        nArray[139] = 23;
        nArray[140] = 192;
        nArray[141] = 88;
        nArray[142] = 20;
        nArray[143] = 55;
        nArray[144] = 189;
        nArray[145] = 10;
        nArray[146] = 9;
        nArray[147] = 37;
        nArray[148] = 150;
        nArray[149] = 229;
        nArray[150] = 58;
        nArray[151] = 181;
        nArray[152] = 154;
        nArray[153] = 45;
        nArray[155] = 118;
        nArray[156] = 16;
        nArray[157] = 195;
        nArray[158] = 222;
        nArray[159] = 6;
        nArray[160] = 118;
        nArray[161] = 246;
        nArray[162] = 201;
        nArray[163] = 66;
        nArray[164] = 234;
        nArray[165] = 100;
        nArray[166] = 64;
        nArray[167] = 66;
        nArray[168] = 188;
        nArray[169] = 83;
        nArray[170] = 41;
        nArray[171] = 128;
        nArray[172] = 222;
        nArray[173] = 163;
        nArray[174] = 141;
        nArray[175] = 21;
        nArray[176] = 70;
        nArray[177] = 176;
        nArray[178] = 202;
        nArray[179] = 249;
        nArray[180] = 121;
        nArray[181] = 7;
        nArray[182] = 61;
        nArray[183] = 102;
        nArray[184] = 205;
        nArray[185] = 76;
        nArray[186] = 17;
        nArray[187] = 232;
        nArray[188] = 2;
        nArray[189] = 17;
        nArray[190] = 235;
        nArray[191] = 10;
        nArray[192] = 252;
        nArray[193] = 150;
        nArray[194] = 232;
        nArray[195] = 84;
        nArray[196] = 114;
        nArray[197] = 108;
        nArray[198] = 208;
        nArray[199] = 236;
        nArray[200] = 170;
        nArray[201] = 110;
        nArray[202] = 90;
        nArray[203] = 179;
        nArray[204] = 5;
        nArray[205] = 33;
        nArray[206] = 242;
        nArray[207] = 223;
        nArray[208] = 23;
        nArray[209] = 229;
        nArray[210] = 149;
        nArray[211] = 166;
        nArray[212] = 172;
        nArray[213] = 184;
        nArray[214] = 101;
        nArray[215] = 219;
        nArray[216] = 38;
        nArray[217] = 244;
        nArray[218] = 232;
        nArray[219] = 18;
        nArray[220] = 24;
        nArray[221] = 130;
        nArray[222] = 67;
        nArray[223] = 39;
        nArray[224] = 67;
        nArray[225] = 230;
        nArray[226] = 3;
        nArray[227] = 18;
        nArray[228] = 82;
        nArray[229] = 130;
        nArray[230] = 164;
        nArray[231] = 238;
        nArray[232] = 195;
        nArray[233] = 12;
        nArray[234] = 225;
        nArray[235] = 83;
        nArray[236] = 31;
        nArray[237] = 113;
        nArray[238] = 52;
        nArray[239] = 79;
        nArray[240] = 200;
        nArray[241] = 93;
        nArray[242] = 22;
        nArray[243] = 110;
        nArray[244] = 35;
        nArray[245] = 5;
        nArray[246] = 185;
        nArray[247] = 123;
        nArray[248] = 91;
        nArray[249] = 245;
        nArray[250] = 245;
        nArray[251] = 54;
        nArray[252] = 146;
        nArray[253] = 154;
        nArray[254] = 172;
        nArray[255] = 124;
        nArray[256] = 222;
        nArray[257] = 91;
        nArray[258] = 96;
        nArray[259] = 112;
        nArray[260] = 125;
        nArray[261] = 17;
        nArray[262] = 206;
        nArray[263] = 170;
        nArray[264] = 18;
        nArray[265] = 128;
        nArray[266] = 119;
        nArray[267] = 30;
        nArray[268] = 11;
        nArray[269] = 223;
        nArray[270] = 41;
        nArray[271] = 238;
        nArray[272] = 246;
        nArray[273] = 179;
        nArray[274] = 146;
        nArray[275] = 99;
        nArray[276] = 52;
        nArray[277] = 210;
        nArray[278] = 95;
        nArray[279] = 140;
        nArray[280] = 158;
        nArray[281] = 173;
        nArray[282] = 224;
        nArray[283] = 60;
        nArray[284] = 208;
        nArray[285] = 158;
        nArray[286] = 118;
        nArray[287] = 190;
        int[] nArray2 = nArray;
        this.out.println("\nSAFER in ECB mode: safer -e -ecb -kx 01020304050607080807060504030201 -r 12\n");
        byte[] byArray = new byte[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            byArray[n] = (byte)nArray2[n];
            ++n;
        }
        Cipher cipher = Cipher.getInstance((String)"SAFER", (String)"Cryptix");
        cipher.setParameter("variant", (Object)"K-128");
        cipher.setParameter("rounds", (Object)new Integer(12));
        byte[] byArray2 = new byte[16];
        int n2 = 0;
        while (n2 < 8) {
            byte by = (byte)(n2 + 1);
            byArray2[15 - n2] = by;
            byArray2[n2] = by;
            ++n2;
        }
        RawSecretKey rawSecretKey = new RawSecretKey("SAFER", byArray2);
        cipher.initEncrypt((Key)rawSecretKey);
        this.compareIt(cipher.crypt(input), byArray);
    }

    private void test6() throws Exception {
        int[] nArray = new int[288];
        nArray[0] = 251;
        nArray[1] = 144;
        nArray[2] = 115;
        nArray[3] = 211;
        nArray[4] = 68;
        nArray[5] = 87;
        nArray[6] = 59;
        nArray[7] = 12;
        nArray[8] = 21;
        nArray[9] = 27;
        nArray[10] = 255;
        nArray[11] = 2;
        nArray[12] = 173;
        nArray[13] = 17;
        nArray[14] = 191;
        nArray[15] = 45;
        nArray[16] = 251;
        nArray[17] = 144;
        nArray[18] = 115;
        nArray[19] = 211;
        nArray[20] = 68;
        nArray[21] = 87;
        nArray[22] = 59;
        nArray[23] = 12;
        nArray[24] = 21;
        nArray[25] = 27;
        nArray[26] = 255;
        nArray[27] = 2;
        nArray[28] = 173;
        nArray[29] = 17;
        nArray[30] = 191;
        nArray[31] = 45;
        nArray[32] = 229;
        nArray[33] = 117;
        nArray[34] = 85;
        nArray[35] = 247;
        nArray[36] = 74;
        nArray[37] = 153;
        nArray[38] = 163;
        nArray[39] = 85;
        nArray[40] = 206;
        nArray[41] = 201;
        nArray[42] = 191;
        nArray[43] = 54;
        nArray[44] = 204;
        nArray[45] = 202;
        nArray[46] = 90;
        nArray[47] = 44;
        nArray[48] = 14;
        nArray[49] = 245;
        nArray[50] = 31;
        nArray[51] = 156;
        nArray[52] = 84;
        nArray[53] = 150;
        nArray[54] = 204;
        nArray[55] = 139;
        nArray[56] = 229;
        nArray[57] = 23;
        nArray[58] = 225;
        nArray[59] = 47;
        nArray[60] = 154;
        nArray[61] = 235;
        nArray[62] = 35;
        nArray[63] = 238;
        nArray[64] = 112;
        nArray[65] = 249;
        nArray[66] = 114;
        nArray[67] = 21;
        nArray[68] = 162;
        nArray[69] = 199;
        nArray[70] = 168;
        nArray[71] = 244;
        nArray[72] = 120;
        nArray[73] = 175;
        nArray[74] = 114;
        nArray[75] = 205;
        nArray[76] = 14;
        nArray[77] = 104;
        nArray[78] = 178;
        nArray[79] = 57;
        nArray[80] = 93;
        nArray[81] = 59;
        nArray[82] = 252;
        nArray[83] = 73;
        nArray[84] = 34;
        nArray[85] = 161;
        nArray[86] = 109;
        nArray[87] = 125;
        nArray[88] = 72;
        nArray[90] = 40;
        nArray[91] = 87;
        nArray[92] = 137;
        nArray[93] = 72;
        nArray[94] = 206;
        nArray[95] = 118;
        nArray[96] = 239;
        nArray[97] = 96;
        nArray[98] = 232;
        nArray[99] = 157;
        nArray[100] = 143;
        nArray[101] = 171;
        nArray[102] = 180;
        nArray[103] = 46;
        nArray[104] = 112;
        nArray[105] = 194;
        nArray[106] = 16;
        nArray[107] = 200;
        nArray[108] = 111;
        nArray[109] = 135;
        nArray[110] = 159;
        nArray[111] = 41;
        nArray[112] = 144;
        nArray[113] = 137;
        nArray[114] = 177;
        nArray[115] = 229;
        nArray[116] = 60;
        nArray[117] = 50;
        nArray[118] = 245;
        nArray[119] = 33;
        nArray[120] = 248;
        nArray[121] = 206;
        nArray[122] = 90;
        nArray[123] = 198;
        nArray[124] = 166;
        nArray[125] = 6;
        nArray[126] = 27;
        nArray[127] = 197;
        nArray[128] = 125;
        nArray[129] = 101;
        nArray[130] = 158;
        nArray[131] = 44;
        nArray[132] = 132;
        nArray[133] = 176;
        nArray[134] = 113;
        nArray[135] = 88;
        nArray[136] = 173;
        nArray[137] = 224;
        nArray[138] = 16;
        nArray[139] = 183;
        nArray[140] = 6;
        nArray[141] = 201;
        nArray[142] = 162;
        nArray[143] = 225;
        nArray[144] = 154;
        nArray[145] = 190;
        nArray[146] = 44;
        nArray[147] = 133;
        nArray[148] = 190;
        nArray[149] = 45;
        nArray[150] = 118;
        nArray[151] = 20;
        nArray[152] = 235;
        nArray[153] = 196;
        nArray[154] = 169;
        nArray[155] = 198;
        nArray[156] = 194;
        nArray[157] = 92;
        nArray[158] = 242;
        nArray[159] = 21;
        nArray[160] = 171;
        nArray[161] = 165;
        nArray[162] = 233;
        nArray[163] = 90;
        nArray[164] = 101;
        nArray[165] = 139;
        nArray[166] = 244;
        nArray[167] = 71;
        nArray[168] = 60;
        nArray[169] = 15;
        nArray[170] = 47;
        nArray[171] = 40;
        nArray[172] = 1;
        nArray[173] = 64;
        nArray[174] = 110;
        nArray[175] = 2;
        nArray[176] = 200;
        nArray[177] = 4;
        nArray[178] = 112;
        nArray[179] = 190;
        nArray[180] = 166;
        nArray[181] = 64;
        nArray[182] = 150;
        nArray[183] = 228;
        nArray[184] = 3;
        nArray[185] = 181;
        nArray[186] = 54;
        nArray[187] = 127;
        nArray[188] = 143;
        nArray[189] = 171;
        nArray[190] = 32;
        nArray[191] = 251;
        nArray[192] = 213;
        nArray[193] = 179;
        nArray[194] = 250;
        nArray[195] = 249;
        nArray[196] = 101;
        nArray[197] = 249;
        nArray[198] = 212;
        nArray[199] = 76;
        nArray[200] = 245;
        nArray[201] = 128;
        nArray[202] = 115;
        nArray[203] = 148;
        nArray[204] = 90;
        nArray[205] = 208;
        nArray[206] = 164;
        nArray[207] = 63;
        nArray[208] = 55;
        nArray[209] = 89;
        nArray[210] = 10;
        nArray[211] = 141;
        nArray[212] = 56;
        nArray[213] = 240;
        nArray[214] = 101;
        nArray[215] = 33;
        nArray[216] = 30;
        nArray[217] = 95;
        nArray[218] = 252;
        nArray[219] = 243;
        nArray[220] = 141;
        nArray[221] = 126;
        nArray[222] = 56;
        nArray[223] = 48;
        nArray[224] = 4;
        nArray[225] = 156;
        nArray[226] = 148;
        nArray[227] = 205;
        nArray[228] = 121;
        nArray[229] = 113;
        nArray[230] = 55;
        nArray[231] = 66;
        nArray[232] = 205;
        nArray[233] = 139;
        nArray[234] = 22;
        nArray[235] = 85;
        nArray[236] = 61;
        nArray[237] = 21;
        nArray[238] = 156;
        nArray[239] = 24;
        nArray[240] = 42;
        nArray[241] = 119;
        nArray[242] = 129;
        nArray[243] = 122;
        nArray[244] = 163;
        nArray[245] = 88;
        nArray[246] = 186;
        nArray[247] = 39;
        nArray[248] = 45;
        nArray[249] = 126;
        nArray[250] = 27;
        nArray[251] = 6;
        nArray[252] = 241;
        nArray[253] = 142;
        nArray[254] = 162;
        nArray[255] = 99;
        nArray[256] = 110;
        nArray[257] = 166;
        nArray[258] = 153;
        nArray[259] = 205;
        nArray[260] = 149;
        nArray[261] = 254;
        nArray[262] = 171;
        nArray[263] = 33;
        nArray[264] = 22;
        nArray[265] = 9;
        nArray[266] = 109;
        nArray[267] = 173;
        nArray[268] = 137;
        nArray[269] = 91;
        nArray[270] = 33;
        nArray[271] = 80;
        nArray[272] = 171;
        nArray[273] = 133;
        nArray[274] = 102;
        nArray[275] = 45;
        nArray[276] = 255;
        nArray[277] = 215;
        nArray[278] = 6;
        nArray[279] = 173;
        nArray[280] = 74;
        nArray[281] = 138;
        nArray[282] = 120;
        nArray[283] = 243;
        nArray[284] = 70;
        nArray[285] = 12;
        nArray[286] = 82;
        nArray[287] = 99;
        int[] nArray2 = nArray;
        this.out.println("\nSAFER in ECB mode: safer -e -ecb -kx 0000000000000001 -s -r 6\n");
        byte[] byArray = new byte[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            byArray[n] = (byte)nArray2[n];
            ++n;
        }
        Cipher cipher = Cipher.getInstance((String)"SAFER", (String)"Cryptix");
        cipher.setParameter("variant", (Object)"SK-64");
        cipher.setParameter("rounds", (Object)new Integer(6));
        byte[] byArray2 = new byte[8];
        byArray2[7] = 1;
        RawSecretKey rawSecretKey = new RawSecretKey("SAFER", byArray2);
        cipher.initEncrypt((Key)rawSecretKey);
        this.compareIt(cipher.crypt(input), byArray);
    }

    private void test7() throws Exception {
        int[] nArray = new int[]{233, 169, 154, 148, 75, 45, 142, 87, 95, 206, 155, 162, 5, 132, 56, 199, 233, 169, 154, 148, 75, 45, 142, 87, 95, 206, 155, 162, 5, 132, 56, 199, 214, 50, 195, 106, 117, 166, 122, 92, 202, 4, 216, 87, 7, 223, 170, 73, 239, 104, 126, 77, 226, 113, 115, 185, 215, 50, 152, 187, 52, 171, 2, 40, 118, 110, 129, 126, 164, 124, 17, 85, 166, 157, 153, 102, 90, 153, 200, 181, 187, 164, 17, 94, 83, 113, 2, 198, 244, 30, 189, 16, 46, 78, 220, 81, 30, 161, 31, 115, 123, 181, 76, 50, 97, 220, 154, 210, 80, 130, 205, 14, 10, 53, 212, 47, 81, 17, 140, 146, 161, 12, 200, 63, 30, 168, 72, 156, 150, 110, 208, 196, 183, 97, 199, 143, 222, 126, 117, 146, 9, 117, 194, 157, 54, 39, 223, 55, 138, 168, 147, 186, 83, 140, 115, 208, 37, 135, 74, 118, 84, 231, 43, 162, 215, 68, 197, 102, 87, 245, 93, 15, 126, 182, 248, 254, 248, 243, 173, 225, 128, 150, 240, 15, 118, 218, 46, 45, 123, 73, 235, 239, 160, 248, 224, 97, 22, 245, 178, 3, 208, 69, 47, 191, 162, 228, 56, 91, 230, 126, 112, 90, 86, 183, 8, 111, 71, 200, 228, 99, 129, 93, 146, 28, 30, 98, 245, 232, 81, 32, 102, 5, 9, 125, 187, 182, 230, 41, 29, 142, 241, 20, 113, 121, 35, 186, 240, 65, 182, 188, 127, 113, 95, 112, 142, 75, 108, 153, 144, 201, 95, 1, 58, 9, 142, 129, 195, 241, 242, 216, 189, 136, 106, 8, 133, 209, 126, 138, 9, 6, 171, 176, 206, 27, 154, 8, 2, 227};
        this.out.println("\nSAFER in ECB mode: safer -e -ecb -kx 0102030405060708 -s -r 6\n");
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            byArray[n] = (byte)nArray[n];
            ++n;
        }
        Cipher cipher = Cipher.getInstance((String)"SAFER", (String)"Cryptix");
        cipher.setParameter("variant", (Object)"SK-64");
        cipher.setParameter("rounds", (Object)new Integer(6));
        byte[] byArray2 = new byte[8];
        int n2 = 0;
        while (n2 < 8) {
            byArray2[n2] = (byte)(n2 + 1);
            ++n2;
        }
        RawSecretKey rawSecretKey = new RawSecretKey("SAFER", byArray2);
        cipher.initEncrypt((Key)rawSecretKey);
        this.compareIt(cipher.crypt(input), byArray);
    }

    private void test8() throws Exception {
        int[] nArray = new int[288];
        nArray[0] = 249;
        nArray[1] = 176;
        nArray[2] = 171;
        nArray[3] = 27;
        nArray[4] = 220;
        nArray[5] = 97;
        nArray[6] = 189;
        nArray[7] = 230;
        nArray[8] = 65;
        nArray[9] = 76;
        nArray[10] = 84;
        nArray[11] = 90;
        nArray[12] = 182;
        nArray[13] = 153;
        nArray[14] = 74;
        nArray[15] = 247;
        nArray[16] = 249;
        nArray[17] = 176;
        nArray[18] = 171;
        nArray[19] = 27;
        nArray[20] = 220;
        nArray[21] = 97;
        nArray[22] = 189;
        nArray[23] = 230;
        nArray[24] = 65;
        nArray[25] = 76;
        nArray[26] = 84;
        nArray[27] = 90;
        nArray[28] = 182;
        nArray[29] = 153;
        nArray[30] = 74;
        nArray[31] = 247;
        nArray[32] = 46;
        nArray[33] = 146;
        nArray[34] = 221;
        nArray[35] = 48;
        nArray[36] = 220;
        nArray[37] = 60;
        nArray[38] = 180;
        nArray[39] = 23;
        nArray[40] = 126;
        nArray[41] = 253;
        nArray[42] = 126;
        nArray[43] = 141;
        nArray[44] = 249;
        nArray[45] = 122;
        nArray[46] = 226;
        nArray[47] = 165;
        nArray[48] = 167;
        nArray[49] = 55;
        nArray[50] = 252;
        nArray[51] = 75;
        nArray[52] = 43;
        nArray[53] = 44;
        nArray[54] = 32;
        nArray[55] = 108;
        nArray[56] = 245;
        nArray[57] = 218;
        nArray[58] = 93;
        nArray[59] = 55;
        nArray[60] = 108;
        nArray[61] = 36;
        nArray[62] = 89;
        nArray[63] = 124;
        nArray[64] = 224;
        nArray[65] = 133;
        nArray[66] = 135;
        nArray[67] = 250;
        nArray[68] = 141;
        nArray[69] = 48;
        nArray[70] = 29;
        nArray[71] = 210;
        nArray[72] = 19;
        nArray[73] = 171;
        nArray[74] = 202;
        nArray[75] = 56;
        nArray[76] = 13;
        nArray[77] = 241;
        nArray[78] = 111;
        nArray[79] = 42;
        nArray[80] = 152;
        nArray[81] = 144;
        nArray[82] = 163;
        nArray[83] = 18;
        nArray[84] = 147;
        nArray[85] = 83;
        nArray[86] = 195;
        nArray[87] = 34;
        nArray[89] = 232;
        nArray[90] = 179;
        nArray[91] = 239;
        nArray[92] = 235;
        nArray[93] = 84;
        nArray[94] = 142;
        nArray[95] = 245;
        nArray[96] = 191;
        nArray[97] = 254;
        nArray[98] = 57;
        nArray[99] = 202;
        nArray[100] = 59;
        nArray[101] = 68;
        nArray[102] = 135;
        nArray[103] = 208;
        nArray[104] = 239;
        nArray[105] = 233;
        nArray[106] = 213;
        nArray[107] = 101;
        nArray[108] = 207;
        nArray[109] = 170;
        nArray[110] = 27;
        nArray[111] = 143;
        nArray[112] = 220;
        nArray[113] = 121;
        nArray[114] = 54;
        nArray[115] = 138;
        nArray[116] = 190;
        nArray[117] = 38;
        nArray[118] = 116;
        nArray[119] = 209;
        nArray[120] = 21;
        nArray[121] = 216;
        nArray[122] = 16;
        nArray[123] = 131;
        nArray[124] = 193;
        nArray[125] = 245;
        nArray[126] = 80;
        nArray[127] = 235;
        nArray[128] = 22;
        nArray[129] = 190;
        nArray[130] = 171;
        nArray[131] = 51;
        nArray[132] = 230;
        nArray[133] = 85;
        nArray[134] = 77;
        nArray[135] = 139;
        nArray[136] = 96;
        nArray[137] = 228;
        nArray[138] = 66;
        nArray[139] = 240;
        nArray[140] = 3;
        nArray[141] = 245;
        nArray[142] = 93;
        nArray[143] = 200;
        nArray[144] = 72;
        nArray[145] = 128;
        nArray[146] = 35;
        nArray[147] = 100;
        nArray[148] = 251;
        nArray[149] = 106;
        nArray[150] = 45;
        nArray[151] = 244;
        nArray[152] = 26;
        nArray[153] = 248;
        nArray[154] = 224;
        nArray[155] = 195;
        nArray[156] = 223;
        nArray[157] = 40;
        nArray[158] = 122;
        nArray[159] = 156;
        nArray[160] = 191;
        nArray[161] = 188;
        nArray[162] = 191;
        nArray[163] = 143;
        nArray[164] = 160;
        nArray[165] = 162;
        nArray[166] = 43;
        nArray[167] = 153;
        nArray[168] = 13;
        nArray[169] = 117;
        nArray[170] = 4;
        nArray[171] = 196;
        nArray[172] = 145;
        nArray[173] = 105;
        nArray[174] = 132;
        nArray[175] = 253;
        nArray[176] = 158;
        nArray[177] = 170;
        nArray[178] = 77;
        nArray[179] = 241;
        nArray[180] = 224;
        nArray[181] = 239;
        nArray[182] = 244;
        nArray[183] = 69;
        nArray[184] = 76;
        nArray[185] = 193;
        nArray[186] = 72;
        nArray[187] = 56;
        nArray[188] = 57;
        nArray[189] = 158;
        nArray[190] = 83;
        nArray[191] = 45;
        nArray[192] = 192;
        nArray[193] = 246;
        nArray[194] = 218;
        nArray[195] = 38;
        nArray[196] = 125;
        nArray[197] = 229;
        nArray[198] = 8;
        nArray[199] = 117;
        nArray[200] = 70;
        nArray[201] = 69;
        nArray[202] = 63;
        nArray[203] = 2;
        nArray[204] = 162;
        nArray[205] = 32;
        nArray[206] = 183;
        nArray[207] = 54;
        nArray[208] = 223;
        nArray[209] = 182;
        nArray[210] = 226;
        nArray[211] = 88;
        nArray[212] = 82;
        nArray[213] = 232;
        nArray[214] = 35;
        nArray[215] = 61;
        nArray[216] = 168;
        nArray[217] = 28;
        nArray[218] = 135;
        nArray[219] = 156;
        nArray[220] = 128;
        nArray[221] = 131;
        nArray[222] = 61;
        nArray[223] = 148;
        nArray[224] = 233;
        nArray[225] = 182;
        nArray[226] = 210;
        nArray[227] = 131;
        nArray[228] = 190;
        nArray[229] = 235;
        nArray[230] = 68;
        nArray[231] = 124;
        nArray[232] = 190;
        nArray[233] = 196;
        nArray[234] = 43;
        nArray[235] = 154;
        nArray[236] = 237;
        nArray[237] = 244;
        nArray[238] = 18;
        nArray[239] = 45;
        nArray[240] = 2;
        nArray[241] = 253;
        nArray[242] = 241;
        nArray[243] = 158;
        nArray[244] = 59;
        nArray[245] = 231;
        nArray[246] = 160;
        nArray[247] = 155;
        nArray[248] = 169;
        nArray[249] = 212;
        nArray[250] = 113;
        nArray[251] = 243;
        nArray[252] = 149;
        nArray[253] = 27;
        nArray[254] = 57;
        nArray[255] = 194;
        nArray[256] = 173;
        nArray[257] = 110;
        nArray[258] = 113;
        nArray[259] = 131;
        nArray[260] = 48;
        nArray[261] = 19;
        nArray[262] = 34;
        nArray[263] = 87;
        nArray[264] = 250;
        nArray[265] = 153;
        nArray[266] = 35;
        nArray[267] = 119;
        nArray[268] = 30;
        nArray[269] = 188;
        nArray[270] = 187;
        nArray[271] = 54;
        nArray[272] = 76;
        nArray[273] = 87;
        nArray[274] = 204;
        nArray[275] = 211;
        nArray[276] = 240;
        nArray[277] = 253;
        nArray[278] = 28;
        nArray[279] = 145;
        nArray[280] = 36;
        nArray[281] = 80;
        nArray[282] = 23;
        nArray[283] = 12;
        nArray[284] = 155;
        nArray[285] = 214;
        nArray[286] = 209;
        nArray[287] = 129;
        int[] nArray2 = nArray;
        this.out.println("\nSAFER in ECB mode: safer -e -ecb -kx 00000000000000010000000000000001 -s -r 10\n");
        byte[] byArray = new byte[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            byArray[n] = (byte)nArray2[n];
            ++n;
        }
        Cipher cipher = Cipher.getInstance((String)"SAFER", (String)"Cryptix");
        cipher.setParameter("variant", (Object)"SK-128");
        cipher.setParameter("rounds", (Object)new Integer(10));
        byte[] byArray2 = new byte[8];
        byArray2[7] = 1;
        RawSecretKey rawSecretKey = new RawSecretKey("SAFER", byArray2);
        cipher.initEncrypt((Key)rawSecretKey);
        this.compareIt(cipher.crypt(input), byArray);
    }

    private void test8B() throws Exception {
        int[] nArray = new int[288];
        nArray[0] = 104;
        nArray[1] = 156;
        nArray[2] = 77;
        nArray[3] = 53;
        nArray[4] = 69;
        nArray[5] = 225;
        nArray[6] = 184;
        nArray[7] = 209;
        nArray[8] = 255;
        nArray[9] = 120;
        nArray[10] = 17;
        nArray[11] = 228;
        nArray[12] = 179;
        nArray[13] = 167;
        nArray[14] = 46;
        nArray[15] = 113;
        nArray[16] = 104;
        nArray[17] = 156;
        nArray[18] = 77;
        nArray[19] = 53;
        nArray[20] = 69;
        nArray[21] = 225;
        nArray[22] = 184;
        nArray[23] = 209;
        nArray[24] = 255;
        nArray[25] = 120;
        nArray[26] = 17;
        nArray[27] = 228;
        nArray[28] = 179;
        nArray[29] = 167;
        nArray[30] = 46;
        nArray[31] = 113;
        nArray[32] = 33;
        nArray[33] = 61;
        nArray[34] = 56;
        nArray[35] = 177;
        nArray[36] = 4;
        nArray[37] = 208;
        nArray[38] = 50;
        nArray[39] = 242;
        nArray[40] = 238;
        nArray[41] = 4;
        nArray[42] = 78;
        nArray[43] = 221;
        nArray[44] = 252;
        nArray[45] = 76;
        nArray[46] = 168;
        nArray[47] = 10;
        nArray[48] = 22;
        nArray[49] = 134;
        nArray[50] = 153;
        nArray[51] = 52;
        nArray[52] = 41;
        nArray[53] = 133;
        nArray[54] = 112;
        nArray[55] = 72;
        nArray[56] = 181;
        nArray[57] = 42;
        nArray[58] = 55;
        nArray[59] = 74;
        nArray[60] = 190;
        nArray[61] = 66;
        nArray[62] = 151;
        nArray[63] = 146;
        nArray[64] = 66;
        nArray[65] = 68;
        nArray[66] = 7;
        nArray[67] = 201;
        nArray[68] = 2;
        nArray[69] = 129;
        nArray[70] = 170;
        nArray[71] = 21;
        nArray[72] = 14;
        nArray[73] = 95;
        nArray[74] = 190;
        nArray[75] = 213;
        nArray[76] = 76;
        nArray[77] = 127;
        nArray[78] = 109;
        nArray[79] = 170;
        nArray[80] = 249;
        nArray[81] = 206;
        nArray[82] = 170;
        nArray[83] = 180;
        nArray[84] = 195;
        nArray[85] = 20;
        nArray[86] = 104;
        nArray[87] = 238;
        nArray[88] = 91;
        nArray[89] = 113;
        nArray[90] = 245;
        nArray[91] = 77;
        nArray[92] = 53;
        nArray[93] = 2;
        nArray[94] = 223;
        nArray[95] = 241;
        nArray[96] = 155;
        nArray[97] = 24;
        nArray[98] = 66;
        nArray[99] = 130;
        nArray[100] = 4;
        nArray[101] = 126;
        nArray[102] = 162;
        nArray[103] = 41;
        nArray[104] = 170;
        nArray[105] = 158;
        nArray[106] = 37;
        nArray[107] = 243;
        nArray[108] = 177;
        nArray[109] = 237;
        nArray[110] = 105;
        nArray[111] = 112;
        nArray[112] = 220;
        nArray[113] = 14;
        nArray[114] = 61;
        nArray[115] = 40;
        nArray[116] = 203;
        nArray[117] = 182;
        nArray[118] = 95;
        nArray[119] = 68;
        nArray[120] = 50;
        nArray[121] = 255;
        nArray[122] = 202;
        nArray[123] = 143;
        nArray[124] = 248;
        nArray[125] = 91;
        nArray[126] = 14;
        nArray[127] = 228;
        nArray[128] = 240;
        nArray[129] = 219;
        nArray[130] = 224;
        nArray[131] = 117;
        nArray[132] = 84;
        nArray[133] = 139;
        nArray[134] = 108;
        nArray[135] = 61;
        nArray[136] = 177;
        nArray[137] = 102;
        nArray[138] = 218;
        nArray[140] = 240;
        nArray[141] = 245;
        nArray[142] = 99;
        nArray[143] = 77;
        nArray[144] = 212;
        nArray[145] = 190;
        nArray[146] = 68;
        nArray[147] = 114;
        nArray[148] = 138;
        nArray[149] = 164;
        nArray[150] = 75;
        nArray[151] = 82;
        nArray[152] = 172;
        nArray[153] = 215;
        nArray[154] = 24;
        nArray[155] = 124;
        nArray[156] = 16;
        nArray[157] = 132;
        nArray[158] = 222;
        nArray[159] = 200;
        nArray[160] = 46;
        nArray[161] = 189;
        nArray[162] = 146;
        nArray[163] = 205;
        nArray[164] = 132;
        nArray[165] = 30;
        nArray[166] = 113;
        nArray[167] = 49;
        nArray[168] = 104;
        nArray[169] = 137;
        nArray[170] = 97;
        nArray[171] = 109;
        nArray[172] = 214;
        nArray[173] = 46;
        nArray[174] = 58;
        nArray[175] = 80;
        nArray[176] = 22;
        nArray[177] = 26;
        nArray[178] = 14;
        nArray[179] = 65;
        nArray[180] = 234;
        nArray[181] = 138;
        nArray[182] = 119;
        nArray[183] = 54;
        nArray[184] = 82;
        nArray[185] = 39;
        nArray[186] = 65;
        nArray[187] = 175;
        nArray[188] = 248;
        nArray[189] = 1;
        nArray[190] = 77;
        nArray[191] = 239;
        nArray[192] = 65;
        nArray[193] = 36;
        nArray[194] = 107;
        nArray[195] = 101;
        nArray[196] = 241;
        nArray[197] = 220;
        nArray[198] = 106;
        nArray[199] = 250;
        nArray[200] = 105;
        nArray[201] = 122;
        nArray[202] = 127;
        nArray[203] = 42;
        nArray[204] = 189;
        nArray[205] = 106;
        nArray[206] = 53;
        nArray[207] = 16;
        nArray[208] = 187;
        nArray[209] = 116;
        nArray[210] = 162;
        nArray[211] = 228;
        nArray[212] = 204;
        nArray[213] = 228;
        nArray[214] = 245;
        nArray[215] = 44;
        nArray[216] = 1;
        nArray[217] = 43;
        nArray[218] = 53;
        nArray[219] = 173;
        nArray[221] = 164;
        nArray[222] = 56;
        nArray[223] = 120;
        nArray[224] = 70;
        nArray[225] = 56;
        nArray[226] = 66;
        nArray[227] = 57;
        nArray[228] = 248;
        nArray[229] = 93;
        nArray[230] = 49;
        nArray[231] = 31;
        nArray[232] = 104;
        nArray[233] = 116;
        nArray[234] = 72;
        nArray[235] = 177;
        nArray[236] = 245;
        nArray[237] = 232;
        nArray[238] = 3;
        nArray[239] = 232;
        nArray[240] = 230;
        nArray[241] = 175;
        nArray[242] = 79;
        nArray[243] = 155;
        nArray[244] = 111;
        nArray[245] = 193;
        nArray[246] = 49;
        nArray[247] = 121;
        nArray[248] = 220;
        nArray[249] = 165;
        nArray[250] = 203;
        nArray[251] = 52;
        nArray[252] = 252;
        nArray[253] = 86;
        nArray[254] = 207;
        nArray[255] = 47;
        nArray[256] = 174;
        nArray[257] = 48;
        nArray[258] = 118;
        nArray[259] = 70;
        nArray[260] = 109;
        nArray[261] = 66;
        nArray[262] = 204;
        nArray[263] = 143;
        nArray[264] = 54;
        nArray[265] = 169;
        nArray[266] = 90;
        nArray[267] = 239;
        nArray[268] = 124;
        nArray[269] = 66;
        nArray[270] = 54;
        nArray[271] = 86;
        nArray[272] = 22;
        nArray[273] = 176;
        nArray[274] = 155;
        nArray[275] = 176;
        nArray[276] = 70;
        nArray[277] = 221;
        nArray[278] = 48;
        nArray[279] = 27;
        nArray[280] = 172;
        nArray[281] = 61;
        nArray[282] = 99;
        nArray[283] = 141;
        nArray[284] = 93;
        nArray[285] = 145;
        nArray[286] = 48;
        nArray[287] = 30;
        int[] nArray2 = nArray;
        this.out.println("\nSAFER in ECB mode: safer -e -ecb -kx 01020304050607080000000000000000 -s -r 10\n");
        byte[] byArray = new byte[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            byArray[n] = (byte)nArray2[n];
            ++n;
        }
        Cipher cipher = Cipher.getInstance((String)"SAFER", (String)"Cryptix");
        byte[] byArray2 = new byte[16];
        int n2 = 0;
        while (n2 < 8) {
            byArray2[n2] = (byte)(n2 + 1);
            byArray2[n2 + 8] = 0;
            ++n2;
        }
        RawSecretKey rawSecretKey = new RawSecretKey("SAFER", byArray2);
        cipher.initEncrypt((Key)rawSecretKey);
        this.compareIt(cipher.crypt(input), byArray);
    }

    private void test8C() throws Exception {
        int[] nArray = new int[288];
        nArray[0] = 1;
        nArray[1] = 194;
        nArray[2] = 254;
        nArray[3] = 49;
        nArray[4] = 5;
        nArray[5] = 168;
        nArray[6] = 29;
        nArray[7] = 16;
        nArray[8] = 73;
        nArray[9] = 201;
        nArray[10] = 157;
        nArray[11] = 152;
        nArray[12] = 165;
        nArray[13] = 188;
        nArray[14] = 89;
        nArray[15] = 8;
        nArray[16] = 1;
        nArray[17] = 194;
        nArray[18] = 254;
        nArray[19] = 49;
        nArray[20] = 5;
        nArray[21] = 168;
        nArray[22] = 29;
        nArray[23] = 16;
        nArray[24] = 73;
        nArray[25] = 201;
        nArray[26] = 157;
        nArray[27] = 152;
        nArray[28] = 165;
        nArray[29] = 188;
        nArray[30] = 89;
        nArray[31] = 8;
        nArray[32] = 142;
        nArray[33] = 84;
        nArray[34] = 64;
        nArray[35] = 7;
        nArray[36] = 168;
        nArray[37] = 177;
        nArray[38] = 52;
        nArray[39] = 112;
        nArray[40] = 147;
        nArray[41] = 150;
        nArray[42] = 146;
        nArray[43] = 127;
        nArray[44] = 150;
        nArray[45] = 8;
        nArray[46] = 125;
        nArray[47] = 55;
        nArray[48] = 236;
        nArray[49] = 6;
        nArray[50] = 197;
        nArray[51] = 172;
        nArray[52] = 69;
        nArray[53] = 115;
        nArray[54] = 158;
        nArray[55] = 128;
        nArray[56] = 74;
        nArray[57] = 84;
        nArray[58] = 34;
        nArray[59] = 162;
        nArray[60] = 82;
        nArray[61] = 158;
        nArray[62] = 27;
        nArray[63] = 176;
        nArray[64] = 90;
        nArray[65] = 191;
        nArray[66] = 47;
        nArray[67] = 85;
        nArray[68] = 40;
        nArray[69] = 97;
        nArray[70] = 159;
        nArray[71] = 237;
        nArray[72] = 228;
        nArray[73] = 194;
        nArray[74] = 116;
        nArray[75] = 4;
        nArray[76] = 4;
        nArray[77] = 35;
        nArray[78] = 156;
        nArray[79] = 62;
        nArray[80] = 49;
        nArray[81] = 80;
        nArray[82] = 122;
        nArray[83] = 19;
        nArray[84] = 20;
        nArray[85] = 124;
        nArray[86] = 173;
        nArray[87] = 88;
        nArray[88] = 191;
        nArray[89] = 103;
        nArray[90] = 205;
        nArray[91] = 164;
        nArray[92] = 106;
        nArray[93] = 165;
        nArray[94] = 178;
        nArray[95] = 133;
        nArray[96] = 79;
        nArray[97] = 83;
        nArray[98] = 120;
        nArray[99] = 127;
        nArray[100] = 124;
        nArray[101] = 254;
        nArray[102] = 28;
        nArray[103] = 244;
        nArray[104] = 173;
        nArray[105] = 182;
        nArray[106] = 157;
        nArray[107] = 212;
        nArray[108] = 240;
        nArray[109] = 120;
        nArray[110] = 247;
        nArray[111] = 90;
        nArray[112] = 224;
        nArray[113] = 185;
        nArray[114] = 108;
        nArray[115] = 101;
        nArray[116] = 183;
        nArray[117] = 79;
        nArray[118] = 83;
        nArray[119] = 86;
        nArray[120] = 222;
        nArray[121] = 190;
        nArray[122] = 208;
        nArray[123] = 162;
        nArray[124] = 228;
        nArray[125] = 186;
        nArray[126] = 9;
        nArray[127] = 55;
        nArray[128] = 136;
        nArray[129] = 213;
        nArray[130] = 53;
        nArray[131] = 6;
        nArray[132] = 47;
        nArray[133] = 224;
        nArray[134] = 109;
        nArray[135] = 160;
        nArray[136] = 219;
        nArray[137] = 86;
        nArray[138] = 60;
        nArray[139] = 145;
        nArray[140] = 172;
        nArray[141] = 116;
        nArray[142] = 48;
        nArray[143] = 107;
        nArray[144] = 176;
        nArray[145] = 32;
        nArray[146] = 6;
        nArray[147] = 89;
        nArray[148] = 39;
        nArray[149] = 152;
        nArray[150] = 171;
        nArray[151] = 143;
        nArray[152] = 17;
        nArray[153] = 161;
        nArray[154] = 187;
        nArray[155] = 95;
        nArray[156] = 105;
        nArray[157] = 135;
        nArray[158] = 164;
        nArray[159] = 1;
        nArray[160] = 211;
        nArray[161] = 29;
        nArray[162] = 246;
        nArray[163] = 81;
        nArray[164] = 22;
        nArray[165] = 51;
        nArray[166] = 105;
        nArray[167] = 79;
        nArray[168] = 58;
        nArray[169] = 56;
        nArray[170] = 54;
        nArray[171] = 193;
        nArray[172] = 174;
        nArray[173] = 28;
        nArray[174] = 140;
        nArray[175] = 184;
        nArray[176] = 244;
        nArray[177] = 40;
        nArray[178] = 192;
        nArray[179] = 18;
        nArray[180] = 185;
        nArray[181] = 19;
        nArray[182] = 13;
        nArray[183] = 176;
        nArray[184] = 160;
        nArray[185] = 217;
        nArray[186] = 42;
        nArray[187] = 37;
        nArray[188] = 241;
        nArray[189] = 100;
        nArray[190] = 49;
        nArray[191] = 80;
        nArray[192] = 92;
        nArray[193] = 189;
        nArray[194] = 119;
        nArray[195] = 176;
        nArray[196] = 54;
        nArray[197] = 38;
        nArray[198] = 254;
        nArray[199] = 59;
        nArray[200] = 50;
        nArray[201] = 146;
        nArray[202] = 73;
        nArray[203] = 211;
        nArray[204] = 147;
        nArray[205] = 199;
        nArray[206] = 33;
        nArray[207] = 182;
        nArray[208] = 36;
        nArray[209] = 245;
        nArray[210] = 251;
        nArray[211] = 101;
        nArray[212] = 134;
        nArray[213] = 120;
        nArray[214] = 241;
        nArray[215] = 150;
        nArray[216] = 114;
        nArray[217] = 250;
        nArray[218] = 222;
        nArray[219] = 38;
        nArray[220] = 78;
        nArray[221] = 201;
        nArray[222] = 243;
        nArray[223] = 140;
        nArray[224] = 199;
        nArray[225] = 196;
        nArray[226] = 185;
        nArray[227] = 46;
        nArray[228] = 222;
        nArray[229] = 24;
        nArray[230] = 66;
        nArray[231] = 229;
        nArray[232] = 232;
        nArray[233] = 251;
        nArray[234] = 77;
        nArray[235] = 219;
        nArray[236] = 221;
        nArray[237] = 32;
        nArray[238] = 101;
        nArray[239] = 22;
        nArray[240] = 19;
        nArray[241] = 191;
        nArray[242] = 242;
        nArray[243] = 109;
        nArray[244] = 41;
        nArray[245] = 207;
        nArray[246] = 125;
        nArray[247] = 223;
        nArray[248] = 103;
        nArray[249] = 135;
        nArray[250] = 55;
        nArray[251] = 167;
        nArray[252] = 240;
        nArray[253] = 202;
        nArray[254] = 224;
        nArray[255] = 23;
        nArray[256] = 39;
        nArray[257] = 208;
        nArray[258] = 7;
        nArray[259] = 63;
        nArray[260] = 206;
        nArray[261] = 207;
        nArray[262] = 109;
        nArray[263] = 91;
        nArray[264] = 99;
        nArray[265] = 43;
        nArray[266] = 38;
        nArray[267] = 87;
        nArray[269] = 115;
        nArray[270] = 25;
        nArray[272] = 93;
        nArray[273] = 30;
        nArray[274] = 36;
        nArray[275] = 147;
        nArray[276] = 239;
        nArray[277] = 236;
        nArray[278] = 50;
        nArray[279] = 109;
        nArray[280] = 120;
        nArray[281] = 18;
        nArray[282] = 104;
        nArray[283] = 132;
        nArray[284] = 241;
        nArray[285] = 85;
        nArray[286] = 45;
        nArray[287] = 194;
        int[] nArray2 = nArray;
        this.out.println("\nSAFER in ECB mode: safer -e -ecb -kx 00000000000000000102030405060708 -s -r 10\n");
        byte[] byArray = new byte[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            byArray[n] = (byte)nArray2[n];
            ++n;
        }
        Cipher cipher = Cipher.getInstance((String)"SAFER", (String)"Cryptix");
        byte[] byArray2 = new byte[16];
        int n2 = 0;
        while (n2 < 8) {
            byArray2[n2 + 8] = (byte)(n2 + 1);
            byArray2[n2] = 0;
            ++n2;
        }
        RawSecretKey rawSecretKey = new RawSecretKey("SAFER", byArray2);
        cipher.initEncrypt((Key)rawSecretKey);
        this.compareIt(cipher.crypt(input), byArray);
    }

    private void test8D() throws Exception {
        int[] nArray = new int[]{205, 12, 46, 193, 207, 240, 215, 91, 13, 210, 52, 6, 71, 172, 3, 254, 205, 12, 46, 193, 207, 240, 215, 91, 13, 210, 52, 6, 71, 172, 3, 254, 96, 29, 39, 40, 55, 146, 237, 123, 163, 222, 184, 162, 239, 94, 48, 227, 228, 222, 185, 200, 2, 157, 249, 164, 68, 39, 224, 119, 89, 33, 96, 7, 242, 117, 142, 64, 57, 232, 204, 149, 190, 247, 201, 153, 52, 49, 3, 63, 155, 237, 13, 46, 120, 238, 140, 219, 122, 30, 255, 85, 78, 61, 10, 48, 168, 115, 66, 152, 102, 60, 154, 227, 107, 14, 152, 53, 133, 152, 68, 139, 83, 200, 77, 30, 227, 67, 72, 211, 164, 177, 85, 204, 155, 172, 146, 35, 8, 193, 190, 95, 239, 98, 140, 95, 233, 65, 18, 184, 202, 230, 205, 91, 255, 104, 241, 3, 226, 173, 125, 6, 244, 176, 44, 67, 248, 195, 43, 191, 124, 41, 157, 69, 145, 16, 177, 172, 169, 234, 191, 227, 52, 188, 217, 124, 141, 132, 66, 147, 148, 208, 139, 53, 74, 34, 190, 164, 218, 124, 123, 229, 208, 105, 140, 21, 81, 68, 50, 58, 125, 159, 156, 47, 200, 186, 151, 23, 193, 147, 212, 182, 33, 100, 119, 187, 84, 210, 239, 222, 193, 230, 145, 53, 240, 212, 114, 130, 109, 253, 150, 142, 230, 219, 160, 207, 73, 147, 129, 21, 54, 163, 136, 104, 15, 147, 61, 237, 73, 70, 215, 57, 52, 209, 173, 244, 14, 9, 56, 52, 95, 76, 40, 70, 148, 21, 166, 15, 66, 204, 46, 196, 68, 243, 154, 48, 91, 149, 142, 20, 118, 65, 1, 124, 83, 86, 111, 82};
        this.out.println("\nSAFER in ECB mode: safer -e -ecb -k AaBcDeFgHiJkLmNoPqRsTuVwXyZz0123456789\n");
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            byArray[n] = (byte)nArray[n];
            ++n;
        }
        Cipher cipher = Cipher.getInstance((String)"SAFER", (String)"Cryptix");
        cipher.setParameter("variant", (Object)"K-128");
        byte[] byArray2 = new byte[16];
        RawSecretKey rawSecretKey = new RawSecretKey("SAFER", byArray2);
        cipher.initEncrypt((Key)rawSecretKey);
        this.compareIt(cipher.crypt(input), byArray);
    }

    private void test8E() throws Exception {
        int[] nArray = new int[]{249, 118, 152, 143, 221, 25, 156, 132, 38, 89, 129, 249, 212, 217, 39, 66, 249, 118, 152, 143, 221, 25, 156, 132, 38, 89, 129, 249, 212, 217, 39, 66, 212, 160, 72, 109, 162, 244, 13, 6, 237, 228, 143, 223, 216, 238, 188, 151, 149, 236, 141, 238, 223, 191, 16, 133, 208, 169, 126, 87, 136, 68, 18, 19, 235, 112, 249, 81, 19, 74, 153, 74, 133, 255, 187, 201, 93, 49, 1, 135, 116, 231, 223, 137, 117, 184, 130, 120, 141, 191, 176, 154, 87, 91, 77, 77, 191, 70, 198, 162, 67, 234, 95, 57, 12, 74, 134, 3, 179, 67, 40, 1, 138, 85, 70, 107, 230, 140, 199, 224, 16, 6, 76, 150, 237, 122, 76, 178, 137, 186, 54, 55, 35, 38, 189, 191, 104, 123, 16, 46, 237, 93, 192, 191, 127, 251, 160, 7, 80, 103, 86, 226, 82, 145, 61, 28, 69, 49, 59, 239, 153, 40, 25, 164, 175, 163, 103, 54, 157, 181, 57, 211, 173, 10, 254, 209, 131, 21, 240, 174, 155, 170, 193, 252, 27, 46, 156, 207, 204, 38, 69, 60, 84, 241, 118, 129, 107, 181, 76, 70, 166, 233, 136, 85, 193, 118, 154, 207, 19, 129, 201, 152, 80, 235, 240, 180, 220, 151, 183, 196, 193, 98, 104, 193, 111, 215, 58, 139, 250, 52, 147, 22, 121, 231, 59, 251, 121, 1, 29, 148, 246, 143, 211, 211, 199, 202, 195, 13, 53, 225, 142, 6, 75, 43, 227, 74, 151, 96, 118, 187, 166, 56, 3, 15, 164, 176, 21, 134, 77, 114, 247, 69, 159, 143, 156, 109, 116, 149, 75, 109, 138, 83, 97, 21, 95, 62, 45, 41};
        this.out.println("\nSAFER in ECB mode: safer -ecbkx 42431BA40D291F81D66083C605D3A4D6\n");
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            byArray[n] = (byte)nArray[n];
            ++n;
        }
        Cipher cipher = Cipher.getInstance((String)"SAFER", (String)"Cryptix");
        cipher.setParameter("variant", (Object)"K-128");
        cipher.initEncrypt((Key)this.aKey);
        this.compareIt(cipher.crypt(input), byArray);
    }

    private void test9() throws Exception {
        int[] nArray = new int[288];
        nArray[0] = 251;
        nArray[1] = 221;
        nArray[2] = 148;
        nArray[3] = 3;
        nArray[4] = 222;
        nArray[5] = 99;
        nArray[6] = 246;
        nArray[7] = 105;
        nArray[8] = 9;
        nArray[9] = 253;
        nArray[10] = 180;
        nArray[11] = 32;
        nArray[12] = 22;
        nArray[13] = 75;
        nArray[14] = 11;
        nArray[15] = 213;
        nArray[16] = 56;
        nArray[17] = 232;
        nArray[18] = 236;
        nArray[19] = 153;
        nArray[20] = 153;
        nArray[21] = 92;
        nArray[22] = 253;
        nArray[23] = 97;
        nArray[24] = 39;
        nArray[25] = 54;
        nArray[26] = 14;
        nArray[27] = 69;
        nArray[28] = 23;
        nArray[29] = 95;
        nArray[30] = 212;
        nArray[31] = 37;
        nArray[32] = 161;
        nArray[33] = 9;
        nArray[34] = 26;
        nArray[35] = 224;
        nArray[36] = 245;
        nArray[37] = 215;
        nArray[38] = 57;
        nArray[39] = 210;
        nArray[40] = 53;
        nArray[41] = 131;
        nArray[42] = 63;
        nArray[43] = 111;
        nArray[44] = 94;
        nArray[45] = 178;
        nArray[46] = 65;
        nArray[47] = 235;
        nArray[48] = 183;
        nArray[49] = 88;
        nArray[50] = 244;
        nArray[51] = 42;
        nArray[52] = 86;
        nArray[53] = 6;
        nArray[54] = 154;
        nArray[55] = 213;
        nArray[56] = 111;
        nArray[57] = 59;
        nArray[58] = 179;
        nArray[59] = 11;
        nArray[60] = 4;
        nArray[61] = 4;
        nArray[62] = 39;
        nArray[63] = 199;
        nArray[64] = 8;
        nArray[65] = 190;
        nArray[66] = 114;
        nArray[67] = 105;
        nArray[68] = 117;
        nArray[69] = 168;
        nArray[70] = 126;
        nArray[71] = 106;
        nArray[72] = 226;
        nArray[73] = 247;
        nArray[74] = 84;
        nArray[75] = 100;
        nArray[76] = 219;
        nArray[77] = 249;
        nArray[78] = 30;
        nArray[79] = 18;
        nArray[80] = 250;
        nArray[81] = 82;
        nArray[82] = 221;
        nArray[83] = 11;
        nArray[84] = 124;
        nArray[85] = 218;
        nArray[86] = 156;
        nArray[87] = 27;
        nArray[88] = 108;
        nArray[89] = 72;
        nArray[90] = 43;
        nArray[91] = 222;
        nArray[92] = 132;
        nArray[93] = 148;
        nArray[94] = 37;
        nArray[95] = 177;
        nArray[96] = 185;
        nArray[97] = 197;
        nArray[98] = 166;
        nArray[99] = 74;
        nArray[100] = 41;
        nArray[101] = 88;
        nArray[102] = 247;
        nArray[103] = 169;
        nArray[104] = 14;
        nArray[105] = 163;
        nArray[106] = 26;
        nArray[107] = 178;
        nArray[108] = 79;
        nArray[109] = 15;
        nArray[110] = 49;
        nArray[111] = 112;
        nArray[112] = 129;
        nArray[113] = 171;
        nArray[114] = 54;
        nArray[115] = 147;
        nArray[116] = 224;
        nArray[117] = 78;
        nArray[118] = 181;
        nArray[119] = 50;
        nArray[120] = 221;
        nArray[121] = 191;
        nArray[122] = 166;
        nArray[123] = 224;
        nArray[124] = 235;
        nArray[125] = 73;
        nArray[126] = 160;
        nArray[127] = 113;
        nArray[128] = 170;
        nArray[129] = 172;
        nArray[130] = 188;
        nArray[131] = 19;
        nArray[132] = 25;
        nArray[133] = 154;
        nArray[134] = 114;
        nArray[135] = 144;
        nArray[136] = 158;
        nArray[137] = 64;
        nArray[138] = 185;
        nArray[139] = 30;
        nArray[140] = 243;
        nArray[141] = 120;
        nArray[142] = 184;
        nArray[143] = 193;
        nArray[144] = 128;
        nArray[145] = 159;
        nArray[146] = 136;
        nArray[147] = 128;
        nArray[148] = 49;
        nArray[149] = 166;
        nArray[150] = 81;
        nArray[151] = 75;
        nArray[152] = 166;
        nArray[153] = 120;
        nArray[154] = 95;
        nArray[155] = 116;
        nArray[156] = 225;
        nArray[157] = 37;
        nArray[158] = 228;
        nArray[159] = 62;
        nArray[160] = 245;
        nArray[161] = 30;
        nArray[162] = 89;
        nArray[163] = 115;
        nArray[164] = 23;
        nArray[165] = 205;
        nArray[166] = 247;
        nArray[167] = 137;
        nArray[168] = 197;
        nArray[169] = 194;
        nArray[170] = 211;
        nArray[171] = 91;
        nArray[172] = 115;
        nArray[173] = 241;
        nArray[174] = 191;
        nArray[175] = 93;
        nArray[176] = 113;
        nArray[177] = 126;
        nArray[178] = 232;
        nArray[179] = 106;
        nArray[180] = 118;
        nArray[181] = 95;
        nArray[182] = 62;
        nArray[183] = 206;
        nArray[184] = 69;
        nArray[185] = 102;
        nArray[186] = 42;
        nArray[187] = 176;
        nArray[188] = 155;
        nArray[189] = 102;
        nArray[190] = 166;
        nArray[191] = 27;
        nArray[192] = 82;
        nArray[193] = 6;
        nArray[194] = 174;
        nArray[195] = 34;
        nArray[196] = 144;
        nArray[197] = 203;
        nArray[198] = 93;
        nArray[199] = 255;
        nArray[200] = 57;
        nArray[201] = 197;
        nArray[202] = 9;
        nArray[203] = 64;
        nArray[204] = 138;
        nArray[205] = 225;
        nArray[206] = 204;
        nArray[207] = 151;
        nArray[208] = 214;
        nArray[210] = 123;
        nArray[211] = 225;
        nArray[212] = 85;
        nArray[213] = 191;
        nArray[214] = 233;
        nArray[215] = 18;
        nArray[216] = 176;
        nArray[217] = 217;
        nArray[218] = 192;
        nArray[219] = 128;
        nArray[220] = 162;
        nArray[221] = 213;
        nArray[222] = 16;
        nArray[223] = 212;
        nArray[224] = 101;
        nArray[225] = 97;
        nArray[226] = 100;
        nArray[227] = 135;
        nArray[228] = 194;
        nArray[229] = 186;
        nArray[230] = 79;
        nArray[231] = 105;
        nArray[232] = 216;
        nArray[233] = 70;
        nArray[234] = 152;
        nArray[235] = 40;
        nArray[236] = 134;
        nArray[237] = 217;
        nArray[238] = 76;
        nArray[239] = 115;
        nArray[240] = 65;
        nArray[241] = 89;
        nArray[242] = 202;
        nArray[243] = 13;
        nArray[244] = 123;
        nArray[245] = 181;
        nArray[246] = 94;
        nArray[247] = 35;
        nArray[248] = 38;
        nArray[249] = 253;
        nArray[250] = 153;
        nArray[251] = 104;
        nArray[252] = 137;
        nArray[253] = 244;
        nArray[254] = 208;
        nArray[255] = 102;
        nArray[256] = 94;
        nArray[257] = 142;
        nArray[258] = 58;
        nArray[259] = 219;
        nArray[260] = 141;
        nArray[261] = 132;
        nArray[262] = 166;
        nArray[263] = 136;
        nArray[264] = 174;
        nArray[265] = 247;
        nArray[266] = 99;
        nArray[267] = 31;
        nArray[268] = 50;
        nArray[269] = 74;
        nArray[270] = 68;
        nArray[271] = 79;
        nArray[272] = 106;
        nArray[273] = 89;
        nArray[274] = 51;
        nArray[275] = 71;
        nArray[276] = 70;
        nArray[277] = 6;
        nArray[278] = 84;
        nArray[279] = 69;
        nArray[280] = 139;
        nArray[281] = 229;
        nArray[282] = 78;
        nArray[283] = 232;
        nArray[284] = 188;
        nArray[285] = 118;
        nArray[286] = 26;
        nArray[287] = 17;
        int[] nArray2 = nArray;
        this.out.println("\nSAFER in CFB mode: safer -cfbkx 42431BA40D291F81D66083C605D3A4D6:74536EBDC211484A\n");
        byte[] byArray = new byte[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            byArray[n] = (byte)nArray2[n];
            ++n;
        }
        Cipher cipher = Cipher.getInstance((String)"SAFER/CFB", (String)"Cryptix");
        cipher.setParameter("variant", (Object)"K-128");
        ((FeedbackCipher)cipher).setInitializationVector(anIV);
        cipher.initEncrypt((Key)this.aKey);
        this.compareIt(cipher.crypt(input), byArray);
        this.out.println("\nDecrypting input and checking it against output:\n");
        cipher.initDecrypt((Key)this.aKey);
        this.compareIt(cipher.crypt(byArray), input);
    }

    private void test10() throws Exception {
        int[] nArray = new int[]{251, 221, 148, 3, 222, 99, 246, 105, 9, 253, 180, 32, 22, 75, 11, 213, 162, 53, 126, 83, 219, 33, 48, 193, 63, 143, 14, 194, 20, 93, 226, 67, 66, 17, 114, 26, 204, 190, 221, 173, 181, 32, 143, 213, 75, 56, 106, 155, 19, 68, 122, 230, 144, 69, 36, 218, 207, 25, 28, 90, 228, 113, 4, 170, 201, 65, 206, 75, 122, 23, 55, 252, 77, 162, 4, 254, 172, 25, 129, 238, 230, 17, 91, 175, 92, 252, 132, 126, 252, 174, 150, 132, 148, 118, 43, 206, 36, 16, 155, 58, 130, 46, 173, 74, 88, 230, 128, 171, 154, 183, 67, 235, 75, 70, 180, 110, 170, 220, 206, 193, 237, 221, 214, 64, 157, 118, 200, 3, 31, 200, 1, 251, 5, 54, 135, 22, 51, 245, 132, 202, 244, 202, 40, 39, 98, 110, 244, 198, 96, 90, 76, 174, 53, 128, 217, 224, 53, 69, 118, 51, 230, 117, 36, 211, 166, 41, 143, 183, 195, 155, 46, 49, 203, 54, 88, 70, 216, 185, 212, 220, 122, 45, 93, 43, 167, 67, 131, 82, 7, 104, 18, 90, 238, 97, 204, 240, 42, 153, 157, 105, 194, 77, 87, 247, 54, 210, 142, 56, 31, 191, 59, 182, 26, 200, 38, 91, 76, 22, 100, 209, 2, 135, 77, 156, 231, 128, 81, 241, 44, 218, 8, 227, 50, 236, 152, 128, 25, 206, 82, 62, 105, 57, 67, 153, 42, 57, 105, 198, 135, 68, 17, 54, 73, 216, 136, 9, 91, 85, 103, 146, 107, 37, 224, 1, 238, 149, 31, 133, 147, 138, 233, 61, 187, 120, 162, 6, 230, 35, 39, 75, 169, 142, 185, 209, 195, 141, 66, 198};
        this.out.println("\nSAFER in OFB mode: safer -ofbkx 42431BA40D291F81D66083C605D3A4D6:74536EBDC211484A\n");
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            byArray[n] = (byte)nArray[n];
            ++n;
        }
        Cipher cipher = Cipher.getInstance((String)"SAFER/OFB", (String)"Cryptix");
        cipher.setParameter("variant", (Object)"K-128");
        ((FeedbackCipher)cipher).setInitializationVector(anIV);
        cipher.initEncrypt((Key)this.aKey);
        this.compareIt(cipher.crypt(input), byArray);
        this.out.println("\nDecrypting input and checking it against output:\n");
        cipher.initDecrypt((Key)this.aKey);
        this.compareIt(cipher.crypt(byArray), input);
    }

    private void test11() throws Exception {
        int[] nArray = new int[288];
        nArray[0] = 251;
        nArray[1] = 221;
        nArray[2] = 148;
        nArray[3] = 3;
        nArray[4] = 222;
        nArray[5] = 99;
        nArray[6] = 246;
        nArray[7] = 105;
        nArray[8] = 226;
        nArray[9] = 42;
        nArray[10] = 71;
        nArray[11] = 84;
        nArray[12] = 68;
        nArray[13] = 15;
        nArray[14] = 77;
        nArray[15] = 253;
        nArray[16] = 159;
        nArray[17] = 242;
        nArray[18] = 171;
        nArray[19] = 246;
        nArray[20] = 112;
        nArray[21] = 85;
        nArray[22] = 1;
        nArray[23] = 17;
        nArray[24] = 201;
        nArray[25] = 140;
        nArray[26] = 36;
        nArray[27] = 25;
        nArray[28] = 241;
        nArray[29] = 217;
        nArray[30] = 207;
        nArray[31] = 44;
        nArray[32] = 80;
        nArray[33] = 203;
        nArray[34] = 156;
        nArray[35] = 123;
        nArray[36] = 6;
        nArray[37] = 117;
        nArray[38] = 108;
        nArray[39] = 33;
        nArray[40] = 253;
        nArray[41] = 118;
        nArray[42] = 156;
        nArray[43] = 50;
        nArray[44] = 215;
        nArray[45] = 83;
        nArray[46] = 192;
        nArray[47] = 211;
        nArray[48] = 192;
        nArray[49] = 96;
        nArray[50] = 132;
        nArray[51] = 205;
        nArray[52] = 118;
        nArray[53] = 92;
        nArray[54] = 206;
        nArray[55] = 254;
        nArray[56] = 202;
        nArray[57] = 230;
        nArray[58] = 171;
        nArray[59] = 236;
        nArray[60] = 51;
        nArray[61] = 135;
        nArray[62] = 233;
        nArray[63] = 194;
        nArray[64] = 53;
        nArray[65] = 57;
        nArray[66] = 72;
        nArray[67] = 89;
        nArray[69] = 227;
        nArray[70] = 222;
        nArray[71] = 39;
        nArray[72] = 185;
        nArray[73] = 94;
        nArray[74] = 100;
        nArray[75] = 159;
        nArray[76] = 46;
        nArray[77] = 224;
        nArray[78] = 186;
        nArray[79] = 134;
        nArray[80] = 232;
        nArray[81] = 36;
        nArray[82] = 54;
        nArray[83] = 169;
        nArray[84] = 81;
        nArray[85] = 223;
        nArray[86] = 150;
        nArray[87] = 161;
        nArray[88] = 105;
        nArray[89] = 97;
        nArray[90] = 100;
        nArray[91] = 184;
        nArray[92] = 37;
        nArray[93] = 205;
        nArray[94] = 111;
        nArray[95] = 144;
        nArray[96] = 43;
        nArray[97] = 156;
        nArray[98] = 135;
        nArray[99] = 129;
        nArray[100] = 56;
        nArray[101] = 57;
        nArray[102] = 2;
        nArray[103] = 115;
        nArray[104] = 59;
        nArray[105] = 120;
        nArray[106] = 171;
        nArray[107] = 26;
        nArray[108] = 204;
        nArray[109] = 97;
        nArray[110] = 254;
        nArray[111] = 53;
        nArray[112] = 164;
        nArray[113] = 17;
        nArray[114] = 135;
        nArray[115] = 22;
        nArray[116] = 23;
        nArray[117] = 121;
        nArray[118] = 49;
        nArray[119] = 144;
        nArray[120] = 173;
        nArray[121] = 38;
        nArray[122] = 181;
        nArray[123] = 61;
        nArray[124] = 227;
        nArray[125] = 132;
        nArray[126] = 145;
        nArray[127] = 40;
        nArray[128] = 75;
        nArray[129] = 69;
        nArray[130] = 65;
        nArray[131] = 164;
        nArray[132] = 65;
        nArray[133] = 64;
        nArray[134] = 25;
        nArray[135] = 9;
        nArray[136] = 199;
        nArray[137] = 38;
        nArray[138] = 132;
        nArray[139] = 165;
        nArray[140] = 135;
        nArray[141] = 97;
        nArray[142] = 129;
        nArray[143] = 144;
        nArray[144] = 4;
        nArray[145] = 179;
        nArray[146] = 112;
        nArray[147] = 60;
        nArray[148] = 182;
        nArray[149] = 250;
        nArray[150] = 222;
        nArray[151] = 252;
        nArray[152] = 248;
        nArray[153] = 23;
        nArray[154] = 59;
        nArray[155] = 228;
        nArray[156] = 191;
        nArray[158] = 56;
        nArray[159] = 237;
        nArray[160] = 163;
        nArray[161] = 20;
        nArray[162] = 30;
        nArray[163] = 104;
        nArray[164] = 216;
        nArray[165] = 45;
        nArray[166] = 209;
        nArray[167] = 254;
        nArray[168] = 107;
        nArray[169] = 188;
        nArray[170] = 169;
        nArray[171] = 97;
        nArray[172] = 173;
        nArray[173] = 41;
        nArray[174] = 205;
        nArray[175] = 249;
        nArray[176] = 164;
        nArray[177] = 128;
        nArray[178] = 120;
        nArray[179] = 201;
        nArray[180] = 215;
        nArray[181] = 188;
        nArray[182] = 35;
        nArray[183] = 103;
        nArray[184] = 108;
        nArray[185] = 202;
        nArray[186] = 174;
        nArray[187] = 140;
        nArray[188] = 138;
        nArray[189] = 95;
        nArray[190] = 241;
        nArray[191] = 71;
        nArray[192] = 83;
        nArray[193] = 199;
        nArray[194] = 70;
        nArray[195] = 162;
        nArray[196] = 73;
        nArray[197] = 226;
        nArray[198] = 87;
        nArray[199] = 84;
        nArray[200] = 43;
        nArray[201] = 17;
        nArray[202] = 178;
        nArray[203] = 203;
        nArray[204] = 21;
        nArray[205] = 250;
        nArray[206] = 128;
        nArray[207] = 159;
        nArray[208] = 137;
        nArray[209] = 190;
        nArray[210] = 174;
        nArray[211] = 11;
        nArray[212] = 215;
        nArray[213] = 22;
        nArray[214] = 155;
        nArray[215] = 34;
        nArray[216] = 34;
        nArray[217] = 169;
        nArray[218] = 13;
        nArray[219] = 95;
        nArray[220] = 208;
        nArray[221] = 118;
        nArray[222] = 231;
        nArray[223] = 89;
        nArray[224] = 88;
        nArray[225] = 179;
        nArray[226] = 4;
        nArray[227] = 29;
        nArray[228] = 176;
        nArray[229] = 17;
        nArray[230] = 64;
        nArray[231] = 235;
        nArray[232] = 58;
        nArray[233] = 88;
        nArray[234] = 114;
        nArray[235] = 65;
        nArray[236] = 57;
        nArray[237] = 96;
        nArray[238] = 211;
        nArray[239] = 163;
        nArray[240] = 188;
        nArray[241] = 18;
        nArray[242] = 100;
        nArray[243] = 4;
        nArray[244] = 91;
        nArray[245] = 45;
        nArray[246] = 233;
        nArray[247] = 80;
        nArray[248] = 217;
        nArray[249] = 90;
        nArray[250] = 45;
        nArray[251] = 93;
        nArray[252] = 144;
        nArray[253] = 82;
        nArray[254] = 60;
        nArray[255] = 203;
        nArray[256] = 224;
        nArray[257] = 81;
        nArray[258] = 113;
        nArray[259] = 231;
        nArray[260] = 159;
        nArray[261] = 185;
        nArray[262] = 171;
        nArray[263] = 128;
        nArray[264] = 109;
        nArray[265] = 224;
        nArray[266] = 154;
        nArray[267] = 141;
        nArray[268] = 33;
        nArray[269] = 66;
        nArray[270] = 255;
        nArray[271] = 44;
        nArray[272] = 112;
        nArray[273] = 41;
        nArray[274] = 125;
        nArray[275] = 205;
        nArray[276] = 154;
        nArray[277] = 174;
        nArray[278] = 226;
        nArray[279] = 225;
        nArray[280] = 173;
        nArray[281] = 243;
        nArray[282] = 107;
        nArray[283] = 172;
        nArray[284] = 214;
        nArray[285] = 234;
        nArray[286] = 22;
        nArray[287] = 186;
        int[] nArray2 = nArray;
        this.out.println("\nSAFER in CBC mode: safer -cbckx 42431BA40D291F81D66083C605D3A4D6:74536EBDC211484A\n");
        byte[] byArray = new byte[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            byArray[n] = (byte)nArray2[n];
            ++n;
        }
        Cipher cipher = Cipher.getInstance((String)"SAFER/CBC", (String)"Cryptix");
        cipher.setParameter("variant", (Object)"K-128");
        ((FeedbackCipher)cipher).setInitializationVector(anIV);
        cipher.initEncrypt((Key)this.aKey);
        byte[] byArray2 = cipher.crypt(input);
        this.compareIt(byArray2, byArray);
        this.out.println("\nNow decrypting this and checking it against input:\n");
        cipher.initDecrypt((Key)this.aKey);
        this.compareIt(cipher.crypt(byArray2), input);
    }

    private void compareIt(byte[] byArray, byte[] byArray2) {
        this.out.print("  computed output:" + Hex.dumpString((byte[])byArray));
        boolean bl = ArrayUtil.areEqual((byte[])byArray, (byte[])byArray2);
        if (!bl) {
            this.out.print("\n certified output:" + Hex.dumpString((byte[])byArray2));
        }
        this.passIf(bl, " *** SAFER OUTPUT");
    }

    TestSAFER() {
    }
}

