/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.CryptixException;
import cryptix.provider.cipher.NativeLink;
import cryptix.util.core.Debug;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.Cipher;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SymmetricCipher;

public final class RC4
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel((String)"RC4");
    private static final PrintWriter err = Debug.getOutput();
    private static NativeLink linkStatus = new NativeLink("RC4", 2, 3);
    private long native_cookie;
    private Object native_lock;
    private int[] sBox = new int[256];
    private int x;
    private int y;
    private static final int BLOCK_SIZE = 1;

    private static void debug(String string) {
        err.println("RC4: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(RC4.getLibMajorVersion(), RC4.getLibMinorVersion());
                        linkStatus.check(this.native_clinit());
                    }
                    if (linkStatus.useNative()) {
                        linkStatus.check(this.native_init());
                        this.native_lock = new Object();
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail((Throwable)unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    RC4.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                RC4.debug("Using native library? " + (this.native_lock != null));
            }
            return;
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private native String native_clinit();

    private native String native_init();

    private native String native_ks(long var1, byte[] var3);

    private native int native_crypt(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7);

    private native String native_finalize();

    public RC4() {
        super(false, false, "Cryptix");
    }

    protected final void finalize() {
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                String string = this.native_finalize();
                if (string != null) {
                    RC4.debug(String.valueOf(string) + " in native_finalize");
                }
                return;
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 1;
    }

    public void engineInitEncrypt(Key key) throws InvalidKeyException {
        this.makeKey(key);
    }

    public void engineInitDecrypt(Key key) throws InvalidKeyException {
        this.makeKey(key);
    }

    protected int engineUpdate(byte[] object, int n, int n2, byte[] byArray, int n3) {
        Object object2;
        if (n2 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        this.getState();
        if (object == byArray && (n3 >= n && (long)n3 < (long)n + (long)n2 || n >= n3 && (long)n < (long)n3 + (long)n2)) {
            object2 = new byte[n2];
            System.arraycopy(object, n, object2, 0, n2);
            object = object2;
            n = 0;
        }
        if (this.native_lock != null) {
            object2 = this.native_lock;
            synchronized (object2) {
                if (n < 0 || (long)n + (long)n2 > (long)((byte[])object).length || n3 < 0 || (long)n3 + (long)n2 > (long)byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(String.valueOf(this.getAlgorithm()) + ": Arguments to native_crypt would cause a buffer overflow");
                }
                if (this.native_crypt(this.native_cookie, (byte[])object, n, n2, byArray, n3) == 0) {
                    throw new CryptixException(String.valueOf(this.getAlgorithm()) + ": Error in native code");
                }
            }
        } else {
            this.rc4((byte[])object, n, n2, byArray, n3);
        }
        return n2;
    }

    private void rc4(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = 0;
        while (n4 < n2) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.sBox[this.x] + this.y & 0xFF;
            int n5 = this.sBox[this.x];
            this.sBox[this.x] = this.sBox[this.y];
            this.sBox[this.y] = n5;
            int n6 = this.sBox[this.x] + this.sBox[this.y] & 0xFF;
            byArray2[n3++] = (byte)(byArray[n++] ^ this.sBox[n6]);
            ++n4;
        }
    }

    private void makeKey(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(String.valueOf(this.getAlgorithm()) + ": Null user key");
        }
        int n = byArray.length;
        if (n == 0) {
            throw new InvalidKeyException(String.valueOf(this.getAlgorithm()) + ": Invalid user key length");
        }
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                try {
                    linkStatus.check(this.native_ks(this.native_cookie, byArray));
                    Object var5_6 = null;
                    return;
                }
                catch (Error error) {
                    this.native_finalize();
                    this.native_lock = null;
                    if (debuglevel > 0) {
                        RC4.debug(String.valueOf(error) + ". Will use 100% Java.");
                    }
                }
            }
        }
        this.y = 0;
        this.x = 0;
        int n2 = 0;
        while (n2 < 256) {
            this.sBox[n2] = n2;
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < 256) {
            n4 = (byArray[n3] & 0xFF) + this.sBox[n5] + n4 & 0xFF;
            int n6 = this.sBox[n5];
            this.sBox[n5] = this.sBox[n4];
            this.sBox[n4] = n6;
            n3 = (n3 + 1) % n;
            ++n5;
        }
    }
}

