/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.math;

import cryptix.util.core.ArrayUtil;
import java.io.Serializable;
import java.security.SecureRandom;

public class BigRegister
implements Cloneable,
Serializable {
    public static final int MAXIMUM_SIZE = 4096;
    private static final byte[] log2x;
    private static final byte[] high;
    private static final byte[] low;
    private static final String[] binaryDigits;
    private static final String m_1 = "size < 2";
    private static final String m_2 = "size > MAXIMUM_SIZE";
    private static final SecureRandom prng;
    private byte[] bits;
    private int size;
    private static final long serialVersionUID = 2535877383275048954L;

    public BigRegister(int n) {
        if (n < 2) {
            throw new IllegalArgumentException(m_1);
        }
        if (n > 4096) {
            throw new IllegalArgumentException(m_2);
        }
        this.size = n;
        this.bits = new byte[(n + 7) / 8];
    }

    private BigRegister(BigRegister bigRegister) {
        this.size = bigRegister.size;
        this.bits = (byte[])bigRegister.bits.clone();
    }

    public synchronized Object clone() {
        return new BigRegister(this);
    }

    public synchronized void and(BigRegister bigRegister) {
        if (this.size != bigRegister.size) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.bits.length) {
            int n2 = n;
            this.bits[n2] = (byte)(this.bits[n2] & bigRegister.bits[n]);
            ++n;
        }
    }

    public synchronized void andNot(BigRegister bigRegister) {
        if (this.size != bigRegister.size) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.bits.length) {
            int n2 = n;
            this.bits[n2] = (byte)(this.bits[n2] & ~bigRegister.bits[n]);
            ++n;
        }
    }

    public synchronized void or(BigRegister bigRegister) {
        if (this.size != bigRegister.size) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.bits.length) {
            int n2 = n;
            this.bits[n2] = (byte)(this.bits[n2] | bigRegister.bits[n]);
            ++n;
        }
        this.pad();
    }

    public synchronized void not() {
        int n = 0;
        while (n < this.bits.length) {
            this.bits[n] = ~this.bits[n];
            ++n;
        }
        this.pad();
    }

    public synchronized void xor(BigRegister bigRegister) {
        if (this.size != bigRegister.size) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.bits.length) {
            int n2 = n;
            this.bits[n2] = (byte)(this.bits[n2] ^ bigRegister.bits[n]);
            ++n;
        }
        this.pad();
    }

    public synchronized void shiftLeft(int n) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            this.shiftRight(-n);
            return;
        }
        if (n >= this.size) {
            this.reset();
            return;
        }
        int n2 = this.lowestSetBit();
        if (n2 == -1) {
            return;
        }
        if (n2 >= this.size - n) {
            this.reset();
            return;
        }
        n2 = n / 8;
        int n3 = n % 8;
        int n4 = this.bits.length;
        byte[] byArray = new byte[n4];
        if (n3 == 0) {
            System.arraycopy(this.bits, 0, byArray, n2, n4 - n2);
        } else {
            int n5 = 8 - n3;
            int n6 = n2;
            int n7 = 0;
            while (n6 < n4) {
                byArray[n6] = (byte)(this.bits[n7] << n3 | (n7 == 0 ? 0 : (this.bits[n7 - 1] & 0xFF) >>> n5));
                ++n6;
                ++n7;
            }
        }
        this.bits = byArray;
        this.pad();
    }

    public synchronized void shiftRight(int n) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            this.shiftLeft(-n);
            return;
        }
        if (n >= this.size) {
            this.reset();
            return;
        }
        int n2 = this.highestSetBit();
        if (n2 < 0) {
            return;
        }
        if (n2 < n) {
            this.reset();
            return;
        }
        n2 = n / 8;
        int n3 = n % 8;
        int n4 = this.bits.length;
        byte[] byArray = new byte[n4];
        if (n3 == 0) {
            System.arraycopy(this.bits, n2, byArray, 0, n4 - n2);
        } else {
            int n5 = 0;
            int n6 = n2;
            while (n5 < n4 && n6 < n4) {
                byArray[n5] = (byte)(((n6 == n4 - 1 ? 0 : this.bits[n6 + 1] << 8) | this.bits[n6] & 0xFF) >>> n3);
                ++n5;
                ++n6;
            }
        }
        this.bits = byArray;
        this.pad();
    }

    public synchronized void rotateLeft(int n) {
        if ((n %= this.size) == 0) {
            return;
        }
        if (n < 0) {
            this.rotateRight(-n);
            return;
        }
        BigRegister bigRegister = (BigRegister)this.clone();
        bigRegister.shiftRight(this.size - n);
        this.shiftLeft(n);
        this.or(bigRegister);
    }

    public synchronized void rotateRight(int n) {
        if ((n %= this.size) == 0) {
            return;
        }
        if (n < 0) {
            this.rotateLeft(-n);
            return;
        }
        BigRegister bigRegister = (BigRegister)this.clone();
        bigRegister.shiftLeft(this.size - n);
        this.shiftRight(n);
        this.or(bigRegister);
    }

    public synchronized void invertOrder() {
        byte[] byArray = new byte[this.bits.length];
        int n = 0;
        int n2 = this.size - 1;
        while (n < this.size) {
            if (this.testBit(n)) {
                int n3 = n2 / 8;
                byArray[n3] = (byte)(byArray[n3] | 1 << n2 % 8);
            }
            ++n;
            --n2;
        }
        this.bits = byArray;
    }

    public synchronized boolean testBit(int n) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException();
        }
        return (this.bits[n / 8] & 1 << n % 8) != 0;
    }

    public synchronized boolean isSameValue(BigRegister bigRegister) {
        if (bigRegister.size != this.size) {
            return false;
        }
        return ArrayUtil.areEqual(this.bits, bigRegister.bits);
    }

    public synchronized int compareTo(BigRegister bigRegister) {
        if (this.size > bigRegister.size) {
            return 1;
        }
        if (this.size < bigRegister.size) {
            return -1;
        }
        return ArrayUtil.compared(this.bits, bigRegister.bits, true);
    }

    public synchronized void setBit(int n) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException();
        }
        int n2 = n / 8;
        this.bits[n2] = (byte)(this.bits[n2] | 1 << n % 8);
    }

    public synchronized void setBits(int n, int n2, long l) {
        if (n < 0 || n > this.size || n2 < 1 || n2 > 64 || n + n2 > this.size) {
            throw new IllegalArgumentException();
        }
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            if ((l & 1L) == 1L) {
                int n5 = n4 / 8;
                this.bits[n5] = (byte)(this.bits[n5] | 1 << n4 % 8);
            }
            l >>>= 1;
            ++n3;
            ++n4;
        }
    }

    public synchronized void clearBit(int n) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException();
        }
        int n2 = n / 8;
        this.bits[n2] = (byte)(this.bits[n2] & ~(1 << n % 8));
    }

    public synchronized void flipBit(int n) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException();
        }
        int n2 = n / 8;
        this.bits[n2] = (byte)(this.bits[n2] ^ 1 << n % 8);
    }

    public synchronized int getBit(int n) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException();
        }
        return (this.bits[n / 8] & 0xFF) >> n % 8 & 1;
    }

    public synchronized long getBits(int n, int n2) {
        if (n < 0 || n > this.size || n2 < 1 || n2 > 64 || n + n2 > this.size) {
            throw new IllegalArgumentException();
        }
        long l = 0L;
        int n3 = 0;
        int n4 = n + n2 - 1;
        while (n3 < n2) {
            l = l << 1 | (long)((this.bits[n4 / 8] & 0xFF) >> n4 % 8 & 1);
            ++n3;
            --n4;
        }
        return l;
    }

    public synchronized int byteValue() {
        return this.bits[0] & 0xFF;
    }

    public synchronized int intValue() {
        int n = 0;
        int n2 = this.bits[n++] & 0xFF;
        try {
            n2 |= (this.bits[n++] & 0xFF) << 8 | (this.bits[n++] & 0xFF) << 16 | (this.bits[n] & 0xFF) << 24;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return n2;
    }

    public synchronized long longValue() {
        int n = 0;
        long l = (long)this.bits[n++] & 0xFFL;
        try {
            l |= ((long)this.bits[n++] & 0xFFL) << 8 | ((long)this.bits[n++] & 0xFFL) << 16 | ((long)this.bits[n++] & 0xFFL) << 24 | ((long)this.bits[n++] & 0xFFL) << 32 | ((long)this.bits[n++] & 0xFFL) << 40 | ((long)this.bits[n++] & 0xFFL) << 48 | ((long)this.bits[n] & 0xFFL) << 56;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return l;
    }

    public synchronized BigRegister valueOf(long l) {
        BigRegister bigRegister = new BigRegister(this.size);
        int n = Math.min(8, this.bits.length);
        int n2 = 0;
        while (n2 < n) {
            bigRegister.bits[n2] = (byte)(l >>> 8 * n2);
            ++n2;
        }
        bigRegister.pad();
        return bigRegister;
    }

    public synchronized void reset() {
        ArrayUtil.clear(this.bits);
    }

    public synchronized void atRandom() {
        this.atRandom(prng);
    }

    public synchronized void atRandom(SecureRandom secureRandom) {
        secureRandom.nextBytes(this.bits);
        this.pad();
    }

    public synchronized void load(BigRegister bigRegister) {
        if (this.size != bigRegister.size) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(bigRegister.bits, 0, this.bits, 0, this.bits.length);
    }

    public synchronized void load(byte[] byArray) {
        int n = byArray.length;
        int n2 = this.bits.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(byArray, 0, this.bits, 0, n);
        if (n < n2) {
            ArrayUtil.clear(this.bits, n, n2 - n);
        }
        this.pad();
    }

    public synchronized byte[] toByteArray() {
        return (byte[])this.bits.clone();
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized int countSetBits() {
        int n = 0;
        int n2 = this.bits.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = this.bits[n3];
            n += by < 0 ? 8 : log2x[by & 0xFF];
            ++n3;
        }
        return n;
    }

    public synchronized int highestSetBit() {
        int n = this.bits.length - 1;
        while (n > 0 && this.bits[n] == 0) {
            --n;
        }
        if (this.bits[n] == 0) {
            return -1;
        }
        int n2 = this.bits[n] >>> 4 & 0xF;
        int n3 = 4;
        if (n2 == 0) {
            n2 = this.bits[n] & 0xF;
            n3 -= 4;
        }
        return n * 8 + (n3 += high[n2]);
    }

    public synchronized int lowestSetBit() {
        int n = 0;
        int n2 = this.bits.length;
        while (n < n2 && this.bits[n] == 0) {
            ++n;
        }
        if (n == n2) {
            return -1;
        }
        int n3 = this.bits[n] & 0xF;
        int n4 = 0;
        if (n3 == 0) {
            n3 = this.bits[n] >>> 4 & 0xF;
            n4 += 4;
        }
        return n * 8 + (n4 += low[n3]);
    }

    public synchronized String toString() {
        int n;
        int n2;
        String string;
        StringBuffer stringBuffer = new StringBuffer(8 * this.bits.length + 64);
        stringBuffer.append("Binary dump of a BigRegister [").append(this.size).append("-bit]...\n");
        stringBuffer.append("Byte #:|........|........|........|........|........|........|........|........|\n");
        int n3 = this.bits.length;
        int n4 = n3-- % 8;
        if (n4 != 0) {
            string = "      " + String.valueOf(this.bits.length);
            stringBuffer.append(string.substring(string.length() - 6)).append(':');
            n2 = 0;
            while (n2 < 8 - n4) {
                stringBuffer.append("         ");
                ++n2;
            }
            n2 = 0;
            while (n2 < n4) {
                n = this.bits[n3--] & 0xFF;
                stringBuffer.append(' ').append(binaryDigits[n >>> 4 & 0xF]).append(binaryDigits[n & 0xF]);
                ++n2;
            }
            stringBuffer.append('\n');
        }
        int n5 = (n3 + 1) / 8;
        n2 = 0;
        while (n2 < n5) {
            string = "      " + String.valueOf(8 * (n5 - n2));
            stringBuffer.append(string.substring(string.length() - 6)).append(':');
            int n6 = 0;
            while (n6 < 8) {
                n = this.bits[n3--] & 0xFF;
                stringBuffer.append(' ').append(binaryDigits[n >>> 4 & 0xF]).append(binaryDigits[n & 0xF]);
                ++n6;
            }
            stringBuffer.append('\n');
            ++n2;
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    private synchronized void pad() {
        int n = 8 - this.size % 8;
        if (n != 8) {
            int n2 = this.bits.length - 1;
            this.bits[n2] = (byte)(this.bits[n2] & 255 >>> n);
        }
    }

    static {
        byte[] byArray = new byte[128];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 2;
        byArray[4] = 3;
        byArray[5] = 3;
        byArray[6] = 3;
        byArray[7] = 3;
        byArray[8] = 4;
        byArray[9] = 4;
        byArray[10] = 4;
        byArray[11] = 4;
        byArray[12] = 4;
        byArray[13] = 4;
        byArray[14] = 4;
        byArray[15] = 4;
        byArray[16] = 5;
        byArray[17] = 5;
        byArray[18] = 5;
        byArray[19] = 5;
        byArray[20] = 5;
        byArray[21] = 5;
        byArray[22] = 5;
        byArray[23] = 5;
        byArray[24] = 5;
        byArray[25] = 5;
        byArray[26] = 5;
        byArray[27] = 5;
        byArray[28] = 5;
        byArray[29] = 5;
        byArray[30] = 5;
        byArray[31] = 5;
        byArray[32] = 6;
        byArray[33] = 6;
        byArray[34] = 6;
        byArray[35] = 6;
        byArray[36] = 6;
        byArray[37] = 6;
        byArray[38] = 6;
        byArray[39] = 6;
        byArray[40] = 6;
        byArray[41] = 6;
        byArray[42] = 6;
        byArray[43] = 6;
        byArray[44] = 6;
        byArray[45] = 6;
        byArray[46] = 6;
        byArray[47] = 6;
        byArray[48] = 6;
        byArray[49] = 6;
        byArray[50] = 6;
        byArray[51] = 6;
        byArray[52] = 6;
        byArray[53] = 6;
        byArray[54] = 6;
        byArray[55] = 6;
        byArray[56] = 6;
        byArray[57] = 6;
        byArray[58] = 6;
        byArray[59] = 6;
        byArray[60] = 6;
        byArray[61] = 6;
        byArray[62] = 6;
        byArray[63] = 6;
        byArray[64] = 7;
        byArray[65] = 7;
        byArray[66] = 7;
        byArray[67] = 7;
        byArray[68] = 7;
        byArray[69] = 7;
        byArray[70] = 7;
        byArray[71] = 7;
        byArray[72] = 7;
        byArray[73] = 7;
        byArray[74] = 7;
        byArray[75] = 7;
        byArray[76] = 7;
        byArray[77] = 7;
        byArray[78] = 7;
        byArray[79] = 7;
        byArray[80] = 7;
        byArray[81] = 7;
        byArray[82] = 7;
        byArray[83] = 7;
        byArray[84] = 7;
        byArray[85] = 7;
        byArray[86] = 7;
        byArray[87] = 7;
        byArray[88] = 7;
        byArray[89] = 7;
        byArray[90] = 7;
        byArray[91] = 7;
        byArray[92] = 7;
        byArray[93] = 7;
        byArray[94] = 7;
        byArray[95] = 7;
        byArray[96] = 7;
        byArray[97] = 7;
        byArray[98] = 7;
        byArray[99] = 7;
        byArray[100] = 7;
        byArray[101] = 7;
        byArray[102] = 7;
        byArray[103] = 7;
        byArray[104] = 7;
        byArray[105] = 7;
        byArray[106] = 7;
        byArray[107] = 7;
        byArray[108] = 7;
        byArray[109] = 7;
        byArray[110] = 7;
        byArray[111] = 7;
        byArray[112] = 7;
        byArray[113] = 7;
        byArray[114] = 7;
        byArray[115] = 7;
        byArray[116] = 7;
        byArray[117] = 7;
        byArray[118] = 7;
        byArray[119] = 7;
        byArray[120] = 7;
        byArray[121] = 7;
        byArray[122] = 7;
        byArray[123] = 7;
        byArray[124] = 7;
        byArray[125] = 7;
        byArray[126] = 7;
        byArray[127] = 7;
        log2x = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[2] = 1;
        byArray2[3] = 1;
        byArray2[4] = 2;
        byArray2[5] = 2;
        byArray2[6] = 2;
        byArray2[7] = 2;
        byArray2[8] = 3;
        byArray2[9] = 3;
        byArray2[10] = 3;
        byArray2[11] = 3;
        byArray2[12] = 3;
        byArray2[13] = 3;
        byArray2[14] = 3;
        byArray2[15] = 3;
        high = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[2] = 1;
        byArray3[4] = 2;
        byArray3[6] = 1;
        byArray3[8] = 3;
        byArray3[10] = 1;
        byArray3[12] = 2;
        byArray3[14] = 1;
        low = byArray3;
        binaryDigits = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};
        prng = new SecureRandom();
    }
}

