extern char *malloc(), *realloc();

# line 2 "gram.y"

/*
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This software was developed by the Computer Systems Engineering group
 * at Lawrence Berkeley Laboratory under DARPA contract BG 91-66 and
 * contributed to Berkeley.
 *
 * All advertising materials mentioning features or use of this software
 * must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Lawrence Berkeley Laboratories.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)gram.y	8.1 (Berkeley) 6/6/93
 *	$Id: gram.y,v 1.2 1995/04/28 08:15:48 cgd Exp $
 */

#include <sys/param.h>
#include <ctype.h>
#include <paths.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include "sem.h"

#define	FORMAT(n) ((n) > -10 && (n) < 10 ? "%d" : "0x%x")

#define	stop(s)	error(s), exit(1)

int	include __P((const char *, int));
void	yyerror __P((const char *));
int	yylex __P((void));
extern const char *lastfile;

static	struct	config conf;	/* at most one active at a time */

/* the following is used to recover nvlist space after errors */
static	struct	nvlist *alloc[1000];
static	int	adepth;
#define	new0(n,s,p,i)	(alloc[adepth++] = newnv(n, s, p, i))
#define	new_n(n)	new0(n, NULL, NULL, 0)
#define	new_ns(n, s)	new0(n, s, NULL, 0)
#define	new_si(s, i)	new0(NULL, s, NULL, i)
#define	new_nsi(n,s,i)	new0(n, s, NULL, i)
#define	new_np(n, p)	new0(n, NULL, p, 0)
#define	new_s(s)	new0(NULL, s, NULL, 0)
#define	new_p(p)	new0(NULL, NULL, p, 0)

static	void	cleanup __P((void));
static	void	setmachine __P((const char *, const char *));
static	void	setmaxpartitions __P((int));


# line 86 "gram.y"
typedef union  {
	struct	attr *attr;
	struct	devbase *devb;
	struct	nvlist *list;
	const char *str;
	int	val;
} YYSTYPE;
# define AND 257
# define AT 258
# define COMPILE_WITH 259
# define CONFIG 260
# define DEFINE 261
# define DEVICE 262
# define DUMPS 263
# define ENDFILE 264
# define XFILE 265
# define FLAGS 266
# define INCLUDE 267
# define XMACHINE 268
# define MAJOR 269
# define MAKEOPTIONS 270
# define MAXUSERS 271
# define MAXPARTITIONS 272
# define MINOR 273
# define ON 274
# define OPTIONS 275
# define PSEUDO_DEVICE 276
# define ROOT 277
# define SWAP 278
# define VECTOR 279
# define FFLAG 280
# define NUMBER 281
# define PATHNAME 282
# define WORD 283
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 368 "gram.y"


void
yyerror(s)
	const char *s;
{

	error("%s", s);
}

/*
 * Cleanup procedure after syntax error: release any nvlists
 * allocated during parsing the current line.
 */
static void
cleanup()
{
	register struct nvlist **np;
	register int i;

	for (np = alloc, i = adepth; --i >= 0; np++)
		nvfree(*np);
	adepth = 0;
}

static void
setmachine(mch, mcharch)
	const char *mch;
	const char *mcharch;
{
	char buf[MAXPATHLEN], archbuf[MAXPATHLEN];

	machine = mch;
	machinearch = mcharch;
	if (machinearch != NULL)
		(void)sprintf(archbuf, "../../%s/conf/files.%s",
		    machinearch, machinearch);
	else
		strncpy(archbuf, _PATH_DEVNULL, MAXPATHLEN);
	(void)sprintf(buf, "files.%s", machine);

	if (include(buf, ENDFILE) ||
	    include(archbuf, ENDFILE) ||
	    include("../../../conf/files", ENDFILE))
		exit(1);
}

static void
setmaxpartitions(n)
	int n;
{

	maxpartitions = n;
}
int yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 38,
	272, 11,
	10, 11,
	-2, 0,
-1, 103,
	0, 1,
	-2, 0,
	};
# define YYNPROD 112
# define YYLAST 308
int yyact[]={

   110,    95,    95,   170,   164,   147,    61,    57,   128,   125,
   132,   148,    60,   131,   100,   102,    65,    17,   162,   176,
   171,    33,    78,    49,    31,    27,    12,    11,    37,   179,
   174,   172,   145,   129,   104,    89,    87,    84,    62,    42,
    34,   143,    80,   155,   177,    72,     8,   133,    41,   173,
    52,    91,   165,   166,   154,   141,   142,    86,   127,   124,
   140,    67,    74,    40,    36,    20,    19,    99,     7,    43,
   105,    64,    59,    76,    54,    39,    13,    46,    10,   160,
   138,   136,    77,    68,    44,    48,   137,   135,    82,    75,
   134,    47,    28,   122,   121,    30,    29,   139,   130,   126,
   159,   123,   109,   108,    45,    38,    16,    14,    51,     4,
   103,    50,     3,     2,    32,     1,    35,   168,   144,    93,
   163,   146,   119,   169,   158,    63,    79,    55,    53,    71,
    58,    85,    69,     0,     0,    70,     0,     0,     0,     0,
     0,     0,    66,     0,     0,    83,     0,     0,    88,     0,
    90,     0,    96,    98,   101,    97,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   106,   107,   113,
   112,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   150,     0,
   152,     0,     0,     0,     0,   149,   151,   156,   157,    56,
   153,     0,     0,     0,     0,     0,     0,     0,   161,     0,
     0,   167,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   175,     0,     0,   178,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    94,    94,    92,
    92,     0,     0,     0,     0,     0,   111,     0,     0,     0,
   117,     0,     0,     0,     0,    26,     0,     9,     0,     0,
   115,   116,     0,    18,     0,   114,   118,     0,    21,    22,
     0,    15,    26,   120,     9,     0,    25,    81,    23,     0,
     0,     0,     0,    24,     0,     0,     0,     0,     0,     0,
     0,     0,     6,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     9,     5,     0,     0,    73 };
int yypact[]={

 -1000, -1000,    36, -1000, -1000,  -256, -1000, -1000, -1000,  -257,
     7,  -258, -1000, -1000, -1000, -1000,    86, -1000,    85, -1000,
 -1000,  -259,  -262,  -241,  -262,   -59,  -254, -1000,     7, -1000,
 -1000,   -60,  -210, -1000,  -242,    26,  -262,  -260,  -206, -1000,
   -84,  -271,  -243, -1000,  -267,    17, -1000,    22, -1000,  -260,
 -1000,    35, -1000,   -63, -1000,    45,    21,  -261,    -2, -1000,
 -1000, -1000, -1000,    44, -1000, -1000, -1000,  -262,  -244,  -223,
 -1000,     7, -1000,  -246, -1000,   -84, -1000,   -43,    21,   -60,
  -271,  -269,  -267, -1000, -1000, -1000, -1000,  -268, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000,  -247,   -23,    26, -1000, -1000,
  -269, -1000, -1000,   -10, -1000, -1000, -1000, -1000, -1000,    84,
 -1000,    83, -1000, -1000,  -274,  -275,  -248,  -270,  -273,  -211,
    48, -1000, -1000,    43, -1000,    20,    42, -1000,    19, -1000,
  -222, -1000,  -249,  -272, -1000,  -274,   -43,  -275,   -43,  -222,
 -1000,  -231,  -231,  -231, -1000, -1000, -1000, -1000,    37, -1000,
 -1000, -1000, -1000, -1000,  -265, -1000,  -265,  -265,  -263, -1000,
 -1000, -1000, -1000, -1000,  -250, -1000,  -208, -1000, -1000, -1000,
  -251,   -44,  -229,  -265, -1000, -1000, -1000,  -252, -1000, -1000 };
int yypgo[]={

     0,    85,   132,   131,    71,    91,   130,    75,    72,   128,
    74,   127,    73,   126,    67,    69,   125,   124,   123,    52,
    53,   122,   121,    51,   120,   119,   118,   117,   115,   113,
   112,    78,    76,   111,   110,   109,    65,   108,    66,   107,
   106,   104,    77,   103,   102,   101,    99,    98,    97,    58,
    59,    60,    54 };
int yyr1[]={

     0,    28,    29,    29,    35,    35,    30,    30,    30,    32,
    37,    37,    33,    33,    38,     1,     1,     2,     2,     3,
     3,    36,    31,    31,    39,    39,    39,    40,    40,    40,
    40,    40,    40,    40,     6,     6,     8,     8,    13,    13,
    14,    14,     5,     7,     7,     9,     9,    10,    10,    11,
    11,    11,    12,    23,    23,    25,    25,    15,    15,    16,
    16,     4,    41,    41,    42,    34,    34,    43,    43,    43,
    44,    44,    44,    44,    44,    44,    44,    44,    46,    46,
    49,    45,    45,    50,    50,    47,    48,    48,    51,    51,
    51,    19,    19,    20,    20,    24,    52,    52,    26,    26,
    21,    21,    22,    22,    22,    22,    17,    17,    18,    18,
    27,    27 };
int yyr2[]={

     0,    20,     4,     0,     2,     2,     5,     7,     3,     3,
     4,     0,     7,     3,    11,     5,     1,     5,     1,     5,
     1,     5,     4,     0,     5,     2,     5,     2,     2,     7,
    15,     9,     7,     8,     7,     3,     3,     3,     5,     1,
     5,     3,     3,     7,     1,     3,     1,     7,     3,     5,
     3,     9,     5,     3,     3,     3,     5,     5,     1,     7,
     3,     3,     6,     2,     7,     4,     0,     5,     2,     5,
     2,     2,     4,     4,     5,     7,     7,    11,     6,     2,
     7,     6,     2,     3,     7,     3,     4,     2,     7,     7,
     7,     7,     3,     3,     3,     9,     2,     0,     3,     1,
     5,     3,     3,     5,     5,     3,     5,     1,     5,     5,
     5,     1 };
int yychk[]={

 -1000,   -28,   -29,   -30,   -35,   268,   256,   -36,    10,   267,
   -31,   283,   283,   -32,   -39,   264,   -40,    10,   256,   -38,
   -36,   261,   262,   271,   276,   269,   265,   283,   -31,    10,
    10,   283,    -5,   283,   281,    -5,   123,   282,   -32,    -7,
   123,   258,   281,   -15,    58,   -41,   -42,    -5,    -1,   283,
   -33,   -37,   256,    -9,   -10,   -11,   283,    91,    -6,    -8,
   283,   277,   281,   -16,    -4,   283,   125,    44,    61,    -2,
    -1,   -31,    10,   272,   125,    44,   -12,    61,   283,   -13,
    44,   279,    44,   -42,   281,    -3,   280,   259,   -32,   281,
   -10,   -23,   283,   -25,   281,    45,   -12,    -7,    -8,   -14,
   283,    -4,   283,   -34,   281,    93,   -15,   -14,   -43,   -44,
    10,   256,   -38,   -36,   275,   270,   271,   260,   276,   -21,
   283,    10,    10,   -45,   -50,   283,   -46,   -49,   283,   281,
   -47,   283,   283,   258,    42,    44,    61,    44,    61,   -48,
   -51,   277,   278,   263,   -26,   281,   -22,   277,   283,   -50,
   -23,   -49,   -23,   -51,   -52,   274,   -52,   -52,   -17,    63,
    42,   -20,   283,   -24,   269,   -19,   -20,   -20,   -27,   -18,
   266,   283,   281,   257,   281,   -23,    63,   273,   -19,   281 };
int yydef[]={

     3,    -2,     0,    23,     2,     0,     8,     4,     5,     0,
     0,     6,    21,    23,    22,     9,     0,    25,     0,    27,
    28,     0,     0,     0,     0,     0,     0,     7,     0,    24,
    26,    44,     0,    42,     0,    58,     0,    16,    -2,    29,
    46,     0,     0,    32,     0,     0,    63,     0,    18,    16,
    23,     0,    13,     0,    45,    48,    50,     0,    39,    35,
    36,    37,    31,    57,    60,    61,    33,     0,     0,    20,
    15,     0,    10,     0,    43,     0,    49,     0,     0,    44,
     0,     0,     0,    62,    64,    14,    17,     0,    66,    12,
    47,    52,    53,    54,    55,     0,     0,    58,    34,    38,
    41,    59,    19,    -2,    56,    51,    30,    40,    65,     0,
    68,     0,    70,    71,     0,     0,     0,     0,     0,     0,
   101,    67,    69,    72,    82,    83,    73,    79,     0,    74,
     0,    85,    99,     0,   100,     0,     0,     0,     0,    75,
    87,    97,    97,    97,    76,    98,   107,   102,   105,    81,
    84,    78,    80,    86,     0,    96,     0,     0,   111,   103,
   104,    88,    93,    94,     0,    89,    92,    90,    77,   106,
     0,     0,     0,     0,   110,   108,   109,     0,    91,    95 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"AND",	257,
	"AT",	258,
	"COMPILE_WITH",	259,
	"CONFIG",	260,
	"DEFINE",	261,
	"DEVICE",	262,
	"DUMPS",	263,
	"ENDFILE",	264,
	"XFILE",	265,
	"FLAGS",	266,
	"INCLUDE",	267,
	"XMACHINE",	268,
	"MAJOR",	269,
	"MAKEOPTIONS",	270,
	"MAXUSERS",	271,
	"MAXPARTITIONS",	272,
	"MINOR",	273,
	"ON",	274,
	"OPTIONS",	275,
	"PSEUDO_DEVICE",	276,
	"ROOT",	277,
	"SWAP",	278,
	"VECTOR",	279,
	"FFLAG",	280,
	"NUMBER",	281,
	"PATHNAME",	282,
	"WORD",	283,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"Configuration : hdrs machine_spec dev_defs dev_eof dev_defs dev_eof maxpart_spec dev_defs dev_eof specs",
	"hdrs : hdrs hdr",
	"hdrs : /* empty */",
	"hdr : include",
	"hdr : '\n'",
	"machine_spec : XMACHINE WORD",
	"machine_spec : XMACHINE WORD WORD",
	"machine_spec : error",
	"dev_eof : ENDFILE",
	"maxpart_blanks : maxpart_blanks '\n'",
	"maxpart_blanks : /* empty */",
	"maxpart_spec : maxpart_blanks MAXPARTITIONS NUMBER",
	"maxpart_spec : error",
	"file : XFILE PATHNAME fopts fflgs rule",
	"fopts : WORD fopts",
	"fopts : /* empty */",
	"fflgs : fflgs FFLAG",
	"fflgs : /* empty */",
	"rule : COMPILE_WITH WORD",
	"rule : /* empty */",
	"include : INCLUDE WORD",
	"dev_defs : dev_defs dev_def",
	"dev_defs : /* empty */",
	"dev_def : one_def '\n'",
	"dev_def : '\n'",
	"dev_def : error '\n'",
	"one_def : file",
	"one_def : include",
	"one_def : DEFINE WORD interface_opt",
	"one_def : DEVICE devbase AT atlist veclist_opt interface_opt attrs_opt",
	"one_def : MAXUSERS NUMBER NUMBER NUMBER",
	"one_def : PSEUDO_DEVICE devbase attrs_opt",
	"one_def : MAJOR '{' majorlist '}'",
	"atlist : atlist ',' atname",
	"atlist : atname",
	"atname : WORD",
	"atname : ROOT",
	"veclist_opt : VECTOR veclist",
	"veclist_opt : /* empty */",
	"veclist : WORD veclist",
	"veclist : WORD",
	"devbase : WORD",
	"interface_opt : '{' loclist_opt '}'",
	"interface_opt : /* empty */",
	"loclist_opt : loclist",
	"loclist_opt : /* empty */",
	"loclist : locdef ',' loclist",
	"loclist : locdef",
	"locdef : WORD locdefault",
	"locdef : WORD",
	"locdef : '[' WORD locdefault ']'",
	"locdefault : '=' value",
	"value : WORD",
	"value : signed_number",
	"signed_number : NUMBER",
	"signed_number : '-' NUMBER",
	"attrs_opt : ':' attrs",
	"attrs_opt : /* empty */",
	"attrs : attrs ',' attr",
	"attrs : attr",
	"attr : WORD",
	"majorlist : majorlist ',' majordef",
	"majorlist : majordef",
	"majordef : devbase '=' NUMBER",
	"specs : specs spec",
	"specs : /* empty */",
	"spec : config_spec '\n'",
	"spec : '\n'",
	"spec : error '\n'",
	"config_spec : file",
	"config_spec : include",
	"config_spec : OPTIONS opt_list",
	"config_spec : MAKEOPTIONS mkopt_list",
	"config_spec : MAXUSERS NUMBER",
	"config_spec : CONFIG conf sysparam_list",
	"config_spec : PSEUDO_DEVICE WORD npseudo",
	"config_spec : device_instance AT attachment locators flags_opt",
	"mkopt_list : mkopt_list ',' mkoption",
	"mkopt_list : mkoption",
	"mkoption : WORD '=' value",
	"opt_list : opt_list ',' option",
	"opt_list : option",
	"option : WORD",
	"option : WORD '=' value",
	"conf : WORD",
	"sysparam_list : sysparam_list sysparam",
	"sysparam_list : sysparam",
	"sysparam : ROOT on_opt dev_spec",
	"sysparam : SWAP on_opt swapdev_list",
	"sysparam : DUMPS on_opt dev_spec",
	"swapdev_list : dev_spec AND swapdev_list",
	"swapdev_list : dev_spec",
	"dev_spec : WORD",
	"dev_spec : major_minor",
	"major_minor : MAJOR NUMBER MINOR NUMBER",
	"on_opt : ON",
	"on_opt : /* empty */",
	"npseudo : NUMBER",
	"npseudo : /* empty */",
	"device_instance : WORD '*'",
	"device_instance : WORD",
	"attachment : ROOT",
	"attachment : WORD '?'",
	"attachment : WORD '*'",
	"attachment : WORD",
	"locators : locators locator",
	"locators : /* empty */",
	"locator : WORD value",
	"locator : WORD '?'",
	"flags_opt : FLAGS NUMBER",
	"flags_opt : /* empty */",
};
#endif /* YYDEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	{ free(yys); free(yyv); return(0); }
#define YYABORT		{ free(yys); free(yyv); return(1); }
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** static variables used by the parser
*/
static YYSTYPE *yyv;			/* value stack */
static int *yys;			/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */

int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */
	unsigned yymaxdepth = YYMAXDEPTH;

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yyv = (YYSTYPE*)malloc(yymaxdepth*sizeof(YYSTYPE));
	yys = (int*)malloc(yymaxdepth*sizeof(int));
	if (!yyv || !yys)
	{
		yyerror( "out of memory" );
		return(1);
	}
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			(void)printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			yymaxdepth += YYMAXDEPTH;
			yyv = (YYSTYPE*)realloc((char*)yyv,
				yymaxdepth * sizeof(YYSTYPE));
			yys = (int*)realloc((char*)yys,
				yymaxdepth * sizeof(int));
			if (!yyv || !yys)
			{
				yyerror( "yacc stack overflow" );
				return(1);
			}
			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			(void)printf( "Received token " );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				(void)printf( "Received token " );
				if ( yychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( yychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						(void)printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					(void)printf( "Error recovery discards " );
					if ( yychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 6:
# line 143 "gram.y"
 { setmachine(yypvt[-0].str,NULL); } break;
case 7:
# line 144 "gram.y"
 { setmachine(yypvt[-1].str,yypvt[-0].str); } break;
case 8:
# line 145 "gram.y"
 { stop("cannot proceed without machine specifier"); } break;
case 9:
# line 148 "gram.y"
 { enddefs(lastfile); checkfiles(); } break;
case 12:
# line 155 "gram.y"
 { setmaxpartitions(yypvt[-0].val); } break;
case 13:
# line 156 "gram.y"
 { stop("cannot proceed without maxpartitions specifier"); } break;
case 14:
# line 162 "gram.y"
 { addfile(yypvt[-3].str, yypvt[-2].list, yypvt[-1].val, yypvt[-0].str); } break;
case 15:
# line 166 "gram.y"
 { (yyval.list = new_n(yypvt[-1].str))->nv_next = yypvt[-0].list; } break;
case 16:
# line 167 "gram.y"
 { yyval.list = NULL; } break;
case 17:
# line 170 "gram.y"
 { yyval.val = yypvt[-1].val | yypvt[-0].val; } break;
case 18:
# line 171 "gram.y"
 { yyval.val = 0; } break;
case 19:
# line 174 "gram.y"
 { yyval.str = yypvt[-0].str; } break;
case 20:
# line 175 "gram.y"
 { yyval.str = NULL; } break;
case 21:
# line 178 "gram.y"
 { (void)include(yypvt[-0].str, '\n'); } break;
case 24:
# line 188 "gram.y"
 { adepth = 0; } break;
case 26:
# line 190 "gram.y"
 { cleanup(); } break;
case 29:
# line 195 "gram.y"
 { (void)defattr(yypvt[-1].str, yypvt[-0].list); } break;
case 30:
# line 197 "gram.y"
 { defdev(yypvt[-5].devb, 0, yypvt[-3].list, yypvt[-2].list, yypvt[-1].list, yypvt[-0].list); } break;
case 31:
# line 198 "gram.y"
 { setdefmaxusers(yypvt[-2].val, yypvt[-1].val, yypvt[-0].val); } break;
case 32:
# line 199 "gram.y"
 { defdev(yypvt[-1].devb,1,NULL,NULL,NULL,yypvt[-0].list); } break;
case 34:
# line 203 "gram.y"
 { (yyval.list = new_n(yypvt[-0].str))->nv_next = yypvt[-2].list; } break;
case 35:
# line 204 "gram.y"
 { yyval.list = new_n(yypvt[-0].str); } break;
case 36:
# line 207 "gram.y"
 { yyval.str = yypvt[-0].str; } break;
case 37:
# line 208 "gram.y"
 { yyval.str = NULL; } break;
case 38:
# line 211 "gram.y"
 { yyval.list = yypvt[-0].list; } break;
case 39:
# line 212 "gram.y"
 { yyval.list = NULL; } break;
case 40:
# line 216 "gram.y"
 { (yyval.list = new_n(yypvt[-1].str))->nv_next = yypvt[-0].list; } break;
case 41:
# line 217 "gram.y"
 { yyval.list = new_n(yypvt[-0].str); } break;
case 42:
# line 220 "gram.y"
 { yyval.devb = getdevbase(yypvt[-0].str); } break;
case 43:
# line 223 "gram.y"
 { (yyval.list = new_n(""))->nv_next = yypvt[-1].list; } break;
case 44:
# line 224 "gram.y"
 { yyval.list = NULL; } break;
case 45:
# line 227 "gram.y"
 { yyval.list = yypvt[-0].list; } break;
case 46:
# line 228 "gram.y"
 { yyval.list = NULL; } break;
case 47:
# line 232 "gram.y"
 { (yyval.list = yypvt[-2].list)->nv_next = yypvt[-0].list; } break;
case 48:
# line 233 "gram.y"
 { yyval.list = yypvt[-0].list; } break;
case 49:
# line 237 "gram.y"
 { yyval.list = new_nsi(yypvt[-1].str, yypvt[-0].str, 0); } break;
case 50:
# line 238 "gram.y"
 { yyval.list = new_nsi(yypvt[-0].str, NULL, 0); } break;
case 51:
# line 239 "gram.y"
 { yyval.list = new_nsi(yypvt[-2].str, yypvt[-1].str, 1); } break;
case 52:
# line 242 "gram.y"
 { yyval.str = yypvt[-0].str; } break;
case 53:
# line 245 "gram.y"
 { yyval.str = yypvt[-0].str; } break;
case 54:
# line 246 "gram.y"
 { char bf[40];
					    (void)sprintf(bf, FORMAT(yypvt[-0].val), yypvt[-0].val);
					    yyval.str = intern(bf); } break;
case 55:
# line 251 "gram.y"
 { yyval.val = yypvt[-0].val; } break;
case 56:
# line 252 "gram.y"
 { yyval.val = -yypvt[-0].val; } break;
case 57:
# line 255 "gram.y"
 { yyval.list = yypvt[-0].list; } break;
case 58:
# line 256 "gram.y"
 { yyval.list = NULL; } break;
case 59:
# line 259 "gram.y"
 { (yyval.list = new_p(yypvt[-0].attr))->nv_next = yypvt[-2].list; } break;
case 60:
# line 260 "gram.y"
 { yyval.list = new_p(yypvt[-0].attr); } break;
case 61:
# line 263 "gram.y"
 { yyval.attr = getattr(yypvt[-0].str); } break;
case 64:
# line 270 "gram.y"
 { setmajor(yypvt[-2].devb, yypvt[-0].val); } break;
case 67:
# line 282 "gram.y"
 { adepth = 0; } break;
case 69:
# line 284 "gram.y"
 { cleanup(); } break;
case 74:
# line 291 "gram.y"
 { setmaxusers(yypvt[-0].val); } break;
case 75:
# line 292 "gram.y"
 { addconf(&conf); } break;
case 76:
# line 293 "gram.y"
 { addpseudo(yypvt[-1].str, yypvt[-0].val); } break;
case 77:
# line 295 "gram.y"
 { adddev(yypvt[-4].str, yypvt[-2].str, yypvt[-1].list, yypvt[-0].val); } break;
case 80:
# line 302 "gram.y"
 { addmkoption(yypvt[-2].str, yypvt[-0].str); } break;
case 83:
# line 309 "gram.y"
 { addoption(yypvt[-0].str, NULL); } break;
case 84:
# line 310 "gram.y"
 { addoption(yypvt[-2].str, yypvt[-0].str); } break;
case 85:
# line 313 "gram.y"
 { conf.cf_name = yypvt[-0].str;
					    conf.cf_lineno = currentline();
					    conf.cf_root = NULL;
					    conf.cf_swap = NULL;
					    conf.cf_dump = NULL; } break;
case 88:
# line 324 "gram.y"
 { setconf(&conf.cf_root, "root", yypvt[-0].list); } break;
case 89:
# line 325 "gram.y"
 { setconf(&conf.cf_swap, "swap", yypvt[-0].list); } break;
case 90:
# line 326 "gram.y"
 { setconf(&conf.cf_dump, "dumps", yypvt[-0].list); } break;
case 91:
# line 329 "gram.y"
 { (yyval.list = yypvt[-2].list)->nv_next = yypvt[-0].list; } break;
case 92:
# line 330 "gram.y"
 { yyval.list = yypvt[-0].list; } break;
case 93:
# line 333 "gram.y"
 { yyval.list = new_si(yypvt[-0].str, NODEV); } break;
case 94:
# line 334 "gram.y"
 { yyval.list = new_si(NULL, yypvt[-0].val); } break;
case 95:
# line 337 "gram.y"
 { yyval.val = makedev(yypvt[-2].val, yypvt[-0].val); } break;
case 98:
# line 343 "gram.y"
 { yyval.val = yypvt[-0].val; } break;
case 99:
# line 344 "gram.y"
 { yyval.val = 1; } break;
case 100:
# line 347 "gram.y"
 { yyval.str = starref(yypvt[-1].str); } break;
case 101:
# line 348 "gram.y"
 { yyval.str = yypvt[-0].str; } break;
case 102:
# line 351 "gram.y"
 { yyval.str = NULL; } break;
case 103:
# line 352 "gram.y"
 { yyval.str = wildref(yypvt[-1].str); } break;
case 104:
# line 353 "gram.y"
 { yyval.str = starref(yypvt[-1].str); } break;
case 105:
# line 354 "gram.y"
 { yyval.str = yypvt[-0].str; } break;
case 106:
# line 357 "gram.y"
 { (yyval.list = yypvt[-0].list)->nv_next = yypvt[-1].list; } break;
case 107:
# line 358 "gram.y"
 { yyval.list = NULL; } break;
case 108:
# line 361 "gram.y"
 { yyval.list = new_ns(yypvt[-1].str, yypvt[-0].str); } break;
case 109:
# line 362 "gram.y"
 { yyval.list = new_ns(yypvt[-1].str, NULL); } break;
case 110:
# line 365 "gram.y"
 { yyval.val = yypvt[-0].val; } break;
case 111:
# line 366 "gram.y"
 { yyval.val = 0; } break;
	}
	goto yystack;		/* reset registers in driver code */
}
