/*
 * load audio driver as an LKM
 */

#include <sys/param.h>
#include <sys/ioctl.h>
#include <sys/systm.h>
#include <sys/conf.h>
#include <sys/mount.h>
#include <sys/exec.h>
#include <sys/lkm.h>
#include <sys/file.h>
#include <sys/errno.h>

extern int      audio_open(), audio_close(), audio_ioctl(), audio_write();
extern int      nullop();

/*
 * operations on our device
 */
static struct cdevsw audio_cdev = {
	audio_open,		/* open */
	audio_close,		/* close */
	nullop,			/* read */
	audio_write,		/* write */
	audio_ioctl,		/* ioctl */
	nullop,			/* stop */
/*	nullop,		*/	/* reset */
	0,			/* tty */
	nullop,			/* select */
	nullop,			/* mmap */
	0			/* strategy */
};


/*
 * our device module
 */
MOD_DEV("audio", LM_DT_CHAR, -1, &audio_cdev)

/*
 * called when device is loaded or unloaded
 */
static
load_unload(lkmtp, cmd)
	struct lkm_table *lkmtp;
	int             cmd;
{
	int             err = 0;

	switch (cmd) {
	case LKM_E_LOAD:
		err = init_audio();
		if (err == 0)
			printf("Audio Module Loaded.\n");
		break;

	case LKM_E_UNLOAD:
		err = cleanup_audio();
		printf("Audio Module unloaded.\n");
		break;

	default:
		err = EINVAL;
		break;
	}
	return (err);
}

lkm_audio(lkmtp, cmd, ver)
	struct lkm_table *lkmtp;
	int             cmd, ver;
{
	DISPATCH(lkmtp, cmd, ver, load_unload, load_unload, lkm_nofunc);
}

