package Varwatcher;
use Tk;
sub new {
    my($w, $label, $watchref) = @_;
    my($f) = Frame::new($w, "-relief" => "ridge");
    my($labelw) = Label::new($f);
    my($watchw) = Label::new($f);
    $labelw->configure("-text" => $label) if defined $label;
    if (defined($watchref)) {
	$$watchref = '' unless defined $$watchref;
	$watchw->configure("-textvariable" => $$watchref);
    }
    tkpack $labelw, $watchw, "-side" => "left";
    return bless({Default => $f, "label" => $labelw, "watch" => $watchw});
}

sub label {
    my($w, $label) = @_;
    if (defined($label)) {
        $w->{"label"}->configure("-text" => $label);
    } else {
        return $w->{"label"}->configure("-text");
    }
}

sub watch {
    my($w, $watchref) = @_;
    $w->{"watch"}->configure("-textvariable" => $$watchref);
}

1;
