package Pad;
use Tk;
require "scrolledlistbox.pl";

sub new {
    my($frame) = Frame::new(shift);
    my($sl) = Scrolledlistbox::new($frame, "-setgrid" => 1,
                                      "-relief" => "ridge");
    my($e) = Entry::new($frame, "-relief" => "sunken");
    my($pad);
    tkpack($sl, "-fill" => "both", "-expand" => "y");
    tkpack($e, "-fill" => "x");
    $pad = bless({Default => $frame, Listbox => $sl, Entry => $e,
                  Focus => $e, "string" => ""});
    $e->configure("-textvariable" => $pad->{"string"});
    tkbind($e, "<Return>", "process", $pad);
    return $pad;
}

sub append {
    my($w) = shift;
    my($l) = $w->{Listbox};
    my($ywindow, $ytop, $ysize);
    foreach (@_) {
        $l->insert("end", $_);
    }
    $ysize = $l->size();
    $ywindow = $l->configure("-geometry");
    $ywindow =~ /x(\d*)$/;
    $ytop = $ysize - $1;
    $ytop = 0 if $ytop < 0;
    $l->yview($ytop);
}

sub cut {
    my($w, $remains) = @_;
    my($max) = $w->size();
    my($todel);
    $todel = $w->{Listbox}->size() - $remains - 1;
    $w->{Listbox}->tkdelete(0, $todel) if $todel >= 0;
}

sub handler {
    my($w, $subref) = @_;
    $w->{"handler"} = $subref;
}

sub process {
    my($w) = shift; 
    my($subref) = $w->{"handler"};
    &$subref($w->{"string"});
    $w->{"string"} = "";
}

sub focus {
    my($w) = shift;
    focus $w->{Entry};
}

1;
