package Filedisplay;
use Tk;
@ISA = (Listbox);
sub new {
    my($w) = shift;
    my($f1) = Frame::new($w);
    my($xscroll) = Scrollbar::new($f1, "-orient" => "horizontal");
    my($f2) = Frame::new($f1);
    my($yscroll) = Scrollbar::new($f2, "-orient" => "vertical");
    my($l) = Listbox::new($f2, "-setgrid" => 1,
                               "-yscrollslave" => $yscroll,
                               "-yscrollmethod" => "set",
                               "-xscrollslave" => $xscroll,
                               "-xscrollmethod" => "set");
    $xscroll->configure("-slave" => $l, "-method" => "xview");
    $yscroll->configure("-slave" => $l, "-method" => "yview");
    tkpack $xscroll, "-fill" => "x";
    tkpack $yscroll, "-side" => "left", "-fill" => "y";
    tkpack $l, "-side" => "left", "-fill" => "both", "-expand" => "y";
    tkpack $f2, "-fill" => "both", "-expand" => "y";
    return bless({Listbox => $l, Default => $f1});
}

sub showfile {
    my($w, $file) = @_;
    my($i);
    
    if ($file ne $w->{"filename"}) {
        $w->{"filename"} = $file;
	*dbline = "::_<$file";
	$w->{"lines"} = \@dbline;
	$w->{"actions"} = \%dbline;
    }
    $w->tkdelete(0, "end");
    for($i = 1; $i <= $#dbline; $i++) {
	$w->insert("end", sprintf("%5d %s", $i, $dbline[$i]));
    }
    1;
}

sub showline {
    my($w, $line) = @_;
    my($max, $window, $edge, $ytop, $ynew);

    $max = $#{$w->{"lines"}};
    $line--;                 # listboxes indexed from zero
    $w->selectclear;
    $w->selectfrom($line);
    $ytop = $w->nearest(0);
#    $window = $w->configure("-geometry");
#    $window =~ /x\d*$/;
    $window = $w->nearest(10000) - $ytop + 1;
    $edge = int($window / 4);
    if ($line < $ytop + $edge || $line > $ytop + $window - $edge) {
        $ynew = $line - int($window / 2);       # centre line in listbox
        if ($ynew < 0) {
            $ynew = 0;
        } elsif ($ynew > $max - 1) {
            $ynew = $max - 1;
        } 
        $w->yview($ynew) if $ynew != $ytop;
    }
    1;
}
