#!/soft/local/bin/perl5
###########################################################################
#
# Usage:
# $0			-> Uebersicht
# $0?package,section	-> Man-pages fuer package nach sections
#			   geordnet auflisten (default)
# $0?package,alphabet	-> Man-pages fuer package alphabetisch
#			   geordnet auflisten
#
###########################################################################
#
# (c) Copyright 1994, 1995 Hubert Feyrer.
# Alle Rechte vorbehalten, weitergabe an Dritte ohne schriftliche
# Genehmiging des o.g. Autors ausdruecklich untersagt!
# All rights reserved, distribution of this software without a written
# permission of the author is hereby strictly forbidden!
#
###########################################################################

$pkgbase="/soft";

if($ENV{"QUERY_STRING"}){
    local($pkg,$sortby)=split(/,/,$ENV{"QUERY_STRING"});

    $sortby="section" if $sortby eq "";
    $title="Man-pages fr Package $pkg, sorted by $sortby";
    header();
    listMans($pkg,$sortby);
    footer();
}else{
    $title="Installierte Software";
    header();
    listPkgs();
    footer();
}


###########################################################################
sub listMans
{
    local($pkg,$sortby)=@_;

    if(!chdir("$pkgbase/$pkg/man")){
	die "warning: can't chdir $pkgbase/$pkg/man\n";
    }

    if($sortby eq "section"){
	local(@mans,$sec,$mans,%mans,$p,$cmd,$url);
	print "<H1>Manual-Pages fr $pkg</H1>\n";

	undef @mans;
	foreach $sec ( 1,2,3,4,5,6,7,8,9,l,n ){
	    %sections = ( '1' => 'Kommmandos fr Benutzer',
			 '2' => 'Betriebssystem-Routinen',
			 '3' => 'Programmier-Bibliotheken',
			 '4' => '',
			 '5' => '',
			 '6' => 'Spiele',
			 '7' => '',
			 '8' => '',
			 '9' => '',
			 'n' => 'neue Befehle',
			 'l' => 'lokale Erweiterungen' );
	    chop($mans=`echo ???$sec/*.?`);
	    next if $mans=~/\?\?\?.\/\*.\?/;

	    print "\t<H2>Abschnitt $sec: $sections{$sec}</H2>\n";
	    print "\t<UL>\n";

	    undef %mans;
	    foreach $p ( split(/ /,$mans)){
		($cmd)=$p=~/....\/(\S+)\.[01-9ln]/;
		$mans{"$cmd($sec)"}=1;
	    }
	    foreach $p ( sort { lc($a) cmp lc($b) } keys %mans ){
		$url="<A HREF=\"http://rfhs1012.fh.uni-regensburg.de/PoolDoku/bin/man.pl.cgi?$p\">$p</A>";	# hier url fuer man2html eintragen!
		print "\t\t<LI> $url\n";
	    }

	    print "\t</UL>\n";
	}
    }else{
	local($mans,$p,$sec,$cmd,%mans,@mans,$url);
	print "<H1>Manual-Pages fr $pkg</H1>\n";

	chop($mans=`echo */*`);
	foreach $p ( split(/ /,$mans) ){
	    ($sec,$cmd)=$p=~/...([1-9ln])\/(\S+)\.[01-9ln]/;
	    $mans{"$cmd($sec)"}=1;
	}

	print "<UL>\n";
	foreach $p ( sort { lc($a) cmp lc($b) } keys %mans ){
	    $url="<A HREF=\"http://rfhs1012.fh.uni-regensburg.de/PoolDoku/bin/man.pl.cgi?$p\">$p</A>";	# hier url fuer man2html eintragen!
	    print "\t\t<LI> $url\n";
	}
	print "</UL>\n";
    }
}

###########################################################################
sub listPkgs
{
    local($d,%p,$c,%c,$name_url);

    opendir(D,"$pkgbase")
	or die "Can't readdir '$pkgbase': $!";
    while($d=readdir(D)){
	next if $d eq ".";
	next if $d eq "..";
	next if $d eq "local";
	next if $d eq "install";
	next if $d eq "scripts.div";

	$c="Sonstiges";
	if(open(F,"$pkgbase/$d/install/package")){
	    while(<F>){ last if /^CATEGORY=.+/; }
	    close(F);
	    if(!/^CATEGORY=(.+)/){
		print "warning: no CATEGORY in $pkgbase/$d/install/package!\n";
	    }else{
		$c=$1;
	    }
	}
	$p{$d}=$c;
    }
    closedir(D);

    foreach $c ( values %p ){ $c{$c}=1; }	# Kategorien in %c
    print "<H1>Installierte Software-Pakete</H1>\n";

    print "<UL>\n";
    foreach $c ( sort { lc($a) cmp lc($b) } keys %c ){
	# Alle Kategorien (Grafik, Datenbanken, ...)
	print "\t<H2>$c</H2>\n";

	print "\t<DL>\n";
	foreach $d ( sort { lc($a) cmp lc($b) } keys %p ){
	    # Alle Programme einer Kategorie
	    next if $p{$d} ne $c;

	    # package-file durchlesen
	    $pkg_name    = "";
	    $pkg_version = "";
	    $pkg_desc    = "";
	    $name_url    = "";
	    if(open(F,"$pkgbase/$d/install/package")){
		while(<F>){
		    if(/^NAME=(.+)/)            { $pkg_name=$1; }
		    if(/^NAME_URL=\'?(.+)\'?$/) { ($name_url=$1)=~s/'$//; }
		    if(/^VERSION=(.+)/)         { $pkg_version=$1; }
		    if(/^DESC[0-9]*="(.+)"\s*$/){ $pkg_desc.=" $1"; }
		}
                $pkg_name=~s/^["']//; $pkg_version=~s/^["']//;
                $pkg_name=~s/["']$//; $pkg_version=~s/["']$//;
		close(F);
	    
		if($name_url){
		    print ("\t\t<DT> <A HREF=\"$name_url\">$pkg_name ",
			   "(Version: $pkg_version)</A></DT>\n");
		}else{
		    print "\t\t<DT> $pkg_name (Version: $pkg_version)</DT>\n";
		}
		print "\t\t\t<DD>$pkg_desc";
		if(-d "$pkgbase/$d/man"){
		    print " Nheres siehe ";
		    print "<A HREF=\"installedSW.pl.cgi?$d,section\">";
		    print "Man-Page(s)</A>.";
		}
		print "</DD>\n";
	    }else{
		print "\t\t<DT>$d</DT>\n";
		if(-d "$pkgbase/$d/man"){
		    print "<DD>Nheres siehe ";
		    print "<A HREF=\"installedSW.pl.cgi?$d,section\">";
		    print "Man-Page(s)</A>.</DD>\n";
		}
	    }
	}
	print "\t</DL>\n";
    }
    print "</UL>\n";
}

###########################################################################
sub header
{
    print "Content-type: text/html\n\n";

    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>$title</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    if($debug){

	print "<HR>\n";
	
	{
	    # ARGC ausgeben
	    local($i);	 
	    
	    for($i=0;$i<=$#ARGC;$i++){
		print "ARGV[$i]='$ARGV[$i]'<BR>\n";
	    }		 
	    print "<P>\n";	
	}
	
	{
	    # ENV ausgeben
	    local($var);	 
	    
	    foreach $var ( sort keys %ENV ){
		print "ENV: $var=$ENV{$var}<BR>\n";
	    }		 
	    print "<P>\n";
	}

	print "<HR>\n";
    }
}

###########################################################################
sub footer
{
    local($today,$d,$m,$y,$date);

    print "<HR>\n";

    ($d,$m,$y)=(localtime)[3,4,5];
    $date=sprintf("%02d.%02d.%02d",$d,$m+1,$y);
    print ("<A HREF=\"http://rfhs1012.fh.uni-regensburg.de/~feyrer/\">",
	   "hubert.feyrer\@rz.uni-regensburg.de</A>, $date\n");

    print "</BODY>\n";
    print "</HTML>\n";
}
