#include <math.h>
#include "rtd.h"
#include "extern.h"
#define SIGN(x) (x > 0) ? 1 : ((x < 0) ? -1 : 0)
  
int box_x,box_y,box_z;
int sign_x,sign_y,sign_z;
double ctrl_x, ctrl_y, ctrl_z;
double slope_x,slope_y,slope_z;
int index;
int axis[3];

struct obj_link *three_dda(r)
struct ray *r;
{
double org_x,org_y,org_z;
double seads_x,seads_y,seads_z;
double abs_x,abs_y,abs_z;
struct obj_link *temp, *three_next();

org_x  = r->org.x;
org_y  = r->org.y;
org_z  = r->org.z;
if (r->dir.x != 0.0) {
  if (org_x < x_world_start) {
    org_y = org_y + (r->dir.y / r->dir.x) * (x_world_start - org_x);
    org_z = org_z + (r->dir.z / r->dir.x) * (x_world_start - org_x);
    org_x = x_world_start;
    }
  else if (org_x > x_world_end) {
    org_y = org_y + (r->dir.y / r->dir.x) * (x_world_end - org_x);
    org_z = org_z + (r->dir.z / r->dir.x) * (x_world_end - org_x);
    org_x = x_world_start;
    }
  }
if (r->dir.y != 0.0) {
  if (org_y < y_world_start) {
    org_x = org_x + (r->dir.x / r->dir.y) * (y_world_start - org_y);
    org_z = org_z + (r->dir.z / r->dir.y) * (y_world_start - org_y);
    org_y = y_world_start;
    }
  else if (org_y > y_world_end) {
    org_x = org_x + (r->dir.x / r->dir.y) * (y_world_end - org_y);
    org_z = org_z + (r->dir.z / r->dir.y) * (y_world_end - org_y);
    org_y = y_world_end;
    }
  }
if (r->dir.z != 0.0) {
  if (org_z < z_world_start) {
    org_x = org_x + (r->dir.x / r->dir.z) * (z_world_start - org_z);
    org_y = org_y + (r->dir.y / r->dir.z) * (z_world_start - org_z);
    org_z = z_world_start;
    }
  else if (org_z > z_world_end) {
    org_x = org_x + (r->dir.x / r->dir.z) * (z_world_start - org_z);
    org_y = org_y + (r->dir.y / r->dir.z) * (z_world_start - org_z);
    org_z = z_world_end;
    }
  }

seads_x = (org_x - x_world_start) / num_pts_per_box;
seads_y = (org_y - y_world_start) / num_pts_per_box;
seads_z = (org_z - z_world_start) / num_pts_per_box;
box_x  = seads_x;
box_y  = seads_y;
box_z  = seads_z;
sign_x = SIGN(r->dir.x); abs_x = fabs(r->dir.x);
sign_y = SIGN(r->dir.y); abs_y = fabs(r->dir.y);
sign_z = SIGN(r->dir.z); abs_z = fabs(r->dir.z);

slope_x = slope_y = slope_z = 0.0;
ctrl_x = ctrl_y = ctrl_z = 0.0;
if (abs_x >= abs_y && abs_x >= abs_z) {
  if (sign_y != 0) {
    slope_y = abs_x / abs_y;
    ctrl_y = seads_x + (box_y - seads_y) * r->dir.x / r->dir.y - box_x;
    ctrl_y = (sign_x > 0) ? -ctrl_y : ctrl_y - 1;
    if (sign_y > 0)
      ctrl_y= ctrl_y - slope_y;
    }
  if (sign_z != 0) {  
    slope_z= abs_x / abs_z;
    ctrl_z = seads_x + (box_z - seads_z) * r->dir.x / r->dir.z - box_x;
    ctrl_z = (sign_x > 0) ? -ctrl_z : ctrl_z - 1;
    if (sign_z > 0)
      ctrl_z= ctrl_z - slope_z;
    }
  }
else if (abs_y >= abs_x && abs_y >= abs_z) {
  if (sign_x != 0) {
    slope_x= abs_y / abs_x;
    ctrl_x = seads_y + (box_x - seads_x) * r->dir.y / r->dir.x - box_y;
    ctrl_x = (sign_y > 0) ? -ctrl_x : ctrl_x - 1;
    if (sign_x > 0)
      ctrl_x = ctrl_x - slope_x;
    }
  if (sign_z != 0) {
    slope_z= abs_y / abs_z;
    ctrl_z = seads_y + (box_z - seads_z) * r->dir.y / r->dir.z - box_y;
    ctrl_z = (sign_y > 0) ? -ctrl_z : ctrl_z - 1;
    if (sign_z > 0)
      ctrl_z = ctrl_z - slope_z;
    }
  }
else {
  if (sign_x != 0) {
    slope_x= abs_z / abs_x;
    ctrl_x = seads_z + (box_x - seads_x) * r->dir.z / r->dir.x - box_z;
    ctrl_x = (sign_z > 0) ? -ctrl_x : ctrl_x - 1;
    if (sign_x > 0)
      ctrl_x = ctrl_x - slope_x;
    }
  if (sign_y != 0) {
    slope_y= abs_z / abs_y;
    ctrl_y = seads_z + (box_y - seads_y) * r->dir.z / r->dir.y - box_z;
    ctrl_y = (sign_z > 0) ? -ctrl_y : ctrl_y - 1;
    if (sign_y > 0)
      ctrl_y = ctrl_y - slope_y;
    }
  }
index = 0;
if (box_x < 0 || box_y < 0 || box_z < 0 ||
    box_x > NUM_BOXES || box_y > NUM_BOXES || box_z > NUM_BOXES)
  return(NULL);
else if (seads[box_x][box_y][box_z] != NULL)
  return(seads[box_x][box_y][box_z]);
else {
  temp = three_next();
  return(temp);
  }
}
  
struct obj_link *three_next()
{
int temp;

while (1) {
  if (index == 0) {
    axis[1]= (ctrl_x < ctrl_y) ? ((ctrl_z < ctrl_x) ? 2 : 0)
			       : ((ctrl_z < ctrl_y) ? 2 : 1);
    axis[2]= (ctrl_x > ctrl_y) ? ((ctrl_z > ctrl_x) ? 2 : 0)
			       : ((ctrl_z > ctrl_y) ? 2 : 1);
    axis[0]= 3 - axis[2] - axis[1];
    }
  temp = axis[index];
  index= (index + 1) % 3;
  switch (temp) {
    case 0: if (++ctrl_x >= 0.0 && sign_x != 0) {
    	      ctrl_x= ctrl_x - slope_x;
    	      box_x = box_x + sign_x;
    	      if (box_x < 0 || box_x > NUM_BOXES)
    	        return(NULL);
    	      if (seads[box_x][box_y][box_z] != NULL)
    	        return(seads[box_x][box_y][box_z]);
    	      }
    	    break;
    case 1: if (++ctrl_y >= 0.0 && sign_y != 0) {
              ctrl_y= ctrl_y - slope_y;
              box_y = box_y + sign_y;
              if (box_y < 0 || box_y > NUM_BOXES)
                return(NULL);
              if (seads[box_x][box_y][box_z] != NULL)
                return(seads[box_x][box_y][box_z]);
              }
            break;
    case 2: if (++ctrl_z >= 0.0 && sign_z != 0) {
              ctrl_z= ctrl_z - slope_z;
              box_z = box_z + sign_z;
              if (box_z < 0 || box_z > NUM_BOXES)
                return(NULL);
              if (seads[box_x][box_y][box_z] != NULL)
                return(seads[box_x][box_y][box_z]);
              }
            break;
    }
  }
}

