/*
 * @(#)desc.c	1.5 91/09/05
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>

#include "defs.h"


static Xlat fcntlcmds[] = {
	F_DUPFD, 	"DUPFD",
	F_GETFD,	"GETFD",
	F_SETFD,	"SETFD",
	F_GETFL,	"F_GETFL",
	F_SETFL,	"F_SETFL",
	F_GETLK,	"F_GETLK",
	F_SETLK,	"F_SETLK",
	F_SETLKW,	"F_SETLKW",
	F_GETOWN,	"F_GETOWN",
	F_SETOWN,	"F_SETOWN",
#ifndef linux
	F_RSETLK,	"F_RSETLK",
	F_RSETLKW,	"F_RSETLKW",
	F_RGETLK,	"F_RGETLK",
	F_CNVT,		"F_CNVT",
#else
	O_NDELAY,	"O_NDELAY",
#endif
	0,		NULL,
};

#ifndef linux

static Xlat flockcmds[] = {
	LOCK_SH,	"LOCK_SH",
	LOCK_EX,	"LOCK_EX",
	LOCK_NB,	"LOCK_NB",
	LOCK_UN,	"LOCK_UN",
	0,		NULL,
};

#endif

static Xlat lockfcmds[] = {
	F_RDLCK,	"F_RDLCK",
	F_WRLCK,	"F_WRLCK",
	F_UNLCK,	"F_UNLCK",
#if defined(F_EXLCK) && defined(F_SHLCK)  /* linux */
	F_EXLCK,	"F_EXLCK",
	F_SHLCK,	"F_SHLCK",
#endif
	0,		NULL,
};

static Xlat whence[] = {
	SEEK_SET,	"SEEK_SET",
	SEEK_CUR,	"SEEK_CUR",
	SEEK_END,	"SEEK_END",
	0,		NULL,
};

/* fcntl/lockf */
static void
printflock(pid, addr, getlk)
{
	struct flock fl;

	if (umove(pid, addr, sizeof fl, (char *)&fl) < 0) {
		fprintf(outf, "{...}");
		return;
	}
	fprintf(outf, "{type ");
	printxval(lockfcmds, fl.l_type, "F_???");
	fprintf(outf, " whence ");
	printxval(whence, fl.l_whence, "SEEK_???");
	fprintf(outf, " start %d len %d", fl.l_start, fl.l_len);
	if (getlk)
		fprintf(outf, " pid %u}", fl.l_pid);
	else
		fprintf(outf, "}");
}

int
sys_fcntl(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		fprintf(outf, "%d, ", tcp->u_args[0]);
		printxval(fcntlcmds, tcp->u_args[1], "F_???");
		fprintf(outf, ", ");
		switch (tcp->u_args[1]) {
		case F_GETLK:
			break;
		case F_SETLK: case F_SETLKW:
			printflock(tcp->pid, tcp->u_args[2], 0);
			break;
		case F_SETOWN:
			printnum(tcp->pid, tcp->u_args[2], "%d");
			break;
		default:
			fprintf(outf, "%#x", tcp->u_args[2]);
			break;
		}
	}
	else {
		if (tcp->u_args[1] == F_GETLK)
			printflock(tcp->pid, tcp->u_args[2], 1);
	}
	return 0;
}

#ifndef linux
int
sys_flock(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		fprintf(outf, "%d, ", tcp->u_args[0]);
		printflags(flockcmds, tcp->u_args[1]);
	}
	return 0;
}
#endif

int
sys_close(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		fprintf(outf, "%d", tcp->u_args[0]);
	}
	return 0;
}

int
sys_dup(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		fprintf(outf, "%d", tcp->u_args[0]);
	}
	return 0;
}

int
sys_dup2(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		fprintf(outf, "%d, %d", tcp->u_args[0], tcp->u_args[1]);
	}
	return 0;
}

int
sys_getdtablesize(tcp)
struct tcb *tcp;
{
	return 0;
}

int
sys_select(tcp)
struct tcb *tcp;
{
	int i, j, nfds;
	fd_set fds;
	struct timeval tv;
	static char outstr[1024];
	char *sep;
#ifdef linux
	int args[5];
#define	ARGS	args
	umove(tcp->pid, tcp->u_args[0], sizeof args, (char *) args);
#else
#define	ARGS	tcp->u_args
#endif

	if (entering(tcp)) {
		nfds = ARGS[0];
		fprintf(outf, "%d", nfds);
		for (i = 0; i < 3; i++) {
			if (ARGS[i+1] == 0) {
				fprintf(outf, ", NULL", j);
				continue;
			}

			fprintf(outf, ", fdset%u:[", i);
			umove(tcp->pid, ARGS[i+1], sizeof fds, (char *)&fds);
			for (j = 0, sep = ""; j < nfds; j++)
				if (FD_ISSET(j, &fds))
					fprintf(outf, "%s%u", sep, j), sep = " ";
			fprintf(outf, "]");
		}
		if (ARGS[4]) {
			umove(tcp->pid, ARGS[4], sizeof tv, (char *)&tv);
			fprintf(outf, ", tv:{%u, %u}", tv.tv_sec, tv.tv_usec);
		} else
			fprintf(outf, ", NULL");
	} else {
		int cumlen = 0;

		if (syserror(tcp))
			return 0;

		if ((nfds = tcp->u_rval) == 0) {
			tcp->auxstr = "Timeout";
			return RVAL_STR;
		}
		outstr[0] = '\0';
		for (i = 0; i < 3; i++) {
			int first = 1;
			char str[20];

			tcp->auxstr = outstr;
			if (ARGS[i+1] == 0) {
				continue;
			}
			umove(tcp->pid, ARGS[i+1], sizeof fds, (char *)&fds);
			for (j = 0; j < ARGS[0]; j++) {
				if (FD_ISSET(j, &fds)) {
					if (first)
						sprintf(str, "fdset%u:[%u",
								i, j), first=0;
					else
						sprintf(str, " %u", j);

					--nfds;
					if ((cumlen += strlen(str)) < sizeof outstr)
						strcat(outstr, str);
				}
			}
			if (cumlen) strcat(outstr, "]");
			if (nfds == 0) break;
		}
		if (ARGS[4]) {
			char str[20];

			umove(tcp->pid, ARGS[4], sizeof tv, (char *)&tv);
			sprintf(str, ", tv:{%u, %u}", tv.tv_sec, tv.tv_usec);
			if ((cumlen += strlen(str)) < sizeof outstr)
				strcat(outstr, str);
		}
		return RVAL_STR;
	}
	return 0;
}
