/*
 * @(#)syscallent.h	1.4 91/09/05	- syscall call switch table
 *		from @(#)init_sysent.c 2.64 89/10/04 SMI; from UCB 6.1 83/08/17
 */
	{ 1, sys_indir, "indir"},		/* 0 = indir */
	{ 1, sys_rexit, "rexit"},		/* 1 = exit */
	{ 0, sys_fork, "fork"},		/* 2 = fork */
	{ 3, sys_read, "read"},		/* 3 = read */
	{ 3, sys_write, "write"},		/* 4 = write */
	{ 3, sys_open, "open"},		/* 5 = open */
	{ 1, sys_close, "close"},		/* 6 = close */
	{ 4, sys_wait4, "wait4"},		/* 7 = wait4 */
	{ 2, sys_creat, "creat"},		/* 8 = creat */
	{ 2, sys_link, "link"},		/* 9 = link */
	{ 1, sys_unlink, "unlink"},		/* 10 = unlink */
	{ 2, sys_execv, "execv"},		/* 11 = execv */
	{ 1, sys_chdir, "chdir"},		/* 12 = chdir */
	{ 0, sys_otime, "otime"},		/* 13 = old time */
	{ 3, sys_mknod, "mknod"},		/* 14 = mknod */
	{ 2, sys_chmod, "chmod"},		/* 15 = chmod */
	{ 3, sys_chown, "chown"},		/* 16 = chown; now 3 args */
	{ 1, sys_brk, "brk"},		/* 17 = brk */
	{ 2, sys_stat, "stat"},		/* 18 = old stat */
	{ 3, sys_lseek, "lseek"},		/* 19 = lseek */
	{ 0, sys_getpid, "getpid"},		/* 20 = getpid */
	{ 0, sys_nosys, "nosys"},		/* 21 = old mount */
	{ 1, sys_umount, "umount"},		/* 22 = old umount */
	{ 1, sys_osetuid, "osetuid"},		/* 23 = old setuid */
	{ 0, sys_getuid, "getuid"},		/* 24 = getuid */
	{ 1, sys_ostime, "ostime"},		/* 25 = old stime */
	{ 5, sys_ptrace, "ptrace"},		/* 26 = ptrace */
	{ 1, sys_oalarm, "oalarm"},		/* 27 = old alarm */
	{ 2, sys_ofstat, "ofstat"},		/* 28 = old fstat */
	{ 0, sys_opause, "opause"},		/* 29 = opause */
	{ 2, sys_outime, "outime"},		/* 30 = old utime */
	{ 0, sys_nosys, "nosys"},		/* 31 = was stty */
	{ 0, sys_nosys, "nosys"},		/* 32 = was gtty */
	{ 2, sys_access, "access"},		/* 33 = access */
	{ 1, sys_onice, "onice"},		/* 34 = old nice */
	{ 1, sys_oftime, "oftime"},		/* 35 = old ftime */
	{ 0, sys_sync, "sync"},		/* 36 = sync */
	{ 2, sys_kill, "kill"},		/* 37 = kill */
	{ 2, sys_stat, "stat"},		/* 38 = stat */
	{ 2, sys_osetpgrp, "osetpgrp"},		/* 39 = old setpgrp */
	{ 2, sys_lstat, "lstat"},		/* 40 = lstat */
	{ 2, sys_dup, "dup"},		/* 41 = dup */
	{ 0, sys_pipe, "pipe"},		/* 42 = pipe */
	{ 1, sys_otimes, "otimes"},		/* 43 = old times */
	{ 4, sys_profil, "profil"},		/* 44 = profil */
	{ 0, sys_nosys, "nosys"},		/* 45 = nosys */
	{ 1, sys_osetgid, "osetgid"},		/* 46 = old setgid */
	{ 0, sys_getgid, "getgid"},		/* 47 = getgid */
	{ 2, sys_ossig, "ossig"},		/* 48 = old sig */
	{ 0, sys_nosys, "nosys"},		/* 49 = reserved for USG */
	{ 0, sys_nosys, "nosys"},		/* 50 = reserved for USG */
	{ 1, sys_sysacct, "sysacct"},		/* 51 = turn acct off/on */
	{ 0, sys_nosys, "nosys"},		/* 52 = old set phys addr */
	{ 4, sys_mctl, "mctl"},		/* 53 = memory control */
	{ 3, sys_ioctl, "ioctl"},		/* 54 = ioctl */
	{ 2, sys_reboot, "reboot"},		/* 55 = reboot */
	{ 3, sys_owait3, "owait3"},		/* 56 = wait3 */
	{ 2, sys_symlink, "symlink"},		/* 57 = symlink */
	{ 3, sys_readlink, "readlink"},		/* 58 = readlink */
	{ 3, sys_execve, "execve"},		/* 59 = execve */
	{ 1, sys_umask, "umask"},		/* 60 = umask */
	{ 1, sys_chroot, "chroot"},		/* 61 = chroot */
	{ 2, sys_fstat, "fstat"},		/* 62 = fstat */
	{ 0, sys_nosys, "nosys"},		/* 63 = used internally */
	{ 1, sys_getpagesize, "getpagesize"},		/* 64 = getpagesize */
	{ 3, sys_omsync, "omsync"},		/* 65 = old msync */
	{ 0, sys_vfork, "vfork"},		/* 66 = vfork */
	{ 0, sys_read, "read"},		/* 67 = old vread */
	{ 0, sys_write, "write"},		/* 68 = old vwrite */
	{ 1, sys_sbrk, "sbrk"},		/* 69 = sbrk */
	{ 1, sys_sstk, "sstk"},		/* 70 = sstk */
	{ 6, sys_smmap, "smmap"},		/* 71 = mmap */
	{ 1, sys_ovadvise, "ovadvise"},		/* 72 = old vadvise */
	{ 2, sys_munmap, "munmap"},		/* 73 = munmap */
	{ 3, sys_mprotect, "mprotect"},		/* 74 = mprotect */
	{ 3, sys_omadvise, "omadvise"},		/* 75 = old madvise */
	{ 1, sys_vhangup, "vhangup"},		/* 76 = vhangup */
	{ 2, sys_ovlimit, "ovlimit"},		/* 77 = old vlimit */
	{ 3, sys_mincore, "mincore"},		/* 78 = mincore */
	{ 2, sys_getgroups, "getgroups"},		/* 79 = getgroups */
	{ 2, sys_setgroups, "setgroups"},		/* 80 = setgroups */
	{ 1, sys_getpgrp, "getpgrp"},		/* 81 = getpgrp */
	{ 2, sys_setpgrp, "setpgrp"},		/* 82 = setpgrp */
	{ 3, sys_setitimer, "setitimer"},		/* 83 = setitimer */
	{ 0, sys_owait, "owait"},		/* 84 = old wait & wait3 */
	{ 1, sys_swapon, "swapon"},		/* 85 = swapon */
	{ 2, sys_getitimer, "getitimer"},		/* 86 = getitimer */
	{ 2, sys_gethostname, "gethostname"},		/* 87 = gethostname */
	{ 2, sys_sethostname, "sethostname"},		/* 88 = sethostname */
	{ 0, sys_getdtablesize, "getdtablesize"},		/* 89 = getdtablesize */
	{ 2, sys_dup2, "dup2"},		/* 90 = dup2 */
	{ 2, sys_getdopt, "getdopt"},		/* 91 = getdopt */
	{ 3, sys_fcntl, "fcntl"},		/* 92 = fcntl */
	{ 5, sys_select, "select"},		/* 93 = select */
	{ 2, sys_setdopt, "setdopt"},		/* 94 = setdopt */
	{ 1, sys_fsync, "fsync"},		/* 95 = fsync */
	{ 3, sys_setpriority, "setpriority"},		/* 96 = setpriority */
	{ 3, sys_socket, "socket"},		/* 97 = socket */
	{ 3, sys_connect, "connect"},		/* 98 = connect */
	{ 3, sys_accept, "accept"},		/* 99 = accept */
	{ 2, sys_getpriority, "getpriority"},		/* 100 = getpriority */
	{ 4, sys_send, "send"},		/* 101 = send */
	{ 4, sys_recv, "recv"},		/* 102 = recv */
	{ 0, sys_nosys, "nosys"},		/* 103 = old socketaddr */
	{ 3, sys_bind, "bind"},		/* 104 = bind */
	{ 5, sys_setsockopt, "setsockopt"},		/* 105 = setsockopt */
	{ 2, sys_listen, "listen"},		/* 106 = listen */
	{ 2, sys_ovtimes, "ovtimes"},		/* 107 = old vtimes */
	{ 3, sys_sigvec, "sigvec"},		/* 108 = sigvec */
	{ 1, sys_sigblock, "sigblock"},		/* 109 = sigblock */
	{ 1, sys_sigsetmask, "sigsetmask"},		/* 110 = sigsetmask */
	{ 1, sys_sigpause, "sigpause"},		/* 111 = sigpause */
	{ 2, sys_sigstack, "sigstack"},		/* 112 = sigstack */
	{ 3, sys_recvmsg, "recvmsg"},		/* 113 = recvmsg */
	{ 3, sys_sendmsg, "sendmsg"},		/* 114 = sendmsg */
	{ 3, sys_vtrace, "vtrace"},		/* 115 = vtrace */
	{ 2, sys_gettimeofday, "gettimeofday"},		/* 116 = gettimeofday */
	{ 2, sys_getrusage, "getrusage"},		/* 117 = getrusage */
	{ 5, sys_getsockopt, "getsockopt"},		/* 118 = getsockopt */
	{ 0, sys_nosys, "nosys"},		/* 119 = nosys */
	{ 3, sys_readv, "readv"},		/* 120 = readv */
	{ 3, sys_writev, "writev"},		/* 121 = writev */
	{ 2, sys_settimeofday, "settimeofday"},		/* 122 = settimeofday */
	{ 3, sys_fchown, "fchown"},		/* 123 = fchown */
	{ 2, sys_fchmod, "fchmod"},		/* 124 = fchmod */
	{ 6, sys_recvfrom, "recvfrom"},		/* 125 = recvfrom */
	{ 2, sys_setreuid, "setreuid"},		/* 126 = setreuid */
	{ 2, sys_setregid, "setregid"},		/* 127 = setregid */
	{ 2, sys_rename, "rename"},		/* 128 = rename */
	{ 2, sys_truncate, "truncate"},		/* 129 = truncate */
	{ 2, sys_ftruncate, "ftruncate"},		/* 130 = ftruncate */
	{ 2, sys_flock, "flock"},		/* 131 = flock */
	{ 0, sys_nosys, "nosys"},		/* 132 = nosys */
	{ 6, sys_sendto, "sendto"},		/* 133 = sendto */
	{ 2, sys_shutdown, "shutdown"},		/* 134 = shutdown */
	{ 5, sys_socketpair, "socketpair"},		/* 135 = socketpair */
	{ 2, sys_mkdir, "mkdir"},		/* 136 = mkdir */
	{ 1, sys_rmdir, "rmdir"},		/* 137 = rmdir */
	{ 2, sys_utimes, "utimes"},		/* 138 = utimes */
	{ 0, sys_sigcleanup, "sigcleanup"},		/* 139 = signalcleanup */
	{ 2, sys_adjtime, "adjtime"},		/* 140 = adjtime */
	{ 3, sys_getpeername, "getpeername"},		/* 141 = getpeername */
	{ 2, sys_gethostid, "gethostid"},		/* 142 = gethostid */
	{ 0, sys_nosys, "nosys"},		/* 143 = old sethostid */
	{ 2, sys_getrlimit, "getrlimit"},		/* 144 = getrlimit */
	{ 2, sys_setrlimit, "setrlimit"},		/* 145 = setrlimit */
	{ 2, sys_killpg, "killpg"},		/* 146 = killpg */
	{ 0, sys_nosys, "nosys"},		/* 147 = nosys */
	{ 0, sys_oldquota, "oldquota"},		/* XXX */ /* 148 = old quota */
	{ 0, sys_oldquota, "oldquota"},		/* XXX */ /* 149 = old qquota */
	{ 3, sys_getsockname, "getsockname"},		/* 150 = getsockname */
	{ 4, sys_getmsg, "getmsg"},		/* 151 = getmsg */
	{ 4, sys_putmsg, "putmsg"},		/* 152 = putmsg */
	{ 3, sys_poll, "poll"},		/* 153 = poll */
	{ 0, sys_nosys, "nosys"},		/* 154 = old nfs_mount */
	{ 1, sys_nfs_svc, "nfs_svc"},		/* 155 = nfs_svc */
	{ 4, sys_getdirentries, "getdirentries"},		/* 156 = getdirentries */
	{ 2, sys_statfs, "statfs"},		/* 157 = statfs */
	{ 2, sys_fstatfs, "fstatfs"},		/* 158 = fstatfs */
	{ 1, sys_unmount, "unmount"},		/* 159 = unmount */
	{ 0, sys_async_daemon, "async_daemon"},		/* 160 = async_daemon */
	{ 2, sys_nfs_getfh, "nfs_getfh"},		/* 161 = get file handle */
	{ 2, sys_getdomainname, "getdomainname"},		/* 162 = getdomainname */
	{ 2, sys_setdomainname, "setdomainname"},		/* 163 = setdomainname */
	{ 5, sys_rtschedule, "rtschedule"},		/* 164 = rtschedule */
	{ 4, sys_quotactl, "quotactl"},		/* 165 = quotactl */
	{ 2, sys_exportfs, "exportfs"},		/* 166 = exportfs */
	{ 4, sys_mount, "mount"},		/* 167 = mount */
	{ 2, sys_ustat, "ustat"},		/* 168 = ustat */
	{ 5, sys_semsys, "semsys"},		/* 169 = semsys */
	{ 6, sys_msgsys, "msgsys"},		/* 170 = msgsys */
	{ 4, sys_shmsys, "shmsys"},		/* 171 = shmsys */
	{ 4, sys_auditsys, "auditsys"},		/* 172 = auditsys (audit control) */
	{ 5, sys_rfssys, "rfssys"},		/* 173 = RFS calls */
	{ 3, sys_getdents, "getdents"},		/* 174 = getdents */
	{ 1, sys_sys_setsid, "sys_setsid"},		/* 175 = setsid & s5 setpgrp() */
	{ 1, sys_fchdir, "fchdir"},		/* 176 = fchdir */
	{ 1, sys_fchroot, "fchroot"},		/* 177 = fchroot */
	{ 2, sys_vpixsys, "vpixsys"},		/* 178 = VP/ix system calls */
	{ 6, sys_aioread, "aioread"},		/* 179 = aioread */
	{ 6, sys_aiowrite, "aiowrite"},		/* 180 = aiowrite */
	{ 1, sys_aiowait, "aiowait"},		/* 181 = aiowait */
	{ 1, sys_aiocancel, "aiocancel"},		/* 182 = aiocancel */
	{ 1, sys_sigpending, "sigpending"},		/* 183 = sigpending */
	{ 0, sys_errsys, "errsys"},		/* 184 = AVAILABLE */
	{ 2, sys_setpgid, "setpgid"},		/* 185 = setpgid */
	{ 2, sys_pathconf, "pathconf"},		/* 186 = pathconf */
	{ 2, sys_fpathconf, "fpathconf"},		/* 187 = fpathconf */
	{ 1, sys_sysconf, "sysconf"},		/* 188 = sysconf */
	{ 1, sys_uname, "uname"},		/* 189 = uname */
	{ 0, sys_nosys, "nosys"},		/* 190 = reserved - Loadable syscalls */
	{ 0, sys_nosys, "nosys"},		/* 191 = reserved - Loadable syscalls */
	{ 0, sys_nosys, "nosys"},		/* 192 = reserved - Loadable syscalls */
	{ 0, sys_nosys, "nosys"},		/* 193 = reserved - Loadable syscalls */
	{ 0, sys_nosys, "nosys"},		/* 194 = reserved - Loadable syscalls */
	{ 0, sys_nosys, "nosys"},		/* 195 = reserved - Loadable syscalls */
	{ 0, sys_nosys, "nosys"},		/* 196 = reserved - Loadable syscalls */
	{ 0, sys_nosys, "nosys"},		/* 197 = reserved - Loadable syscalls */
